/*
 * Decompiled with CFR 0.152.
 */
package xtc.typical;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import xtc.lang.JavaPrinter;
import xtc.parser.ParseException;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.typical.Transformer;
import xtc.typical.TypicalAnalyzer;
import xtc.typical.TypicalParser;
import xtc.util.SymbolTable;
import xtc.util.Tool;

public class Typical
extends Tool {
    protected Object analyser;
    protected String checker;
    protected String typicalName;

    public String getName() {
        return "Typical";
    }

    public void init() {
        super.init();
        this.runtime.bool("checkOnly", "optionCheckOnly", false, "Type check, but do not generate code.").bool("typesOnly", "optionTypesOnly", false, "Generate external type definitions.").word("o", "optionOutput", false, "Specify the base name of the generated checker.").bool("printAST", "printAST", false, "Print the AST of the of the pre-transformed program.").bool("printSymbolTable", "printSymbolTable", false, "Print the symbol table.").bool("printSource", "printSource", false, "Print the java source code of the generated checker.").bool("Oswitch", "optimizeMatch", false, "Use switch statements and type tags for pattern matches.").bool("Ofold-let", "optimizeFoldLet", false, "Collapse let expressions where possible.").bool("Olet", "optimizeLet", false, "Avoid creating a Let object if possible.").bool("Otype", "optimizeType", false, "Eliminate type records, if attributes are not defined.").word("node", "optionNodeType", false, "Specify the name of the node type.");
    }

    public Node parse(Reader reader, File file) throws IOException, ParseException {
        this.typicalName = file.toString();
        TypicalParser typicalParser = new TypicalParser(reader, file.toString(), (int)file.length());
        return (Node)typicalParser.value(typicalParser.pModule(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Node node) {
        Visitor visitor;
        String string;
        if (this.runtime.test("printAST")) {
            this.runtime.console().pln().format(node).pln().flush();
        }
        GNode gNode = null;
        GNode gNode2 = null;
        GNode gNode3 = null;
        String string2 = (String)this.runtime.getValue("optionOutput");
        if (null == string2) {
            string2 = this.typicalName.substring(0, this.typicalName.length() - 5);
        }
        if (null == (string = (String)this.runtime.getValue("optionNodeType"))) {
            string = "node";
        }
        SymbolTable symbolTable = null;
        TypicalAnalyzer typicalAnalyzer = new TypicalAnalyzer(this.runtime, string);
        symbolTable = typicalAnalyzer.run(node);
        if (0 < this.runtime.errorCount()) {
            return;
        }
        if (this.runtime.test("printSymbolTable")) {
            if (null != symbolTable) {
                visitor = this.runtime.console().visitor();
                try {
                    symbolTable.root().dump(this.runtime.console());
                }
                finally {
                    this.runtime.console().register(visitor);
                }
                this.runtime.console().flush();
            } else {
                this.runtime.error("symbol table not initialized");
                this.runtime.exit();
            }
        }
        if (!this.runtime.test("optionCheckOnly")) {
            Printer printer;
            visitor = null;
            visitor = new Transformer((GNode)node, symbolTable, string2, this.runtime);
            ((Transformer)visitor).run();
            gNode = ((Transformer)visitor).getCheckerAST();
            gNode2 = ((Transformer)visitor).getTypesAST();
            gNode3 = ((Transformer)visitor).getSupportAST();
            File file = this.runtime.getFile("outputDirectory");
            File file2 = new File(file, string2 + "Analyzer.java");
            if (!this.runtime.test("optionTypesOnly")) {
                try {
                    printer = new Printer(new PrintWriter(new BufferedWriter(new FileWriter(file2))));
                }
                catch (IOException iOException) {
                    if (null == iOException.getMessage()) {
                        this.runtime.error(file2.toString() + ": I/O error");
                    } else {
                        this.runtime.error(file2.toString() + ": " + iOException.getMessage());
                    }
                    return;
                }
                this.printHeader(printer);
                new JavaPrinter(printer).dispatch(gNode);
                printer.flush();
            }
            file2 = new File(file, string2 + "Types.java");
            try {
                printer = new Printer(new PrintWriter(new BufferedWriter(new FileWriter(file2))));
            }
            catch (IOException iOException) {
                if (null == iOException.getMessage()) {
                    this.runtime.error(file2.toString() + ": I/O error");
                } else {
                    this.runtime.error(file2.toString() + ": " + iOException.getMessage());
                }
                return;
            }
            this.printHeader(printer);
            new JavaPrinter(printer).dispatch(gNode2);
            printer.flush();
            file2 = new File(file, string2 + "Support.java");
            try {
                printer = new Printer(new PrintWriter(new BufferedWriter(new FileWriter(file2))));
            }
            catch (IOException iOException) {
                if (null == iOException.getMessage()) {
                    this.runtime.error(file2.toString() + ": I/O error");
                } else {
                    this.runtime.error(file2.toString() + ": " + iOException.getMessage());
                }
                return;
            }
            this.printHeader(printer);
            new JavaPrinter(printer).dispatch(gNode3);
            printer.flush();
        }
        if (this.runtime.test("printSource")) {
            new JavaPrinter(this.runtime.console()).dispatch(gNode);
            this.runtime.console().flush();
        }
    }

    public static void main(String[] stringArray) {
        new Typical().run(stringArray);
    }
}

