/*
 * Decompiled with CFR 0.152.
 */
package xtc.typical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.typical.TreeFactory;
import xtc.typical.Tuple;
import xtc.typical.TypicalTypes;
import xtc.util.Pair;
import xtc.util.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapper {
    public static final Object OBJECT = new Object();
    public static final Object PAIR_OF_OBJECT = new Object();
    public static final Node nameTupleT = GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Tuple", null), GNode.create("TypeInstantiation", "T3", GNode.create("TypeArguments", GNode.create("Type", GNode.create("QualifiedIdentifier", "Name"), null), GNode.create("Type", GNode.create("QualifiedIdentifier", "String"), null), GNode.create("Type", GNode.create("QualifiedIdentifier", "String"), null)))), null);
    protected final Runtime runtime;
    protected final String prefix;
    protected final boolean replaceType;
    protected final String prefixNoDot;
    protected final TreeFactory factory;
    Pair<String> nodeTypes;
    protected HashMap<String, String> variableNames = new HashMap();
    protected boolean inFunctionType = false;

    public TypeMapper(Runtime runtime, String string, boolean bl, Pair<String> pair) {
        this.factory = new TreeFactory();
        this.runtime = runtime;
        this.prefixNoDot = string;
        this.prefix = string + ".";
        this.replaceType = bl;
        this.nodeTypes = pair;
    }

    public PatternMatchType makePatternMatchType(Object object, Object object2) {
        if (null == object) {
            throw new AssertionError((Object)"Null left type");
        }
        if (null == object2) {
            throw new AssertionError((Object)"Null right type");
        }
        return new PatternMatchType(object, object2);
    }

    public static String getAnnotatedString(Object object) {
        if (object instanceof TypicalTypes.type) {
            TypicalTypes.type type2 = (TypicalTypes.type)object;
            TypicalTypes.raw_type<?> raw_type2 = type2.type;
            return TypeMapper.getAnnotatedString(raw_type2);
        }
        if (object instanceof TypicalTypes.raw_type) {
            TypicalTypes.raw_type raw_type3 = (TypicalTypes.raw_type)object;
            if (raw_type3.isStringName()) {
                return (String)((Tuple)raw_type3.getTuple()).get1();
            }
            throw new AssertionError((Object)("unknown type " + raw_type3));
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public static Pair<String> getAnnotatedStringList(Object object) {
        if (object instanceof TypicalTypes.type) {
            TypicalTypes.type type2 = (TypicalTypes.type)object;
            TypicalTypes.raw_type<?> raw_type2 = type2.type;
            return TypeMapper.getAnnotatedStringList(raw_type2);
        }
        if (object instanceof TypicalTypes.raw_type) {
            TypicalTypes.raw_type raw_type3 = (TypicalTypes.raw_type)object;
            if (raw_type3.isStringList()) {
                Pair pair = (Pair)((Tuple)raw_type3.getTuple()).get1();
                return pair;
            }
            throw new AssertionError((Object)("unknown type " + raw_type3));
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public String toTypeString(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (OBJECT == object) {
            return "Object";
        }
        if (PAIR_OF_OBJECT == object) {
            return "Pair<?>";
        }
        if (object instanceof String) {
            return this.getType((String)object);
        }
        if (object instanceof TypicalTypes.type) {
            TypicalTypes.type type2 = (TypicalTypes.type)object;
            return this.toTypeString(type2.type);
        }
        if (object instanceof TypicalTypes.raw_type) {
            TypicalTypes.raw_type raw_type2 = (TypicalTypes.raw_type)object;
            if (raw_type2.isBoolT()) {
                return "Boolean";
            }
            if (raw_type2.isIntT()) {
                return "BigInteger";
            }
            if (raw_type2.isFloat32T()) {
                return "Float";
            }
            if (raw_type2.isFloat64T()) {
                return "Double";
            }
            if (raw_type2.isStringT()) {
                return "String";
            }
            if (raw_type2.isAnyT()) {
                return "Object";
            }
            if (raw_type2.isWildcardT()) {
                return "Object";
            }
            if (raw_type2.isVariableT()) {
                String string = (String)((Tuple)raw_type2.getTuple()).get1();
                if (this.variableNames.containsKey(string)) {
                    return this.variableNames.get(string);
                }
                return "Object";
            }
            if (raw_type2.isConstructorT()) {
                return this.getType((String)((Tuple)raw_type2.getTuple()).get1());
            }
            if (raw_type2.isVariantT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                TypicalTypes.raw_type<?> raw_type3 = this.unwrapRawType(pair.head());
                return this.getType((String)((Tuple)raw_type3.getTuple()).get1());
            }
            if (raw_type2.isPolyVariantT()) {
                return this.getType("Node");
            }
            if (raw_type2.isNodeTypeT()) {
                return this.getType("Node");
            }
            if (raw_type2.isFieldT()) {
                return this.getType(this.toTypeString(((Tuple)raw_type2.getTuple()).get3()));
            }
            if (raw_type2.isConstructedT()) {
                TypicalTypes.raw_type raw_type4 = raw_type2;
                TypicalTypes.ConstructedT constructedT = (TypicalTypes.ConstructedT)raw_type4;
                String string = (String)((Tuple.T2)constructedT.getTuple()).get2();
                if ("list".equals(string)) {
                    return "Pair<" + this.getType(this.toTypeString(this.getBase(raw_type2))) + ">";
                }
                if ("var".equals(string)) {
                    return this.getType(this.toTypeString(this.getBase(raw_type2)));
                }
                return string;
            }
            if (raw_type2.isTypeName()) {
                return this.getType((String)((Tuple)raw_type2.getTuple()).get1());
            }
            if (raw_type2.isRecordT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                Object t = pair.head();
                TypicalTypes.raw_type<?> raw_type5 = this.unwrapRawType(t);
                if (raw_type5.isFieldT()) {
                    String string = (String)((Tuple)raw_type5.getTuple()).get1();
                    return this.getType(string);
                }
                return this.toTypeString(raw_type5);
            }
            if (raw_type2.isTupleT()) {
                List<String> list = this.getMembers(raw_type2);
                String string = "Tuple.T" + list.size() + "<";
                for (int i = 0; i < list.size(); ++i) {
                    string = string + this.getType(list.get(i));
                    if (i >= list.size() - 1) continue;
                    string = string + ",";
                }
                string = string + ">";
                return string;
            }
            if (raw_type2.isPairOfType()) {
                return this.toTypeString(((Tuple)raw_type2.getTuple()).get1());
            }
            if (raw_type2.isFunctionT()) {
                this.inFunctionType = true;
                List<String> list = this.getParameterTypes(object);
                String string = this.getReturnType(object);
                StringBuilder stringBuilder = new StringBuilder("Function.F" + list.size() + "<" + string);
                for (String string2 : list) {
                    stringBuilder.append("," + string2);
                }
                stringBuilder.append(">");
                this.inFunctionType = false;
                return stringBuilder.toString();
            }
        } else if (object instanceof PatternMatchType) {
            PatternMatchType patternMatchType = (PatternMatchType)object;
            return this.toTypeString(patternMatchType.left);
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public Node toTypeNode(Object object, boolean bl) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (object instanceof Node) {
            return (Node)object;
        }
        if (OBJECT == object) {
            return this.makeTypeNode("Object", bl);
        }
        if (object instanceof String) {
            return this.makeTypeNode((String)object, bl);
        }
        if (PAIR_OF_OBJECT == object) {
            return GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Pair", GNode.create("TypeArguments", GNode.create("Wildcard", null)))), null);
        }
        if (object instanceof TypicalTypes.type) {
            TypicalTypes.type type2 = (TypicalTypes.type)object;
            return this.toTypeNode(type2.type, bl);
        }
        if (object instanceof TypicalTypes.raw_type) {
            TypicalTypes.raw_type raw_type2 = (TypicalTypes.raw_type)object;
            if (raw_type2.isBoolT()) {
                return this.makeTypeNode("Boolean", false);
            }
            if (raw_type2.isIntT()) {
                return this.makeTypeNode("BigInteger", false);
            }
            if (raw_type2.isFloat32T()) {
                return this.makeTypeNode("Float", false);
            }
            if (raw_type2.isFloat64T()) {
                return this.makeTypeNode("Double", false);
            }
            if (raw_type2.isStringT()) {
                return this.makeTypeNode("String", false);
            }
            if (raw_type2.isAnyT()) {
                return this.makeTypeNode("Object", bl);
            }
            if (raw_type2.isWildcardT()) {
                return this.makeTypeNode("Object", bl);
            }
            if (raw_type2.isVariableT()) {
                String string = (String)((Tuple)raw_type2.getTuple()).get1();
                if (bl) {
                    return this.makeTypeNode("Object", bl);
                }
                if (this.variableNames.containsKey(string)) {
                    return GNode.create("Type", GNode.create("QualifiedIdentifier", this.variableNames.get(string)), null);
                }
                return this.makeTypeNode("Object", bl);
            }
            if (raw_type2.isConstructorT()) {
                return this.makeTypeNode((String)((Tuple)raw_type2.getTuple()).get1(), bl);
            }
            if (raw_type2.isVariantT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                TypicalTypes.raw_type<?> raw_type3 = this.unwrapRawType(pair.head());
                return this.makeTypeNode((String)((Tuple)raw_type3.getTuple()).get1(), bl);
            }
            if (raw_type2.isPolyVariantT()) {
                return this.makeTypeNode("Node", bl);
            }
            if (raw_type2.isNodeTypeT()) {
                return this.makeTypeNode("Node", bl);
            }
            if (raw_type2.isFieldT()) {
                return this.toTypeNode(((Tuple)raw_type2.getTuple()).get3(), bl);
            }
            if (raw_type2.isConstructedT()) {
                TypicalTypes.raw_type raw_type4 = raw_type2;
                TypicalTypes.ConstructedT constructedT = (TypicalTypes.ConstructedT)raw_type4;
                String string = (String)((Tuple.T2)constructedT.getTuple()).get2();
                Node node = this.toTypeNode(this.getBase(raw_type2), bl);
                if ("list".equals(string)) {
                    return GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Pair", GNode.create("TypeArguments", node))), null);
                }
                if ("var".equals(string)) {
                    return node;
                }
                return this.makeTypeNode(string, bl);
            }
            if (raw_type2.isTypeName()) {
                return this.makeTypeNode((String)((Tuple)raw_type2.getTuple()).get1(), bl);
            }
            if (raw_type2.isRecordT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                Object t = pair.head();
                TypicalTypes.raw_type<?> raw_type5 = this.unwrapRawType(t);
                if (raw_type5.isFieldT()) {
                    String string = (String)((Tuple)raw_type5.getTuple()).get1();
                    return this.makeTypeNode(string, bl);
                }
                return this.toTypeNode(raw_type5, bl);
            }
            if (raw_type2.isTupleT()) {
                TypicalTypes.raw_type raw_type6 = raw_type2;
                TypicalTypes.TupleT tupleT = (TypicalTypes.TupleT)raw_type6;
                ArrayList arrayList = new ArrayList();
                Pair pair = (Pair)((Tuple.T1)tupleT.getTuple()).get1();
                Object object2 = pair.iterator();
                while (object2.hasNext()) {
                    arrayList.add(object2.next());
                }
                object2 = GNode.create("TypeArguments");
                for (Object e : arrayList) {
                    ((Node)object2).add(this.toTypeNode(e, bl));
                }
                return GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Tuple", null), GNode.create("TypeInstantiation", "T" + arrayList.size(), object2)), null);
            }
            if (raw_type2.isPairOfType()) {
                return this.toTypeNode(((Tuple)raw_type2.getTuple()).get1(), bl);
            }
            if (raw_type2.isFunctionT()) {
                Object object3;
                this.inFunctionType = true;
                ArrayList arrayList = new ArrayList();
                Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
                Object object4 = pair.iterator();
                while (object4.hasNext()) {
                    arrayList.add(object4.next());
                }
                Object b = ((Tuple)raw_type2.getTuple()).get2();
                if (b instanceof TypicalTypes.type) {
                    object3 = (TypicalTypes.type)b;
                    object4 = null == ((TypicalTypes.type)object3).type ? this.makeTypeNode("Void", false) : this.toTypeNode(object3, bl);
                } else {
                    object4 = null == b ? this.makeTypeNode("Void", false) : this.toTypeNode(b, bl);
                }
                object3 = GNode.create("TypeArguments");
                ((Node)object3).add(object4);
                for (Object e : arrayList) {
                    ((Node)object3).add(this.toTypeNode(e, bl));
                }
                this.inFunctionType = false;
                return GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Function", null), GNode.create("TypeInstantiation", "F" + arrayList.size(), object3)), null);
            }
        } else if (object instanceof PatternMatchType) {
            PatternMatchType patternMatchType = (PatternMatchType)object;
            return this.toTypeNode(patternMatchType.left, bl);
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public boolean hasTypeVariables(Object object) {
        if (null == object) {
            return false;
        }
        if (object.equals(nameTupleT)) {
            return false;
        }
        if (this.isTGType(object)) {
            TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
            if (null == raw_type2) {
                throw new AssertionError((Object)"Null raw type");
            }
            if (raw_type2.isVariableT()) {
                String string = (String)((Tuple)raw_type2.getTuple()).get1();
                return this.variableNames.containsKey(string);
            }
            if (raw_type2.isConstructorT()) {
                return this.hasTypeVariables(((Tuple)raw_type2.getTuple()).get3());
            }
            if (raw_type2.isVariantT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    if (!this.hasTypeVariables(iterator.next())) continue;
                    return true;
                }
                return false;
            }
            if (raw_type2.isFieldT()) {
                return this.hasTypeVariables(((Tuple)raw_type2.getTuple()).get3());
            }
            if (raw_type2.isConstructedT()) {
                return this.hasTypeVariables(this.getBase(raw_type2));
            }
            if (raw_type2.isRecordT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    if (!this.hasTypeVariables(iterator.next())) continue;
                    return true;
                }
                return false;
            }
            if (raw_type2.isTupleT()) {
                TypicalTypes.raw_type<?> raw_type3 = raw_type2;
                TypicalTypes.TupleT tupleT = (TypicalTypes.TupleT)raw_type3;
                Pair pair = (Pair)((Tuple.T1)tupleT.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    if (!this.hasTypeVariables(iterator.next())) continue;
                    return true;
                }
                return false;
            }
            if (raw_type2.isPairOfType()) {
                return this.hasTypeVariables(((Tuple)raw_type2.getTuple()).get1()) || this.hasTypeVariables(((Tuple)raw_type2.getTuple()).get2());
            }
            if (raw_type2.isFunctionT()) {
                Object b = ((Tuple)raw_type2.getTuple()).get2();
                if (this.hasTypeVariables(b)) {
                    return true;
                }
                Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    if (!this.hasTypeVariables(iterator.next())) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        if (object instanceof PatternMatchType) {
            PatternMatchType patternMatchType = (PatternMatchType)object;
            return this.hasTypeVariables(patternMatchType.left) || this.hasTypeVariables(patternMatchType.right);
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public List<String> getTypeVariables(Object object) {
        List<String> list = new ArrayList<String>();
        if (null == object) {
            return list;
        }
        if (this.isTGType(object)) {
            TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
            if (null == raw_type2) {
                return list;
            }
            if (raw_type2.isVariableT()) {
                list.add((String)((Tuple)raw_type2.getTuple()).get1());
                return list;
            }
            if (raw_type2.isConstructorT()) {
                return this.getTypeVariables(((Tuple)raw_type2.getTuple()).get3());
            }
            if (raw_type2.isVariantT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    List<String> list2 = this.getTypeVariables(iterator.next());
                    for (String string : list2) {
                        if (-1 != list.indexOf(string)) continue;
                        list.add(string);
                    }
                }
                return list;
            }
            if (raw_type2.isFieldT()) {
                return this.getTypeVariables(((Tuple)raw_type2.getTuple()).get3());
            }
            if (raw_type2.isConstructedT()) {
                return this.getTypeVariables(this.getBase(raw_type2));
            }
            if (raw_type2.isRecordT()) {
                Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    List<String> list3 = this.getTypeVariables(iterator.next());
                    for (String string : list3) {
                        if (-1 != list.indexOf(string)) continue;
                        list.add(string);
                    }
                }
                return list;
            }
            if (raw_type2.isTupleT()) {
                TypicalTypes.raw_type<?> raw_type3 = raw_type2;
                TypicalTypes.TupleT tupleT = (TypicalTypes.TupleT)raw_type3;
                Pair pair = (Pair)((Tuple.T1)tupleT.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    List<String> list4 = this.getTypeVariables(iterator.next());
                    for (String string : list4) {
                        if (-1 != list.indexOf(string)) continue;
                        list.add(string);
                    }
                }
                return list;
            }
            if (raw_type2.isPairOfType()) {
                List<String> list5 = this.getTypeVariables(((Tuple)raw_type2.getTuple()).get1());
                list = list5;
                list5 = this.getTypeVariables(((Tuple)raw_type2.getTuple()).get2());
                for (String string : list5) {
                    if (-1 != list.indexOf(string)) continue;
                    list.add(string);
                }
                return list;
            }
            if (raw_type2.isFunctionT()) {
                List<String> list6;
                Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
                Iterator<Object> iterator = pair.iterator();
                while (iterator.hasNext()) {
                    list6 = this.getTypeVariables(iterator.next());
                    for (String string : list6) {
                        if (-1 != list.indexOf(string)) continue;
                        list.add(string);
                    }
                }
                iterator = ((Tuple)raw_type2.getTuple()).get2();
                list6 = this.getTypeVariables(iterator);
                for (String string : list6) {
                    if (-1 != list.indexOf(string)) continue;
                    list.add(string);
                }
                return list;
            }
            return list;
        }
        if (object instanceof PatternMatchType) {
            PatternMatchType patternMatchType = (PatternMatchType)object;
            List<String> list7 = this.getTypeVariables(patternMatchType.left);
            list = list7;
            list7 = this.getTypeVariables(patternMatchType.right);
            for (String string : list7) {
                if (-1 != list.indexOf(string)) continue;
                list.add(string);
            }
            return list;
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public int processTypeVariables(Object object, int n) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (this.isTGType(object)) {
            TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
            if (raw_type2.isFunctionT()) {
                Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
                Object b = ((Tuple)raw_type2.getTuple()).get2();
                List<String> list = this.getTypeVariables(b);
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    List<String> list2 = this.getTypeVariables(iterator.next());
                    arrayList.add(list2);
                }
                int n2 = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    List list3 = (List)arrayList.get(i);
                    for (String string : list3) {
                        if (!(list3.indexOf(string) == list3.lastIndexOf(string) && -1 == list.indexOf(string) || this.variableNames.containsKey(string))) {
                            this.variableNames.put(string, "T" + n);
                            ++n;
                            ++n2;
                            continue;
                        }
                        for (int j = 0; j < arrayList.size(); ++j) {
                            List list4;
                            if (i == j || -1 == (list4 = (List)arrayList.get(j)).indexOf(string) || this.variableNames.containsKey(string)) continue;
                            this.variableNames.put(string, "T" + n);
                            ++n;
                            ++n2;
                        }
                    }
                }
                if (null != b && this.isFunctionType(b)) {
                    n2 += this.processTypeVariables(b, n);
                }
                return n2;
            }
            throw new AssertionError((Object)("function type expected, found " + object));
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public Object getPatternMatchLeftType(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (this.isTGType(object)) {
            raw_type2 = this.unwrapRawType(object);
            if (raw_type2.isPairOfType()) {
                return ((Tuple)raw_type2.getTuple()).get1();
            }
            throw new AssertionError((Object)("PairOfType is expected, found " + object));
        }
        if (object instanceof PatternMatchType) {
            PatternMatchType patternMatchType = (PatternMatchType)object;
            return patternMatchType.left;
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public Object getPatternMatchRightType(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (this.isTGType(object)) {
            raw_type2 = this.unwrapRawType(object);
            if (raw_type2.isPairOfType()) {
                return ((Tuple)raw_type2.getTuple()).get2();
            }
            throw new AssertionError((Object)("PairOfType is expected, found " + object));
        }
        if (object instanceof PatternMatchType) {
            PatternMatchType patternMatchType = (PatternMatchType)object;
            return patternMatchType.left;
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    private TypicalTypes.raw_type<?> unwrapRawType(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (object instanceof TypicalTypes.raw_type) {
            return (TypicalTypes.raw_type)object;
        }
        if (object instanceof TypicalTypes.type) {
            TypicalTypes.type type2 = (TypicalTypes.type)object;
            return type2.type;
        }
        throw new IllegalArgumentException("can't unwrap non type");
    }

    public boolean isList(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (PAIR_OF_OBJECT == object) {
            return true;
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("unknown type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (!raw_type2.isConstructedT()) {
            return false;
        }
        TypicalTypes.raw_type<?> raw_type3 = raw_type2;
        TypicalTypes.ConstructedT constructedT = (TypicalTypes.ConstructedT)raw_type3;
        String string = (String)((Tuple.T2)constructedT.getTuple()).get2();
        return "list".equals(string);
    }

    public boolean isVariable(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (PAIR_OF_OBJECT == object) {
            return true;
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("unknown type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (!raw_type2.isConstructedT()) {
            return false;
        }
        TypicalTypes.raw_type<?> raw_type3 = raw_type2;
        TypicalTypes.ConstructedT constructedT = (TypicalTypes.ConstructedT)raw_type3;
        String string = (String)((Tuple.T2)constructedT.getTuple()).get2();
        return "var".equals(string);
    }

    public boolean containsAny(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        List<String> list = this.getMembers(object);
        return list.contains("AnyT");
    }

    public boolean isNode(Object object) {
        return "Node".equals(this.toTypeString(object));
    }

    public Object getBase(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (PAIR_OF_OBJECT == object) {
            return OBJECT;
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (raw_type2.isConstructedT()) {
            Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
            return pair.head();
        }
        throw new AssertionError((Object)("ConstructedT is expected, found " + object));
    }

    public boolean isFunctionType(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (this.isTGType(object)) {
            TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
            return null != raw_type2 && raw_type2.isFunctionT();
        }
        return false;
    }

    private boolean isTGType(Object object) {
        return object instanceof TypicalTypes.type || object instanceof TypicalTypes.raw_type;
    }

    public String getReturnType(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (raw_type2.isFunctionT()) {
            this.inFunctionType = true;
            Object b = ((Tuple)raw_type2.getTuple()).get2();
            if (null == b) {
                return "Void";
            }
            TypicalTypes.raw_type<?> raw_type3 = this.unwrapRawType(b);
            if (null == raw_type3) {
                return "Void";
            }
            String string = this.getType(this.toTypeString(raw_type3));
            this.inFunctionType = false;
            return string;
        }
        return this.getType(this.toTypeString(raw_type2));
    }

    public Object getReturnTypeObject(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (raw_type2.isFunctionT()) {
            return ((Tuple)raw_type2.getTuple()).get2();
        }
        return object;
    }

    public Node getReturnTypeNode(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (raw_type2.isFunctionT()) {
            this.inFunctionType = true;
            Object b = ((Tuple)raw_type2.getTuple()).get2();
            if (null == b) {
                return this.makeTypeNode("Void", false);
            }
            TypicalTypes.raw_type<?> raw_type3 = this.unwrapRawType(b);
            if (null == raw_type3) {
                return this.makeTypeNode("Void", false);
            }
            Node node = this.toTypeNode(raw_type3, false);
            this.inFunctionType = false;
            return node;
        }
        return this.toTypeNode(raw_type2, false);
    }

    public List<String> getParameterTypes(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isTGType(object)) {
            this.inFunctionType = true;
            TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
            if (!raw_type2.isFunctionT()) {
                throw new AssertionError((Object)("FunctionT is expected, found " + object));
            }
            Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
            for (Object a : pair) {
                arrayList.add(this.getType(this.toTypeString(a)));
            }
            this.inFunctionType = false;
            return arrayList;
        }
        return null;
    }

    public List<Node> getParameterTypeNodes(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (this.isTGType(object)) {
            this.inFunctionType = true;
            TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
            if (!raw_type2.isFunctionT()) {
                throw new AssertionError((Object)("FunctionT is expected, found " + object));
            }
            Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
            Iterator iterator = pair.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.toTypeNode(iterator.next(), false));
            }
            this.inFunctionType = false;
            return arrayList;
        }
        return null;
    }

    public List<String> getFieldTypes(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (!raw_type2.isRecordT()) {
            throw new AssertionError((Object)("RecordT is expected, found " + object));
        }
        Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
        Iterator iterator = pair.iterator();
        while (iterator.hasNext()) {
            TypicalTypes.FieldT fieldT = (TypicalTypes.FieldT)this.unwrapRawType(iterator.next());
            arrayList.add(this.getType(this.toTypeString(((Tuple.T3)fieldT.getTuple()).get3())));
        }
        return arrayList;
    }

    public List<Node> getFieldTypeNodes(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (!raw_type2.isRecordT()) {
            throw new AssertionError((Object)("RecordT is expected, found " + object));
        }
        Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
        Iterator iterator = pair.iterator();
        while (iterator.hasNext()) {
            TypicalTypes.FieldT fieldT = (TypicalTypes.FieldT)this.unwrapRawType(iterator.next());
            arrayList.add(this.toTypeNode(((Tuple.T3)fieldT.getTuple()).get3(), false));
        }
        return arrayList;
    }

    public List<String> getFieldNames(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        TypicalTypes.raw_type<?> raw_type2 = null;
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        raw_type2 = this.unwrapRawType(object);
        if (!raw_type2.isRecordT()) {
            throw new AssertionError((Object)("RecordT is expected, found " + object));
        }
        Pair pair = this.cast(((Tuple)raw_type2.getTuple()).get1());
        Iterator iterator = pair.iterator();
        while (iterator.hasNext()) {
            TypicalTypes.raw_type<?> raw_type3 = this.unwrapRawType(iterator.next());
            TypicalTypes.FieldT fieldT = (TypicalTypes.FieldT)raw_type3;
            String string = (String)((Tuple.T3)fieldT.getTuple()).get2();
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getMembers(Object object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Object> list = this.getMemberObjects(object);
        for (Object object2 : list) {
            arrayList.add(this.toTypeString(object2));
        }
        return arrayList;
    }

    public List<Object> getMemberObjects(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
        if (raw_type2.isConstructorT()) {
            TypicalTypes.ConstructorT constructorT = (TypicalTypes.ConstructorT)raw_type2;
            if (null == ((Tuple.T3)constructorT.getTuple()).get3()) {
                return arrayList;
            }
            TypicalTypes.raw_type<?> raw_type3 = this.unwrapRawType(((Tuple.T3)constructorT.getTuple()).get3());
            if (raw_type3.isTupleT()) {
                TypicalTypes.TupleT tupleT = (TypicalTypes.TupleT)raw_type3;
                Pair pair = (Pair)((Tuple.T1)tupleT.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return arrayList;
            }
            arrayList.add(raw_type3);
            return arrayList;
        }
        if (null != raw_type2 && raw_type2.isTupleT()) {
            Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
            Iterator iterator = pair.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.toTypeString(iterator.next()));
            }
            return arrayList;
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    public List<Node> getMemberNodes(Object object) {
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (object instanceof Node) {
            Node node = (Node)object;
            GNode gNode = node.getGeneric(0).getGeneric(1).getGeneric(1);
            for (int i = 0; i < gNode.size(); ++i) {
                arrayList.add(gNode.getGeneric(i));
            }
            return arrayList;
        }
        if (!this.isTGType(object)) {
            throw new AssertionError((Object)("Not a type " + object));
        }
        TypicalTypes.raw_type<?> raw_type2 = this.unwrapRawType(object);
        if (raw_type2.isConstructorT()) {
            TypicalTypes.ConstructorT constructorT = (TypicalTypes.ConstructorT)raw_type2;
            if (null == ((Tuple.T3)constructorT.getTuple()).get3()) {
                return arrayList;
            }
            TypicalTypes.raw_type<?> raw_type3 = this.unwrapRawType(((Tuple.T3)constructorT.getTuple()).get3());
            if (raw_type3.isTupleT()) {
                TypicalTypes.TupleT tupleT = (TypicalTypes.TupleT)raw_type3;
                Pair pair = (Pair)((Tuple.T1)tupleT.getTuple()).get1();
                Iterator iterator = pair.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(this.toTypeNode(iterator.next(), false));
                }
                return arrayList;
            }
            arrayList.add(this.toTypeNode(raw_type3, false));
            return arrayList;
        }
        if (null != raw_type2 && raw_type2.isTupleT()) {
            Pair pair = (Pair)((Tuple)raw_type2.getTuple()).get1();
            Iterator iterator = pair.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.toTypeNode(iterator.next(), false));
            }
            return arrayList;
        }
        throw new AssertionError((Object)("unknown type " + object));
    }

    private <T> Pair<T> cast(T t) {
        return (Pair)t;
    }

    private String getType(String string) {
        String string2 = "raw_type".equals(string) ? "raw_type<?>" : string;
        String string3 = string2 = "Pair".equals(string2) ? "Pair<?>" : string2;
        if (this.replaceType && "type".equals(string2)) {
            string2 = "raw_type<?>";
        }
        if (this.nodeTypes.contains(string2)) {
            string2 = "Node";
        } else if ("name".equals(string2)) {
            string2 = "Name";
        } else if ("scope_kind".equals(string2)) {
            string2 = "ScopeKind";
        } else if ("scopeT".equals(string2)) {
            string2 = "Scope";
        }
        if ("Named".equals(string2)) {
            return "ScopeKind.Named";
        }
        if ("Anonymous".equals(string2)) {
            return "ScopeKind.Anonymous";
        }
        if ("Temporary".equals(string2)) {
            return "ScopeKind.Temporary";
        }
        if ("SimpleName".equals(string2)) {
            return "Name.SimpleName";
        }
        if ("QualifiedName".equals(string2)) {
            return "Name.QualifiedName";
        }
        if ("Object".equals(string2) || "String".equals(string2) || "BigInteger".equals(string2) || "Float".equals(string2) || "Double".equals(string2) || "Node".equals(string2) || "GNode".equals(string2) || "Boolean".equals(string2) || string2.startsWith("Pair<") || string2.startsWith("Tuple.T") || string2.startsWith("Function.F") || string2.startsWith(this.prefix) || "Name".equals(string2) || "Scope".equals(string2) || "ScopeKind".equals(string2) || "Void".equals(string2)) {
            return string2;
        }
        return this.prefix + string2;
    }

    private Node makeTypeNode(String string, boolean bl) {
        String string2;
        String string3 = string2 = "raw_type".equals(string) ? "raw_type<?>" : string;
        if (this.replaceType && "type".equals(string)) {
            string2 = "raw_type<?>";
        }
        if (bl && "Object".equals(string)) {
            return GNode.create("Wildcard", null);
        }
        if (this.nodeTypes.contains(string2)) {
            string2 = "Node";
        } else if ("name".equals(string2)) {
            string2 = "Name";
        } else if ("scope_kind".equals(string2)) {
            string2 = "ScopeKind";
        } else if ("scopeT".equals(string2)) {
            string2 = "Scope";
        }
        if ("Named".equals(string2)) {
            return GNode.create("Type", GNode.create("QualifiedIdentifier", "ScopeKind", "Named"), null);
        }
        if ("Anonymous".equals(string2)) {
            return GNode.create("Type", GNode.create("QualifiedIdentifier", "ScopeKind", "Anonymous"), null);
        }
        if ("Temporary".equals(string2)) {
            return GNode.create("Type", GNode.create("QualifiedIdentifier", "ScopeKind", "Temporary"), null);
        }
        if ("SimpleName".equals(string2)) {
            return GNode.create("Type", GNode.create("QualifiedIdentifier", "Name", "SimpleName"), null);
        }
        if ("QualifiedName".equals(string2)) {
            return GNode.create("Type", GNode.create("QualifiedIdentifier", "Name", "QualifiedName"), null);
        }
        if ("Object".equals(string2) || "String".equals(string2) || "BigInteger".equals(string2) || "Float".equals(string2) || "Double".equals(string2) || "Node".equals(string2) || "GNode".equals(string2) || "Boolean".equals(string2) || "Name".equals(string2) || "Scope".equals(string2) || "ScopeKind".equals(string2) || "Void".equals(string2)) {
            return GNode.create("Type", GNode.create("QualifiedIdentifier", string2), null);
        }
        return GNode.create("Type", GNode.create("QualifiedIdentifier", this.prefixNoDot, string2), null);
    }

    class PatternMatchType {
        public Object left;
        public Object right;

        public PatternMatchType(Object object, Object object2) {
            this.left = object;
            this.right = object2;
        }
    }
}

