/*
 * Decompiled with CFR 0.152.
 */
package xtc.typical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import xtc.tree.Comment;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.typical.FlagSetter;
import xtc.typical.FreeVariableCollector;
import xtc.typical.LetFolder;
import xtc.typical.Primitives;
import xtc.typical.TreeFactory;
import xtc.typical.TypeCollector;
import xtc.typical.TypeMapper;
import xtc.util.Pair;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
extends Visitor {
    protected static final String TYPE = "__type";
    protected static final String TOP = "top";
    protected static final String RHS = "rhs";
    protected static final String MATCHARG = "match_arg";
    protected static final String BINDINGS = "bindings";
    protected static final String INANALYZE = "inAnalyze";
    protected static final String SCOPE = "process_scope";
    protected static final String ANNOTATE = "annotate_node";
    protected static final String UPVARS = "up_variables";
    protected static final String LETBINDINGS = "let_bindings";
    protected static final String BODY = "body";
    protected static final String NEWLET = "new_let";
    protected final TreeFactory factory;
    protected final SymbolTable table;
    protected final Node typical;
    protected final String nodeTypeName;
    protected final String output;
    protected GNode transformed;
    protected GNode typesAST;
    protected GNode supportAST;
    protected Node cbody;
    protected Node tbody;
    protected Node sbody;
    protected Node tags;
    protected final Runtime runtime;
    protected final HashMap<Integer, String> typicalVars = new HashMap();
    protected TypeMapper mapper;
    protected boolean seenScope = false;
    protected HashMap<Match, String> matches = new HashMap();
    protected HashMap<Node, String> nodeMatches = new HashMap();
    protected final Node mod = GNode.create("Modifiers");
    protected final Node fmod = Transformer.toModifiers("final");
    protected final Node pmod = Transformer.toModifiers("public");
    protected final Node nullNode = GNode.create("NullLiteral");
    protected final Node nodeType = GNode.create("Type", GNode.create("QualifiedIdentifier", "Node"), null);
    protected final Node gnodeType = GNode.create("Type", GNode.create("QualifiedIdentifier", "GNode"), null);
    protected final List<Node> staticFields = new ArrayList<Node>();
    protected final List<Node> functionDefinitions = new ArrayList<Node>();
    protected final String spareVar;
    protected boolean seenNameSpace = false;
    protected ArrayList<String> processScopeNodes = new ArrayList();
    protected ArrayList<Equality> equalities = new ArrayList();
    protected String packageName;
    protected Node packageNode;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();
    protected List<Attribute> eqAttributeList = new ArrayList<Attribute>();
    protected boolean replaceType;
    protected boolean optimizeLet;
    private boolean isListUsed;
    private boolean isArrayListUsed;
    private boolean isBigIntegerUsed;
    private boolean isPairUsed;
    private boolean isNodeUsed;
    private boolean isGNodeUsed;
    private boolean isPrimitivesUsed;
    private boolean isRecordUsed;
    private boolean isVariantUsed;
    private boolean isTupleUsed;
    private boolean isReductionUsed;
    private boolean isNameUsed;
    private boolean isScopeUsed;
    private boolean isScopeKindUsed;
    private boolean isAnalyzerUsed;
    protected List<Node> primitiveDeclList = new ArrayList<Node>();
    protected List<PrimitiveInstance> primitiveInsList = new ArrayList<PrimitiveInstance>();
    protected Pair<String> nodeTypes = null;
    Node conditions = null;

    public Transformer(GNode gNode, SymbolTable symbolTable, String string, Runtime runtime) {
        this.factory = new TreeFactory();
        this.typical = gNode;
        this.output = string;
        this.table = symbolTable;
        this.runtime = runtime;
        if (this.runtime.test("optimizeType")) {
            this.replaceType = true;
        }
        this.optimizeLet = this.runtime.test("optimizeLet");
        this.spareVar = this.table.freshJavaId("spareVar");
        String string2 = (String)this.runtime.getValue("optionNodeType");
        this.nodeTypeName = null == string2 ? "node" : string2;
        this.dispatch(this.typical.getGeneric(0));
        this.cbody = this.makeClassBody();
        this.cbody = GNode.ensureVariable((GNode)this.cbody);
        if (this.optimizeLet) {
            this.cbody.add(this.factory.fieldDecl3(this.spareVar));
        }
        this.tbody = GNode.create("ClassBody");
        this.tbody = GNode.ensureVariable((GNode)this.tbody);
        this.sbody = GNode.create("ClassBody");
        this.sbody = GNode.ensureVariable((GNode)this.sbody);
    }

    public void visitModule(GNode gNode) {
        GNode gNode2;
        int n;
        Iterable<Object> iterable;
        boolean bl = false;
        int n2 = gNode.size();
        for (int i = 0; i < n2; ++i) {
            iterable = gNode.getGeneric(i);
            if (((Node)iterable).hasName("AttributeDefinition") || ((Node)iterable).hasName("EqualAttributeDefinition")) {
                bl = true;
                new TypeCollector().dispatch((Node)iterable);
                continue;
            }
            if (!((Node)iterable).hasName("NameSpaceDefinition") && (!((Node)iterable).hasName("TypeDefinition") || !"raw_type".equals(((Node)iterable).getString(1)))) continue;
            new TypeCollector().dispatch((Node)iterable);
        }
        if (bl && this.replaceType) {
            this.replaceType = false;
        }
        Object object = gNode.getProperty("__node_types");
        iterable = TypeMapper.getAnnotatedStringList(object);
        this.mapper = new TypeMapper(this.runtime, this.output + "Types", this.replaceType, (Pair<String>)iterable);
        for (n = 0; n < n2; ++n) {
            gNode2 = gNode.getGeneric(n);
            if (!((Node)gNode2).hasName("AttributeDefinition") && !((Node)gNode2).hasName("EqualAttributeDefinition") && !((Node)gNode2).hasName("EqualityDefinition") && !((Node)gNode2).hasName("NameSpaceDefinition")) continue;
            this.dispatch(gNode2);
        }
        for (n = 0; n < n2; ++n) {
            gNode2 = gNode.getGeneric(n);
            if (((Node)gNode2).hasName("TypeDefinition") && ((Pair)iterable).contains(gNode2.getString(1)) || ((Node)gNode2).hasName("AttributeDefinition") || ((Node)gNode2).hasName("EqualAttributeDefinition") || ((Node)gNode2).hasName("EqualityDefinition") || ((Node)gNode2).hasName("NameSpaceDefinition")) continue;
            this.dispatch(gNode2);
            if (!((Node)gNode2).hasName("TypeDefinition") || !"raw_type".equals(gNode2.getString(1))) continue;
            this.dispatch(this.processRawTypeDefinition());
        }
        this.processScopeSpace();
        this.cbody.addAll(this.functionDefinitions);
        this.sbody.addAll(this.primitiveDeclList);
        this.sbody.addAll(this.staticFields);
        this.tbody.add(this.factory.typesConstr(this.output + "Types"));
        this.sbody.add(this.factory.typesConstr(this.output + "Support"));
        this.transformed = GNode.cast(this.makeSkeleton());
        this.typesAST = GNode.cast(this.makeTypesSkeleton());
        this.supportAST = GNode.cast(this.makeSupportSkeleton());
    }

    public void visitModuleDeclaration(GNode gNode) {
        GNode gNode2 = GNode.create("QualifiedIdentifier");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < gNode.size() - 1; ++i) {
            gNode2.add(gNode.getString(i));
            stringBuilder.append(gNode.getString(i));
            if (i >= gNode.size() - 2) continue;
            stringBuilder.append('.');
        }
        this.packageName = stringBuilder.toString();
        this.packageNode = GNode.create("PackageDeclaration", null, gNode2);
    }

    public Node visitFunExpression(GNode gNode) {
        Object object = gNode.getProperty(TYPE);
        if (null == object) {
            throw new AssertionError((Object)"Null type");
        }
        if (this.mapper.isFunctionType(object)) {
            int n;
            GNode gNode2 = gNode.getGeneric(0);
            GNode gNode3 = gNode.getGeneric(1);
            if (gNode.hasProperty(INANALYZE)) {
                gNode2.setProperty(INANALYZE, Boolean.TRUE);
                gNode3.setProperty(INANALYZE, Boolean.TRUE);
            }
            String string = (String)gNode.getProperty("enterScope");
            boolean bl = false;
            if (gNode.hasProperty("enterScope") && !this.table.current().getName().equals(string)) {
                this.enterScope(string);
                bl = true;
            }
            boolean bl2 = (n = this.mapper.processTypeVariables(object, 0)) > 0;
            Node node = this.mapper.getReturnTypeNode(object);
            List<Node> list = this.mapper.getParameterTypeNodes(object);
            Node node2 = this.mapper.toTypeNode(object, false);
            gNode3.setProperty(TYPE, node);
            GNode gNode4 = GNode.create("FormalParameters", gNode2.size());
            for (int i = 0; i < gNode2.size(); ++i) {
                gNode4.add(GNode.create("FormalParameter", this.fmod, list.get(i), null, gNode2.getGeneric(i).getString(0), null));
            }
            GNode gNode5 = null;
            if (bl2) {
                gNode5 = GNode.create("TypeParameters");
                for (int i = 0; i < n; ++i) {
                    gNode5.add(GNode.create("TypeParameter", "T" + i, null));
                }
            }
            Object object2 = this.mapper.getReturnTypeObject(object);
            Node node3 = (Node)this.dispatch(gNode3);
            node3 = this.checkToLet(node3, object2);
            GNode gNode6 = GNode.create("ClassBody", GNode.create("MethodDeclaration", this.pmod, gNode5, node, "apply", gNode4, null, null, GNode.create("Block", this.factory.ret(node3))));
            if (bl) {
                this.exitScope(string);
            }
            return this.toNewExpression2(node2, null, gNode6);
        }
        throw new AssertionError((Object)"Function type is required");
    }

    public Node visitValueDefinition(GNode gNode) {
        String string = gNode.getString(0);
        GNode gNode2 = gNode.getGeneric(1);
        GNode gNode3 = gNode.getGeneric(2);
        String string2 = SymbolTable.toNameSpace(string, "value");
        Object object = gNode.getProperty(TYPE);
        if (null == object) {
            object = this.table.current().lookup(string2);
        }
        if (this.mapper.isFunctionType(object)) {
            Iterable<LetBinding> iterable;
            Node node;
            GNode gNode4;
            Object object2;
            int n = this.mapper.processTypeVariables(object, 0);
            boolean bl = n > 0;
            Node node2 = this.mapper.getReturnTypeNode(object);
            List<Node> list = this.mapper.getParameterTypeNodes(object);
            Node node3 = this.mapper.toTypeNode(object, false);
            if (((Node)gNode3).hasName("FunctionExpression")) {
                object2 = this.table.freshJavaId("arg");
                gNode3 = GNode.create("MatchExpression", GNode.create("LowerID", object2), gNode3.get(0));
                gNode3.setProperty("__arg_type", list.get(0));
                gNode.set(1, GNode.create("Parameters", GNode.create("Parameter", object2, null)));
                gNode2 = gNode.getGeneric(1);
            } else if (((Node)gNode3).hasName("ReduceExpression")) {
                object2 = "lst";
                gNode.set(1, GNode.create("Parameters", GNode.create("Parameter", object2, null)));
                gNode2 = gNode.getGeneric(1);
            }
            if ("analyze".equals(string)) {
                gNode3.setProperty(INANALYZE, Boolean.TRUE);
            }
            gNode3.setProperty(TYPE, node2);
            object2 = GNode.create("FormalParameters", gNode2.size());
            for (int i = 0; i < gNode2.size(); ++i) {
                ((Node)object2).add(GNode.create("FormalParameter", this.fmod, list.get(i), null, gNode2.getGeneric(i).getString(0), null));
            }
            if (!"getNameSpace".equals(string)) {
                this.enterScope(string);
            }
            GNode gNode5 = null;
            if (bl) {
                gNode5 = GNode.create("TypeParameters");
                for (int i = 0; i < n; ++i) {
                    gNode5.add(GNode.create("TypeParameter", "T" + i, null));
                }
            }
            if (!this.optimizeLet) {
                gNode4 = GNode.create("Block", this.factory.ret((Node)this.dispatch(gNode3)));
            } else {
                gNode4 = GNode.create("Block");
                gNode4 = GNode.ensureVariable(GNode.cast(gNode4));
                node = (Node)this.dispatch(gNode3);
                iterable = this.getBindings(node);
                if (null != iterable) {
                    for (LetBinding letBinding : iterable) {
                        if (!letBinding.name.equals(this.spareVar)) {
                            if (this.mapper.hasTypeVariables(letBinding.typeObject)) {
                                gNode4.add(this.factory.fieldDecl2(letBinding.type, letBinding.name, letBinding.value));
                                continue;
                            }
                            gNode4.add(this.factory.fieldDecl2(letBinding.type, letBinding.name, this.factory.cast(letBinding.value)));
                            continue;
                        }
                        if (this.mapper.hasTypeVariables(letBinding.typeObject)) {
                            gNode4.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), letBinding.value));
                            continue;
                        }
                        gNode4.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), this.factory.cast(letBinding.value)));
                    }
                }
                gNode4.add(this.factory.castReturn(node));
            }
            node = GNode.create("ClassBody", GNode.create("MethodDeclaration", this.pmod, gNode5, node2, "apply", object2, null, null, gNode4));
            if (!"getNameSpace".equals(string)) {
                this.exitScope(string);
            }
            if ("getNameSpace".equals(string) || "getScope".equals(string)) {
                return this.makeVarDec2(string, node3, this.toNewExpression2(node3, null, node));
            }
            if (!bl) {
                this.functionDefinitions.add(this.makeVarDec2(string, node3, this.toNewExpression2(node3, null, node)));
            } else {
                iterable = this.factory.classDecl3(string);
                ((Node)iterable).set(5, node);
                this.functionDefinitions.add((Node)iterable);
                this.functionDefinitions.add(this.factory.instanceDecl(GNode.create("Type", GNode.create("QualifiedIdentifier", string), null), string, GNode.create("QualifiedIdentifier", string)));
            }
        } else {
            Node node = (Node)this.dispatch(gNode3);
            node = this.checkToLet(node, object);
            if (this.mapper.hasTypeVariables(object)) {
                this.functionDefinitions.add(this.makeVarDec2(string, this.mapper.toTypeNode(object, false), node));
            } else {
                this.functionDefinitions.add(this.makeVarDec2(string, this.mapper.toTypeNode(object, false), this.factory.cast(node)));
            }
        }
        return null;
    }

    public Node visitFunctionExpression(GNode gNode) {
        Object object = gNode.getProperty(TYPE);
        Node node = this.mapper.getReturnTypeNode(object);
        List<Node> list = this.mapper.getParameterTypeNodes(object);
        Object object2 = this.mapper.getPatternMatchRightType(gNode.getGeneric(0).getProperty(TYPE));
        GNode gNode2 = GNode.create("MatchExpression", GNode.create("LowerID", "var"), gNode.getGeneric(0));
        gNode2.setProperty("__arg_type", list.get(0));
        gNode2.setProperty(TYPE, object2);
        return this.factory.functionExpression(node, list.get(0), (Node)this.dispatch(gNode2));
    }

    public void visitTypeDefinition(GNode gNode) {
        gNode.getGeneric(2).setProperty("name", gNode.getString(1));
        this.dispatch(gNode.getGeneric(2));
    }

    public GNode visitStringLiteral(GNode gNode) {
        return gNode;
    }

    public Node visitIntegerLiteral(GNode gNode) {
        return this.factory.createInteger(Transformer.toLiteral("IntegerLiteral", gNode.getString(0)));
    }

    public Node visitFloatingLiteral(GNode gNode) {
        return this.factory.createFloat(Transformer.toLiteral("FloatingPointLiteral", gNode.getString(0)));
    }

    public Node visitBottom(GNode gNode) {
        return GNode.create("NullLiteral");
    }

    public Node visitBottomPattern(GNode gNode) {
        return this.factory.equalsBottom(Transformer.toIdentifier((String)gNode.getProperty(MATCHARG)));
    }

    public Node visitBooleanLiteral(GNode gNode) {
        return "true".equals(gNode.getString(0)) ? Transformer.toIdentifier("Boolean.TRUE") : Transformer.toIdentifier("Boolean.FALSE");
    }

    public Node visitConsExpression(GNode gNode) {
        Node node;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (!this.optimizeLet) {
            return this.factory.consWrapper((Node)this.dispatch(gNode.getGeneric(0)), (Node)this.dispatch(gNode.getGeneric(1)));
        }
        List<String> list4 = this.getUpVariables(gNode);
        GNode gNode2 = gNode.getGeneric(0);
        GNode gNode3 = gNode.getGeneric(1);
        if (null != list4) {
            gNode2.setProperty(UPVARS, list4);
        }
        if (null != (list3 = this.groupList(list4, list2 = this.extractVariables(list = this.getBindings(node = (Node)this.dispatch(gNode2)))))) {
            gNode3.setProperty(UPVARS, list3);
        }
        Node node2 = (Node)this.dispatch(gNode3);
        List<LetBinding> list5 = this.getBindings(node2);
        List<LetBinding> list6 = this.groupList(list, list5);
        Node node3 = this.factory.consWrapper(node, node2);
        if (null != list6) {
            node3.setProperty(LETBINDINGS, list6);
        }
        return node3;
    }

    public Node visitWildCard(GNode gNode) {
        return Transformer.toLiteral("BooleanLiteral", "true");
    }

    public Node visitFieldExpression(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode.hasProperty(INANALYZE)) {
            gNode2.setProperty(INANALYZE, Boolean.TRUE);
        }
        if ("TupleConstructor".equals(((Node)gNode2).getName())) {
            String string = Primitives.convertName(gNode.getString(1));
            if ("Limits".equals(gNode2.getString(0))) {
                if (Primitives.hasIntegerType(string)) {
                    return this.factory.createInteger(Transformer.toIdentifier("xtc.Limits." + string));
                }
                return Transformer.toIdentifier("xtc.Limits." + string);
            }
            return Transformer.toIdentifier("Primitives." + string);
        }
        this.passVariables(gNode, gNode2);
        if (this.replaceType && "type".equals(gNode.getString(1))) {
            return (Node)this.dispatch(gNode2);
        }
        Node node = (Node)this.dispatch(gNode2);
        Node node2 = this.factory.fieldExpression(node, gNode.getString(1));
        this.passBindings(node, node2);
        return node2;
    }

    public Node visitTupleLiteral(GNode gNode) {
        return this.makeTuple(gNode);
    }

    public Node visitTuplePattern(GNode gNode) {
        Object object;
        String string = (String)gNode.getProperty(MATCHARG);
        Node node = this.factory.jand(this.factory.notEqualsBottom(Transformer.toIdentifier(string)), this.factory.sizeEqual(Transformer.toIdentifier(string), Transformer.toLiteral("IntegerLiteral", Integer.toString(gNode.size()))));
        for (int i = 0; i < gNode.size(); ++i) {
            object = gNode.getGeneric(i);
            if (((Node)object).hasName("WildCard")) continue;
            if (((Node)object).hasName("Variable")) {
                ((Node)object).setProperty(RHS, string + ".get" + (i + 1) + "()");
                ((Node)object).setProperty(BINDINGS, gNode.getProperty(BINDINGS));
                this.dispatch((Node)object);
                continue;
            }
            if (this.isLiteral((Node)object)) {
                node = this.factory.jand(node, this.factory.jequals2((Node)this.dispatch((Node)object), Transformer.toIdentifier(string + ".get" + (i + 1) + "()")));
                continue;
            }
            ((Node)object).setProperty(RHS, string + ".get" + (i + 1) + "()");
            ((Node)object).setProperty(BINDINGS, gNode.getProperty(BINDINGS));
            ((Node)object).setProperty(MATCHARG, (String)gNode.getProperty(MATCHARG) + ".get" + (i + 1) + "()");
            node = this.factory.jand(node, (Node)this.dispatch((Node)object));
        }
        if (gNode.hasProperty(TOP)) {
            String string2 = this.table.freshJavaId("match");
            node = this.replaceMatchArg(node, string);
            object = new Match(this.mapper.toTypeNode(gNode.getProperty(TYPE), false), node);
            if (this.matches.containsKey(object)) {
                string2 = this.matches.get(object);
            } else {
                this.matches.put((Match)object, string2);
                Object object2 = gNode.getProperty(TYPE);
                Node node2 = null;
                node2 = this.mapper.hasTypeVariables(object2) ? this.mapper.toTypeNode(object2, true) : this.mapper.toTypeNode(object2, false);
                Node node3 = this.factory.matchFunction(string2, node2, node);
                node3.getGeneric(4).getGeneric(0).set(3, "m");
                this.staticFields.add(node3);
            }
            return this.factory.matchCall(Transformer.toIdentifier(this.output + "Support"), string2, Transformer.toIdentifier((String)gNode.getProperty(MATCHARG)));
        }
        return node;
    }

    public Node visitListLiteral(GNode gNode) {
        return this.makeList(gNode);
    }

    private Node replaceMatchArg(Node node, String string) {
        for (int i = 0; i < node.size(); ++i) {
            Object object = node.get(i);
            if (object instanceof Node) {
                Node node2 = (Node)object;
                if (node2.hasName("PrimaryIdentifier") && node2.getString(0).equals(string)) {
                    node2.set(0, node2.getString(0).replace(string, "m"));
                    continue;
                }
                if (node2.hasName("PrimaryIdentifier") && node2.getString(0).startsWith(string + ".")) {
                    node2.set(0, node2.getString(0).replace(string + ".", "m."));
                    continue;
                }
                this.replaceMatchArg(node2, string);
                continue;
            }
            if (!(object instanceof String) || !string.equals(object)) continue;
            node.set(i, string);
        }
        return node;
    }

    public Node visitListPattern(GNode gNode) {
        Object object;
        Node node;
        this.checkTypeAnnotation(gNode);
        String string = (String)gNode.getProperty(MATCHARG);
        Node node2 = 0 == gNode.size() ? this.factory.isEmptyCall(Transformer.toIdentifier(string)) : this.factory.sizeEqual(Transformer.toIdentifier(string), Transformer.toLiteral("IntegerLiteral", Integer.toString(gNode.size())));
        for (int i = 0; i < gNode.size(); ++i) {
            node = gNode.getGeneric(i);
            if (node.hasName("WildCard")) continue;
            if (node.hasName("Variable")) {
                object = gNode.getProperty(TYPE);
                if (this.mapper.hasTypeVariables(object)) {
                    ((Node)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(node.getString(0), this.mapper.toTypeNode(this.mapper.getBase(object), false), Transformer.toIdentifier(string + ".get(" + i + ")")));
                    continue;
                }
                ((Node)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(node.getString(0), this.mapper.toTypeNode(this.mapper.getBase(object), false), this.factory.cast(Transformer.toIdentifier(string + ".get(" + i + ")"))));
                continue;
            }
            if (this.isLiteral(node)) {
                node2 = this.factory.jand(node2, this.factory.jequals2((Node)this.dispatch(node), Transformer.toIdentifier(string + ".get(" + i + ")")));
                continue;
            }
            node.setProperty(BINDINGS, gNode.getProperty(BINDINGS));
            node.setProperty(MATCHARG, string + ".get(" + i + ")");
            node2 = this.factory.jand(node2, (Node)this.dispatch(node));
        }
        if (gNode.hasProperty(TOP)) {
            Object object2 = gNode.getProperty(TYPE);
            node = null;
            node = this.mapper.hasTypeVariables(object2) ? this.mapper.toTypeNode(object2, true) : this.mapper.toTypeNode(object2, false);
            node2 = this.replaceMatchArg(node2, string);
            object = this.table.freshJavaId("match");
            Match match = null;
            match = new Match(node, node2);
            if (this.matches.containsKey(match)) {
                object = this.matches.get(match);
            } else {
                this.matches.put(match, (String)object);
                Node node3 = this.factory.matchFunction((String)object, node, node2);
                node3.getGeneric(4).getGeneric(0).set(3, "m");
                this.staticFields.add(node3);
            }
            return this.factory.matchCall(Transformer.toIdentifier(this.output + "Support"), (String)object, Transformer.toIdentifier((String)gNode.getProperty(MATCHARG)));
        }
        return node2;
    }

    public Node visitPredicateExpression(GNode gNode) {
        GNode gNode2;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
        }
        GNode gNode3 = gNode.getGeneric(0).getGeneric(0);
        for (int i = 0; i < gNode3.size(); ++i) {
            gNode2 = gNode3.getGeneric(i);
            gNode2.setProperty(RHS, RHS);
            gNode2.setProperty(BINDINGS, GNode.create("Block"));
            gNode2.setProperty("enterScope", "scope" + i);
        }
        GNode gNode4 = GNode.create("WildCard");
        gNode4.setProperty("enterScope", "ihavenoscope");
        gNode2 = GNode.create("PatternMatch", GNode.create("Patterns", gNode4), GNode.create("BooleanLiteral", "false"));
        GNode gNode5 = GNode.create("PatternMatch", gNode.getGeneric(0).getGeneric(0), GNode.create("BooleanLiteral", "true"));
        GNode gNode6 = GNode.create("PatternMatching", gNode5, gNode2);
        TypeMapper.PatternMatchType patternMatchType = this.mapper.makePatternMatchType(gNode3.getProperty(TYPE), gNode.getProperty(TYPE));
        gNode5.setProperty(TYPE, patternMatchType);
        gNode2.setProperty(TYPE, patternMatchType);
        gNode6.setProperty(TYPE, patternMatchType);
        gNode5.setProperty("enterScope", "predicatescope");
        gNode2.setProperty("enterScope", "predicatescope");
        GNode gNode7 = GNode.create("MatchExpression", gNode.getGeneric(1), gNode6);
        gNode7.setProperty("__arg_type", gNode.getProperty("__arg_type"));
        gNode7.setProperty(TYPE, gNode.getProperty(TYPE));
        return this.factory.jequals2((Node)this.dispatch(gNode7), Transformer.toLiteral("BooleanLiteral", "true"));
    }

    public Node visitGuardExpression(GNode gNode) {
        Set<String> set = new FreeVariableCollector(gNode).getIdentifiers();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Object object2 = gNode.getGeneric(0).getProperty(TYPE);
        Node node = this.mapper.toTypeNode(object2, false);
        String string = this.table.freshJavaId("result");
        for (String object3 : set) {
            arrayList.add(this.factory.ifStatement(this.factory.isNull(Transformer.toIdentifier(object3)), this.factory.ret(Transformer.toIdentifier("null"))));
        }
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode.hasProperty(INANALYZE)) {
            gNode2.setProperty(INANALYZE, Boolean.TRUE);
        }
        this.passVariables(gNode, gNode2);
        Node node2 = (Node)this.dispatch(gNode2);
        arrayList.add(this.factory.fieldDecl2(node, string, node2));
        if (this.mapper.hasTypeVariables(object2)) {
            arrayList.add(this.factory.ifStatement(this.factory.isNull(Transformer.toIdentifier(string)), this.factory.ret((Node)this.dispatch(gNode.getGeneric(1)))));
        } else {
            arrayList.add(this.factory.ifStatement(this.factory.isNull(Transformer.toIdentifier(string)), this.factory.ret(this.factory.cast((Node)this.dispatch(gNode.getGeneric(1))))));
        }
        arrayList.add(this.factory.ret(Transformer.toIdentifier(string)));
        Node node3 = this.factory.guardExpression(node, arrayList);
        this.passBindings(node2, node3);
        return node3;
    }

    public Node visitReduceExpression(GNode gNode) {
        Node node = Transformer.toIdentifier("lst");
        Node node2 = Transformer.toIdentifier("runtime");
        ArrayList<Node> arrayList = new ArrayList<Node>();
        GNode gNode2 = gNode.getGeneric(0);
        for (int i = 0; i < gNode2.size(); ++i) {
            String string = gNode2.getString(i);
            if ("required".equals(string)) {
                arrayList.add(this.factory.reduceReq());
                continue;
            }
            if ("optional".equals(string)) {
                arrayList.add(this.factory.reduceOpt());
                continue;
            }
            if ("list".equals(string)) {
                arrayList.add(this.factory.reduceList());
                continue;
            }
            if ("set".equals(string)) {
                arrayList.add(this.factory.reduceSet());
                continue;
            }
            if ("dup".equals(string)) {
                arrayList.add(this.factory.reduceDup());
                continue;
            }
            if ("nodup".equals(string)) {
                arrayList.add(this.factory.reduceNodup());
                continue;
            }
            if (!"singleton".equals(string)) continue;
            arrayList.add(this.factory.reduceSing());
        }
        arrayList.add(this.factory.reduceTag(gNode.getGeneric(1)));
        GNode gNode3 = gNode.getGeneric(2);
        for (int i = 0; i < gNode3.size(); ++i) {
            GNode gNode4 = gNode3.getGeneric(i);
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            ArrayList<Node> arrayList3 = new ArrayList<Node>();
            arrayList2.add((Node)this.dispatch(gNode4.getGeneric(1)));
            GNode gNode5 = gNode4.getGeneric(0).getGeneric(0);
            for (int j = 0; j < gNode5.size(); ++j) {
                GNode gNode6 = gNode5.getGeneric(j);
                if (((Node)gNode6).hasName("AsPattern")) {
                    String string = gNode6.getString(1);
                    gNode6 = gNode6.getGeneric(0);
                    gNode6.setProperty("ancestor", true);
                    gNode6.setProperty(TOP, true);
                    gNode6.setProperty(MATCHARG, this.table.freshJavaId("arg"));
                    arrayList3.add(this.factory.reduceGetMatch(string, (Node)this.dispatch(gNode6)));
                }
                gNode6.setProperty("ancestor", true);
                gNode6.setProperty(TOP, true);
                gNode6.setProperty(MATCHARG, this.table.freshJavaId("arg"));
                arrayList2.add((Node)this.dispatch(gNode6));
            }
            arrayList3.add(this.factory.reduceAddPatterns(arrayList2));
            arrayList.add(this.factory.block(arrayList3));
        }
        return this.factory.cast(this.factory.reduceExpression(node, node2, arrayList));
    }

    public Node visitFunctionApplication(GNode gNode) {
        List<Object> list;
        List<Object> list2;
        Object object;
        Object object2;
        GNode gNode2 = gNode.getGeneric(gNode.size() - 1);
        GNode gNode3 = gNode.getGeneric(0);
        if ("ancestor".equals(gNode3.getString(0)) || "parent".equals(gNode3.getString(0))) {
            Node node = gNode2.getGeneric(0);
            node.setProperty("ancestor", true);
            node.setProperty(MATCHARG, this.table.freshJavaId("arg"));
            node = (Node)this.dispatch(node);
            ArrayList<Node> arrayList = new ArrayList<Node>(1);
            arrayList.add(node);
            return this.factory.apply(Transformer.toIdentifier(gNode3.getString(0)), arrayList);
        }
        if (gNode.hasProperty(INANALYZE)) {
            for (int i = 0; i < gNode2.size(); ++i) {
                gNode2.getGeneric(i).setProperty(INANALYZE, Boolean.TRUE);
            }
        }
        GNode gNode4 = GNode.create("Arguments");
        List<LetBinding> list3 = null;
        List<String> list4 = this.getUpVariables(gNode);
        for (int i = 0; i < gNode2.size(); ++i) {
            object2 = gNode2.getGeneric(i);
            if (null != list4) {
                ((Node)object2).setProperty(UPVARS, list4);
            }
            object = (Node)this.dispatch((Node)object2);
            list2 = this.getBindings((Node)object);
            list = this.extractVariables(list2);
            list4 = this.groupList(list4, list);
            list3 = this.groupList(list3, list2);
            gNode4.add(object);
        }
        Node node = null;
        if (3 == gNode.size()) {
            String string = gNode.getGeneric(0).getString(0);
            String string2 = "Prelude".equals(string) ? gNode.getGeneric(1).getString(0) : string + "." + gNode.getGeneric(1).getString(0);
            object = this.table.current().lookup("value(" + string2 + ")");
            list2 = this.mapper.getParameterTypes(object);
            list = this.mapper.getParameterTypeNodes(object);
            Node node2 = this.mapper.getReturnTypeNode(object);
            object2 = Primitives.convertName(gNode.getGeneric(1).getString(0));
            if ("Map".equals(string)) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                if ("get".equals(object2)) {
                    arrayList.add(gNode4.getGeneric(0));
                    arrayList.add(Transformer.toIdentifier("hashTable"));
                    node = this.factory.castInvocation(Transformer.toIdentifier("Primitives.get"), "apply", arrayList);
                    if (null != list3) {
                        node.setProperty(LETBINDINGS, list3);
                    }
                    return node;
                }
                if (2 == gNode4.size()) {
                    arrayList.add(gNode4.getGeneric(0));
                    arrayList.add(gNode4.getGeneric(1));
                    arrayList.add(Transformer.toIdentifier("hashTable"));
                    node = this.factory.castInvocation(Transformer.toIdentifier("Primitives.put"), "apply", arrayList);
                    if (null != list3) {
                        node.setProperty(LETBINDINGS, list3);
                    }
                    return node;
                }
                String string3 = this.table.freshJavaId("var");
                node = this.factory.curryingPut(Transformer.toIdentifier(string3), gNode4.getGeneric(0));
                if (null != list3) {
                    node.setProperty(LETBINDINGS, list3);
                }
                return node;
            }
            if (gNode4.size() == list2.size()) {
                Node node3 = null;
                if ("head".equals(object2) || "tail".equals(object2) || "append".equals(object2) || "union".equals(object2) || "cons".equals(object2) || "nth".equals(object2) || "intersection".equals(object2) || "subtraction".equals(object2)) {
                    String string4;
                    Object object3 = this.mapper.getBase(gNode2.getGeneric(0).getProperty(TYPE));
                    String string5 = this.mapper.toTypeString(object3);
                    Node node4 = this.mapper.toTypeNode(object3, false);
                    if (this.mapper.hasTypeVariables(object3)) {
                        if ("head".equals(object2)) {
                            node = this.factory.newApplyHead(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("tail".equals(object2)) {
                            node = this.factory.newApplyHead(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("append".equals(object2)) {
                            node = this.factory.newApplyAppend(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("union".equals(object2)) {
                            node = this.factory.newApplyUnion(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("cons".equals(object2)) {
                            node = this.factory.newApplyCons(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("nth".equals(object2)) {
                            node = this.factory.newApplyNth(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("intersection".equals(object2)) {
                            node = this.factory.newApplyIntersection(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("subtraction".equals(object2)) {
                            node = this.factory.newApplySubtraction(node4, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string5);
                    String string6 = this.getInstanceName((String)object2, arrayList);
                    if (null == string6) {
                        string4 = this.table.freshJavaId((String)object2);
                        this.primitiveInsList.add(new PrimitiveInstance((String)object2, arrayList, string4));
                    } else {
                        string4 = string6;
                    }
                    if (null == string6 && "head".equals(object2)) {
                        node3 = this.factory.newHead(node4, string4);
                    } else if (null == string6 && "tail".equals(object2)) {
                        node3 = this.factory.newTail(node4, string4);
                    } else if (null == string6 && "append".equals(object2)) {
                        node3 = this.factory.newAppend(node4, string4);
                    } else if (null == string6 && "union".equals(object2)) {
                        node3 = this.factory.newUnion(node4, string4);
                    } else if (null == string6 && "cons".equals(object2)) {
                        node3 = this.factory.newCons(node4, string4);
                    } else if (null == string6 && "nth".equals(object2)) {
                        node3 = this.factory.newNth(node4, string4);
                    } else if (null == string6 && "intersection".equals(object2)) {
                        node3 = this.factory.newIntersection(node4, string4);
                    } else if (null == string6 && "subtraction".equals(object2)) {
                        node3 = this.factory.newSubtraction(node4, string4);
                    }
                    if (null == string6) {
                        this.primitiveDeclList.add(node3);
                    }
                    node = this.factory.apply(Transformer.toIdentifier(this.output + "Support." + string4), Transformer.makeArgumentList(gNode4));
                    if (null != list3) {
                        node.setProperty(LETBINDINGS, list3);
                    }
                    return node;
                }
                if ("exists".equals(object2)) {
                    String string7;
                    Object object4 = this.mapper.getBase(gNode2.getGeneric(1).getProperty(TYPE));
                    String string8 = this.mapper.toTypeString(object4);
                    Node node5 = this.mapper.toTypeNode(object4, false);
                    if (this.mapper.hasTypeVariables(object4)) {
                        node = this.factory.newApplyExists(node5, Transformer.makeArgumentList(gNode4));
                        if (null != list3) {
                            node.setProperty(LETBINDINGS, list3);
                        }
                        return node;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string8);
                    String string9 = this.getInstanceName((String)object2, arrayList);
                    if (null == string9) {
                        string7 = this.table.freshJavaId((String)object2);
                        this.primitiveInsList.add(new PrimitiveInstance((String)object2, arrayList, string7));
                        node3 = this.factory.newExists(node5, string7);
                        this.primitiveDeclList.add(node3);
                    } else {
                        string7 = string9;
                    }
                    node = this.factory.apply(Transformer.toIdentifier(this.output + "Support." + string7), Transformer.makeArgumentList(gNode4));
                    if (null != list3) {
                        node.setProperty(LETBINDINGS, list3);
                    }
                    return node;
                }
                if ("map".equals(object2) || "iter".equals(object2)) {
                    String string10;
                    Object object5 = gNode2.getGeneric(0).getProperty(TYPE);
                    String string11 = this.mapper.getReturnType(object5);
                    Node node6 = this.mapper.getReturnTypeNode(object5);
                    Object object6 = this.mapper.getBase(gNode2.getGeneric(1).getProperty(TYPE));
                    String string12 = this.mapper.toTypeString(object6);
                    Node node7 = this.mapper.toTypeNode(object6, false);
                    if (this.mapper.hasTypeVariables(object5) || this.mapper.hasTypeVariables(object6)) {
                        if ("map".equals(object2)) {
                            node = this.factory.newApplyMap(node6, node7, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                        if ("iter".equals(object2)) {
                            node = this.factory.newApplyIter(node6, node7, Transformer.makeArgumentList(gNode4));
                            if (null != list3) {
                                node.setProperty(LETBINDINGS, list3);
                            }
                            return node;
                        }
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string11);
                    arrayList.add(string12);
                    String string13 = this.getInstanceName((String)object2, arrayList);
                    if (null == string13) {
                        string10 = this.table.freshJavaId((String)object2);
                        this.primitiveInsList.add(new PrimitiveInstance((String)object2, arrayList, string10));
                    } else {
                        string10 = string13;
                    }
                    if (null == string13 && "map".equals(object2)) {
                        node3 = this.factory.newMap(node6, node7, string10);
                    } else if (null == string13 && "iter".equals(object2)) {
                        node3 = this.factory.newIter(node6, node7, string10);
                    }
                    if (null == string13) {
                        this.primitiveDeclList.add(node3);
                    }
                    node = this.factory.apply(Transformer.toIdentifier(this.output + "Support." + string10), Transformer.makeArgumentList(gNode4));
                    if (null != list3) {
                        node.setProperty(LETBINDINGS, list3);
                    }
                    return node;
                }
                if ("foldl".equals(object2)) {
                    String string14;
                    Object object7 = gNode2.getGeneric(2).getProperty(TYPE);
                    String string15 = this.mapper.toTypeString(object7);
                    Node node8 = this.mapper.toTypeNode(object7, false);
                    Object object8 = this.mapper.getBase(gNode2.getGeneric(1).getProperty(TYPE));
                    String string16 = this.mapper.toTypeString(object8);
                    Node node9 = this.mapper.toTypeNode(object8, false);
                    if (this.mapper.hasTypeVariables(object7) || this.mapper.hasTypeVariables(object8)) {
                        node = this.factory.newApplyFoldl(node8, node9, Transformer.makeArgumentList(gNode4));
                        if (null != list3) {
                            node.setProperty(LETBINDINGS, list3);
                        }
                        return node;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string15);
                    arrayList.add(string16);
                    String string17 = this.getInstanceName((String)object2, arrayList);
                    if (null == string17) {
                        string14 = this.table.freshJavaId((String)object2);
                        this.primitiveInsList.add(new PrimitiveInstance((String)object2, arrayList, string14));
                        node3 = this.factory.newFoldl(node8, node9, string14);
                        this.primitiveDeclList.add(node3);
                    } else {
                        string14 = string17;
                    }
                    node = this.factory.apply(Transformer.toIdentifier(this.output + "Support." + string14), Transformer.makeArgumentList(gNode4));
                    if (null != list3) {
                        node.setProperty(LETBINDINGS, list3);
                    }
                    return node;
                }
                node = this.factory.applyPrimitive((String)object2, Transformer.makeArgumentList(gNode4));
                if (null != list3) {
                    node.setProperty(LETBINDINGS, list3);
                }
                return node;
            }
            node = this.makeCurry("Primitives." + (String)object2, gNode4, list, node2, object);
            if (null != list3) {
                node.setProperty(LETBINDINGS, list3);
            }
            return node;
        }
        String string = gNode.getGeneric(0).getString(0);
        object2 = Primitives.convertName(gNode.getGeneric(0).getString(0));
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if ("lookup".equals(object2) || "lookupLocally".equals(object2)) {
            if (1 == gNode2.size()) {
                arrayList.add((Node)this.dispatch(gNode2.getGeneric(0)));
                arrayList.add(Transformer.toIdentifier("getNameSpace"));
                node = this.factory.castInvocation(Transformer.toIdentifier((String)object2 + "2"), "apply", arrayList);
                if (null != list3) {
                    node.setProperty(LETBINDINGS, list3);
                }
                return node;
            }
            if (2 == gNode2.size()) {
                Node node10 = (Node)this.dispatch(gNode2.getGeneric(0));
                if ("ErrorClause".equals(gNode2.getGeneric(1).getName())) {
                    String string18 = gNode2.getGeneric(1).getGeneric(0).getString(0);
                    arrayList.add(node10);
                    arrayList.add(Transformer.toLiteral("StringLiteral", "\"" + string18 + "\""));
                    arrayList.add((Node)this.dispatch(gNode2.getGeneric(1).getGeneric(1)));
                    arrayList.add(Transformer.toIdentifier("getNameSpace"));
                    node = this.factory.castInvocation(Transformer.toIdentifier((String)object2 + "4"), "apply", arrayList);
                    if (null != list3) {
                        node.setProperty(LETBINDINGS, list3);
                    }
                    return node;
                }
                arrayList.add(node10);
                arrayList.add(Transformer.toIdentifier("getNameSpace"));
                node = this.factory.castInvocation(Transformer.toIdentifier((String)object2 + "2"), "apply", arrayList);
                if (null != list3) {
                    node.setProperty(LETBINDINGS, list3);
                }
                return node;
            }
            String string19 = gNode2.getGeneric(2).getGeneric(0).getString(0);
            arrayList.add((Node)this.dispatch(gNode2.getGeneric(0)));
            arrayList.add(Transformer.toLiteral("StringLiteral", "\"" + string19 + "\""));
            arrayList.add((Node)this.dispatch(gNode2.getGeneric(2).getGeneric(1)));
            arrayList.add(Transformer.toIdentifier("getNameSpace"));
            node = this.factory.castInvocation(Transformer.toIdentifier((String)object2 + "4"), "apply", arrayList);
            if (null != list3) {
                node.setProperty(LETBINDINGS, list3);
            }
            return node;
        }
        if ("define".equals(object2)) {
            if (2 == gNode2.size()) {
                arrayList.add((Node)this.dispatch(gNode2.getGeneric(0)));
                arrayList.add((Node)this.dispatch(gNode2.getGeneric(1)));
                arrayList.add(Transformer.toIdentifier("getNameSpace"));
                node = this.factory.apply(Transformer.toIdentifier("define3"), arrayList);
                if (null != list3) {
                    node.setProperty(LETBINDINGS, list3);
                }
                return node;
            }
            String string20 = gNode2.getGeneric(2).getGeneric(0).getString(0);
            arrayList.add((Node)this.dispatch(gNode2.getGeneric(0)));
            arrayList.add((Node)this.dispatch(gNode2.getGeneric(1)));
            arrayList.add(Transformer.toLiteral("StringLiteral", "\"" + string20 + "\""));
            arrayList.add((Node)this.dispatch(gNode2.getGeneric(2).getGeneric(1)));
            arrayList.add(Transformer.toIdentifier("getNameSpace"));
            node = this.factory.invocation(Transformer.toIdentifier("define5"), "apply", arrayList);
            if (null != list3) {
                node.setProperty(LETBINDINGS, list3);
            }
            return node;
        }
        if ("isDefined".equals(object2) || "isDefinedLocally".equals(object2) || "redefine".equals(object2)) {
            gNode4.add(Transformer.toIdentifier("getNameSpace"));
            node = this.factory.apply(Transformer.toIdentifier((String)object2), Transformer.makeArgumentList(gNode4));
            if (null != list3) {
                node.setProperty(LETBINDINGS, list3);
            }
            return node;
        }
        object = this.table.current().lookup("value(" + string + ")");
        list2 = this.mapper.getParameterTypes(object);
        list = this.mapper.getParameterTypeNodes(object);
        Node node11 = this.mapper.getReturnTypeNode(object);
        if (gNode4.size() == list2.size()) {
            if (Primitives.isPrimitive((String)object2)) {
                node = this.factory.applyPrimitive((String)object2, Transformer.makeArgumentList(gNode4));
                if (null != list3) {
                    node.setProperty(LETBINDINGS, list3);
                }
                return node;
            }
            node = this.factory.apply(Transformer.toIdentifier((String)object2), Transformer.makeArgumentList(gNode4));
            if (null != list3) {
                node.setProperty(LETBINDINGS, list3);
            }
            return node;
        }
        if (Primitives.isPrimitive((String)object2)) {
            node = this.makeCurry("Primitives." + (String)object2, gNode4, list, node11, object);
            if (null != list3) {
                node.setProperty(LETBINDINGS, list3);
            }
            return node;
        }
        node = this.makeCurry((String)object2, gNode4, list, node11, object);
        if (null != list3) {
            node.setProperty(LETBINDINGS, list3);
        }
        return node;
    }

    private Node makeTuple(GNode gNode) {
        Object object;
        Node node;
        GNode gNode2;
        GNode gNode3 = GNode.create("Arguments");
        List<String> list = this.getUpVariables(gNode);
        List list2 = null;
        for (int i = 0; i < gNode.size(); ++i) {
            gNode2 = gNode.getGeneric(i);
            if (gNode.hasProperty(INANALYZE)) {
                gNode2.setProperty(INANALYZE, Boolean.TRUE);
            }
            if (null != list) {
                gNode2.setProperty(UPVARS, list);
            }
            node = (Node)this.dispatch(gNode2);
            gNode3.add(node);
            object = this.getBindings(node);
            Iterable<Object> iterable = this.extractVariables((List<LetBinding>)object);
            list = this.groupList((List)list, (List)iterable);
            list2 = this.groupList(list2, (List)object);
        }
        List<Node> list3 = this.mapper.getMemberNodes(gNode.getProperty(TYPE));
        gNode2 = GNode.create("TypeArguments");
        for (Iterable<Object> iterable : list3) {
            gNode2.add(iterable);
        }
        node = !list3.isEmpty() ? GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Tuple", null), GNode.create("TypeInstantiation", "T" + list3.size(), gNode2)), null) : GNode.create("Type", GNode.create("QualifiedIdentifier", "Tuple", "T0"), null);
        object = this.toNewExpression2(node, gNode3, null);
        if (null != list2) {
            ((Node)object).setProperty(LETBINDINGS, list2);
        }
        return object;
    }

    private Node makeList(GNode gNode) {
        Node node;
        ArrayList<Node> arrayList = new ArrayList<Node>(gNode.size());
        List<LetBinding> list = null;
        List<String> list2 = this.getUpVariables(gNode);
        for (int i = 0; i < gNode.size(); ++i) {
            node = gNode.getGeneric(i);
            if (gNode.hasProperty(INANALYZE)) {
                node.setProperty(INANALYZE, Boolean.TRUE);
            }
            if (null != list2) {
                node.setProperty(UPVARS, list2);
            }
            Node node2 = (Node)this.dispatch(node);
            arrayList.add(node2);
            List<LetBinding> list3 = this.getBindings(node2);
            List<String> list4 = this.extractVariables(list3);
            list2 = this.groupList(list2, list4);
            list = this.groupList(list, list3);
        }
        if (arrayList.isEmpty()) {
            String string = this.getType(this.mapper.getBase(gNode.getProperty(TYPE)));
            node = this.mapper.toTypeNode(this.mapper.getBase(gNode.getProperty(TYPE)), false);
            if ("Object".equals(string)) {
                return this.factory.invocation(Transformer.toIdentifier("Pair"), "empty", arrayList);
            }
            return this.factory.pairEmpty(node);
        }
        Node node3 = this.factory.newPair(this.mapper.toTypeNode(gNode.getProperty(TYPE), false), (Node)arrayList.get(0));
        for (int i = 1; i < arrayList.size(); ++i) {
            node3 = this.factory.appendPair(node3, this.toNewExpression2(this.mapper.toTypeNode(gNode.getProperty(TYPE), false), GNode.create("Arguments", arrayList.get(i)), null));
        }
        if (null != list) {
            node3.setProperty(LETBINDINGS, list);
        }
        return node3;
    }

    public Node visitConsPattern(GNode gNode) {
        String string = this.table.freshJavaId("list");
        String string2 = (String)gNode.getProperty(RHS);
        String string3 = (String)gNode.getProperty(MATCHARG);
        Object object = gNode.getProperty(TYPE);
        if (this.mapper.hasTypeVariables(object)) {
            ((Node)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(string, this.mapper.toTypeNode(object, false), Transformer.toIdentifier(string2)));
        } else {
            ((Node)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(string, this.mapper.toTypeNode(object, false), this.factory.cast(Transformer.toIdentifier(string2))));
        }
        Node node = gNode.getGeneric(0);
        node.setProperty(MATCHARG, "Primitives.wrapHead(" + string3 + ")");
        node.setProperty(RHS, "Primitives.wrapHead(" + string + ")");
        node.setProperty(BINDINGS, gNode.getProperty(BINDINGS));
        Node node2 = gNode.getGeneric(1);
        node2.setProperty(MATCHARG, "Primitives.wrapTail(" + string3 + ".tail()");
        node2.setProperty(RHS, "Primitives.wrapTail(" + string + ")");
        node2.setProperty(BINDINGS, gNode.getProperty(BINDINGS));
        if ((node.hasName("WildCard") || node.hasName("Variable")) && (((Node)node2).hasName("WildCard") || ((Node)node2).hasName("Variable"))) {
            this.dispatch(node);
            this.dispatch(node2);
            return this.factory.isNotEmptyCall(Transformer.toIdentifier(string3));
        }
        if (((Node)node2).hasName("WildCard") || ((Node)node2).hasName("Variable")) {
            node = (Node)this.dispatch(node);
            this.dispatch(node2);
            return this.factory.jequals(node, this.factory.headWrapper(Transformer.toIdentifier(string3)));
        }
        if (node.hasName("WildCard") || node.hasName("Variable")) {
            node2 = (Node)this.dispatch(node2);
            this.dispatch(node);
            return this.factory.jequals(node2, this.factory.tailWrapper(Transformer.toIdentifier(string3)));
        }
        return this.factory.jand(this.factory.jequals((Node)this.dispatch(node), this.factory.headWrapper(Transformer.toIdentifier(string3))), this.factory.jequals((Node)this.dispatch(node2), this.factory.tailWrapper(Transformer.toIdentifier(string3))));
    }

    public Node visitMatchExpression(GNode gNode) {
        Object object = this.mapper.getPatternMatchLeftType(gNode.getGeneric(1).getProperty(TYPE));
        String string = this.table.freshJavaId("arg");
        gNode.getGeneric(1).setProperty(TOP, null);
        gNode.getGeneric(1).setProperty(MATCHARG, string);
        gNode.getGeneric(1).setProperty(RHS, string);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node = this.mapper.toTypeNode(object, false);
        if (this.nodeType.equals(node) || this.gnodeType.equals(node)) {
            arrayList.add(this.makeVarDec2(string, node, this.factory.gnodeCast((Node)this.dispatch(gNode.getGeneric(0)))));
            if (gNode.hasProperty(INANALYZE)) {
                gNode.getGeneric(1).setProperty(ANNOTATE, Boolean.TRUE);
            } else {
                gNode.getGeneric(1).setProperty(SCOPE, Boolean.TRUE);
            }
        } else if (this.mapper.hasTypeVariables(object)) {
            arrayList.add(this.makeVarDec2(string, node, (Node)this.dispatch(gNode.getGeneric(0))));
        } else {
            arrayList.add(this.makeVarDec2(string, node, this.factory.cast((Node)this.dispatch(gNode.getGeneric(0)))));
        }
        if (!this.containsBottomMatch(gNode.getGeneric(1))) {
            arrayList.add(this.factory.ifStatement4(Transformer.toIdentifier(string)));
        }
        List list = (List)this.dispatch(gNode.getGeneric(1));
        arrayList.addAll(list);
        arrayList.add(this.factory.ret(this.nullNode));
        Node node2 = this.factory.matchExpression(this.mapper.toTypeNode(gNode.getProperty(TYPE), false), arrayList);
        return node2;
    }

    private boolean containsBottomMatch(Node node) {
        for (int i = 0; i < node.size(); ++i) {
            GNode gNode = node.getGeneric(i).getGeneric(0);
            for (int j = 0; j < gNode.size(); ++j) {
                GNode gNode2 = gNode.getGeneric(j);
                if (!((Node)gNode2).hasName("BottomPattern")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTypeConstructorMatch(Node node) {
        for (int i = 0; i < node.size(); ++i) {
            if (!node.getGeneric(i).getGeneric(0).getGeneric(0).hasName("TypeConstructorPattern") || this.mapper.isNode(node.getGeneric(i).getGeneric(0).getGeneric(0).getProperty(TYPE))) continue;
            return true;
        }
        return false;
    }

    public List<Node> visitPatternMatching(GNode gNode) {
        Object object;
        String string;
        int n = gNode.size();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = this.isTypeConstructorMatch(gNode);
        for (int i = 0; i < n; ++i) {
            GNode gNode2 = gNode.getGeneric(i).getGeneric(0);
            for (int j = 0; j < gNode2.size(); ++j) {
                string = (String)gNode.getGeneric(i).getProperty("enterScope");
                if (null == string) {
                    string = (String)gNode.getGeneric(i).getProperty("enterScope");
                }
                this.enterScope(string);
                object = GNode.create("PatternMatch", GNode.create("Patterns", gNode2.getGeneric(j)), gNode.getGeneric(i).getGeneric(1));
                ((Node)object).setProperty(TOP, null);
                ((Node)object).setProperty(MATCHARG, gNode.getProperty(MATCHARG));
                ((Node)object).setProperty(RHS, gNode.getProperty(MATCHARG));
                ((Node)object).setProperty(TYPE, gNode.getProperty(TYPE));
                if (gNode.hasProperty(ANNOTATE)) {
                    ((Node)object).setProperty(ANNOTATE, Boolean.TRUE);
                }
                if (gNode.hasProperty(SCOPE)) {
                    ((Node)object).setProperty(SCOPE, Boolean.TRUE);
                }
                if (bl) {
                    ((Node)object).setProperty("TCMatch", null);
                }
                arrayList.add((Node)this.dispatch((Node)object));
                this.exitScope(string);
            }
        }
        if (this.runtime.test("optimizeMatch")) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("default", new ArrayList());
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node = arrayList.get(i);
                if (node.hasProperty("TName")) {
                    string = (String)node.getProperty("TName");
                    if (hashMap.containsKey(string)) {
                        ((ArrayList)hashMap.get(string)).add(node);
                        continue;
                    }
                    object = new ArrayList();
                    ((ArrayList)object).add(node);
                    hashMap.put(string, object);
                    continue;
                }
                ((ArrayList)hashMap.get("default")).add(node);
            }
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            Node node = this.factory.switchStmnt(Transformer.toIdentifier((String)gNode.getProperty(MATCHARG)));
            node = GNode.ensureVariable(GNode.cast(node));
            string = this.table.freshJavaId("default");
            for (String string2 : hashMap.keySet()) {
                if ("default".equals(string2)) continue;
                node.add(this.makeCase(GNode.create("PrimaryIdentifier", string2), (List)hashMap.get(string2), string));
            }
            node.add(GNode.create("DefaultClause", GNode.create("BreakStatement", null)));
            arrayList2.add(this.factory.switchWrap(Transformer.toIdentifier((String)gNode.getProperty(MATCHARG)), node));
            if (((ArrayList)hashMap.get("default")).size() > 0) {
                arrayList2.addAll((Collection)hashMap.get("default"));
            }
            if (bl) {
                return arrayList2;
            }
        }
        return arrayList;
    }

    public Node visitTypedPattern(GNode gNode) {
        return (Node)this.dispatch(gNode.getGeneric(0));
    }

    public Node visitAsPattern(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(0);
        String string = (String)gNode.getProperty(RHS);
        String string2 = (String)gNode.getProperty(MATCHARG);
        if (gNode.hasProperty(TOP)) {
            gNode2.setProperty(TOP, null);
        }
        gNode2.setProperty(MATCHARG, gNode.getProperty(MATCHARG));
        gNode2.setProperty(RHS, string);
        gNode2.setProperty(BINDINGS, gNode.getProperty(BINDINGS));
        gNode2.setProperty(TYPE, gNode2.getProperty(TYPE));
        Object object = gNode2.getProperty(TYPE);
        if (this.mapper.hasTypeVariables(object)) {
            ((Node)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(gNode.getString(1), this.mapper.toTypeNode(object, false), Transformer.toIdentifier(string2)));
        } else {
            ((Node)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(gNode.getString(1), this.mapper.toTypeNode(object, false), this.factory.cast(Transformer.toIdentifier(string2))));
        }
        if (this.isLiteral(gNode)) {
            return this.factory.jequals((Node)this.dispatch(gNode2), Transformer.toIdentifier(string2));
        }
        return (Node)this.dispatch(gNode2);
    }

    public Node visitWhenPattern(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(0);
        gNode2.setProperty(TOP, null);
        gNode2.setProperty(RHS, gNode.getProperty(RHS));
        gNode2.setProperty(BINDINGS, gNode.getProperty(BINDINGS));
        gNode2.setProperty(TYPE, gNode.getProperty(TYPE));
        gNode2.setProperty(MATCHARG, gNode.getProperty(MATCHARG));
        if (gNode.hasProperty(TOP)) {
            gNode2.setProperty(TOP, null);
        }
        Node node = (Node)this.dispatch(gNode.getGeneric(1));
        node = this.checkToLet(node, gNode.getGeneric(1).getProperty(TYPE));
        return this.factory.ifStatement(node, (Node)this.dispatch(gNode2));
    }

    public Node visitPatternMatch(GNode gNode) {
        Iterable<Object> iterable;
        Node node = this.conditions;
        String string = (String)gNode.getProperty(RHS);
        GNode gNode2 = gNode.getGeneric(0);
        GNode gNode3 = gNode.getGeneric(1);
        String string2 = (String)gNode.getProperty(MATCHARG);
        Node node2 = this.toIfStatement(null, null);
        if (gNode.hasProperty(INANALYZE)) {
            gNode3.setProperty(INANALYZE, Boolean.TRUE);
        }
        gNode2.setProperty(TOP, null);
        gNode2.setProperty(BINDINGS, node2.getGeneric(1));
        gNode2.setProperty(MATCHARG, string2);
        gNode2.setProperty(RHS, string);
        if ("WhenPattern".equals(gNode2.getGeneric(0).getName())) {
            Iterable<Object> iterable2;
            GNode gNode4 = (GNode)this.dispatch(gNode2);
            if (gNode2.getGeneric(0).getGeneric(0).hasName("WildCard") || gNode2.getGeneric(0).getGeneric(0).hasName("Variable")) {
                node2.set(0, Transformer.toLiteral("BooleanLiteral", "true"));
            } else {
                node2.set(0, GNode.create(gNode4.getGeneric(1).getGeneric(0)));
            }
            if (this.optimizeLet && null != (iterable2 = this.getPatternVariables(gNode2.getGeneric(0))) && !iterable2.isEmpty()) {
                gNode3.setProperty(UPVARS, iterable2);
            }
            iterable2 = (Node)this.dispatch(gNode3);
            gNode4.getGeneric(1).set(0, this.factory.ret((Node)iterable2));
            node2.getGeneric(1).add(gNode4);
            if (gNode.hasProperty(ANNOTATE) || gNode.hasProperty(SCOPE)) {
                return this.augmentIfStatement(node2, string2, gNode, (Node)iterable2);
            }
            return this.addToIf(node2, (Node)iterable2);
        }
        if (((Node)gNode2).hasName("WildCard") || ((Node)gNode2).hasName("Variable")) {
            node2.set(0, Transformer.toLiteral("BooleanLiteral", "true"));
            this.dispatch(gNode2);
        } else {
            node2.set(0, this.dispatch(gNode2));
        }
        if (this.optimizeLet && null != (iterable = this.getPatternVariables(gNode2.getGeneric(0))) && !iterable.isEmpty()) {
            gNode3.setProperty(UPVARS, iterable);
        }
        iterable = (Node)this.dispatch(gNode3);
        Object object = this.mapper.getPatternMatchRightType(gNode.getProperty(TYPE));
        if (((Node)iterable).hasName("Block")) {
            node2.getGeneric(1).add(iterable);
        } else if (this.conditions == null) {
            if (this.mapper.hasTypeVariables(object)) {
                node2.getGeneric(1).add(this.factory.ret((Node)iterable));
            } else {
                node2.getGeneric(1).add(this.factory.ret(this.factory.cast((Node)iterable)));
            }
        } else {
            GNode gNode5 = GNode.create("Block");
            Node node3 = this.toIfStatement(this.conditions, gNode5);
            if (this.mapper.hasTypeVariables(object)) {
                gNode5.add(this.factory.ret((Node)iterable));
            } else {
                gNode5.add(this.factory.ret(this.factory.cast((Node)iterable)));
            }
            node2.getGeneric(1).add(node3);
        }
        this.conditions = node;
        if (gNode.hasProperty(ANNOTATE) || gNode.hasProperty(SCOPE)) {
            return this.augmentIfStatement(node2, string2, gNode, (Node)iterable);
        }
        if (gNode.hasProperty("TCMatch")) {
            if (gNode.getGeneric(0).getGeneric(0).hasName("TypeConstructorPattern")) {
                node2.setProperty("TName", gNode.getGeneric(0).getGeneric(0).getString(0));
            }
            if (gNode.getGeneric(0).getGeneric(0).hasName("AsPattern") && gNode.getGeneric(0).getGeneric(0).getGeneric(0).hasName("TypeConstructorPattern")) {
                node2.setProperty("TName", gNode.getGeneric(0).getGeneric(0).getGeneric(0).getString(0));
            }
        }
        return this.addToIf(node2, (Node)iterable);
    }

    public Node visitTypeConstructorPattern(GNode gNode) {
        Iterable<Node> iterable;
        Iterable<Object> iterable2;
        Object object;
        Object object2;
        String string = gNode.getString(0);
        Object object3 = gNode.getProperty(TYPE);
        Node node = this.mapper.toTypeNode(object3, false);
        String string2 = (String)gNode.getProperty(MATCHARG);
        Node node2 = Transformer.toIdentifier(string2);
        Node node3 = null;
        Node node4 = (Node)gNode.getProperty(BINDINGS);
        int n = gNode.size();
        if (this.nodeType.equals(node) || this.gnodeType.equals(node)) {
            node3 = this.factory.hasNameCall(Transformer.toIdentifier(string2), Transformer.toLiteral("StringLiteral", "\"" + string + "\""));
            if (n != 1 && !gNode.getGeneric(1).hasName("WildCard")) {
                object2 = gNode.getGeneric(1);
                object = this.mapper.getMembers(object3);
                iterable2 = this.mapper.getMemberObjects(object3);
                iterable = this.mapper.getMemberNodes(object3);
                boolean bl = false;
                for (Object object4 : iterable2) {
                    if (!this.mapper.isVariable(object4)) continue;
                    bl = true;
                }
                node3 = ((String)object.get(object.size() - 1)).startsWith("Pair") || bl ? this.factory.jand(node3, this.factory.sizeGreaterEqual(node2, Transformer.toLiteral("IntegerLiteral", Integer.toString(((Node)object2).size() - 1)))) : this.factory.jand(node3, this.factory.sizeEqual(node2, Transformer.toLiteral("IntegerLiteral", Integer.toString(((Node)object2).size()))));
                for (int i = 0; i < ((Node)object2).size(); ++i) {
                    Object object4;
                    object4 = (String)object.get(i);
                    Node node5 = (Node)iterable.get(i);
                    GNode gNode2 = ((Node)object2).getGeneric(i);
                    if (((Node)gNode2).hasName("Variable")) {
                        if ("String".equals(object4)) {
                            node4.add(this.factory.makeNodeBinding2(gNode2.getString(0), Transformer.toIdentifier(string2), Transformer.toLiteral("IntegerLiteral", Integer.toString(i))));
                            continue;
                        }
                        if ("Node".equals(object.get(i)) || "GNode".equals(object.get(i))) {
                            node4.add(this.factory.makeNodeBinding(gNode2.getString(0), Transformer.toIdentifier(string2), Transformer.toLiteral("IntegerLiteral", Integer.toString(i))));
                            continue;
                        }
                        if (!((String)object4).startsWith("Pair")) continue;
                        node4.add(this.makeVarDec2(gNode2.getString(0), node5, this.factory.cast(Transformer.toIdentifier("Primitives.getChildren(" + string2 + ", " + i + ", " + string2 + ".size())"))));
                        continue;
                    }
                    if (((Node)gNode2).hasName("WildCard")) continue;
                    if (this.isLiteral(gNode2)) {
                        node3 = this.factory.jand(node3, this.factory.jequals2((Node)this.dispatch(gNode2), Transformer.toIdentifier(string2 + ".getString(" + i + ")")));
                        continue;
                    }
                    gNode2.setProperty(BINDINGS, node4);
                    if ("String".equals(object.get(i))) {
                        gNode2.setProperty(MATCHARG, string2 + ".getString(" + i + ")");
                    } else if ("Node".equals(object.get(i)) || "GNode".equals(object.get(i))) {
                        gNode2.setProperty(MATCHARG, string2 + ".getGeneric(" + i + ")");
                    } else if (((String)object.get(i)).startsWith("Pair")) {
                        gNode2.setProperty(MATCHARG, "Primitives.getChildren(" + string2 + ", " + i + ", " + string2 + ".size())");
                    }
                    node3 = this.factory.jand(node3, (Node)this.dispatch(gNode2));
                }
            }
        } else {
            node3 = this.factory.isMethodCall(node2, "is" + string);
            if (gNode.size() != 1 && !gNode.getGeneric(1).hasName("WildCard")) {
                object2 = gNode.getGeneric(1);
                object = this.mapper.getMemberNodes(object3);
                for (int i = 0; i < ((Node)object2).size(); ++i) {
                    iterable = ((Node)object2).getGeneric(i);
                    if (((Node)iterable).hasName("WildCard")) continue;
                    if (((Node)iterable).hasName("Variable")) {
                        node4.add(this.makeVarDec2(((Node)iterable).getString(0), (Node)object.get(i), this.factory.cast(Transformer.toIdentifier(string2 + ".getTuple().get" + (i + 1) + "()"))));
                        continue;
                    }
                    if (this.isLiteral((Node)iterable)) {
                        node3 = this.factory.jand(node3, this.factory.jequals2((Node)this.dispatch((Node)iterable), Transformer.toIdentifier(string2 + ".getTuple().get" + (i + 1) + "()")));
                        continue;
                    }
                    ((Node)iterable).setProperty(MATCHARG, string2 + ".getTuple().get" + (i + 1) + "()");
                    node3 = this.factory.jand(node3, (Node)this.dispatch((Node)iterable));
                }
            }
        }
        if (gNode.hasProperty(TOP) || gNode.hasProperty("ancestor")) {
            node3 = this.replaceMatchArg(node3, string2);
            if (gNode.hasProperty("ancestor")) {
                object2 = this.factory.ancestorExpression(this.factory.ret(node3));
                if (this.nodeMatches.containsKey(object2)) {
                    return this.factory.support(Transformer.toIdentifier(this.output + "Support"), this.nodeMatches.get(object2));
                }
                object = this.table.freshJavaId("nodeMatch");
                this.staticFields.add(this.factory.supportNodeMatch((String)object, (Node)object2));
                this.nodeMatches.put((Node)object2, (String)object);
                return this.factory.support(Transformer.toIdentifier(this.output + "Support"), (String)object);
            }
            object2 = this.table.freshJavaId("match");
            object = new Match(this.mapper.toTypeNode(gNode.getProperty(TYPE), false), node3);
            if (this.matches.containsKey(object)) {
                object2 = this.matches.get(object);
            } else {
                this.matches.put((Match)object, (String)object2);
                iterable2 = null;
                iterable2 = this.mapper.hasTypeVariables(object3) ? this.mapper.toTypeNode(object3, true) : this.mapper.toTypeNode(object3, false);
                iterable = this.factory.matchFunction((String)object2, (Node)iterable2, node3);
                ((Node)iterable).getGeneric(4).getGeneric(0).set(3, "m");
                this.staticFields.add((Node)iterable);
            }
            return this.factory.matchCall(Transformer.toIdentifier(this.output + "Support"), (String)object2, Transformer.toIdentifier((String)gNode.getProperty(MATCHARG)));
        }
        return node3;
    }

    public Node visitPatternParameters(GNode gNode) {
        return this.makeTuple(gNode);
    }

    public void visitVariantDeclaration(GNode gNode) {
        GNode gNode2;
        String string = (String)gNode.getProperty("name");
        GNode gNode3 = GNode.create("ClassBody");
        GNode gNode4 = GNode.create("EnumConstants");
        GNode gNode5 = GNode.create("EnumDeclaration", GNode.create("Modifiers", GNode.create("Modifier", "public"), GNode.create("Modifier", "static")), "Tag", null, gNode4, null);
        gNode3.add(gNode5);
        gNode3.add(this.factory.defaultConstr(string));
        gNode3.add(this.factory.getTagAbstract());
        for (int i = 0; i < gNode.size(); ++i) {
            Node node32;
            Object object2;
            Node node2;
            gNode2 = gNode.getGeneric(i);
            this.addEnum(gNode4, gNode2.getString(0));
            Object object3 = gNode2.getProperty(TYPE);
            List<String> list = this.mapper.getMembers(object3);
            List<Node> list2 = this.mapper.getMemberNodes(object3);
            int n = list.size();
            GNode gNode6 = GNode.create("FormalParameters");
            GNode gNode7 = GNode.create("ClassBody");
            GNode gNode8 = GNode.create("Arguments");
            for (int j = 0; j < n; ++j) {
                node2 = list2.get(j);
                object2 = "member" + (j + 1);
                gNode8.add(Transformer.toIdentifier((String)object2));
                gNode6.add(GNode.create("FormalParameter", null, node2, null, object2, null));
            }
            GNode gNode9 = GNode.create("Block");
            node2 = GNode.create("ConstructorDeclaration", this.pmod, null, gNode2.getString(0), gNode6, null, gNode9);
            object2 = GNode.create("TypeArguments");
            for (Node node32 : list2) {
                ((Node)object2).add(node32);
            }
            GNode gNode10 = !list2.isEmpty() ? GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Tuple", null), GNode.create("TypeInstantiation", "T" + list2.size(), object2)), null) : GNode.create("Type", GNode.create("QualifiedIdentifier", "Tuple", "T0"), null);
            gNode9.add(this.factory.assign(Transformer.toIdentifier("tuple"), this.factory.newExpr(gNode10, Transformer.makeArgumentList(gNode8))));
            gNode7.add(node2);
            gNode7.add(this.factory.getTag(gNode2.getString(0)));
            Node node4 = this.factory.isMethod();
            node4.set(3, "is" + gNode2.getString(0));
            gNode3.add(node4);
            node32 = this.factory.isMethod();
            node32.set(3, "is" + gNode2.getString(0));
            node32.getGeneric(7).getGeneric(0).getGeneric(0).set(0, "true");
            gNode7.add(node32);
            gNode7.add(this.factory.getNameMethod(GNode.create("StringLiteral", "\"" + gNode2.getString(0) + "\"")));
            for (Equality equality : this.equalities) {
                if (!equality.name.equals(gNode2.getString(0))) continue;
                gNode7.add(this.createVariantEqualsMethod(gNode2.getString(0)));
                break;
            }
            Object object5 = "\"" + gNode2.getString(0);
            object5 = n > 0 ? (String)object5 + " of \" + tuple.toString()" : (String)object5 + "\"";
            Node object4 = this.factory.toStringMethod();
            object4.set(7, GNode.create("Block", this.factory.ret(Transformer.toLiteral("StringLiteral", (String)object5))));
            gNode7.add(object4);
            GNode gNode11 = GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", string, GNode.create("TypeArguments", gNode10))), null);
            this.tbody.add(Transformer.comment(this.makeExtendedClassDecl(gNode2.getString(0), gNode11, gNode7), "Implementation of constructor '" + gNode2.getString(0) + "' in variant '" + string + "'."));
        }
        String string2 = string + "<T extends Tuple>";
        gNode2 = GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Variant", GNode.create("TypeArguments", GNode.create("Type", GNode.create("QualifiedIdentifier", "T"), null)))), null);
        this.tbody.add(Transformer.comment(this.makeExtendedClassDecl2(string2, gNode2, gNode3), "Superclass of all constructors in variant '" + string + "'."));
    }

    private Node makeExtendedClassDecl(String string, Node node, Node node2) {
        Node node3 = this.factory.extendsDecl();
        node3.set(1, string);
        node3.getGeneric(3).set(0, node);
        node3.set(5, node2);
        return node3;
    }

    private Node makeExtendedClassDecl2(String string, Node node, Node node2) {
        Node node3 = this.factory.extendsDecl2();
        node3.set(1, string);
        node3.getGeneric(3).set(0, node);
        node3.set(5, node2);
        return node3;
    }

    private Node makeImplementedClassDecl(String string, String string2, Node node) {
        Node node2 = this.factory.implementsDecl();
        node2.set(1, string);
        node2.getGeneric(4).set(0, Transformer.toType(string2));
        node2.set(5, node);
        return node2;
    }

    public void visitRecordDeclaration(GNode gNode) {
        String string = (String)gNode.getProperty("name");
        Object object = gNode.getProperty(TYPE);
        List<Node> list = this.mapper.getFieldTypeNodes(object);
        List<String> list2 = this.mapper.getFieldNames(object);
        GNode gNode2 = GNode.create("ClassBody");
        StringBuilder stringBuilder = new StringBuilder("\"{\"");
        Node node = null;
        GNode gNode3 = GNode.create("Block");
        if ("type".equals(string)) {
            node = this.createTypeRecordEquals();
        } else {
            node = this.factory.equalsMethod();
            node.set(7, gNode3);
            gNode3.add(this.toIfStatement(this.factory.jnot(this.toInstanceOf(Transformer.toIdentifier("o"), Transformer.toType(string))), this.factory.ret(Transformer.toLiteral("BooleanLiteral", "true"))));
            gNode3.add(this.makeVarDec("r", string, this.factory.cast(Transformer.toIdentifier("o"))));
        }
        GNode gNode4 = GNode.create("Block");
        GNode gNode5 = GNode.create("ConstructorDeclaration", this.pmod, null, string, GNode.create("FormalParameters"), null, gNode4);
        GNode gNode6 = gNode5.getGeneric(3);
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = list2.get(i);
            Node node2 = list.get(i);
            stringBuilder.append(" + (null == " + string2 + " ? \"?\" : " + string2 + ".toString())");
            gNode6.add(GNode.create("FormalParameter", null, node2, null, string2, null));
            gNode4.add(this.factory.assign(this.factory.thisExpr(string2), Transformer.toIdentifier(string2)));
            if (i < list2.size() - 1) {
                stringBuilder.append(" + \",\" ");
            }
            gNode2.add(this.factory.publicFieldDecl(node2, string2));
            gNode3.add(this.toIfStatement(this.factory.jnot(this.factory.jequals(Transformer.toIdentifier(string2), this.factory.fieldExpression(Transformer.toIdentifier("r"), string2))), this.factory.ret(Transformer.toLiteral("BooleanLiteral", "false"))));
        }
        gNode3.add(this.factory.ret(Transformer.toLiteral("BooleanLiteral", "true")));
        stringBuilder.append(" + \"}\"");
        Node node3 = this.factory.toStringMethod();
        node3.getGeneric(7).set(0, this.factory.ret(Transformer.toLiteral("StringLiteral", stringBuilder.toString())));
        gNode2.add(gNode5);
        gNode2.add(node);
        gNode2.add(node3);
        this.tbody.add(Transformer.comment(this.makeImplementedClassDecl(string, "Record", gNode2), "Implementation of record '" + string + "'."));
    }

    public Node visitTupleConstructor(GNode gNode) {
        GNode gNode2 = GNode.create("Arguments");
        if (gNode.hasProperty(INANALYZE)) {
            for (int i = 1; i < gNode.size(); ++i) {
                gNode.getGeneric(i).setProperty(INANALYZE, Boolean.TRUE);
            }
        }
        List<LetBinding> list = null;
        List<String> list2 = this.getUpVariables(gNode);
        if (gNode.getProperty(TYPE) != null && this.gnodeType.equals(this.mapper.toTypeNode(gNode.getProperty(TYPE), false)) || this.nodeType.equals(this.mapper.toTypeNode(gNode.getProperty(TYPE), false))) {
            ArrayList<Node> arrayList = new ArrayList<Node>(gNode.size());
            arrayList.add(Transformer.toLiteral("StringLiteral", "\"" + gNode.getString(0) + "\""));
            for (int i = 1; i < gNode.size(); ++i) {
                GNode gNode3 = gNode.getGeneric(i);
                if (null != list2) {
                    gNode3.setProperty(UPVARS, list2);
                }
                Node node = (Node)this.dispatch(gNode3);
                List<LetBinding> list3 = this.getBindings(node);
                List<String> list4 = this.extractVariables(list3);
                list2 = this.groupList(list2, list4);
                list = this.groupList(list, list3);
                arrayList.add(node);
            }
            Node node = this.factory.gnodeCreate(arrayList);
            if (null != list) {
                node.setProperty(LETBINDINGS, list);
            }
            return node;
        }
        for (int i = 1; i < gNode.size(); ++i) {
            GNode gNode4 = gNode.getGeneric(i);
            if (null != list2) {
                gNode4.setProperty(UPVARS, list2);
            }
            Node node = (Node)this.dispatch(gNode4);
            List<LetBinding> list5 = this.getBindings(node);
            List<String> list6 = this.extractVariables(list5);
            list2 = this.groupList(list2, list6);
            list = this.groupList(list, list5);
            gNode2.add(node);
        }
        Node node = this.toNewExpression2(this.mapper.toTypeNode(gNode.getString(0), false), gNode2, null);
        if (null != list) {
            node.setProperty(LETBINDINGS, list);
        }
        return node;
    }

    private Node toInstanceOf(Node node, Node node2) {
        return GNode.create("InstanceOfExpression", node, node2);
    }

    public Node visitLowerID(GNode gNode) {
        String string = Primitives.convertName(gNode.getString(0));
        if (Primitives.isPrimitive(string)) {
            if ("nonce".equals(string)) {
                return this.factory.apply2(Transformer.toIdentifier("Primitives." + string));
            }
            return Transformer.toIdentifier("Primitives." + string);
        }
        return Transformer.toIdentifier(string);
    }

    public void visitVariable(GNode gNode) {
        String string = gNode.getString(0);
        Object object = gNode.getProperty(TYPE);
        Node node = this.mapper.toTypeNode(object, false);
        String string2 = (String)gNode.getProperty(RHS);
        if (this.table.current().isDefinedLocally(SymbolTable.toNameSpace(string, "value"))) {
            if (this.nodeType.equals(node) || this.gnodeType.equals(node)) {
                ((GNode)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(string, node, this.factory.gnodeCast(Transformer.toIdentifier(string2))));
            } else if (this.mapper.hasTypeVariables(object)) {
                ((GNode)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(string, node, Transformer.toIdentifier(string2)));
            } else {
                ((GNode)gNode.getProperty(BINDINGS)).add(this.makeVarDec2(string, node, this.factory.cast(Transformer.toIdentifier(string2))));
            }
        } else {
            Node node2 = this.factory.jequals(Transformer.toIdentifier(string2), Transformer.toIdentifier(string));
            this.conditions = this.conditions == null ? node2 : this.factory.jand(this.conditions, node2);
        }
    }

    public Node visitRecordExpression(GNode gNode) {
        boolean bl;
        boolean bl2 = bl = null != gNode.getGeneric(0) && gNode.getGeneric(0).getGeneric(0).hasName("Bottom");
        if (gNode.hasProperty(INANALYZE)) {
            for (int i = 0; i < gNode.size(); ++i) {
                gNode.getGeneric(i).setProperty(INANALYZE, Boolean.TRUE);
            }
        }
        if (this.replaceType && "type".equals(gNode.getGeneric(1).getString(0))) {
            return (Node)this.dispatch(gNode.getGeneric(1).getGeneric(1));
        }
        Object object = gNode.getProperty(TYPE);
        List<String> list = this.mapper.getFieldNames(object);
        GNode gNode2 = gNode.getGeneric(0);
        GNode gNode3 = GNode.create("Arguments");
        List<LetBinding> list2 = null;
        List<String> list3 = this.getUpVariables(gNode);
        for (String string : list) {
            boolean bl3 = false;
            for (int i = 1; i < gNode.size(); ++i) {
                if (!string.equals(gNode.getGeneric(i).getString(0))) continue;
                bl3 = true;
                Node node = gNode.getGeneric(i).getNode(1);
                if (null != list3) {
                    node.setProperty(UPVARS, list3);
                }
                Node node2 = (Node)this.dispatch(node);
                List<LetBinding> list4 = this.getBindings(node2);
                List<String> list5 = this.extractVariables(list4);
                list3 = this.groupList(list3, list5);
                list2 = this.groupList(list2, list4);
                gNode3.add(node2);
            }
            if (!bl3 && "WithExpression".equals(((Node)gNode2).getName())) {
                if (!bl) {
                    Node node = (Node)this.dispatch(gNode2.getGeneric(0));
                    node = this.checkToLet(node, gNode2.getGeneric(0).getProperty(TYPE));
                    gNode3.add(this.factory.fieldExpression(node, string));
                    continue;
                }
                gNode3.add(GNode.create("NullLiteral"));
                continue;
            }
            if (!bl3) assert (bl3) : "cannot determine field value";
        }
        Node node = this.toNewExpression2(this.mapper.toTypeNode(object, false), gNode3, null);
        if (null != list2) {
            node.setProperty(LETBINDINGS, list2);
        }
        return node;
    }

    public Node visitFieldAssign(GNode gNode) {
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (!this.optimizeLet) {
            return this.factory.assignField(Transformer.toIdentifier(gNode.getString(0)), (Node)this.dispatch(gNode.getNode(1)));
        }
        this.passVariables(gNode, gNode.getGeneric(1));
        Node node = (Node)this.dispatch(gNode.getNode(1));
        Node node2 = this.factory.assignField(Transformer.toIdentifier(gNode.getString(0)), node);
        this.passBindings(node, node2);
        return node2;
    }

    /*
     * WARNING - void declaration
     */
    public Node visitLetExpression(GNode gNode) {
        void var16_34;
        int n;
        if (this.runtime.test("optimizeFoldLet")) {
            new LetFolder().collapseLet(gNode, this.table);
        }
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
        }
        String string = (String)gNode.getProperty("enterScope");
        boolean bl = false;
        if (gNode.hasProperty("enterScope") && !this.table.current().getName().equals(string)) {
            this.enterScope(string);
            bl = true;
        }
        GNode gNode2 = gNode.getGeneric(0);
        GNode gNode3 = gNode.getGeneric(1);
        Object object2 = gNode.getProperty(TYPE);
        int n2 = gNode2.size();
        GNode gNode4 = null;
        Node node = null;
        Object object3 = gNode3.getProperty(TYPE);
        if (!this.optimizeLet) {
            node = (GNode)this.dispatch(gNode3);
            gNode4 = "Block".equals(node.getName()) ? GNode.create("Block", node) : (this.mapper.hasTypeVariables(object3) ? GNode.create("Block", this.factory.ret(node)) : GNode.create("Block", this.factory.ret(this.factory.cast(node))));
            GNode gNode5 = GNode.create("ClassBody");
            gNode5 = GNode.ensureVariable(gNode5);
            GNode gNode6 = GNode.create("Block");
            for (int i = 0; i < n2; ++i) {
                Object object;
                String string2;
                GNode gNode7 = gNode2.getGeneric(i);
                GNode gNode8 = gNode7.getGeneric(0);
                GNode object5 = gNode7.getGeneric(1);
                if (gNode.hasProperty(INANALYZE)) {
                    object5.setProperty(INANALYZE, Boolean.TRUE);
                }
                Node node2 = (Node)this.dispatch(object5);
                if (((Node)gNode8).hasName("Variable")) {
                    string2 = gNode8.getString(0);
                    object = gNode8.getProperty(TYPE);
                    gNode5.add(this.makeVarDec2(string2, this.mapper.toTypeNode(object, false), null));
                    if (this.mapper.hasTypeVariables(object)) {
                        gNode6.add(this.factory.assign(Transformer.toIdentifier(string2), node2));
                        continue;
                    }
                    gNode6.add(this.factory.assign(Transformer.toIdentifier(string2), this.factory.cast(node2)));
                    continue;
                }
                if ("TypedPattern".equals(((Node)gNode8).getName()) && "Variable".equals(gNode8.getGeneric(0).getName())) {
                    string2 = gNode8.getGeneric(0).getString(0);
                    object = gNode8.getProperty(TYPE);
                    gNode5.add(this.makeVarDec2(string2, this.mapper.toTypeNode(object, false), null));
                    if (this.mapper.hasTypeVariables(object)) {
                        gNode6.add(this.factory.assign(Transformer.toIdentifier(string2), node2));
                        continue;
                    }
                    gNode6.add(this.factory.assign(Transformer.toIdentifier(string2), this.factory.cast(node2)));
                    continue;
                }
                if (node2.hasName("ConditionalExpression")) {
                    gNode6.add(this.factory.discard(node2));
                    continue;
                }
                gNode6.add(this.factory.expressionStmnt(node2));
            }
            if (gNode6.size() > 0) {
                gNode5.add(gNode6);
            }
            gNode5.add(GNode.create("MethodDeclaration", Transformer.toModifiers("public"), null, this.mapper.toTypeNode(object2, false), "apply", GNode.create("FormalParameters"), null, null, gNode4));
            Node node3 = this.factory.letExpression(this.mapper.toTypeNode(object2, false));
            node3.getGeneric(0).set(4, gNode5);
            if (bl) {
                this.exitScope(string);
            }
            return node3;
        }
        List<String> list = this.getUpVariables(gNode);
        List<LetBinding> list2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < n2; ++n) {
            GNode gNode9 = gNode2.getGeneric(n);
            GNode gNode5 = gNode9.getGeneric(0);
            if (((Node)gNode5).hasName("Variable")) {
                arrayList.add(gNode5.getString(0));
                continue;
            }
            if (!"TypedPattern".equals(((Node)gNode5).getName()) || !"Variable".equals(gNode5.getGeneric(0).getName())) continue;
            arrayList.add(gNode5.getGeneric(0).getString(0));
        }
        n = 0;
        for (String string3 : arrayList) {
            if (null == list || !list.contains(string3)) continue;
            n = 1;
        }
        list = n != 0 ? arrayList : this.groupList(list, arrayList);
        for (int i = 0; i < n2; ++i) {
            Object object;
            String string4;
            GNode gNode6 = gNode2.getGeneric(i);
            GNode gNode7 = gNode6.getGeneric(0);
            GNode gNode8 = gNode6.getGeneric(1);
            if (((Node)gNode7).hasName("Variable")) {
                string4 = gNode7.getString(0);
                object = gNode7.getProperty(TYPE);
            } else if ("TypedPattern".equals(((Node)gNode7).getName()) && "Variable".equals(gNode7.getGeneric(0).getName())) {
                string4 = gNode7.getGeneric(0).getString(0);
                object = gNode7.getProperty(TYPE);
            } else {
                string4 = this.spareVar;
                object = gNode8.getProperty(TYPE);
            }
            gNode8.setProperty(UPVARS, list);
            Node node2 = (Node)this.dispatch(gNode8);
            List<LetBinding> list3 = this.getBindings(node2);
            List<String> list4 = this.extractVariables(list3);
            list2 = this.groupList(list2, list3);
            if (null == list2) {
                list2 = new ArrayList<LetBinding>();
                list2.add(new LetBinding(string4, object, this.mapper.toTypeNode(object, false), node2));
            } else {
                list2.add(new LetBinding(string4, object, this.mapper.toTypeNode(object, false), node2));
            }
            list = this.groupList(list, list4);
        }
        gNode3.setProperty(UPVARS, list);
        node = (Node)this.dispatch(gNode3);
        List<LetBinding> list5 = this.getBindings(node);
        list2 = this.groupList(list2, list5);
        Object var16_31 = null;
        if (n != 0 || gNode.hasProperty(NEWLET)) {
            Node node3 = this.convertToLet(node, list2, object3);
        } else {
            node.setProperty(LETBINDINGS, list2);
            Node node4 = node;
        }
        if (bl) {
            this.exitScope(string);
        }
        return var16_34;
    }

    private Node checkToLet(Node node, Object object) {
        List<LetBinding> list = this.getBindings(node);
        if (null == list || list.isEmpty()) {
            return node;
        }
        GNode gNode = null;
        gNode = "Block".equals(node.getName()) ? GNode.create("Block", node) : (this.mapper.hasTypeVariables(object) ? GNode.create("Block", this.factory.ret(node)) : GNode.create("Block", this.factory.ret(this.factory.cast(node))));
        GNode gNode2 = GNode.create("ClassBody");
        gNode2 = GNode.ensureVariable(gNode2);
        GNode gNode3 = GNode.create("Block");
        for (LetBinding letBinding : list) {
            if (!letBinding.name.equals(this.spareVar)) {
                gNode2.add(this.makeVarDec2(letBinding.name, letBinding.type, null));
            }
            if (this.mapper.hasTypeVariables(letBinding.typeObject)) {
                gNode3.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), letBinding.value));
                continue;
            }
            gNode3.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), this.factory.cast(letBinding.value)));
        }
        if (gNode3.size() > 0) {
            gNode2.add(gNode3);
        }
        gNode2.add(GNode.create("MethodDeclaration", Transformer.toModifiers("public"), null, this.mapper.toTypeNode(object, false), "apply", GNode.create("FormalParameters"), null, null, gNode));
        Node node2 = this.factory.letExpression(this.mapper.toTypeNode(object, false));
        node2.getGeneric(0).set(4, gNode2);
        return node2;
    }

    private Node convertToLet(Node node, List<LetBinding> list, Object object) {
        GNode gNode = null;
        gNode = "Block".equals(node.getName()) ? GNode.create("Block", node) : (this.mapper.hasTypeVariables(object) ? GNode.create("Block", this.factory.ret(node)) : GNode.create("Block", this.factory.ret(this.factory.cast(node))));
        GNode gNode2 = GNode.create("ClassBody");
        gNode2 = GNode.ensureVariable(gNode2);
        GNode gNode3 = GNode.create("Block");
        for (LetBinding letBinding : list) {
            if (!letBinding.name.equals(this.spareVar)) {
                gNode2.add(this.makeVarDec2(letBinding.name, letBinding.type, null));
            }
            if (this.mapper.hasTypeVariables(letBinding.typeObject)) {
                gNode3.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), letBinding.value));
                continue;
            }
            gNode3.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), this.factory.cast(letBinding.value)));
        }
        if (gNode3.size() > 0) {
            gNode2.add(gNode3);
        }
        gNode2.add(GNode.create("MethodDeclaration", Transformer.toModifiers("public"), null, this.mapper.toTypeNode(object, false), "apply", GNode.create("FormalParameters"), null, null, gNode));
        Node node2 = this.factory.letExpression(this.mapper.toTypeNode(object, false));
        node2.getGeneric(0).set(4, gNode2);
        return node2;
    }

    public Node visitPatterns(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode.hasProperty(TOP)) {
            gNode2.setProperty(TOP, null);
        }
        if (this.isLiteral(gNode2)) {
            return this.factory.jequals((Node)this.dispatch(gNode2), Transformer.toIdentifier((String)gNode.getProperty(MATCHARG)));
        }
        gNode2.setProperty(MATCHARG, gNode.getProperty(MATCHARG));
        gNode2.setProperty(BINDINGS, gNode.getProperty(BINDINGS));
        gNode2.setProperty(RHS, gNode.getProperty(RHS));
        return (GNode)this.dispatch(gNode2);
    }

    private boolean isLiteral(Node node) {
        if (null != node) {
            String string = node.getName();
            return "StringLiteral".equals(string) || "BooleanLiteral".equals(string) || "FloatingLiteral".equals(string) || "IntegerLiteral".equals(string);
        }
        this.runtime.error("Calling isLiteral on null node", node);
        return false;
    }

    public Node visitAdditiveExpression(GNode gNode) {
        Node node;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        String string = gNode.getString(1);
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(2).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list3 = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list3);
        }
        if (null != (list3 = this.groupList(list3, list2 = this.extractVariables(list = this.getBindings(node = (Node)this.dispatch(gNode.getGeneric(0))))))) {
            gNode.getGeneric(2).setProperty(UPVARS, list3);
        }
        Node node2 = (Node)this.dispatch(gNode.getGeneric(2));
        List<LetBinding> list4 = this.getBindings(node2);
        list = this.groupList(list, list4);
        Node node3 = "+".equals(string) ? this.factory.addInt(node, node2) : ("-".equals(string) ? this.factory.subtractInt(node, node2) : ("+.".equals(string) ? this.factory.addFloat64(node, node2) : this.factory.subtractFloat64(node, node2)));
        if (null != list) {
            node3.setProperty(LETBINDINGS, list);
        }
        return node3;
    }

    public Node visitConcatenationExpression(GNode gNode) {
        Node node;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(2).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list3 = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list3);
        }
        if (null != (list3 = this.groupList(list3, list2 = this.extractVariables(list = this.getBindings(node = (Node)this.dispatch(gNode.getGeneric(0))))))) {
            gNode.getGeneric(2).setProperty(UPVARS, list3);
        }
        Node node2 = (Node)this.dispatch(gNode.getGeneric(2));
        List<LetBinding> list4 = this.getBindings(node2);
        list = this.groupList(list, list4);
        Node node3 = "^".equals(gNode.getString(1)) ? this.factory.concatStrings(node, node2) : this.factory.concatLists(node, node2);
        if (null != list) {
            node3.setProperty(LETBINDINGS, list);
        }
        return node3;
    }

    public Node visitMultiplicativeExpression(GNode gNode) {
        Node node;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        String string = gNode.getString(1);
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(2).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list3 = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list3);
        }
        if (null != (list3 = this.groupList(list3, list2 = this.extractVariables(list = this.getBindings(node = (Node)this.dispatch(gNode.getGeneric(0))))))) {
            gNode.getGeneric(2).setProperty(UPVARS, list3);
        }
        Node node2 = (Node)this.dispatch(gNode.getGeneric(2));
        List<LetBinding> list4 = this.getBindings(node2);
        list = this.groupList(list, list4);
        Node node3 = "*".equals(string) ? this.factory.multiplyInt(node, node2) : ("/".equals(string) ? this.factory.divideInt(node, node2) : ("%".equals(string) ? this.factory.modInt(node, node2) : ("*.".equals(string) ? this.factory.multiplyFloat64(node, node2) : this.factory.divideFloat64(node, node2))));
        if (null != list) {
            node3.setProperty(LETBINDINGS, list);
        }
        return node3;
    }

    public Node visitRelationalExpression(GNode gNode) {
        Node node;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(2).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list3 = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list3);
        }
        if (null != (list3 = this.groupList(list3, list2 = this.extractVariables(list = this.getBindings(node = (Node)this.dispatch(gNode.getGeneric(0))))))) {
            gNode.getGeneric(2).setProperty(UPVARS, list3);
        }
        Node node2 = (Node)this.dispatch(gNode.getGeneric(2));
        List<LetBinding> list4 = this.getBindings(node2);
        list = this.groupList(list, list4);
        String string = gNode.getString(1);
        String string2 = null;
        if ("<".equals(string)) {
            string2 = "lessInt";
        }
        if ("<=".equals(string)) {
            string2 = "lessEqualInt";
        }
        if (">".equals(string)) {
            string2 = "greaterInt";
        }
        if (">=".equals(string)) {
            string2 = "greaterEqualInt";
        }
        if ("<.".equals(string)) {
            string2 = "lessFloat64";
        }
        if ("<=.".equals(string)) {
            string2 = "lessEqualFloat64";
        }
        if (">.".equals(string)) {
            string2 = "greaterFloat64";
        }
        if (">=.".equals(string)) {
            string2 = "greaterEqualFloat64";
        }
        assert (null != string2) : "undefined relational operator " + string;
        Node node3 = this.factory.relationalExpr(Transformer.toIdentifier("Primitives." + string2), node, node2);
        if (null != list) {
            node3.setProperty(LETBINDINGS, list);
        }
        return node3;
    }

    public Node visitLogicalOrExpression(GNode gNode) {
        Node node;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list3 = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list3);
        }
        if (null != (list3 = this.groupList(list3, list2 = this.extractVariables(list = this.getBindings(node = (Node)this.dispatch(gNode.getGeneric(0))))))) {
            gNode.getGeneric(1).setProperty(UPVARS, list3);
        }
        Node node2 = (Node)this.dispatch(gNode.getGeneric(1));
        List<LetBinding> list4 = this.getBindings(node2);
        list = this.groupList(list, list4);
        Node node3 = this.factory.or(node, node2);
        if (null != list) {
            node3.setProperty(LETBINDINGS, list);
        }
        return node3;
    }

    public Node visitLogicalAndExpression(GNode gNode) {
        Node node;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list3 = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list3);
        }
        if (null != (list3 = this.groupList(list3, list2 = this.extractVariables(list = this.getBindings(node = (Node)this.dispatch(gNode.getGeneric(0))))))) {
            gNode.getGeneric(1).setProperty(UPVARS, list3);
        }
        Node node2 = (Node)this.dispatch(gNode.getGeneric(1));
        List<LetBinding> list4 = this.getBindings(node2);
        list = this.groupList(list, list4);
        Node node3 = this.factory.and(node, node2);
        if (null != list) {
            node3.setProperty(LETBINDINGS, list);
        }
        return node3;
    }

    public Node visitLogicalNegationExpression(GNode gNode) {
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
        }
        this.passVariables(gNode, gNode.getGeneric(0));
        Node node = (Node)this.dispatch(gNode.getGeneric(0));
        Node node2 = this.factory.not(node);
        this.passBindings(node, node2);
        return node2;
    }

    public Node visitEqualityExpression(GNode gNode) {
        Node node;
        Node node2;
        List<LetBinding> list;
        List<String> list2;
        List<String> list3;
        String string = gNode.getString(1);
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(2).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list3 = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list3);
        }
        if (null != (list3 = this.groupList(list3, list2 = this.extractVariables(list = this.getBindings(node2 = (Node)this.dispatch(gNode.getGeneric(0))))))) {
            gNode.getGeneric(2).setProperty(UPVARS, list3);
        }
        Node node3 = (Node)this.dispatch(gNode.getGeneric(2));
        List<LetBinding> list4 = this.getBindings(node3);
        list = this.groupList(list, list4);
        if ("=".equals(string)) {
            if ("Bottom".equals(gNode.getGeneric(0).getName())) {
                Node node4 = this.factory.equalsBottom(node3);
                if (null != list) {
                    node4.setProperty(LETBINDINGS, list);
                }
                return node4;
            }
            if ("Bottom".equals(gNode.getGeneric(2).getName())) {
                Node node5 = this.factory.equalsBottom(node2);
                if (null != list) {
                    node5.setProperty(LETBINDINGS, list);
                }
                return node5;
            }
        } else {
            if ("Bottom".equals(gNode.getGeneric(0).getName())) {
                Node node6 = this.factory.notEqualsBottom(node3);
                if (null != list) {
                    node6.setProperty(LETBINDINGS, list);
                }
                return node6;
            }
            if ("Bottom".equals(gNode.getGeneric(2).getName())) {
                Node node7 = this.factory.notEqualsBottom(node2);
                if (null != list) {
                    node7.setProperty(LETBINDINGS, list);
                }
                return node7;
            }
        }
        Node node8 = node = "=".equals(gNode.getString(1)) ? this.factory.equal(node2, node3) : this.factory.not(this.factory.equal(node2, node3));
        if (null != list) {
            node.setProperty(LETBINDINGS, list);
        }
        return node;
    }

    public void visitAttributeDefinition(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(1);
        if ("ConstraintType".equals(((Node)gNode2).getName())) {
            gNode2 = GNode.create("UserDefinedType", "Node");
        }
        this.attributeList.add(new Attribute(gNode.getString(0), gNode2));
    }

    public void visitEqualAttributeDefinition(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(1);
        if ("ConstraintType".equals(((Node)gNode2).getName())) {
            gNode2 = GNode.create("UserDefinedType", "Node");
        }
        this.eqAttributeList.add(new Attribute(gNode.getString(0), gNode2));
    }

    public Node processRawTypeDefinition() {
        GNode gNode = GNode.create("RecordDeclaration", GNode.create("FieldType", "type", GNode.create("UserDefinedType", "raw_type<?>")));
        gNode = GNode.ensureVariable(gNode);
        gNode.setProperty(TYPE, this.table.current().lookup("type(type)"));
        for (Attribute attribute : this.eqAttributeList) {
            gNode.add(GNode.create("FieldType", attribute.name, attribute.type));
        }
        for (Attribute attribute : this.attributeList) {
            gNode.add(GNode.create("FieldType", attribute.name, attribute.type));
        }
        return GNode.create("TypeDefinition", null, "type", gNode);
    }

    public void visitEqualityDefinition(GNode gNode) {
        for (int i = 1; i < gNode.size(); ++i) {
            boolean bl = false;
            GNode gNode2 = (GNode)gNode.get(i);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int j = 1; j < gNode2.size(); ++j) {
                if ("WildCard".equals(gNode2.getGeneric(j).getName())) continue;
                arrayList.add(j);
                bl = true;
            }
            if (!bl) {
                throw new AssertionError((Object)"At least one identifier required");
            }
            this.equalities.add(new Equality(gNode2.getGeneric(0).getString(0), arrayList));
        }
    }

    protected String getNodeName(Node node) {
        return "TypeConstructorPattern".equals(node.getName()) ? node.getString(0) : this.getNodeName(node.getGeneric(0));
    }

    public void visitScopeDefinition(GNode gNode) {
        GNode gNode2;
        GNode gNode3 = gNode.getGeneric(0);
        for (int i = 0; i < gNode3.size(); ++i) {
            gNode2 = gNode3.getGeneric(i).getGeneric(0);
            for (int j = 0; j < gNode2.size(); ++j) {
                this.processScopeNodes.add(this.getNodeName(gNode2.getGeneric(j)));
            }
        }
        GNode gNode4 = GNode.create("MatchExpression", GNode.create("LowerID", "n"), gNode.getGeneric(0));
        gNode4.setProperty("__arg_type", gNode.getProperty("__arg_type"));
        gNode4.setProperty(TYPE, this.mapper.getPatternMatchRightType(gNode.getProperty(TYPE)));
        this.seenScope = true;
        gNode2 = gNode.getGeneric(0);
        gNode2.setProperty(MATCHARG, "n");
        List list = (List)this.dispatch(gNode2);
        list.add(this.factory.ret(GNode.create("NullLiteral")));
        GNode gNode5 = GNode.create("ValueDefinition", "getScope", GNode.create("Parameters", GNode.create("Parameter", "n", GNode.create("UserDefinedType", "node"))), GNode.create("BooleanLiteral", "true"));
        gNode5.setProperty(TYPE, this.table.current().lookup("value(getScope)"));
        gNode5.setProperty("__isfunction", null);
        GNode gNode6 = GNode.create("Block");
        for (Node node : list) {
            gNode6.add(node);
        }
        Node node = (Node)this.dispatch(gNode5);
        node.getGeneric(2).getGeneric(0).getGeneric(2).getGeneric(4).getGeneric(0).set(7, gNode6);
        this.functionDefinitions.add(node);
    }

    public void visitNameSpaceDefinition(GNode gNode) {
        GNode gNode2;
        this.seenNameSpace = true;
        GNode gNode3 = GNode.create("PatternMatching");
        gNode3.setProperty(TYPE, gNode.getProperty(TYPE));
        gNode3.setProperty(MATCHARG, "n");
        for (int i = 0; i < gNode.size(); ++i) {
            gNode2 = gNode.getGeneric(i);
            for (int j = 0; j < gNode2.getGeneric(2).size(); ++j) {
                GNode gNode4 = gNode2.getGeneric(2).getGeneric(j);
                GNode gNode5 = GNode.create("PatternMatch");
                gNode5.add(gNode4.getGeneric(0));
                GNode gNode6 = GNode.create("TupleLiteral", gNode4.getGeneric(1), GNode.create("StringLiteral", "\"" + gNode2.getString(0) + "\""), GNode.create("StringLiteral", "\"" + gNode2.getString(1) + "\""));
                gNode6.setProperty(TYPE, TypeMapper.nameTupleT);
                gNode5.add(gNode6);
                gNode5.setProperty("enterScope", gNode4.getProperty("enterScope"));
                GNode gNode7 = gNode5.getGeneric(0);
                for (int k = 0; k < gNode7.size(); ++k) {
                    gNode7.getGeneric(k).setProperty("enterScope", gNode5.getProperty("enterScope"));
                }
                gNode3.add(gNode5);
            }
        }
        gNode3.setProperty(MATCHARG, "n");
        GNode gNode8 = GNode.create("MatchExpression", GNode.create("LowerID", "n"), gNode3);
        gNode2 = GNode.create("ValueDefinition", "getNameSpace", GNode.create("Parameters", GNode.create("Parameter", "n", GNode.create("UserDefinedType", "node"))), gNode8);
        gNode2.setProperty("__isfunction", null);
        gNode8.setProperty("__arg_type", this.table.current().lookup("type(node)"));
        gNode8.setProperty(TYPE, TypeMapper.nameTupleT);
        gNode2.setProperty("__arg_type", gNode.getProperty("__arg_type"));
        gNode2.setProperty(TYPE, this.table.current().lookup("value(getNameSpace)"));
        this.functionDefinitions.add((Node)this.dispatch(gNode2));
    }

    public Node visitErrorClause(GNode gNode) {
        Node node = (Node)this.dispatch(gNode.getGeneric(2));
        if (null == node) {
            node = this.nullNode;
        }
        Node node2 = (Node)this.dispatch(gNode.getGeneric(1));
        node2 = this.checkToLet(node2, gNode.getGeneric(1).getProperty(TYPE));
        return this.factory.errorClause(gNode.getGeneric(0).getString(0), node2, node);
    }

    public Node visitAssertClause(GNode gNode) {
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            if (null != gNode.getGeneric(1)) {
                gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
            }
        }
        Node node = (Node)this.dispatch(gNode.getGeneric(0));
        node = this.checkToLet(node, gNode.getGeneric(0).getProperty(TYPE));
        Node node2 = (Node)this.dispatch(gNode.getGeneric(1));
        node2 = this.checkToLet(node2, gNode.getGeneric(1).getProperty(TYPE));
        return null == gNode.getGeneric(1) ? GNode.create("PostfixExpression", Transformer.toIdentifier("assertion"), GNode.create("Arguments", node)) : GNode.create("PostfixExpression", Transformer.toIdentifier("assertion"), GNode.create("Arguments", node, node2));
    }

    public Node visitIfExpression(GNode gNode) {
        List<String> list;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list);
        }
        Node node = (Node)this.dispatch(gNode.getGeneric(0));
        List<LetBinding> list2 = this.getBindings(node);
        Node node2 = (Node)this.dispatch(gNode.getGeneric(1));
        node2 = this.checkToLet(node2, gNode.getGeneric(1).getProperty(TYPE));
        Node node3 = this.factory.ifExpression(node, node2);
        if (null != list2) {
            node3.setProperty(LETBINDINGS, list2);
        }
        return node3;
    }

    public Node visitIfElseExpression(GNode gNode) {
        List<String> list;
        if (gNode.hasProperty(INANALYZE)) {
            gNode.getGeneric(0).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(1).setProperty(INANALYZE, Boolean.TRUE);
            gNode.getGeneric(2).setProperty(INANALYZE, Boolean.TRUE);
        }
        if (null != (list = this.getUpVariables(gNode))) {
            gNode.getGeneric(0).setProperty(UPVARS, list);
        }
        Node node = (Node)this.dispatch(gNode.getGeneric(0));
        List<LetBinding> list2 = this.getBindings(node);
        Node node2 = (Node)this.dispatch(gNode.getGeneric(1));
        node2 = this.checkToLet(node2, gNode.getGeneric(1).getProperty(TYPE));
        Node node3 = (Node)this.dispatch(gNode.getGeneric(2));
        node3 = this.checkToLet(node3, gNode.getGeneric(2).getProperty(TYPE));
        Node node4 = this.factory.ifElseExpression(node, node2, node3);
        if (null != list2) {
            node4.setProperty(LETBINDINGS, list2);
        }
        return node4;
    }

    /*
     * WARNING - void declaration
     */
    public Node visitRequireExpression(GNode gNode) {
        Object object;
        Iterable<Object> iterable;
        int n = gNode.size();
        GNode gNode2 = gNode.getGeneric(n - 1);
        this.passVariables(gNode, gNode2);
        if (gNode.hasProperty(INANALYZE)) {
            gNode2.setProperty(INANALYZE, Boolean.TRUE);
        }
        Node node = (Node)this.dispatch(gNode2);
        Node node2 = gNode2.hasProperty(TYPE) ? this.mapper.toTypeNode(gNode2.getProperty(TYPE), false) : GNode.create("Type", GNode.create("QualifiedIdentifier", "Object"), null);
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        for (int i = 0; i < n - 1; ++i) {
            iterable = gNode.getGeneric(i);
            arrayList.add((GNode)iterable);
        }
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        iterable = new ArrayList();
        for (Node node3 : arrayList) {
            GNode gNode3 = node3.getGeneric(0);
            if (gNode.hasProperty(INANALYZE)) {
                gNode3.setProperty(INANALYZE, Boolean.TRUE);
            }
            Node node4 = (Node)this.dispatch(gNode3);
            node4 = this.checkToLet(node4, gNode3.getProperty(TYPE));
            String string = this.table.freshJavaId("var");
            arrayList2.add(this.factory.boolVar(string, node4));
            ((ArrayList)iterable).add((Node)Transformer.toIdentifier(string));
            GNode gNode4 = node3.getGeneric(1);
            String string2 = gNode4.getString(0);
            GNode gNode5 = node3.getGeneric(2);
            Node node5 = (Node)this.dispatch(gNode5);
            GNode gNode6 = node3.getGeneric(3);
            Node node6 = null == gNode6 ? this.nullNode : (Node)this.dispatch(gNode6);
            Node node7 = this.factory.ifStatement3(Transformer.toIdentifier(string), GNode.create("StringLiteral", "\"" + string2 + "\""), node5, node6);
            arrayList2.add(node7);
        }
        if (1 == ((ArrayList)iterable).size()) {
            object = this.factory.ifStatement4((Node)((ArrayList)iterable).get(0));
            arrayList2.add((Node)object);
        } else {
            object = GNode.create("LogicalOrExpression");
            ((Node)object).add(this.factory.isNull((Node)((ArrayList)iterable).get(0)));
            ((Node)object).add(this.factory.isNull((Node)((ArrayList)iterable).get(1)));
            int i = 2;
            while (i < ((ArrayList)iterable).size()) {
                object = GNode.create("LogicalOrExpression", object, this.factory.isNull((Node)((ArrayList)iterable).get((int)i)));
                ++i;
            }
            Node node8 = this.factory.ifStatement5((Node)object);
            arrayList2.add(node8);
        }
        if (1 == ((ArrayList)iterable).size()) {
            object = !"Block".equals(node.getName()) ? this.factory.ifStatement((Node)((ArrayList)iterable).get(0), this.factory.ret(node)) : this.toIfStatement((Node)((ArrayList)iterable).get(0), node);
            arrayList2.add((Node)object);
        } else {
            void var10_20;
            void var10_17;
            object = GNode.create("LogicalAndExpression");
            ((Node)object).add(((ArrayList)iterable).get(0));
            ((Node)object).add(((ArrayList)iterable).get(1));
            int n2 = 2;
            while (var10_17 < ((ArrayList)iterable).size()) {
                object = GNode.create("LogicalAndExpression", object, ((ArrayList)iterable).get((int)var10_17));
                ++var10_17;
            }
            if (!"Block".equals(node.getName())) {
                Node node8 = this.factory.ifStatement((Node)object, this.factory.ret(node));
            } else {
                Node node9 = this.toIfStatement((Node)object, node);
            }
            arrayList2.add((Node)var10_20);
        }
        arrayList2.add(this.factory.ret(this.nullNode));
        object = this.factory.requireExpression(node2, arrayList2);
        this.passBindings(node, (Node)object);
        return object;
    }

    public void processScopeSpace() {
        GNode gNode = GNode.create("Block");
        for (int i = 0; i < this.processScopeNodes.size(); ++i) {
            Node node = this.factory.addScopeNode(Transformer.toIdentifier("\"" + this.processScopeNodes.get(i) + "\""));
            gNode.add(node);
        }
        Node node = this.factory.getScopeNodesMethod();
        node.set(7, gNode);
        this.cbody.add(node);
        if (!this.seenScope) {
            this.cbody.add(this.factory.getScopeClass());
            this.cbody.add(this.factory.getScopeObject());
        }
        if (!this.seenNameSpace) {
            throw new AssertionError((Object)"Name space must be defined");
        }
    }

    public Node createTypeRecordEquals() {
        GNode gNode = GNode.create("Block");
        gNode.add(this.toIfStatement(this.factory.equality(Transformer.toIdentifier("o"), this.nullNode), this.factory.ret(GNode.create("BooleanLiteral", "false"))));
        gNode.add(this.toIfStatement(GNode.create("LogicalNegationExpression", GNode.create("InstanceOfExpression", Transformer.toIdentifier("o"), Transformer.toType("type"))), this.factory.ret(Transformer.toLiteral("BooleanLiteral", "false"))));
        gNode.add(this.factory.recordFieldEqual());
        gNode.add(this.factory.recordEqualReturn());
        gNode.add(this.factory.compareTypes());
        for (Attribute attribute : this.eqAttributeList) {
            gNode.add(this.factory.compareAttributes(Transformer.toIdentifier(attribute.name)));
        }
        gNode.add(this.factory.ret(Transformer.toIdentifier("res")));
        Node node = this.factory.equalsMethod();
        node.set(7, gNode);
        return node;
    }

    public Node createVariantEqualsMethod(String string) {
        Equality equality = null;
        for (Equality object2 : this.equalities) {
            if (!string.equals(object2.name)) continue;
            equality = object2;
            break;
        }
        assert (null != equality) : "null value for constr";
        GNode gNode = GNode.create("Block");
        gNode.add(this.factory.ifStatement1(Transformer.toIdentifier("o")));
        Node node = this.factory.ifStatement2(Transformer.toIdentifier("o"));
        node.getGeneric(0).getGeneric(0).set(1, Transformer.toType(string));
        gNode.add(node);
        gNode.add(this.makeDec("other", string, GNode.create("CastExpression", Transformer.toType(string), Transformer.toIdentifier("o"))));
        gNode.add(this.makeDec("res", "boolean", Transformer.toLiteral("BooleanLiteral", "true")));
        for (Integer n : equality.positions) {
            gNode.add(this.factory.compareMembers("getTuple().get" + n + "()"));
        }
        gNode.add(this.factory.ret(Transformer.toIdentifier("res")));
        Node node2 = this.factory.equalsMethod();
        node2.set(7, gNode);
        return node2;
    }

    public Node augmentIfStatement(Node node, String string, GNode gNode, Node node2) {
        Object object;
        List<LetBinding> list;
        GNode gNode2 = node.getGeneric(1);
        GNode gNode3 = gNode.getGeneric(0).getGeneric(0);
        List<Integer> list2 = Transformer.getIndexList(gNode3);
        int n = gNode2.size();
        GNode gNode4 = gNode2.getGeneric(n - 1);
        assert ("ReturnStatement" == ((Node)gNode4).getName()) : "The last statement of the if block is not a return statement";
        gNode2.set(n - 1, this.factory.matchingNodesAdd(Transformer.toIdentifier(string)));
        gNode2.add(this.factory.processScope(Transformer.toIdentifier(string)));
        gNode2.add(this.factory.checkEnterScope(Transformer.toIdentifier(string)));
        String string2 = this.table.freshJavaId("nodeName");
        String string3 = this.table.freshJavaId("listName");
        if (null != list2 && list2.size() > 1) {
            gNode2.add(this.factory.spOffspringList(string3));
            gNode2.add(this.factory.spRunNode(string2, Transformer.toIdentifier(string)));
            for (int i = 0; i < list2.size() - 1; ++i) {
                int n2 = list2.get(i);
                gNode2.add(this.factory.spGetGeneric(Transformer.toIdentifier(string2), Transformer.toLiteral("IntegerLiteral", "" + n2)));
                gNode2.add(this.factory.processScope(Transformer.toIdentifier(string2)));
                gNode2.add(this.factory.checkEnterScope(Transformer.toIdentifier(string2)));
                gNode2.add(this.factory.spOffspringListAdd(Transformer.toIdentifier(string3), Transformer.toIdentifier(string2)));
            }
        }
        if (null != (list = this.getBindings(node2))) {
            for (LetBinding object2 : list) {
                if (!object2.name.equals(this.spareVar)) {
                    if (this.mapper.hasTypeVariables(object2.typeObject)) {
                        gNode2.add(this.factory.fieldDecl2(object2.type, object2.name, object2.value));
                        continue;
                    }
                    gNode2.add(this.factory.fieldDecl2(object2.type, object2.name, this.factory.cast(object2.value)));
                    continue;
                }
                if (this.mapper.hasTypeVariables(object2.typeObject)) {
                    gNode2.add(this.factory.assign(Transformer.toIdentifier(object2.name), object2.value));
                    continue;
                }
                gNode2.add(this.factory.assign(Transformer.toIdentifier(object2.name), this.factory.cast(object2.value)));
            }
        }
        String string4 = this.table.freshJavaId("retValue");
        gNode2.add(this.factory.storeValue(string4, gNode4.getGeneric(0)));
        if (null != list2 && list2.size() > 1) {
            gNode2.add(this.factory.spForLoop(Transformer.toIdentifier(string3)));
        }
        gNode2.add(this.factory.checkExitScope(Transformer.toIdentifier(string)));
        gNode2.add(this.factory.matchingNodesRemove());
        if (gNode.hasProperty(ANNOTATE)) {
            gNode2.add(this.factory.annotateType(Transformer.toIdentifier(string), Transformer.toIdentifier(string4)));
        }
        if (this.mapper.hasTypeVariables(object = this.mapper.getPatternMatchRightType(gNode.getProperty(TYPE)))) {
            gNode2.add(this.factory.castReturn(Transformer.toIdentifier(string4)));
        } else {
            gNode2.add(this.factory.castReturn(Transformer.toIdentifier(string4)));
        }
        return node;
    }

    public Node addToIf(Node node, Node node2) {
        GNode gNode = node.getGeneric(1);
        int n = gNode.size();
        GNode gNode2 = gNode.getGeneric(n - 1);
        gNode.set(n - 1, null);
        List<LetBinding> list = this.getBindings(node2);
        if (null != list) {
            for (LetBinding letBinding : list) {
                if (!letBinding.name.equals(this.spareVar)) {
                    if (this.mapper.hasTypeVariables(letBinding.typeObject)) {
                        gNode.add(this.factory.fieldDecl2(letBinding.type, letBinding.name, letBinding.value));
                        continue;
                    }
                    gNode.add(this.factory.fieldDecl2(letBinding.type, letBinding.name, this.factory.cast(letBinding.value)));
                    continue;
                }
                if (this.mapper.hasTypeVariables(letBinding.typeObject)) {
                    gNode.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), letBinding.value));
                    continue;
                }
                gNode.add(this.factory.assign(Transformer.toIdentifier(letBinding.name), this.factory.cast(letBinding.value)));
            }
        }
        gNode.add(gNode2);
        return node;
    }

    public static List<Integer> getIndexList(GNode gNode) {
        String string = gNode.getName();
        if ("WhenPattern".equals(string) || "AsPattern".equals(string) || "TypedPattern".equals(string)) {
            return Transformer.getIndexList(gNode.getGeneric(0));
        }
        if ("TypeConstructorPattern".equals(string)) {
            List<Integer> list;
            if (1 == gNode.size() || "WidlCard".equals(gNode.getGeneric(1).getName())) {
                return null;
            }
            GNode gNode2 = gNode.getGeneric(1);
            boolean bl = false;
            for (int i = 0; i < gNode2.size(); ++i) {
                list = Transformer.getIndexList(gNode2.getGeneric(i));
                if (null != list && !list.isEmpty()) {
                    if ("ConsPattern".equals(gNode2.getGeneric(i).getName()) || "ListPattern".equals(gNode2.getGeneric(i).getName())) {
                        int n = list.remove(0);
                        list.add(0, n + i);
                        return list;
                    }
                    list.add(0, i);
                    return list;
                }
                if (null == list) continue;
                bl = true;
            }
            if (bl) {
                list = new ArrayList<Integer>();
                list.add(0);
                return list;
            }
            return null;
        }
        if ("ConsPattern".equals(string)) {
            List<Integer> list = Transformer.getIndexList(gNode.getGeneric(0));
            if (null == list) {
                list = Transformer.getIndexList(gNode.getGeneric(1));
                if (null == list || list.isEmpty()) {
                    return list;
                }
                int n = list.remove(0);
                list.add(0, n + 1);
                return list;
            }
            if (list.isEmpty()) {
                return list;
            }
            list.add(0, 0);
            return list;
        }
        if ("ListPattern".equals(string)) {
            boolean bl = false;
            for (int i = 0; i < gNode.size(); ++i) {
                List<Integer> list = Transformer.getIndexList(gNode.getGeneric(i));
                if (null != list && !list.isEmpty()) {
                    list.add(0, i);
                    return list;
                }
                if (null == list) continue;
                bl = true;
            }
            return bl ? new ArrayList() : null;
        }
        if ("Variable".equals(string)) {
            return new ArrayList<Integer>();
        }
        if ("WildCard".equals(string) || "BottomPattern".equals(string)) {
            return null;
        }
        return null;
    }

    public Node makeCurry(String string, Node node, List<Node> list, Node node2, Object object) {
        Object object3;
        Object object4;
        int n = list.size() - node.size();
        GNode gNode = GNode.create("TypeArguments");
        gNode.add(node2);
        for (int i = node.size(); i < list.size(); ++i) {
            gNode.add(list.get(i));
        }
        GNode gNode2 = GNode.create("Type", GNode.create("InstantiatedType", GNode.create("TypeInstantiation", "Function", null), GNode.create("TypeInstantiation", "F" + n, gNode)), null);
        GNode gNode3 = GNode.create("FormalParameters", n);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = node.size(); i < list.size(); ++i) {
            object4 = this.table.freshJavaId("para");
            arrayList.add((String)object4);
            gNode3.add(GNode.create("FormalParameter", this.fmod, list.get(i), null, object4, null));
        }
        GNode gNode4 = GNode.create("Block");
        object4 = new ArrayList();
        for (int i = 0; i < node.size(); ++i) {
            object3 = this.table.freshJavaId("var");
            object4.add(object3);
            gNode4.add(this.factory.fieldDecl2(list.get(i), (String)object3, node.getGeneric(i)));
        }
        GNode gNode5 = GNode.create("Arguments");
        object3 = object4.iterator();
        while (object3.hasNext()) {
            String object22 = (String)object3.next();
            gNode5.add(Transformer.toIdentifier(object22));
        }
        for (String string2 : arrayList) {
            gNode5.add(Transformer.toIdentifier(string2));
        }
        object3 = this.factory.ret(this.factory.apply(Transformer.toIdentifier(string), Transformer.makeArgumentList(gNode5)));
        gNode4.add(object3);
        GNode gNode6 = GNode.create("ClassBody", GNode.create("MethodDeclaration", this.pmod, null, node2, "apply", gNode3, null, null, gNode4));
        return this.toNewExpression2(gNode2, null, gNode6);
    }

    public String getInstanceName(String string, List<String> list) {
        for (PrimitiveInstance primitiveInstance : this.primitiveInsList) {
            if (!string.equals(primitiveInstance.name) || list.size() != primitiveInstance.types.size()) continue;
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).equals(primitiveInstance.types.get(i))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return primitiveInstance.instanceName;
        }
        return null;
    }

    private Node makeVarDec(String string, String string2, Node node) {
        Node node2 = this.factory.fieldDecl(Transformer.toType(string2), node);
        node2.getGeneric(2).getGeneric(0).set(0, string);
        return node2;
    }

    private Node makeVarDec2(String string, Node node, Node node2) {
        Node node3 = this.factory.fieldDecl(node, node2);
        node3.getGeneric(2).getGeneric(0).set(0, string);
        return node3;
    }

    private Node makeStaticVarDec(String string, String string2, Node node) {
        Node node2 = this.factory.staticFieldDecl(Transformer.toType(string2), node);
        node2.getGeneric(2).getGeneric(0).set(0, string);
        return node2;
    }

    private Node makeDec(String string, String string2, Node node) {
        Node node2 = this.factory.fieldDecl1(Transformer.toType(string2), node);
        node2.getGeneric(2).getGeneric(0).set(0, string);
        return node2;
    }

    private List<LetBinding> getBindings(Node node) {
        return (List)node.getProperty(LETBINDINGS);
    }

    private List<String> getUpVariables(Node node) {
        return (List)node.getProperty(UPVARS);
    }

    private List<String> extractVariables(List<LetBinding> list) {
        if (null == list) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (LetBinding letBinding : list) {
            arrayList.add(letBinding.name);
        }
        return arrayList;
    }

    private <T0> List<T0> groupList(List<T0> list, List<T0> list2) {
        if (null == list) {
            return list2;
        }
        if (null == list2) {
            return list;
        }
        List<T0> list3 = list;
        list3.addAll(list2);
        return list3;
    }

    private void passVariables(Node node, Node node2) {
        List<String> list = this.getUpVariables(node);
        if (null != list) {
            node2.setProperty(UPVARS, list);
        }
    }

    private void passBindings(Node node, Node node2) {
        List<LetBinding> list = this.getBindings(node);
        if (null != list) {
            node2.setProperty(LETBINDINGS, list);
        }
    }

    private List<String> getPatternVariables(Node node) {
        String string = node.getName();
        if ("TuplePattern".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < node.size(); ++i) {
                List<String> list = this.getPatternVariables(node.getGeneric(i));
                if (null == list) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }
        if ("WhenPattern".equals(string)) {
            return this.getPatternVariables(node.getGeneric(0));
        }
        if ("AsPattern".equals(string)) {
            List<String> list = this.getPatternVariables(node.getGeneric(0));
            list.add(node.getString(1));
            return list;
        }
        if ("TypedPattern".equals(string)) {
            return this.getPatternVariables(node.getGeneric(0));
        }
        if ("ConsPattern".equals(string)) {
            List<String> list = this.getPatternVariables(node.getGeneric(0));
            list.addAll(this.getPatternVariables(node.getGeneric(1)));
            return list;
        }
        if ("Variable".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(node.getString(0));
            return arrayList;
        }
        if ("TypeConstructorPattern".equals(string)) {
            if (1 < node.size()) {
                return this.getPatternVariables(node.getGeneric(1));
            }
            return new ArrayList<String>();
        }
        if ("PatternParameters".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < node.size(); ++i) {
                List<String> list = this.getPatternVariables(node.getGeneric(i));
                if (null == list) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }
        if ("ListPattern".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < node.size(); ++i) {
                List<String> list = this.getPatternVariables(node.getGeneric(i));
                if (null == list) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }
        if ("RecordPattern".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < node.size(); ++i) {
                List<String> list = this.getPatternVariables(node.getGeneric(i));
                if (null == list) continue;
                arrayList.addAll(list);
            }
            return arrayList;
        }
        if ("FieldPattern".equals(string)) {
            return this.getPatternVariables(node.getGeneric(1));
        }
        return new ArrayList<String>();
    }

    public void run() {
        this.dispatch(this.typical);
    }

    public GNode getCheckerAST() {
        return this.transformed;
    }

    public GNode getTypesAST() {
        return this.typesAST;
    }

    public GNode getSupportAST() {
        return this.supportAST;
    }

    private void setFlagVariables(Node node) {
        FlagSetter flagSetter = new FlagSetter((GNode)node);
        this.isListUsed = flagSetter.isListUsed;
        this.isArrayListUsed = flagSetter.isArrayListUsed;
        this.isBigIntegerUsed = flagSetter.isBigIntegerUsed;
        this.isPairUsed = flagSetter.isPairUsed;
        this.isNodeUsed = flagSetter.isNodeUsed;
        this.isGNodeUsed = flagSetter.isGNodeUsed;
        this.isPrimitivesUsed = flagSetter.isPrimitivesUsed;
        this.isRecordUsed = flagSetter.isRecordUsed;
        this.isVariantUsed = flagSetter.isVariantUsed;
        this.isTupleUsed = flagSetter.isTupleUsed;
        this.isReductionUsed = flagSetter.isReductionUsed;
        this.isNameUsed = flagSetter.isNameUsed;
        this.isScopeUsed = flagSetter.isScopeUsed;
        this.isScopeKindUsed = flagSetter.isScopeKindUsed;
        this.isAnalyzerUsed = flagSetter.isAnalyzerUsed;
    }

    private void addImports(Node node, Node node2, String string) {
        GNode gNode;
        this.setFlagVariables(node2);
        if (this.isBigIntegerUsed) {
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "math", "BigInteger"), null);
            node.add(gNode);
        }
        if (this.isListUsed) {
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "util", "List"), null);
            node.add(gNode);
        }
        if (this.isArrayListUsed) {
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "util", "ArrayList"), null);
            node.add(gNode);
        }
        if (this.isPairUsed) {
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "util", "Pair"), null);
            node.add(gNode);
        }
        if ("Analyzer".equals(string)) {
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "util", "Runtime"), null);
            node.add(gNode);
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "util", "Function"), null);
            node.add(gNode);
        }
        if (this.isNodeUsed) {
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "tree", "Node"), null);
            node.add(gNode);
        }
        if (this.isGNodeUsed) {
            gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "tree", "GNode"), null);
            node.add(gNode);
        }
        if (!"xtc.typical".equals(this.packageName)) {
            if ("Analyzer".equals(string) || this.isAnalyzerUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Analyzer"), null);
                node.add(gNode);
            }
            if (this.isPrimitivesUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Primitives"), null);
                node.add(gNode);
            }
            if (this.isRecordUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Record"), null);
                node.add(gNode);
            }
            if (this.isVariantUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Variant"), null);
                node.add(gNode);
            }
            if (this.isTupleUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Tuple"), null);
                node.add(gNode);
            }
            if (this.isReductionUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Reduction"), null);
                node.add(gNode);
            }
            if (this.isNameUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Name"), null);
                node.add(gNode);
            }
            if (this.isScopeUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "Scope"), null);
                node.add(gNode);
            }
            if (this.isScopeKindUsed) {
                gNode = GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "xtc", "typical", "ScopeKind"), null);
                node.add(gNode);
            }
        }
    }

    private Node makeClassBody() {
        if ("Typical".equals(this.output)) {
            Node node = this.factory.makeConstructor(this.output + "Analyzer");
            Node node2 = this.factory.nodeTypeDecl();
            return GNode.create("ClassBody", node2, node);
        }
        Node node = this.factory.makeConstructor2(this.output + "Analyzer");
        return GNode.create("ClassBody", node);
    }

    private Node makeSkeleton() {
        GNode gNode = GNode.create("ClassDeclaration", Transformer.toModifiers("public"), this.output + "Analyzer", null, GNode.create("Extension", GNode.create("Type", GNode.create("QualifiedIdentifier", "Analyzer"), null)), null, this.cbody);
        GNode gNode2 = GNode.create("CompilationUnit", 8);
        gNode2.add(this.packageNode);
        this.addImports(gNode2, this.cbody, "Analyzer");
        gNode2.add(Transformer.comment(gNode, "Type checker for " + this.output + "."));
        return gNode2;
    }

    private Node makeTypesSkeleton() {
        GNode gNode = GNode.create("CompilationUnit", 8);
        gNode.add(this.packageNode);
        this.addImports(gNode, this.tbody, "Types");
        Node node = this.factory.classDecl2(this.output + "Types");
        node.set(5, this.tbody);
        gNode.add(Transformer.comment(node, "Types for " + this.output + "."));
        return gNode;
    }

    private Node makeSupportSkeleton() {
        GNode gNode = GNode.create("CompilationUnit", 8);
        gNode.add(this.packageNode);
        this.addImports(gNode, this.sbody, "Support");
        Node node = this.factory.classDecl2(this.output + "Support");
        node.set(5, this.sbody);
        gNode.add(Transformer.comment(node, "Helper functionality for " + this.output + "."));
        return gNode;
    }

    private void addEnum(Node node, String string) {
        node.add(GNode.create("EnumConstant", null, string, null, null));
    }

    private void enterScope(String string) {
        this.table.enter(string);
    }

    private void exitScope(String string) {
        if (!string.equals(this.table.current().getName())) {
            throw new AssertionError((Object)("mismatched scope exit " + string));
        }
        this.table.exit();
    }

    private void checkTypeAnnotation(GNode gNode) {
        if (!gNode.hasProperty(TYPE)) {
            throw new AssertionError((Object)("no type annotation for " + gNode.getName()));
        }
        if (gNode.getProperty(TYPE) == null) {
            throw new AssertionError((Object)(gNode.getName() + " has null type"));
        }
    }

    private final void printAST(Node node) {
        this.runtime.console().pln().format(node).pln().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printSymbolTable() {
        if (null != this.table) {
            Visitor visitor = this.runtime.console().visitor();
            try {
                this.table.root().dump(this.runtime.console());
            }
            finally {
                this.runtime.console().register(visitor);
            }
        } else {
            throw new AssertionError((Object)"Symbol table not initialized");
        }
        this.runtime.console().flush();
    }

    private String getType(Object object) {
        return this.mapper.toTypeString(object);
    }

    public static Node comment(Node node, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return new Comment(Comment.Kind.DOCUMENTATION, arrayList, node);
    }

    public static Node toModifiers(String string) {
        return GNode.create("Modifiers", GNode.create("Modifier", string));
    }

    public static Node toLiteral(String string, String string2) {
        return GNode.create(string, string2);
    }

    public static Node toIdentifier(String string) {
        if (null == string) {
            throw new AssertionError((Object)"null name in toIdentifier");
        }
        return GNode.create("PrimaryIdentifier", string);
    }

    public Node toIfStatement(Node node, Node node2) {
        node2 = null == node2 ? GNode.create("Block") : node2;
        GNode gNode = node2.hasName("Block") ? GNode.ensureVariable(GNode.cast(node2)) : GNode.ensureVariable(GNode.create("Block", node2));
        return GNode.create("ConditionalStatement", node, gNode, null);
    }

    private Node makeCase(Node node, List<Node> list, String string) {
        GNode gNode = this.factory.caseStmnt(node, list).getGeneric(1);
        return gNode;
    }

    private static Node toType(String string) {
        assert (null != string) : "null string";
        return GNode.create("Type", GNode.create("QualifiedIdentifier", string), null);
    }

    private Node toNewExpression2(Node node, Node node2, Node node3) {
        if (null == node2) {
            node2 = GNode.create("Arguments");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(node2.size());
        node2.addAllTo(arrayList);
        ArrayList<Object> arrayList2 = arrayList;
        List list = arrayList2;
        Node node4 = this.factory.newExpr(node, list);
        node4.set(4, node3);
        return node4;
    }

    private static List<Node> makeArgumentList(Node node) {
        if (null == node) {
            node = GNode.create("Arguments");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(node.size());
        node.addAllTo(arrayList);
        ArrayList<Object> arrayList2 = arrayList;
        return arrayList2;
    }

    static class LetBinding {
        public String name;
        public Object typeObject;
        public Node type;
        public Node value;

        public LetBinding(String string, Object object, Node node, Node node2) {
            this.name = string;
            this.typeObject = object;
            this.type = node;
            this.value = node2;
        }
    }

    static class Match {
        private Object type;
        private Node condition;

        public Match(Object object, Node node) {
            this.type = object;
            this.condition = node;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Match)) {
                return false;
            }
            Match match = (Match)object;
            return this.type.equals(match.type) && this.condition.equals(match.condition);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrimitiveInstance {
        public String name;
        public List<String> types;
        public String instanceName;

        public PrimitiveInstance(String string, List<String> list, String string2) {
            this.name = string;
            this.types = list;
            this.instanceName = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Equality {
        public String name;
        public List<Integer> positions;

        Equality(String string, List<Integer> list) {
            this.name = string;
            this.positions = list;
        }
    }

    static class Attribute {
        public String name;
        public Node type;

        Attribute(String string, Node node) {
            this.name = string;
            this.type = node;
        }
    }
}

