/*
 * Decompiled with CFR 0.152.
 */
package xtc.typical;

import java.util.ArrayList;
import java.util.Hashtable;
import xtc.tree.Node;
import xtc.typical.Name;
import xtc.typical.Scope;
import xtc.typical.ScopeKind;
import xtc.typical.Tuple;
import xtc.util.Function;
import xtc.util.Pair;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Analyzer {
    protected final Runtime runtime;
    protected final SymbolTable gamma;
    protected final String ENTERSCOPE = "enterScope";
    protected final String EXITSCOPE = "exitScope";
    protected final String MAGICNUMBER = "magicNumber";
    protected Hashtable<Object, Object> hashTable;
    protected Function.F1<?, Node> analyzer;
    protected Node root;
    protected final ArrayList<Node> matching_nodes = new ArrayList();
    protected final ArrayList<String> processScopeNodes = new ArrayList();
    protected final Function.F3<Void, String, String, Object> load = new Function.F3<Void, String, String, Object>(){

        @Override
        public Void apply(String string, String string2, Object object) {
            if (null == string || null == string2) {
                return null;
            }
            Analyzer.this.gamma.current().define(SymbolTable.toNameSpace(string, string2), object);
            return null;
        }
    };
    protected final Function.F1<Node, NodeMatch> ancestor = new Function.F1<Node, NodeMatch>(){

        @Override
        public final Node apply(NodeMatch nodeMatch) {
            for (int i = Analyzer.this.matching_nodes.size() - 1; i >= 0; --i) {
                Node node = Analyzer.this.matching_nodes.get(i);
                if (!((Boolean)nodeMatch.apply(node)).booleanValue()) continue;
                return node;
            }
            return null;
        }
    };
    protected final Function.F1<Node, NodeMatch> parent = new Function.F1<Node, NodeMatch>(){

        @Override
        public final Node apply(NodeMatch nodeMatch) {
            Node node = Analyzer.this.matching_nodes.get(Analyzer.this.matching_nodes.size() - 1);
            if (nodeMatch.equals(node)) {
                return node;
            }
            return null;
        }
    };
    protected final Function.F2<Object, Node, Function.F1<?, Node>> lookup2 = new Function.F2<Object, Node, Function.F1<?, Node>>(){

        @Override
        public final Object apply(Node node, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "Unable to map namespace for node " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            Object object = Analyzer.this.gamma.lookup(((Name)t3.get1()).mangle((String)t3.get2()));
            if (null == object) {
                Analyzer.this.showMessage("error", "Undefined: " + ((Name)t3.get1()).mangle((String)t3.get2()), node);
            }
            Analyzer.this.checkExitScope(node);
            return object;
        }
    };
    protected final Function.F4<Object, Node, String, String, Function.F1<?, Node>> lookup4 = new Function.F4<Object, Node, String, String, Function.F1<?, Node>>(){

        @Override
        public final Object apply(Node node, String string, String string2, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "Unable to map namespace for node " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            Object object = Analyzer.this.gamma.lookup(((Name)t3.get1()).mangle((String)t3.get2()));
            if (null == object) {
                Analyzer.this.showMessage(string, string2, node);
            }
            Analyzer.this.checkExitScope(node);
            return object;
        }
    };
    protected final Function.F2<Object, Node, Function.F1<?, Node>> lookupLocally2 = new Function.F2<Object, Node, Function.F1<?, Node>>(){

        @Override
        public final Object apply(Node node, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "Unable to map namespace for node " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            Object object = Analyzer.this.gamma.lookup(((Name)t3.get1()).mangle((String)t3.get2()));
            if (null == object) {
                Analyzer.this.showMessage("error", "Undefined in the current scope: " + ((Name)t3.get1()).mangle((String)t3.get2()), node);
            }
            Analyzer.this.checkExitScope(node);
            return object;
        }
    };
    protected final Function.F4<Object, Node, String, String, Function.F1<?, Node>> lookupLocally4 = new Function.F4<Object, Node, String, String, Function.F1<?, Node>>(){

        @Override
        public final Object apply(Node node, String string, String string2, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "Unable to map namespace for node " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            Object object = Analyzer.this.gamma.lookup(((Name)t3.get1()).mangle((String)t3.get2()));
            if (null == object) {
                Analyzer.this.showMessage(string, string2, node);
            }
            Analyzer.this.checkExitScope(node);
            return object;
        }
    };
    protected final Function.F3<Void, Node, Object, Function.F1<?, Node>> define3 = new Function.F3<Void, Node, Object, Function.F1<?, Node>>(){

        @Override
        public final Void apply(Node node, Object object, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "define : no namespace for " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            Analyzer.this.gamma.current().define(((Name)t3.get1()).mangle((String)t3.get2()), object);
            Analyzer.this.checkExitScope(node);
            return null;
        }
    };
    protected final Function.F5<Void, Node, Object, String, String, Function.F1<?, Node>> define5 = new Function.F5<Void, Node, Object, String, String, Function.F1<?, Node>>(){

        @Override
        public final Void apply(Node node, Object object, String string, String string2, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "define : no namespace for " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            String string3 = ((Name)t3.get1()).mangle((String)t3.get2());
            if (Analyzer.this.gamma.current().isDefined(string3)) {
                Analyzer.this.showMessage(string, string2, node);
            }
            Analyzer.this.gamma.current().define(string3, object);
            Analyzer.this.checkExitScope(node);
            return null;
        }
    };
    protected final Function.F3<Void, Node, Object, Function.F1<?, Node>> redefine = new Function.F3<Void, Node, Object, Function.F1<?, Node>>(){

        @Override
        public final Void apply(Node node, Object object, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "redefine : no namespace for " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            String string = ((Name)t3.get1()).mangle((String)t3.get2());
            Analyzer.this.gamma.current().define(string, object);
            Analyzer.this.checkExitScope(node);
            return null;
        }
    };
    protected final Function.F2<Boolean, Node, Function.F1<?, Node>> isDefined = new Function.F2<Boolean, Node, Function.F1<?, Node>>(){

        @Override
        public final Boolean apply(Node node, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "is_define : no namespace for " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            boolean bl = Analyzer.this.gamma.isDefined(((Name)t3.get1()).mangle((String)t3.get2()));
            Analyzer.this.checkExitScope(node);
            return bl;
        }
    };
    protected final Function.F2<Boolean, Node, Function.F1<?, Node>> isDefinedLocally = new Function.F2<Boolean, Node, Function.F1<?, Node>>(){

        @Override
        public final Boolean apply(Node node, Function.F1<?, Node> f1) {
            Tuple.T3 t3 = (Tuple.T3)Analyzer.cast(f1.apply(node));
            assert (null != t3) : "is_define_locally : no namespace for " + (null == node ? "Null" : node.getName());
            Analyzer.this.checkEnterScope(node);
            boolean bl = Analyzer.this.gamma.current().isDefinedLocally(((Name)t3.get1()).mangle((String)t3.get2()));
            Analyzer.this.checkExitScope(node);
            return bl;
        }
    };
    protected final Function.F1<Boolean, String> show_symbols = new Function.F1<Boolean, String>(){

        @Override
        public Boolean apply(String string) {
            if ("local".equals(string)) {
                Analyzer.this.gamma.current().dump(Analyzer.this.runtime.console());
                Analyzer.this.runtime.console().flush();
            } else if ("all".equals(string)) {
                Analyzer.this.gamma.root().dump(Analyzer.this.runtime.console());
                Analyzer.this.runtime.console().flush();
            } else {
                Analyzer.this.runtime.error("local or all required to use show_symbol function");
            }
            return Boolean.TRUE;
        }
    };
    protected final Function.F1<String, String> freshName = new Function.F1<String, String>(){

        @Override
        public String apply(String string) {
            return Analyzer.this.gamma.freshName(string);
        }
    };
    protected final Function.F1<Boolean, Object> notBottom = new Function.F1<Boolean, Object>(){

        @Override
        public Boolean apply(Object object) {
            return null == object ? null : Boolean.TRUE;
        }
    };

    protected abstract void getScopeNodes();

    public Analyzer(Runtime runtime) {
        this.runtime = runtime;
        this.gamma = new SymbolTable();
        this.hashTable = new Hashtable();
        this.getScopeNodes();
    }

    protected void checkEnterScope(Node node) {
        if (null != node && node.hasProperty("enterScope")) {
            String string = (String)node.getProperty("enterScope");
            if (!string.equals(this.gamma.current().getName())) {
                this.gamma.enter(string);
            } else if (!node.hasProperty("magicNumber")) {
                node.setProperty("magicNumber", 1);
            } else {
                Integer n = (Integer)node.getProperty("magicNumber");
                node.setProperty("magicNumber", n + 1);
            }
        }
    }

    protected void checkExitScope(Node node) {
        if (null != node && node.hasProperty("exitScope")) {
            if (!node.hasProperty("magicNumber")) {
                this.gamma.exit();
            } else {
                Integer n = (Integer)node.getProperty("magicNumber");
                if (1 == n) {
                    node.removeProperty("magicNumber");
                } else {
                    node.setProperty("magicNumber", n - 1);
                }
            }
        }
        if (null != node && node.hasProperty("deleteScope")) {
            this.gamma.delete((String)node.getProperty("deleteScope"));
        }
    }

    protected Object error(String string, Node node) {
        if (null == node) {
            node = this.matching_nodes.get(this.matching_nodes.size() - 1);
        }
        this.runtime.error(string, node);
        return null;
    }

    protected Object warning(String string, Node node) {
        if (null == node) {
            node = this.matching_nodes.get(this.matching_nodes.size() - 1);
        }
        this.runtime.warning(string, node);
        return null;
    }

    protected void showMessage(String string, String string2, Object object) {
        Node node = (Node)object;
        if (null == node) {
            if ("error".equals(string)) {
                if (this.matching_nodes.size() - 1 < 0) {
                    this.runtime.error(string2);
                } else {
                    Node node2 = this.matching_nodes.get(this.matching_nodes.size() - 1);
                    this.runtime.error(string2, node2);
                }
            } else if (this.matching_nodes.size() - 1 < 0) {
                this.runtime.warning(string2);
            } else {
                Node node3 = this.matching_nodes.get(this.matching_nodes.size() - 1);
                this.runtime.warning(string2, node3);
            }
        } else if ("error".equals(string)) {
            this.runtime.error(string2, node);
        } else {
            this.runtime.warning(string2, node);
        }
    }

    protected void processScope(Node node, Function.F1<?, Node> f1) {
        Node node2;
        Object object;
        Scope scope = (Scope)Analyzer.cast(f1.apply(node));
        if (null == scope) {
            throw new AssertionError((Object)("unable to get scope for : " + node.getName()));
        }
        ScopeKind scopeKind = (ScopeKind)((Tuple.T2)scope.getTuple()).get1();
        String string = scopeKind.isNamed() ? (((Name)(object = (Name)((Tuple.T1)((ScopeKind.Named)scopeKind).getTuple()).get1())).isSimpleName() ? (String)((Tuple.T1)((Name.SimpleName)object).getTuple()).get1() : "QualifiedName") : (scopeKind.isAnonymous() ? this.gamma.freshName((String)((Tuple.T1)((ScopeKind.Anonymous)scopeKind).getTuple()).get1()) : this.gamma.freshName((String)((Tuple.T1)((ScopeKind.Temporary)scopeKind).getTuple()).get1()));
        object = (Pair)((Tuple.T2)scope.getTuple()).get2();
        ArrayList arrayList = (ArrayList)((Pair)object).list();
        int n = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            node2 = (Node)arrayList.get(i);
            if (node2 == null || node2.hasProperty("enterScope")) continue;
            node2.setProperty("enterScope", string);
            node2.setProperty("exitScope", true);
            n = i;
        }
        if (n != -1 && scopeKind.isTemporary()) {
            node2 = (Node)arrayList.get(n);
            node2.setProperty("deleteScope", string);
        }
    }

    public SymbolTable run(Node node) {
        if (null == this.analyzer) {
            this.runtime.error("Analyzer is null");
            this.runtime.exit();
        }
        if (null == node) {
            this.runtime.error("Tree root is null");
            this.runtime.exit();
        } else {
            this.root = node;
        }
        this.matching_nodes.add(node);
        this.analyzer.apply(node);
        return this.gamma;
    }

    public Node getASTRoot() {
        return this.root;
    }

    protected void printAST(Node node) {
        this.runtime.console().pln().format(node).pln().flush();
    }

    public static final String toString(Object object) {
        return null == object ? "?" : object.toString();
    }

    public static Boolean equal(Object object, Object object2) {
        return null == object ? null == object2 : object.equals(object2);
    }

    protected static Boolean not_equal(Object object, Object object2) {
        return null == object ? null != object2 : !object.equals(object2);
    }

    protected static final void discard(Object object) {
    }

    public static final <T> T cast(Object object) {
        return (T)object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Guard<T>
    extends Function.F0<T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Let<T>
    extends Function.F0<T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Require<T>
    extends Function.F0<T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeMatch
    extends Function.F1<Boolean, Node> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Match<T>
    extends Function.F0<T> {
    }
}

