/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import xtc.type.DerivedT;
import xtc.type.ErrorT;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariantT
extends DerivedT {
    private final String qname;
    private final String qualifier;
    private final String sname;
    private final boolean polymorphic;
    private List<TupleT> tuples;

    public VariantT(String string) {
        this(null, string, false, null);
    }

    public VariantT(String string, List<TupleT> list) {
        this(null, string, false, list);
    }

    public VariantT(String string, boolean bl, List<TupleT> list) {
        this(null, string, bl, list);
    }

    public VariantT(Type type2, String string, boolean bl, List<TupleT> list) {
        super(type2);
        this.qname = string;
        this.qualifier = null == string ? null : Utilities.getQualifier(string);
        this.sname = null == string ? null : Utilities.unqualify(string);
        this.polymorphic = bl;
        this.tuples = list;
        if (null == string && !bl) {
            throw new NullPointerException("Null name");
        }
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.tuples = Type.seal(this.tuples);
        }
        return this;
    }

    @Override
    public VariantT copy() {
        return new VariantT(this, this.qname, this.polymorphic, VariantT.copy(this.tuples));
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.VARIANT;
    }

    @Override
    public boolean isVariant() {
        return true;
    }

    @Override
    public VariantT toVariant() {
        return this;
    }

    @Override
    public String getName() {
        return this.qname;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getSimpleName() {
        return this.sname;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public Type lookup(String string) {
        for (TupleT tupleT : this.tuples) {
            if (!tupleT.hasName(string)) continue;
            return tupleT;
        }
        return ErrorT.TYPE;
    }

    public Type lookupSimple(String string) {
        for (TupleT tupleT : this.tuples) {
            if (!tupleT.hasSimpleName(string)) continue;
            return tupleT;
        }
        return ErrorT.TYPE;
    }

    public List<TupleT> getTuples() {
        return this.tuples;
    }

    public void setTuples(List<TupleT> list) {
        this.checkNotSealed();
        this.tuples = list;
    }

    public int hashCode() {
        if (this.polymorphic) {
            return null == this.tuples ? 0 : ((Object)this.tuples).hashCode();
        }
        return this.qname.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = VariantT.resolve(object);
        if (this == type2) {
            return true;
        }
        if (!type2.isVariant()) {
            return false;
        }
        VariantT variantT = type2.toVariant();
        if (this.polymorphic != variantT.polymorphic) {
            return false;
        }
        if (!this.polymorphic) {
            return this.qname.equals(variantT.qname);
        }
        if (null == this.tuples) {
            return null == variantT.tuples;
        }
        if (this.tuples.size() != variantT.tuples.size()) {
            return false;
        }
        for (TupleT tupleT : this.tuples) {
            if (variantT.tuples.contains(tupleT)) continue;
            return false;
        }
        for (TupleT tupleT : variantT.tuples) {
            if (this.tuples.contains(tupleT)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        if (null != this.qname) {
            appendable.append("variant ");
            appendable.append(this.qname);
        } else {
            appendable.append("variant(");
            Iterator<TupleT> iterator = this.tuples.iterator();
            while (iterator.hasNext()) {
                appendable.append('`');
                iterator.next().write(appendable);
                if (!iterator.hasNext()) continue;
                appendable.append(", ");
            }
            appendable.append(')');
        }
    }
}

