/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import xtc.tree.Attribute;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.BooleanT;
import xtc.type.ClassOrInterfaceT;
import xtc.type.ClassT;
import xtc.type.EnumT;
import xtc.type.EnumeratorT;
import xtc.type.ErrorT;
import xtc.type.FunctionOrMethodT;
import xtc.type.FunctionT;
import xtc.type.InstantiatedT;
import xtc.type.InterfaceT;
import xtc.type.InternalT;
import xtc.type.LabelT;
import xtc.type.MethodT;
import xtc.type.NumberT;
import xtc.type.PackageT;
import xtc.type.Parameter;
import xtc.type.ParameterizedT;
import xtc.type.PointerT;
import xtc.type.StructT;
import xtc.type.Tagged;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.UnionT;
import xtc.type.UnitT;
import xtc.type.VariableT;
import xtc.type.VariantT;
import xtc.type.VoidT;

public class TypePrinter
extends Visitor {
    protected final Printer printer;
    protected final Map<Object, Object> visited;
    protected boolean isInstantiated;

    public TypePrinter(Printer printer) {
        this.printer = printer;
        this.visited = new IdentityHashMap<Object, Object>();
        this.isInstantiated = false;
        printer.register(this);
    }

    public void reset() {
        this.visited.clear();
    }

    public boolean printAnnotations(Type type2) {
        boolean bl = false;
        if (type2.hasLocation(false)) {
            this.printer.p("line(").p(type2.getLocation((boolean)false).line).p(") ");
            bl = true;
        }
        if (type2.hasLanguage(false)) {
            this.printer.p("language(").p(type2.getLanguage(false).toString()).p(") ");
            bl = true;
        }
        if (type2.hasScope(false)) {
            this.printer.p("scope(").p(type2.getScope(false)).p(") ");
            bl = true;
        }
        if (type2.hasConstant(false)) {
            this.printer.p("value(").p(type2.getConstant(false).getValue().toString()).p(") ");
            bl = true;
        }
        if (type2.hasShape(false)) {
            this.printer.p("shape(").p(type2.getShape().toString()).p(") ");
            bl = true;
        }
        if (type2.hasAttributes()) {
            for (Attribute attribute : type2.attributes()) {
                this.printer.p(attribute).p(' ');
                bl = true;
            }
        }
        return bl;
    }

    public void visit(BooleanT booleanT) {
        this.printAnnotations(booleanT);
        this.printer.p("boolean");
    }

    public void visit(ErrorT errorT) {
        this.printAnnotations(errorT);
        this.printer.p("** error **");
    }

    public void visit(InternalT internalT) {
        this.printAnnotations(internalT);
        this.printer.p(internalT.getName());
    }

    public void visit(LabelT labelT) {
        this.printAnnotations(labelT);
        this.printer.p("label(").p(labelT.getName()).p(')');
    }

    public void visit(NumberT numberT) {
        this.printAnnotations(numberT);
        this.printer.p(numberT.toString());
    }

    public void visit(PackageT packageT) {
        this.printAnnotations(packageT);
        this.printer.p("package(").p(packageT.getName()).p(')');
    }

    public void visit(Parameter parameter) {
        this.printAnnotations(parameter);
        this.printer.p('<').p(parameter.getName()).p('>');
    }

    public void visit(UnitT unitT) {
        this.printAnnotations(unitT);
        this.printer.p(unitT.getName());
    }

    public void visit(VoidT voidT) {
        this.printAnnotations(voidT);
        this.printer.p("void");
    }

    public void visit(ArrayT arrayT) {
        this.printAnnotations(arrayT);
        this.printer.p("array(").p(arrayT.getType());
        if (arrayT.isVarLength()) {
            this.printer.p(", *");
        } else if (arrayT.hasLength()) {
            this.printer.p(", ").p(arrayT.getLength());
        }
        this.printer.p(')');
    }

    public void printBody(ClassOrInterfaceT classOrInterfaceT) {
        if (!classOrInterfaceT.getInterfaces().isEmpty()) {
            Iterator<Type> iterator = classOrInterfaceT.getInterfaces().iterator();
            while (iterator.hasNext()) {
                Type type2 = iterator.next();
                if (type2.isAlias() && null == type2.toAlias().getType()) {
                    this.printer.p(type2);
                } else {
                    this.printer.p(((InterfaceT)type2.resolve()).getQName());
                }
                if (!iterator.hasNext()) continue;
                this.printer.p(", ");
            }
        }
        if (this.visited.containsKey(classOrInterfaceT)) {
            return;
        }
        this.visited.put(classOrInterfaceT, Boolean.TRUE);
        if (classOrInterfaceT.getFields().isEmpty() && classOrInterfaceT.getMethods().isEmpty()) {
            this.printer.p(" {}");
        } else {
            this.printer.pln(" {").incr();
            for (Type type2 : classOrInterfaceT.getFields()) {
                this.printer.indent().p(type2).pln(';');
            }
            for (Type type2 : classOrInterfaceT.getMethods()) {
                this.printer.indent().p(type2).pln(';');
            }
            this.printer.decr().indent().p('}');
        }
    }

    public void visit(ClassT classT) {
        this.printer.p("class ").p(classT.getQName());
        if (null != classT.getParent()) {
            Type type2 = classT.getParent();
            this.printer.p(" extends ");
            if (type2.isAlias() && null == type2.toAlias().getType()) {
                this.printer.p(type2);
            } else {
                this.printer.p(((ClassT)type2.resolve()).getQName());
            }
        }
        if (!classT.getInterfaces().isEmpty()) {
            this.printer.p(" implements ");
        }
        this.printBody(classT);
    }

    public void visit(InterfaceT interfaceT) {
        this.printer.p("interface ").p(interfaceT.getQName());
        if (!interfaceT.getInterfaces().isEmpty()) {
            this.printer.p(" extends ");
        }
        this.printBody(interfaceT);
    }

    public void printSignature(FunctionOrMethodT functionOrMethodT) {
        this.printer.p('(');
        Iterator<Type> iterator = functionOrMethodT.getParameters().iterator();
        while (iterator.hasNext()) {
            this.printer.p(iterator.next());
            if (!iterator.hasNext() && !functionOrMethodT.isVarArgs()) continue;
            this.printer.p(", ");
        }
        if (functionOrMethodT.isVarArgs()) {
            this.printer.p("...");
        }
        this.printer.p(") -> ");
        if (functionOrMethodT.getResult().resolve().isFunction()) {
            this.printer.p('(').p(functionOrMethodT.getResult()).p(')');
        } else {
            this.printer.p(functionOrMethodT.getResult());
        }
        if (null != functionOrMethodT.getExceptions() && !functionOrMethodT.getExceptions().isEmpty()) {
            this.printer.p(" throws ");
            iterator = functionOrMethodT.getExceptions().iterator();
            while (iterator.hasNext()) {
                this.printer.p(iterator.next());
                if (!iterator.hasNext()) continue;
                this.printer.p(", ");
            }
        }
    }

    public void visit(FunctionT functionT) {
        this.printAnnotations(functionT);
        this.printSignature(functionT);
    }

    public void visit(MethodT methodT) {
        this.printAnnotations(methodT);
        this.printer.p(methodT.getName()).p(' ');
        this.printSignature(methodT);
    }

    public void visit(PointerT pointerT) {
        this.printAnnotations(pointerT);
        this.printer.p("pointer(").p(pointerT.getType()).p(')');
    }

    public void printTagged(String string, Tagged tagged) {
        this.printer.p(string).p(' ').p(tagged.getName());
        if (null != tagged.getMembers() && !this.visited.containsKey(tagged)) {
            this.visited.put(tagged, Boolean.TRUE);
            if (tagged.getMembers().isEmpty()) {
                this.printer.p(" {}");
            } else {
                this.printer.pln(" {").incr();
                Iterator<? extends Type> iterator = tagged.getMembers().iterator();
                while (iterator.hasNext()) {
                    this.printer.indent().p(iterator.next());
                    if ("enum".equals(string)) {
                        if (iterator.hasNext()) {
                            this.printer.pln(',');
                            continue;
                        }
                        this.printer.pln();
                        continue;
                    }
                    this.printer.pln(';');
                }
                this.printer.decr().indent().p('}');
            }
        }
    }

    public void visit(StructT structT) {
        this.printAnnotations(structT);
        this.printTagged("struct", structT);
    }

    public void visit(UnionT unionT) {
        this.printAnnotations(unionT);
        this.printTagged("union", unionT);
    }

    public void visit(TupleT tupleT) {
        this.printAnnotations(tupleT);
        if (null == tupleT.getName()) {
            this.printer.p("<anon>");
        } else {
            this.printer.p(tupleT.getName());
        }
        this.printer.p('(');
        if (null == tupleT.getTypes()) {
            this.printer.p("...");
        } else {
            Iterator<Type> iterator = tupleT.getTypes().iterator();
            while (iterator.hasNext()) {
                this.printer.p(iterator.next());
                if (!iterator.hasNext()) continue;
                this.printer.p(", ");
            }
        }
        this.printer.p(')');
    }

    public void visit(VariantT variantT) {
        this.printAnnotations(variantT);
        if (variantT.isPolymorphic()) {
            this.printer.p("polymorphic-");
        }
        this.printer.p("variant ");
        if (null == variantT.getName()) {
            this.printer.p("<anonymous>");
        } else {
            this.printer.p(variantT.getName());
        }
        if (this.visited.containsKey(variantT)) {
            return;
        }
        this.visited.put(variantT, Boolean.TRUE);
        if (null == variantT.getTuples()) {
            this.printer.p(" { ... }");
        } else {
            this.printer.pln(" {").incr();
            for (TupleT tupleT : variantT.getTuples()) {
                this.printer.indent().p(tupleT).pln(';');
            }
            this.printer.decr().indent().p('}');
        }
    }

    public void visit(AliasT aliasT) {
        this.printAnnotations(aliasT);
        this.printer.p("alias(").p(aliasT.getName());
        if (null != aliasT.getType()) {
            this.printer.p(", ").p(aliasT.getType());
        }
        this.printer.p(')');
    }

    public void visit(AnnotatedT annotatedT) {
        this.printAnnotations(annotatedT);
        this.printer.p(annotatedT.getType());
    }

    public void visit(EnumeratorT enumeratorT) {
        this.printAnnotations(enumeratorT);
        this.printer.p("enumerator(").p(enumeratorT.getType()).p(' ').p(enumeratorT.getName()).p(')');
    }

    public void visit(EnumT enumT) {
        this.printAnnotations(enumT);
        this.printTagged("enum", enumT);
    }

    public void visit(InstantiatedT instantiatedT) {
        this.printAnnotations(instantiatedT);
        Iterator<Parameter> iterator = instantiatedT.toParameterized().getParameters().iterator();
        Iterator<Type> iterator2 = instantiatedT.getArguments().iterator();
        this.printer.p('<');
        while (iterator.hasNext()) {
            this.printer.p(iterator.next()).p(" = ").p(iterator2.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p('>');
        this.isInstantiated = true;
        this.printer.p(instantiatedT.getType());
    }

    public void visit(ParameterizedT parameterizedT) {
        this.printAnnotations(parameterizedT);
        if (this.isInstantiated) {
            this.isInstantiated = false;
        } else {
            this.printer.p('<');
            Iterator<Parameter> iterator = parameterizedT.getParameters().iterator();
            while (iterator.hasNext()) {
                this.printer.p(iterator.next());
                if (!iterator.hasNext()) continue;
                this.printer.p(", ");
            }
            this.printer.p("> ");
        }
        this.printer.p(parameterizedT.getType());
    }

    public void visit(VariableT variableT) {
        this.printAnnotations(variableT);
        switch (variableT.getKind()) {
            case GLOBAL: {
                this.printer.p("global");
                break;
            }
            case LOCAL: {
                this.printer.p("local");
                break;
            }
            case PARAMETER: {
                this.printer.p("param");
                break;
            }
            case FIELD: {
                this.printer.p("field");
                break;
            }
            case BITFIELD: {
                this.printer.p("bitfield");
            }
        }
        this.printer.p('(').p(variableT.getType()).p(", ");
        if (variableT.hasName()) {
            this.printer.p(variableT.getName());
        } else {
            this.printer.p("<anon>");
        }
        if (variableT.hasWidth()) {
            this.printer.p(", ").p(variableT.getWidth());
        }
        this.printer.p(')');
    }
}

