/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.type.DerivedT;
import xtc.type.Type;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleT
extends DerivedT {
    private final String qname;
    private final String sname;
    private List<Type> types;

    public TupleT() {
        this(null, null, null);
    }

    public TupleT(List<Type> list) {
        this(null, null, list);
    }

    public TupleT(String string) {
        this(null, string, null);
    }

    public TupleT(String string, Type type2) {
        this(null, string, new ArrayList<Type>(1));
        this.types.add(type2);
    }

    public TupleT(String string, List<Type> list) {
        this(null, string, list);
    }

    public TupleT(Type type2, String string, List<Type> list) {
        super(type2);
        this.qname = string;
        this.sname = null == string ? null : Utilities.unqualify(string);
        this.types = list;
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.types = Type.seal(this.types);
        }
        return this;
    }

    @Override
    public TupleT copy() {
        return new TupleT(this, this.qname, TupleT.copy(this.types));
    }

    @Override
    public Type.Tag tag() {
        return Type.Tag.TUPLE;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public TupleT toTuple() {
        return this;
    }

    public boolean hasName() {
        return null != this.qname;
    }

    @Override
    public boolean hasName(String string) {
        return string.equals(this.qname);
    }

    public boolean hasSimpleName(String string) {
        return string.equals(this.sname);
    }

    @Override
    public String getName() {
        return this.qname;
    }

    public String getSimpleName() {
        return this.sname;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public void setTypes(List<Type> list) {
        this.checkNotSealed();
        this.types = list;
    }

    public int hashCode() {
        int n = 0;
        if (null != this.qname) {
            n = this.qname.hashCode();
        }
        if (null != this.types) {
            n = 7 * n + ((Object)this.types).hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = TupleT.resolve(object);
        if (this == type2) {
            return true;
        }
        if (!type2.isTuple()) {
            return false;
        }
        TupleT tupleT = type2.toTuple();
        if (null == this.qname ? null != tupleT.qname : !this.qname.equals(tupleT.qname)) {
            return false;
        }
        return null == this.types ? null == tupleT.types : ((Object)this.types).equals(tupleT.types);
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        if (null == this.qname) {
            appendable.append("<anonymous>");
        } else {
            appendable.append(this.qname);
        }
        appendable.append('(');
        if (null == this.types) {
            appendable.append("...");
        } else {
            Iterator<Type> iterator = this.types.iterator();
            while (iterator.hasNext()) {
                iterator.next().write(appendable);
                if (!iterator.hasNext()) continue;
                appendable.append(", ");
            }
        }
        appendable.append(')');
    }
}

