/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import xtc.Constants;
import xtc.tree.Attribute;
import xtc.tree.Printer;
import xtc.tree.VisitingException;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.ArrayT;
import xtc.type.ClassOrInterfaceT;
import xtc.type.EnumT;
import xtc.type.ErrorT;
import xtc.type.FunctionT;
import xtc.type.InternalT;
import xtc.type.NumberT;
import xtc.type.PointerT;
import xtc.type.StructT;
import xtc.type.Type;
import xtc.type.UnionT;
import xtc.type.VariableT;
import xtc.type.VoidT;
import xtc.type.WrappedT;

public class SourcePrinter
extends Visitor {
    private static Set<Attribute> LITERALS = new HashSet<Attribute>();
    protected final Printer printer;
    protected Type base;
    protected List<Type> derived;
    protected String name;
    protected boolean needsSpace;

    public SourcePrinter(Printer printer) {
        this.printer = printer;
    }

    public void print(Type type2) {
        this.print(type2, null);
    }

    public void print(Type type2, String string) {
        Type type3 = this.base;
        List<Type> list = this.derived;
        String string2 = this.name;
        boolean bl = this.needsSpace;
        this.base = type2;
        this.derived = null;
        this.name = string;
        this.needsSpace = false;
        try {
            this.dispatch(type2);
        }
        catch (VisitingException visitingException) {
            if (visitingException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)visitingException.getCause();
            }
            throw visitingException;
        }
        finally {
            this.base = type3;
            this.derived = list;
            this.name = string2;
            this.needsSpace = bl;
        }
    }

    protected void setVariable(String string) {
        if (null != this.name) {
            throw new IllegalArgumentException("duplicate variable name");
        }
        this.name = string;
    }

    protected void addDerived(Type type2) {
        if (null == this.derived) {
            this.derived = new ArrayList<Type>();
        }
        this.derived.add(type2);
    }

    protected void space() {
        if (this.needsSpace) {
            this.printer.p(' ');
            this.needsSpace = false;
        }
    }

    protected void printDerived() {
        Type type2;
        int n;
        int n2;
        if (null != this.derived) {
            n2 = 1;
            for (n = this.derived.size() - 1; n >= 0; --n) {
                Type type3 = this.derived.get(n);
                type2 = type3.resolve();
                if (!type2.isPointer()) {
                    n2 = 0;
                    continue;
                }
                if (n2 == 0) {
                    this.space();
                    this.printer.p('(');
                    this.needsSpace = false;
                    n2 = 1;
                }
                this.printPointer(type3);
            }
        }
        if (null != this.name) {
            this.space();
            this.printer.p(this.name);
        }
        if (null != this.derived) {
            n2 = this.derived.size();
            n = 0;
            for (int i = 0; i < n2; ++i) {
                type2 = this.derived.get(i);
                Type type4 = type2.resolve();
                if (type4.isPointer()) {
                    if (n != 0) continue;
                    for (int j = i + 1; j < n2; ++j) {
                        if (this.derived.get(j).resolve().isPointer()) continue;
                        this.space();
                        this.printer.p(')');
                        break;
                    }
                    n = 1;
                    continue;
                }
                if (type4.isArray()) {
                    n = 0;
                    this.printArray(type2);
                    continue;
                }
                if (!type4.isFunction()) continue;
                n = 0;
                this.printFunction(type2);
            }
        }
    }

    protected void printPointer(Type type2) {
        if (!type2.resolve().isPointer()) {
            throw new IllegalStateException("printing non-pointer as pointer");
        }
        this.space();
        this.printer.p('*');
        if (SourcePrinter.hasAttributes(type2)) {
            this.printer.p(' ');
            this.printAttributes(type2);
        }
    }

    protected void printArray(Type type2) {
        Type type3 = type2.resolve();
        if (!type3.isArray()) {
            throw new IllegalStateException("printing non-array as array");
        }
        ArrayT arrayT = type3.toArray();
        this.space();
        this.printer.p('[');
        if (SourcePrinter.hasAttributes(type2)) {
            this.printAttributes(type2);
        }
        if (arrayT.isVarLength()) {
            this.space();
            this.printer.p('*');
        } else if (arrayT.hasLength()) {
            this.space();
            this.printer.p(arrayT.getLength());
        }
        this.printer.p(']');
    }

    protected void printFunction(Type type2) {
        Type type3 = type2.resolve();
        if (!type3.isFunction()) {
            throw new IllegalStateException("printing non-function as function");
        }
        FunctionT functionT = (FunctionT)type3;
        this.space();
        this.printer.p('(');
        if (functionT.hasAttribute(Constants.ATT_STYLE_NEW)) {
            List<Type> list = functionT.getParameters();
            if (0 == list.size()) {
                this.printer.p("void");
            } else {
                Iterator<Type> iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.print(iterator.next());
                    if (!iterator.hasNext()) continue;
                    this.printer.p(", ");
                }
            }
        }
        this.printer.p(')');
    }

    public static boolean isPrintable(Attribute attribute) {
        if (LITERALS.contains(attribute)) {
            return true;
        }
        String string = attribute.getName();
        return "storage".equals(string) || "visibility".equals(string) && !Constants.ATT_PACKAGE_PRIVATE.equals(attribute);
    }

    public static boolean hasAttributes(Type type2) {
        while (true) {
            if (type2.hasAttributes()) {
                for (Attribute attribute : type2.attributes()) {
                    if (!SourcePrinter.isPrintable(attribute)) continue;
                    return true;
                }
            }
            if (!type2.isWrapped()) {
                return false;
            }
            type2 = type2.toWrapped().getType();
        }
    }

    protected void printAttributes(Type type2) {
        while (true) {
            if (type2.hasAttributes()) {
                for (Attribute attribute : type2.attributes()) {
                    this.dispatch(attribute);
                }
            }
            if (!type2.isWrapped()) {
                return;
            }
            type2 = type2.toWrapped().getType();
        }
    }

    public void visit(Attribute attribute) {
        String string = attribute.getName();
        if ("storage".equals(string)) {
            this.space();
            this.printer.p(attribute.getValue().toString());
            this.needsSpace = true;
        } else if ("visibility".equals(string)) {
            if (!Constants.ATT_PACKAGE_PRIVATE.equals(attribute)) {
                this.space();
                this.printer.p(attribute.getValue().toString());
                this.needsSpace = true;
            }
        } else if (Constants.ATT_CONSTANT.equals(attribute)) {
            this.space();
            this.printer.p("const");
            this.needsSpace = true;
        } else if (Constants.ATT_THREAD_LOCAL.equals(attribute)) {
            this.space();
            this.printer.p("__thread");
            this.needsSpace = true;
        } else if (LITERALS.contains(attribute)) {
            this.space();
            this.printer.p(string);
            this.needsSpace = true;
        }
    }

    public void visit(VoidT voidT) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p("void");
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(NumberT numberT) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p(numberT.toString());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(StructT structT) {
        if (structT.isUnnamed()) {
            throw new IllegalArgumentException("anonymous struct");
        }
        this.printAttributes(this.base);
        this.space();
        this.printer.p("struct ").p(structT.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(UnionT unionT) {
        if (unionT.isUnnamed()) {
            throw new IllegalArgumentException("anonymous union");
        }
        this.printAttributes(this.base);
        this.space();
        this.printer.p("union ").p(unionT.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(EnumT enumT) {
        if (enumT.isUnnamed()) {
            throw new IllegalArgumentException("anonymous enum");
        }
        this.printAttributes(this.base);
        this.space();
        this.printer.p("enum ").p(enumT.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(ClassOrInterfaceT classOrInterfaceT) {
        this.space();
        this.printer.p(classOrInterfaceT.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(AliasT aliasT) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p(aliasT.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(InternalT internalT) {
        this.printAttributes(this.base);
        this.space();
        this.printer.p(internalT.getName());
        this.needsSpace = true;
        this.printDerived();
    }

    public void visit(PointerT pointerT) {
        this.addDerived(this.base);
        this.base = pointerT.getType();
        this.dispatch(this.base);
    }

    public void visit(ArrayT arrayT) {
        this.addDerived(this.base);
        this.base = arrayT.getType();
        this.dispatch(this.base);
    }

    public void visit(FunctionT functionT) {
        this.addDerived(this.base);
        this.base = functionT.getResult();
        this.dispatch(this.base);
    }

    public void visit(VariableT variableT) {
        this.setVariable(variableT.getName());
        this.dispatch(variableT.getType());
    }

    public void visit(WrappedT wrappedT) {
        this.dispatch(wrappedT.getType());
    }

    public void visit(ErrorT errorT) {
        throw new IllegalArgumentException("error type");
    }

    static {
        LITERALS.add(Constants.ATT_ABSTRACT);
        LITERALS.add(Constants.ATT_CONSTANT);
        LITERALS.add(Constants.ATT_INLINE);
        LITERALS.add(Constants.ATT_NATIVE);
        LITERALS.add(Constants.ATT_RESTRICT);
        LITERALS.add(Constants.ATT_STRICT_FP);
        LITERALS.add(Constants.ATT_SYNCHRONIZED);
        LITERALS.add(Constants.ATT_THREAD_LOCAL);
        LITERALS.add(Constants.ATT_TRANSIENT);
        LITERALS.add(Constants.ATT_VOLATILE);
    }
}

