/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.type.Parameter;
import xtc.type.Type;
import xtc.type.WrappedT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedT
extends WrappedT {
    private List<Parameter> parameters;

    public ParameterizedT(Parameter parameter, Type type2) {
        super(type2);
        this.parameters = new ArrayList<Parameter>(1);
        this.parameters.add(parameter);
    }

    public ParameterizedT(List<Parameter> list, Type type2) {
        super(type2);
        this.parameters = list;
    }

    public ParameterizedT(Type type2, List<Parameter> list, Type type3) {
        super(type2, type3);
        this.parameters = list;
    }

    @Override
    public ParameterizedT copy() {
        return new ParameterizedT(this, Type.copy(this.parameters), this.getType().copy());
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.parameters = Type.seal(this.parameters);
        }
        return this;
    }

    @Override
    public Type.Tag wtag() {
        return Type.Tag.PARAMETERIZED;
    }

    @Override
    public boolean isParameterized() {
        return true;
    }

    @Override
    public boolean hasParameterized() {
        return true;
    }

    @Override
    public ParameterizedT toParameterized() {
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        appendable.append('<');
        Iterator<Parameter> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            iterator.next().write(appendable);
            if (!iterator.hasNext()) continue;
            appendable.append(", ");
        }
        appendable.append("> ");
        this.getType().write(appendable);
    }
}

