/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.Type;

public class Parameter
extends Type {
    private final String name;
    private Type binding;

    public Parameter(String string) {
        this.name = string;
    }

    public Parameter(Type type2, String string) {
        super(type2);
        this.name = string;
    }

    public Parameter copy() {
        return new Parameter(this, this.name);
    }

    public Type.Tag tag() {
        return Type.Tag.PARAMETER;
    }

    public boolean isParameter() {
        return true;
    }

    public Parameter toParameter() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void bind(Type type2) {
        this.checkNotSealed();
        if (null != this.binding) {
            throw new IllegalStateException("Parameter already bound");
        }
        this.binding = type2;
        if (this.binding.isParameter()) {
            this.binding = this.binding.toParameter().lookup();
        }
    }

    public Type lookup() {
        if (null == this.binding) {
            return this;
        }
        if (this.binding.isParameter()) {
            this.binding = this.binding.toParameter().lookup();
        }
        return this.binding;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = Parameter.resolve(object);
        if (this == type2) {
            return true;
        }
        if (!type2.isParameter()) {
            return false;
        }
        Parameter parameter = type2.toParameter();
        return this.name.equals(parameter.name);
    }

    public void write(Appendable appendable) throws IOException {
        appendable.append(this.name);
    }

    public String toString() {
        return this.name;
    }
}

