/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.tree.Locatable;
import xtc.type.AST;
import xtc.type.ClassT;
import xtc.type.ErrorT;
import xtc.type.InstantiatedT;
import xtc.type.Parameter;
import xtc.type.ParameterizedT;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.type.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAST
extends AST {
    public static final Set<String> PRIMITIVES;
    public static final Set<String> MODIFIERS;
    public static final Set<String> KEYWORDS;
    protected Map<String, Class<?>> resolvedTypes = new HashMap();
    private static final int QLIST_IDX;
    private static final int LIST_IDX;
    private static final int QACTION_IDX;
    private static final int ACTION_IDX;

    @Override
    public void initialize(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.externToIntern.clear();
        this.internToExtern.clear();
        this.externToIntern.put("?", Wildcard.TYPE);
        this.externToIntern.put("void", VoidT.TYPE);
        this.externToIntern.put("Object", ANY);
        this.externToIntern.put("java.lang.Object", ANY);
        this.externToIntern.put("Character", CHAR);
        this.externToIntern.put("java.lang.Character", CHAR);
        this.externToIntern.put("String", STRING);
        this.externToIntern.put("java.lang.String", STRING);
        if (bl2) {
            this.externToIntern.put("Token", TOKEN);
        }
        this.externToIntern.put("xtc.tree.Token", TOKEN);
        if (bl) {
            this.externToIntern.put("Node", NODE);
        }
        this.externToIntern.put("xtc.tree.Node", NODE);
        this.externToIntern.put("generic", GENERIC);
        if (bl) {
            this.externToIntern.put("GNode", NODE);
        }
        this.externToIntern.put("xtc.tree.GNode", NODE);
        if (bl3) {
            this.externToIntern.put("Formatting", FORMATTING);
        }
        this.externToIntern.put("xtc.tree.Formatting", FORMATTING);
        this.externToIntern.put("Pair", WILD_LIST);
        this.externToIntern.put("xtc.util.Pair", WILD_LIST);
        if (bl4) {
            this.externToIntern.put("Action", WILD_ACTION);
        }
        this.externToIntern.put("xtc.util.Action", WILD_ACTION);
        this.internToExtern.put("?", "?");
        this.internToExtern.put("void", "Void");
        this.internToExtern.put("unit", "Void");
        this.internToExtern.put("any", "Object");
        this.internToExtern.put("char", "Character");
        this.internToExtern.put("string", "String");
        this.internToExtern.put("token", "Token");
        this.internToExtern.put("node", "Node");
        this.internToExtern.put("formatting", "Formatting");
        this.internToExtern.put("list", "Pair");
        this.internToExtern.put("action", "Action");
    }

    @Override
    public boolean isVoid(String string) {
        return "void".equals(string);
    }

    @Override
    public boolean isGenericNode(String string) {
        return "generic".equals(string);
    }

    @Override
    protected Type internList(String string) {
        if (string.startsWith("xtc.util.Pair<")) {
            return new InstantiatedT(this.intern(string.substring(QLIST_IDX, string.length() - 1)), LIST);
        }
        if (string.startsWith("Pair<")) {
            return new InstantiatedT(this.intern(string.substring(LIST_IDX, string.length() - 1)), LIST);
        }
        return ErrorT.TYPE;
    }

    @Override
    protected Type internAction(String string) {
        if (string.startsWith("xtc.util.Action<")) {
            return new InstantiatedT(this.intern(string.substring(QACTION_IDX, string.length() - 1)), ACTION);
        }
        if (string.startsWith("Action<")) {
            return new InstantiatedT(this.intern(string.substring(ACTION_IDX, string.length() - 1)), ACTION);
        }
        return ErrorT.TYPE;
    }

    @Override
    protected Type internUser(String string) {
        if (PRIMITIVES.contains(string)) {
            throw new IllegalArgumentException("Java primitive type");
        }
        if (MODIFIERS.contains(string)) {
            throw new IllegalArgumentException("Java modifier as type");
        }
        if (KEYWORDS.contains(string)) {
            throw new IllegalArgumentException("Java keyword as type");
        }
        int n = string.indexOf(60);
        if (-1 == n) {
            return new ClassT(string, null, null, null, null);
        }
        ClassT classT = new ClassT(string.substring(0, n), null, null, null, null);
        String string2 = string.substring(n + 1, string.length() - 1);
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        ArrayList<Type> arrayList2 = new ArrayList<Type>();
        int n2 = 1;
        int n3 = 0;
        do {
            int n4 = this.endOfType(string2, n3);
            arrayList.add(new Parameter("T" + n2));
            arrayList2.add(this.intern(string2.substring(n3, n4)));
            n3 = n4 + 1;
            ++n2;
        } while (n3 < string2.length());
        return new InstantiatedT(arrayList2, (Type)new ParameterizedT(arrayList, (Type)classT));
    }

    protected int endOfType(String string, int n) {
        int n2 = string.length();
        int n3 = n;
        int n4 = 0;
        do {
            char c = string.charAt(n3);
            switch (c) {
                case '<': {
                    ++n4;
                    break;
                }
                case '>': {
                    --n4;
                    break;
                }
                case ',': {
                    if (0 != n4) break;
                    return n3;
                }
            }
        } while (++n3 < n2);
        return n3;
    }

    @Override
    protected String externList(Type type2) {
        return "Pair<" + this.extern(JavaAST.getArgument(type2)) + ">";
    }

    @Override
    protected String externAction(Type type2) {
        return "Action<" + this.extern(JavaAST.getArgument(type2)) + ">";
    }

    @Override
    protected String externUser(Type type2) {
        if (type2.hasInstantiated() || type2.hasParameterized()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.extern(type2.resolve()));
            stringBuilder.append('<');
            Iterator<Type> iterator = type2.hasInstantiated() ? type2.toInstantiated().getArguments().iterator() : type2.toParameterized().getParameters().iterator();
            do {
                stringBuilder.append(this.extern(iterator.next()));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            } while (iterator.hasNext());
            stringBuilder.append('>');
            return stringBuilder.toString();
        }
        if (!type2.resolve().isClass()) {
            System.out.println(type2);
        }
        return type2.resolve().toClass().getQName();
    }

    @Override
    protected Constants.FuzzyBoolean hasLocationUser(Type type2) {
        Class<?> clazz = this.resolve(type2.resolve().toClass().getQName());
        if (null == clazz || Object.class.equals(clazz)) {
            return Constants.FuzzyBoolean.MAYBE;
        }
        if (Locatable.class.isAssignableFrom(clazz)) {
            return Constants.FuzzyBoolean.TRUE;
        }
        return Constants.FuzzyBoolean.FALSE;
    }

    @Override
    protected Type unifyUser(Type type2, Type type3, boolean bl) {
        Type type4 = type2.resolve();
        Type type5 = type3.resolve();
        if (type4.isClass() && type5.isClass() && type4.toClass().getQName().equals(type5.toClass().getQName())) {
            return type2;
        }
        if (bl) {
            return ErrorT.TYPE;
        }
        return ANY;
    }

    public Class<?> resolve(String string) {
        if (this.resolvedTypes.containsKey(string)) {
            return this.resolvedTypes.get(string);
        }
        Class<?> clazz = null;
        if (this.importedTypes.containsKey(string)) {
            try {
                clazz = Class.forName((String)this.importedTypes.get(string));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            for (String string2 : this.importedModules) {
                try {
                    clazz = Class.forName(string2 + string);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (null == clazz) {
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        this.resolvedTypes.put(string, clazz);
        return clazz;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("byte");
        hashSet.add("short");
        hashSet.add("char");
        hashSet.add("int");
        hashSet.add("long");
        hashSet.add("float");
        hashSet.add("double");
        hashSet.add("boolean");
        PRIMITIVES = Collections.unmodifiableSet(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("public");
        hashSet2.add("protected");
        hashSet2.add("private");
        hashSet2.add("static");
        hashSet2.add("abstract");
        hashSet2.add("final");
        hashSet2.add("native");
        hashSet2.add("synchronized");
        hashSet2.add("transient");
        hashSet2.add("volatile");
        hashSet2.add("strictfp");
        MODIFIERS = Collections.unmodifiableSet(hashSet);
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add("assert");
        hashSet3.add("break");
        hashSet3.add("case");
        hashSet3.add("catch");
        hashSet3.add("class");
        hashSet3.add("const");
        hashSet3.add("continue");
        hashSet3.add("default");
        hashSet3.add("do");
        hashSet3.add("else");
        hashSet3.add("enum");
        hashSet3.add("extends");
        hashSet3.add("finally");
        hashSet3.add("for");
        hashSet3.add("if");
        hashSet3.add("goto");
        hashSet3.add("implements");
        hashSet3.add("import");
        hashSet3.add("instanceof");
        hashSet3.add("interface");
        hashSet3.add("new");
        hashSet3.add("package");
        hashSet3.add("return");
        hashSet3.add("super");
        hashSet3.add("switch");
        hashSet3.add("this");
        hashSet3.add("throw");
        hashSet3.add("throws");
        hashSet3.add("try");
        hashSet3.add("while");
        KEYWORDS = Collections.unmodifiableSet(hashSet3);
        QLIST_IDX = "xtc.util.Pair<".length();
        LIST_IDX = "Pair<".length();
        QACTION_IDX = "xtc.util.Action<".length();
        ACTION_IDX = "Action<".length();
    }
}

