/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import xtc.type.NumberT;
import xtc.type.Type;

public class IntegerT
extends NumberT {
    public IntegerT(NumberT.Kind kind) {
        this(null, kind);
    }

    public IntegerT(Type type2, NumberT.Kind kind) {
        super(type2, kind);
        switch (kind) {
            case FLOAT: 
            case DOUBLE: 
            case LONG_DOUBLE: 
            case FLOAT_COMPLEX: 
            case DOUBLE_COMPLEX: 
            case LONG_DOUBLE_COMPLEX: {
                throw new IllegalArgumentException("Not an integer kind " + (Object)((Object)kind));
            }
        }
    }

    public IntegerT copy() {
        return new IntegerT(this, this.kind);
    }

    public Type.Tag tag() {
        return Type.Tag.INTEGER;
    }

    public boolean isInteger() {
        return true;
    }

    public IntegerT toInteger() {
        return this;
    }

    public static NumberT.Kind fromRank(int n, boolean bl) {
        switch (n) {
            case 1: {
                if (bl) {
                    return NumberT.Kind.CHAR;
                }
                return NumberT.Kind.U_CHAR;
            }
            case 2: {
                return bl ? NumberT.Kind.SHORT : NumberT.Kind.U_SHORT;
            }
            case 3: {
                return bl ? NumberT.Kind.INT : NumberT.Kind.U_INT;
            }
            case 4: {
                return bl ? NumberT.Kind.LONG : NumberT.Kind.U_LONG;
            }
            case 5: {
                return bl ? NumberT.Kind.LONG_LONG : NumberT.Kind.U_LONG_LONG;
            }
        }
        throw new IllegalArgumentException("Invalid rank: " + n);
    }
}

