/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.type.Type;
import xtc.type.WrappedT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiatedT
extends WrappedT {
    private List<Type> arguments;

    public InstantiatedT(Type type2, Type type3) {
        super(type3);
        this.arguments = new ArrayList<Type>(1);
        this.arguments.add(type2);
        if (!type3.hasParameterized()) {
            throw new IllegalArgumentException("Not a parameterized type " + type3);
        }
        if (1 != type3.toParameterized().getParameters().size()) {
            throw new IllegalArgumentException("Wrong number of parameters " + type3);
        }
    }

    public InstantiatedT(List<Type> list, Type type2) {
        super(type2);
        this.arguments = list;
        if (!type2.hasParameterized()) {
            throw new IllegalArgumentException("Not a parameterized type " + type2);
        }
        if (list.size() != type2.toParameterized().getParameters().size()) {
            throw new IllegalArgumentException("Wrong number of parameters " + type2);
        }
    }

    public InstantiatedT(Type type2, List<Type> list, Type type3) {
        super(type2, type3);
        this.arguments = list;
        if (!type3.hasParameterized()) {
            throw new IllegalArgumentException("Not a parameterized type " + type3);
        }
        if (list.size() != type3.toParameterized().getParameters().size()) {
            throw new IllegalArgumentException("Wrong number of parameters " + type3);
        }
    }

    @Override
    public InstantiatedT copy() {
        return new InstantiatedT(this, Type.copy(this.arguments), this.getType().copy());
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.arguments = Type.seal(this.arguments);
        }
        return this;
    }

    @Override
    public Type.Tag wtag() {
        return Type.Tag.INSTANTIATED;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public boolean hasInstantiated() {
        return true;
    }

    @Override
    public InstantiatedT toInstantiated() {
        return this;
    }

    public List<Type> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = InstantiatedT.cast(object);
        if (!type2.hasInstantiated()) {
            return false;
        }
        InstantiatedT instantiatedT = type2.toInstantiated();
        if (this.arguments.size() != instantiatedT.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i).equals(instantiatedT.arguments.get(i))) continue;
            return false;
        }
        return this.getType().equals(instantiatedT.getType());
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        if (1 == this.arguments.size()) {
            appendable.append("argument(");
        } else {
            appendable.append("arguments(");
        }
        Iterator<Type> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            iterator.next().write(appendable);
            if (!iterator.hasNext()) continue;
            appendable.append(", ");
        }
        appendable.append(") ");
        this.getType().write(appendable);
    }
}

