/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.List;
import xtc.type.EnumeratorT;
import xtc.type.ErrorT;
import xtc.type.Tagged;
import xtc.type.Type;
import xtc.type.WrappedT;
import xtc.util.Nonce;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumT
extends WrappedT
implements Tagged {
    private final Nonce nonce;
    private final String name;
    private List<EnumeratorT> enumerators;

    public EnumT(String string) {
        this(null, ErrorT.TYPE, Nonce.create(), string, null);
    }

    public EnumT(Type type2, String string, List<EnumeratorT> list) {
        this(null, type2, Nonce.create(), string, list);
    }

    public EnumT(Type type2, Type type3, Nonce nonce, String string, List<EnumeratorT> list) {
        super(type2, type3);
        if (null == string) {
            throw new NullPointerException("Null name");
        }
        this.nonce = nonce;
        this.name = string;
        this.enumerators = list;
    }

    @Override
    public EnumT copy() {
        return new EnumT(this, this.getType().copy(), this.nonce, this.name, EnumT.copy(this.enumerators));
    }

    @Override
    public Type seal() {
        if (null != this.enumerators && !this.isSealed()) {
            super.seal();
            this.enumerators = Type.seal(this.enumerators);
        }
        return this;
    }

    @Override
    public Type.Tag wtag() {
        return Type.Tag.ENUM;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public boolean hasEnum() {
        return true;
    }

    @Override
    public EnumT toEnum() {
        return this;
    }

    @Override
    public boolean hasTagged() {
        return true;
    }

    @Override
    public Tagged toTagged() {
        return this;
    }

    @Override
    public void setType(Type type2) {
        super.setType(type2);
        for (EnumeratorT enumeratorT : this.enumerators) {
            enumeratorT.setType(type2);
        }
    }

    @Override
    public Nonce getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isUnnamed() {
        return this.name.startsWith("tag(");
    }

    @Override
    public boolean hasName(String string) {
        return string.equals(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type lookup(String string) {
        for (EnumeratorT enumeratorT : this.enumerators) {
            if (!enumeratorT.hasName(string)) continue;
            return enumeratorT;
        }
        return ErrorT.TYPE;
    }

    @Override
    public int getMemberCount() {
        return null == this.enumerators ? -1 : this.enumerators.size();
    }

    @Override
    public EnumeratorT getMember(int n) {
        return this.enumerators.get(n);
    }

    public List<EnumeratorT> getMembers() {
        return this.enumerators;
    }

    public void setMembers(List<EnumeratorT> list) {
        this.checkNotSealed();
        this.enumerators = list;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = (Type)object;
        return type2.hasTagged() && this.nonce == type2.toTagged().getNonce();
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        appendable.append("enum ");
        appendable.append(this.name);
    }
}

