/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.Limits;
import xtc.tree.Attribute;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.Constant;
import xtc.type.EnumeratorT;
import xtc.type.ErrorT;
import xtc.type.FloatT;
import xtc.type.FunctionT;
import xtc.type.IntegerT;
import xtc.type.NumberT;
import xtc.type.PointerT;
import xtc.type.Reference;
import xtc.type.StructOrUnionT;
import xtc.type.StructT;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.util.Utilities;

public class C {
    public static final IntegerT IMPLICIT = new IntegerT(NumberT.Kind.INT);
    protected static final NumberT.Kind KIND_SIZEOF;
    public static final IntegerT SIZEOF;
    protected static final NumberT.Kind KIND_PTR_DIFF;
    public static final IntegerT PTR_DIFF;
    protected static final NumberT.Kind KIND_WCHAR;
    public static final IntegerT WCHAR;
    private static final Attribute PACKED;
    protected final BigInteger FACTOR_CHAR = BigInteger.valueOf(2L).pow(8);
    protected final BigInteger FACTOR_WIDE = BigInteger.valueOf(2L).pow(32);

    public boolean isChar(Type type2) {
        if (type2.hasEnum()) {
            return false;
        }
        if ((type2 = type2.resolve()).isInteger()) {
            switch (type2.toInteger().getKind()) {
                case CHAR: 
                case S_CHAR: 
                case U_CHAR: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isWideChar(Type type2) {
        if (type2.hasEnum()) {
            return false;
        }
        if ((type2 = type2.resolve()).isInteger()) {
            return NumberT.equal(KIND_WCHAR, type2.toInteger().getKind());
        }
        return false;
    }

    public boolean isString(Type type2) {
        return (type2 = type2.resolve()).isArray() && this.isChar(type2.toArray().getType());
    }

    public boolean isWideString(Type type2) {
        return (type2 = type2.resolve()).isArray() && this.isWideChar(type2.toArray().getType());
    }

    public boolean isStringLiteral(Type type2) {
        return (this.isString(type2) || this.isWideString(type2)) && type2.hasConstant();
    }

    public boolean isIntegral(Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: 
            case INTEGER: {
                return true;
            }
        }
        return false;
    }

    public boolean isReal(Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: 
            case INTEGER: {
                return true;
            }
            case FLOAT: {
                switch (type2.resolve().toFloat().getKind()) {
                    case FLOAT_COMPLEX: 
                    case DOUBLE_COMPLEX: 
                    case LONG_DOUBLE_COMPLEX: {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isArithmetic(Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public boolean isScalar(Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case POINTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isIncomplete(Type type2) {
        while (type2.isWrapped()) {
            switch (type2.wtag()) {
                case ALIAS: {
                    return null == type2.toAlias().getType();
                }
                case ENUM: {
                    return null == type2.toEnum().getMembers();
                }
            }
            type2 = type2.toWrapped().getType();
        }
        switch (type2.tag()) {
            case VOID: {
                return true;
            }
            case ARRAY: {
                ArrayT arrayT = type2.toArray();
                return !arrayT.isVarLength() && !arrayT.hasLength() || this.isIncomplete(arrayT.getType()) || this.hasTrailingArray(arrayT.getType());
            }
            case STRUCT: {
                List<VariableT> list = type2.toStruct().getMembers();
                if (null == list) {
                    return true;
                }
                Iterator<VariableT> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ArrayT arrayT;
                    VariableT variableT = iterator.next();
                    if (!(iterator.hasNext() || Type.Tag.ARRAY != variableT.tag() ? this.isIncomplete(variableT) : this.isIncomplete((arrayT = variableT.resolve().toArray()).getType()))) continue;
                    return true;
                }
                return false;
            }
            case UNION: {
                List<VariableT> list = type2.toUnion().getMembers();
                if (null == list) {
                    return true;
                }
                for (VariableT variableT : list) {
                    if (!this.isIncomplete(variableT)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean hasTrailingArray(Type type2) {
        switch (type2.tag()) {
            case STRUCT: {
                List<VariableT> list = type2.resolve().toStruct().getMembers();
                if (null != list) {
                    VariableT variableT;
                    int n = list.size();
                    VariableT variableT2 = variableT = 0 < n ? list.get(n - 1) : null;
                    if (null != variableT && Type.Tag.ARRAY == ((Type)variableT).tag()) {
                        ArrayT arrayT = ((Type)variableT).resolve().toArray();
                        return !arrayT.isVarLength() && !arrayT.hasLength();
                    }
                }
                return false;
            }
            case UNION: {
                List<VariableT> list = type2.resolve().toUnion().getMembers();
                if (null != list) {
                    for (VariableT variableT : list) {
                        if (!this.hasTrailingArray(variableT)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean isVariablyModified(Type type2) {
        switch (type2.tag()) {
            case POINTER: {
                return this.isVariablyModified(type2.resolve().toPointer().getType());
            }
            case ARRAY: {
                ArrayT arrayT = type2.resolve().toArray();
                return arrayT.isVarLength() || this.isVariablyModified(arrayT.getType());
            }
        }
        return false;
    }

    public boolean isConstant(Type type2) {
        if (type2.hasAttribute(Constants.ATT_CONSTANT)) {
            return true;
        }
        switch (type2.tag()) {
            case ARRAY: {
                type2 = type2.resolve().toArray().getType();
                return null == type2 ? false : this.isConstant(type2);
            }
            case STRUCT: 
            case UNION: {
                for (Type type3 : type2.toTagged().getMembers()) {
                    if (!this.isConstant(type3)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isModifiable(Type type2) {
        if (!type2.hasShape()) {
            return false;
        }
        if (this.isIncomplete(type2)) {
            return false;
        }
        if (Type.Tag.ARRAY == type2.tag()) {
            return false;
        }
        return !this.isConstant(type2);
    }

    public boolean hasConstRef(Type type2) {
        if (type2.hasConstant() && type2.getConstant().isReference()) {
            return true;
        }
        switch (type2.tag()) {
            case ARRAY: 
            case FUNCTION: {
                return type2.hasShape() && type2.getShape().isConstant();
            }
        }
        return false;
    }

    public Reference getConstRef(Type type2) {
        if (type2.hasConstant()) {
            Constant constant = type2.getConstant();
            if (!constant.isReference()) {
                throw new IllegalArgumentException("Constant not a reference " + type2);
            }
            return constant.refValue();
        }
        switch (type2.tag()) {
            case ARRAY: 
            case FUNCTION: {
                if (!type2.hasShape()) break;
                Reference reference = type2.getShape();
                if (!reference.isConstant()) {
                    throw new IllegalArgumentException("Shaped not constant " + type2);
                }
                return reference;
            }
        }
        throw new IllegalArgumentException("Type without constant reference " + type2);
    }

    public boolean hasQualifiers(Type type2) {
        return type2.hasAttribute(Constants.ATT_CONSTANT) || type2.hasAttribute(Constants.ATT_RESTRICT) || type2.hasAttribute(Constants.ATT_VOLATILE);
    }

    public boolean hasQualifiers(Type type2, Type type3) {
        if (type3.hasAttribute(Constants.ATT_CONSTANT) && !type2.hasAttribute(Constants.ATT_CONSTANT)) {
            return false;
        }
        if (type3.hasAttribute(Constants.ATT_RESTRICT) && !type2.hasAttribute(Constants.ATT_RESTRICT)) {
            return false;
        }
        return !type3.hasAttribute(Constants.ATT_VOLATILE) || type2.hasAttribute(Constants.ATT_VOLATILE);
    }

    public boolean hasSameQualifiers(Type type2, Type type3) {
        return type2.hasAttribute(Constants.ATT_CONSTANT) == type3.hasAttribute(Constants.ATT_CONSTANT) && type2.hasAttribute(Constants.ATT_RESTRICT) == type3.hasAttribute(Constants.ATT_RESTRICT) && type2.hasAttribute(Constants.ATT_VOLATILE) == type3.hasAttribute(Constants.ATT_VOLATILE);
    }

    public Type qualify(Type type2, Type type3) {
        if (!this.hasQualifiers(type3)) {
            return type2;
        }
        type2 = type2.annotate();
        if (type3.hasAttribute(Constants.ATT_CONSTANT)) {
            type2 = type2.attribute(Constants.ATT_CONSTANT);
        }
        if (type3.hasAttribute(Constants.ATT_RESTRICT)) {
            type2 = type2.attribute(Constants.ATT_RESTRICT);
        }
        if (type3.hasAttribute(Constants.ATT_VOLATILE)) {
            type2 = type2.attribute(Constants.ATT_VOLATILE);
        }
        return type2;
    }

    public Type reattribute(Type type2, Type type3) {
        boolean bl = false;
        do {
            if (!type3.hasAttributes()) continue;
            for (Attribute attribute : type3.attributes()) {
                if (!"gcc".equals(attribute.getName()) || type2.hasAttribute(attribute)) continue;
                if (!bl) {
                    type2 = type2.annotate();
                    bl = true;
                }
                type2.addAttribute(attribute);
            }
        } while (null != (type3 = type3.isWrapped() ? type3.toWrapped().getType() : null));
        return type2;
    }

    public Type toRValue(Type type2) {
        Type type3;
        if (!type2.hasShape()) {
            return type2;
        }
        Type type4 = type3 = type2.hasEnum() ? type2.toEnum() : type2.resolve();
        if (this.hasQualifiers(type2) || type2.hasConstant()) {
            type3 = this.qualify(type3.annotate(), type2);
            if (type2.hasConstant()) {
                type3 = type3.constant(type2.getConstant().getValue());
            }
        }
        return type3;
    }

    public long getAlignment(Type type2) {
        return this.getAlignment(type2, true);
    }

    public long getAlignment(Type type2, boolean bl) {
        Type type3 = type2.resolve();
        if (type3.isStruct() || type3.isUnion()) {
            if (this.isPacked(type2)) {
                return 1L;
            }
            long l = Math.max(1L, this.getAligned(type2));
            for (Type type4 : type2.toTagged().getMembers()) {
                if (0 == type4.toVariable().getWidth()) continue;
                l = Math.max(l, this.getAlignment(type4, false));
            }
            return l;
        }
        long l = this.getAligned(type2);
        if (-1L != l) {
            return l;
        }
        switch (type2.tag()) {
            case VOID: {
                return 1L;
            }
            case BOOLEAN: {
                return bl ? 1L : 1L;
            }
            case INTEGER: 
            case FLOAT: {
                switch (type2.resolve().toNumber().getKind()) {
                    case CHAR: 
                    case S_CHAR: 
                    case U_CHAR: {
                        return 1L;
                    }
                    case SHORT: 
                    case U_SHORT: {
                        return bl ? 2L : 2L;
                    }
                    case INT: 
                    case S_INT: 
                    case U_INT: {
                        return bl ? 4L : 4L;
                    }
                    case LONG: 
                    case U_LONG: {
                        return bl ? 4L : 4L;
                    }
                    case LONG_LONG: 
                    case U_LONG_LONG: {
                        return bl ? 8L : 4L;
                    }
                    case FLOAT: {
                        return bl ? 4L : 4L;
                    }
                    case DOUBLE: {
                        return bl ? 8L : 4L;
                    }
                    case LONG_DOUBLE: {
                        return bl ? 16L : 16L;
                    }
                    case FLOAT_COMPLEX: {
                        return bl ? 4L : 4L;
                    }
                    case DOUBLE_COMPLEX: {
                        return bl ? 8L : 4L;
                    }
                    case LONG_DOUBLE_COMPLEX: {
                        return bl ? 16L : 16L;
                    }
                }
                throw new AssertionError((Object)("Invalid number kind " + (Object)((Object)type2.toNumber().getKind())));
            }
            case POINTER: {
                return bl ? 4L : 4L;
            }
            case ARRAY: {
                return this.getAlignment(type2.resolve().toArray().getType(), bl);
            }
            case FUNCTION: {
                return 1L;
            }
        }
        throw new IllegalArgumentException("Type without alignment " + type2);
    }

    public long getSize(Type type2) {
        switch (type2.tag()) {
            case VOID: {
                return 1L;
            }
            case BOOLEAN: {
                return 1L;
            }
            case INTEGER: 
            case FLOAT: {
                switch (type2.resolve().toNumber().getKind()) {
                    case CHAR: 
                    case S_CHAR: 
                    case U_CHAR: {
                        return 1L;
                    }
                    case SHORT: 
                    case U_SHORT: {
                        return 2L;
                    }
                    case INT: 
                    case S_INT: 
                    case U_INT: {
                        return 4L;
                    }
                    case LONG: 
                    case U_LONG: {
                        return 4L;
                    }
                    case LONG_LONG: 
                    case U_LONG_LONG: {
                        return 8L;
                    }
                    case FLOAT: {
                        return 4L;
                    }
                    case DOUBLE: {
                        return 8L;
                    }
                    case LONG_DOUBLE: {
                        return 16L;
                    }
                    case FLOAT_COMPLEX: {
                        return 8L;
                    }
                    case DOUBLE_COMPLEX: {
                        return 16L;
                    }
                    case LONG_DOUBLE_COMPLEX: {
                        return 32L;
                    }
                }
                throw new AssertionError((Object)("Invalid number kind " + (Object)((Object)type2.toNumber().getKind())));
            }
            case POINTER: {
                return 4L;
            }
            case ARRAY: {
                ArrayT arrayT = type2.resolve().toArray();
                if (arrayT.hasLength()) {
                    return this.getSize(arrayT.getType()) * arrayT.getLength();
                }
                throw new IllegalArgumentException("Array without size");
            }
            case STRUCT: {
                return this.layout(type2.resolve().toStruct(), null);
            }
            case UNION: {
                long l = 0L;
                for (Type type3 : type2.toTagged().getMembers()) {
                    l = Math.max(l, this.getSize(type3));
                }
                return l;
            }
            case FUNCTION: {
                return 1L;
            }
        }
        throw new IllegalArgumentException("Type without size " + type2);
    }

    public long getOffset(StructOrUnionT structOrUnionT, String string) {
        if (structOrUnionT.isStruct()) {
            return this.layout(structOrUnionT.toStruct(), string);
        }
        for (VariableT variableT : structOrUnionT.getMembers()) {
            long l;
            if (variableT.hasName(string)) {
                return 0L;
            }
            if (variableT.hasName() || variableT.hasWidth() || -1L == (l = this.getOffset(variableT.toStructOrUnion(), string))) continue;
            return l;
        }
        return -1L;
    }

    public long layout(StructT structT, String string) {
        List<VariableT> list = structT.getMembers();
        int n = list.size();
        boolean bl = this.hasTrailingArray(structT);
        boolean bl2 = this.isPacked(structT);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 1L;
        long l5 = Math.max(1L, this.getAligned(structT));
        for (int i = 0; !(i >= n || bl && i == n - 1); ++i) {
            long l6;
            long l7;
            VariableT variableT = list.get(i);
            boolean bl3 = i == n - 1 || bl && i == n - 2;
            long l8 = l7 = bl2 ? 1L : this.getAlignment(variableT, false);
            if (0 != variableT.getWidth()) {
                l5 = Math.max(l7, l5);
            }
            if (!variableT.hasKind(VariableT.Kind.BITFIELD)) {
                long l9 = l % l7;
                if (0L != l9) {
                    l += l7 - l9;
                }
                if (null != string) {
                    long l10;
                    if (variableT.hasName(string)) {
                        return l;
                    }
                    if (!variableT.hasName() && -1L != (l10 = this.getOffset(variableT.toStructOrUnion(), string))) {
                        return l + l10;
                    }
                }
                l += this.getSize(variableT);
                continue;
            }
            int n2 = variableT.getWidth();
            assert (-1 < n2);
            if (bl2) {
                l2 += (long)n2;
                if (!bl3 && -1 != list.get(i + 1).getWidth()) continue;
                l += l2 / 8L;
                if (0L != l2 % 8L) {
                    ++l;
                }
                l2 = 0L;
                l3 = 0L;
                l4 = 1L;
                continue;
            }
            if (0 == n2) {
                l += l2 / 8L;
                if (0L != l2 % 8L) {
                    ++l;
                }
                if (0L != (l6 = l % l7)) {
                    l += l7 - l6;
                }
                l2 = 0L;
                l3 = 0L;
                l4 = 1L;
                continue;
            }
            if (0L == l3) {
                l2 = n2;
                l3 = this.getSize(variableT);
                l4 = l7;
            } else if (l2 + (long)n2 <= Limits.toWidth(l3)) {
                l2 += (long)n2;
            } else {
                l6 = (l += l3) % l4;
                if (0L != l6) {
                    l += l4 - l6;
                }
                l2 = n2;
                l3 = this.getSize(variableT);
                l4 = l7;
            }
            if (!bl3 && -1 != list.get(i + 1).getWidth()) continue;
            l += l2 / 8L;
            if (0L != l2 % 8L) {
                ++l;
            }
            l2 = 0L;
            l3 = 0L;
            l4 = 1L;
        }
        if (null != string) {
            return -1L;
        }
        long l11 = l % l5;
        if (0L != l11) {
            l += l5 - l11;
        }
        return l;
    }

    protected boolean isPacked(Type type2) {
        return type2.hasAttribute(PACKED);
    }

    protected long getAligned(Type type2) {
        long l = -1L;
        while (true) {
            for (Attribute attribute : type2.attributes()) {
                if (!"gcc".equals(attribute.getName()) || !"aligned".equals((attribute = (Attribute)attribute.getValue()).getName())) continue;
                if (null == attribute.getValue()) {
                    l = Math.max(4, 16);
                    continue;
                }
                l = ((BigInteger)attribute.getValue()).longValue();
            }
            if (!type2.isWrapped()) break;
            type2 = type2.toWrapped().getType();
        }
        return l;
    }

    public long getWidth(Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: {
                return this.getSize(type2) * 8L;
            }
        }
        throw new AssertionError((Object)("Not a C number " + type2));
    }

    public Type fit(BigInteger bigInteger) {
        if (Limits.fitsInt(bigInteger)) {
            return NumberT.INT;
        }
        if (Limits.fitsUnsignedInt(bigInteger)) {
            return NumberT.U_INT;
        }
        if (Limits.fitsLong(bigInteger)) {
            return NumberT.LONG;
        }
        if (Limits.fitsUnsignedLong(bigInteger)) {
            return NumberT.U_LONG;
        }
        if (Limits.fitsLongLong(bigInteger)) {
            return NumberT.LONG_LONG;
        }
        if (Limits.fitsUnsignedLongLong(bigInteger)) {
            return NumberT.U_LONG_LONG;
        }
        return ErrorT.TYPE;
    }

    public boolean fits(BigInteger bigInteger, Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: {
                return Limits.fitsUnsignedChar(bigInteger);
            }
            case INTEGER: {
                switch (type2.resolve().toInteger().getKind()) {
                    case CHAR: {
                        return Limits.fitsChar(bigInteger);
                    }
                    case S_CHAR: {
                        return Limits.fitsChar(bigInteger);
                    }
                    case U_CHAR: {
                        return Limits.fitsUnsignedChar(bigInteger);
                    }
                    case SHORT: {
                        return Limits.fitsShort(bigInteger);
                    }
                    case U_SHORT: {
                        return Limits.fitsUnsignedShort(bigInteger);
                    }
                    case INT: 
                    case S_INT: {
                        return Limits.fitsInt(bigInteger);
                    }
                    case U_INT: {
                        return Limits.fitsUnsignedInt(bigInteger);
                    }
                    case LONG: {
                        return Limits.fitsLong(bigInteger);
                    }
                    case U_LONG: {
                        return Limits.fitsUnsignedLong(bigInteger);
                    }
                    case LONG_LONG: {
                        return Limits.fitsLongLong(bigInteger);
                    }
                    case U_LONG_LONG: {
                        return Limits.fitsUnsignedLongLong(bigInteger);
                    }
                }
            }
        }
        throw new AssertionError((Object)("Not a C integer " + type2));
    }

    public BigInteger mask(BigInteger bigInteger, Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: {
                return 0 != bigInteger.signum() ? BigInteger.ONE : BigInteger.ZERO;
            }
            case INTEGER: {
                switch (type2.resolve().toInteger().getKind()) {
                    case CHAR: {
                        return Limits.maskAsSignedChar(bigInteger);
                    }
                    case S_CHAR: {
                        return Limits.maskAsSignedChar(bigInteger);
                    }
                    case U_CHAR: {
                        return Limits.maskAsUnsignedChar(bigInteger);
                    }
                    case SHORT: {
                        return Limits.maskAsShort(bigInteger);
                    }
                    case U_SHORT: {
                        return Limits.maskAsUnsignedShort(bigInteger);
                    }
                    case INT: 
                    case S_INT: {
                        return Limits.maskAsInt(bigInteger);
                    }
                    case U_INT: {
                        return Limits.maskAsUnsignedInt(bigInteger);
                    }
                    case LONG: {
                        return Limits.maskAsLong(bigInteger);
                    }
                    case U_LONG: {
                        return Limits.maskAsUnsignedLong(bigInteger);
                    }
                    case LONG_LONG: {
                        return Limits.maskAsLongLong(bigInteger);
                    }
                    case U_LONG_LONG: {
                        return Limits.maskAsUnsignedLongLong(bigInteger);
                    }
                }
            }
        }
        throw new AssertionError((Object)("Not a C integer " + type2));
    }

    public String toDesignation(Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case POINTER: {
                return "scalar";
            }
            case ARRAY: {
                return "array";
            }
            case STRUCT: {
                return "struct";
            }
            case UNION: {
                return "union";
            }
            case FUNCTION: {
                return "function";
            }
            case INTERNAL: {
                return type2.resolve().toInternal().getName();
            }
        }
        throw new AssertionError((Object)("Not a C type " + type2));
    }

    public Type promote(Type type2) {
        boolean bl = false;
        type2 = type2.resolve();
        switch (type2.tag()) {
            case BOOLEAN: {
                return NumberT.INT;
            }
            case INTEGER: {
                switch (type2.toInteger().getKind()) {
                    case CHAR: 
                    case S_CHAR: 
                    case U_CHAR: 
                    case SHORT: {
                        return NumberT.INT;
                    }
                    case U_SHORT: {
                        return NumberT.INT;
                    }
                    case INT: {
                        return bl ? NumberT.U_INT : NumberT.INT;
                    }
                    case S_INT: {
                        return NumberT.INT;
                    }
                    case U_INT: 
                    case LONG: 
                    case U_LONG: 
                    case LONG_LONG: 
                    case U_LONG_LONG: {
                        return type2;
                    }
                }
                throw new AssertionError((Object)("Not a C integer " + type2));
            }
        }
        return type2;
    }

    public Type promoteArgument(Type type2) {
        Type type3 = type2.resolve();
        if (type3.isFloat()) {
            if (NumberT.Kind.FLOAT == type3.toFloat().getKind()) {
                return NumberT.DOUBLE;
            }
            return type3;
        }
        return this.promote(type2);
    }

    public Type pointerize(Type type2) {
        type2 = type2.resolve();
        switch (type2.tag()) {
            case ARRAY: {
                return new PointerT(type2.toArray().getType());
            }
            case FUNCTION: {
                return new PointerT(type2);
            }
        }
        return type2;
    }

    public Type convert(Type type2, Type type3) {
        if (!this.isArithmetic(type2) || type2.hasError()) {
            throw new IllegalArgumentException("Not an arithmetic type " + type2);
        }
        if (!this.isArithmetic(type3) || type3.hasError()) {
            throw new IllegalArgumentException("Not an arithmetic type " + type3);
        }
        type2 = this.promote(type2);
        type3 = this.promote(type3);
        NumberT.Kind kind = ((NumberT)type2).getKind();
        NumberT.Kind kind2 = ((NumberT)type3).getKind();
        if (!this.isReal(type2) || !this.isReal(type3)) {
            if (NumberT.Kind.LONG_DOUBLE_COMPLEX == kind || NumberT.Kind.LONG_DOUBLE_COMPLEX == kind2) {
                return NumberT.LONG_DOUBLE_COMPLEX;
            }
            if (NumberT.Kind.DOUBLE_COMPLEX == kind || NumberT.Kind.DOUBLE_COMPLEX == kind2) {
                return NumberT.DOUBLE_COMPLEX;
            }
            if (NumberT.Kind.FLOAT_COMPLEX == kind || NumberT.Kind.FLOAT_COMPLEX == kind2) {
                return NumberT.FLOAT_COMPLEX;
            }
        }
        if (NumberT.Kind.LONG_DOUBLE == kind || NumberT.Kind.LONG_DOUBLE == kind2) {
            return NumberT.LONG_DOUBLE;
        }
        if (NumberT.Kind.DOUBLE == kind || NumberT.Kind.DOUBLE == kind2) {
            return NumberT.DOUBLE;
        }
        if (NumberT.Kind.FLOAT == kind || NumberT.Kind.FLOAT == kind2) {
            return NumberT.FLOAT;
        }
        IntegerT integerT = type2.toInteger();
        IntegerT integerT2 = type3.toInteger();
        if (kind == kind2) {
            return integerT;
        }
        if (integerT.isSigned() == integerT2.isSigned()) {
            return kind.ordinal() < kind2.ordinal() ? integerT2 : integerT;
        }
        if (!integerT.isSigned()) {
            if (kind.ordinal() > kind2.ordinal()) {
                return integerT;
            }
        } else if (kind2.ordinal() > kind.ordinal()) {
            return integerT2;
        }
        if (integerT.isSigned()) {
            if (this.getSize(integerT) > this.getSize(integerT2)) {
                return integerT;
            }
        } else if (this.getSize(integerT2) > this.getSize(integerT)) {
            return integerT2;
        }
        if (integerT.isSigned()) {
            if (NumberT.Kind.INT == kind) {
                return NumberT.U_INT;
            }
            if (NumberT.Kind.LONG == kind) {
                return NumberT.U_LONG;
            }
            return NumberT.U_LONG_LONG;
        }
        if (NumberT.Kind.INT == kind2) {
            return NumberT.U_INT;
        }
        if (NumberT.Kind.LONG == kind2) {
            return NumberT.U_LONG;
        }
        return NumberT.U_LONG_LONG;
    }

    public Type compose(Type type2, Type type3, boolean bl) {
        return this.compose(type2, type3, bl, true);
    }

    protected Type compose(Type type2, Type type3, boolean bl, boolean bl2) {
        if (bl2) {
            if (type2.isEnum()) {
                return type2.equals(type3) ? type2 : ErrorT.TYPE;
            }
            if (type2.isWrapped()) {
                Type type4 = type2.toWrapped().getType();
                Type type5 = this.compose(type4, type3, bl, true);
                if (type5.isError()) {
                    return ErrorT.TYPE;
                }
                if (type4 == type5) {
                    return type2;
                }
                switch (type2.wtag()) {
                    case ALIAS: {
                        return new AliasT(type2, type2.toAlias().getName(), type5);
                    }
                    case ANNOTATED: {
                        return new AnnotatedT(type2, type5);
                    }
                    case ENUMERATOR: {
                        EnumeratorT enumeratorT = type2.toEnumerator();
                        return new EnumeratorT(type2, type5, enumeratorT.getName(), enumeratorT.getValue());
                    }
                    case VARIABLE: {
                        VariableT variableT = type2.toVariable();
                        return variableT.hasWidth() ? new VariableT(type2, type5, variableT.getName(), variableT.getWidth()) : new VariableT(type2, type5, variableT.getKind(), variableT.getName());
                    }
                }
                throw new AssertionError((Object)("Invalid type " + type2));
            }
        } else {
            while (type2.isWrapped()) {
                if (type2.isEnum()) {
                    return type2.equals(type3) ? type2 : ErrorT.TYPE;
                }
                type2 = type2.toWrapped().getType();
            }
        }
        if (type2 == (type3 = type3.resolve())) {
            return type2;
        }
        if (type2.tag() != type3.tag()) {
            return ErrorT.TYPE;
        }
        switch (type2.tag()) {
            case ERROR: {
                return ErrorT.TYPE;
            }
            case BOOLEAN: 
            case VOID: {
                return type2;
            }
            case INTEGER: 
            case FLOAT: {
                return NumberT.equal(type2.toNumber().getKind(), type3.toNumber().getKind()) ? type2 : ErrorT.TYPE;
            }
            case INTERNAL: {
                return type2.toInternal().getName().equals(type3.toInternal().getName()) ? type2 : ErrorT.TYPE;
            }
            case LABEL: {
                return type2.toLabel().getName().equals(type3.toLabel().getName()) ? type2 : ErrorT.TYPE;
            }
            case STRUCT: 
            case UNION: {
                return type2 == type3 ? type2 : ErrorT.TYPE;
            }
            case POINTER: {
                Type type6 = type2.toPointer().getType();
                Type type7 = type3.toPointer().getType();
                if (!this.hasSameQualifiers(type6, type7)) {
                    return ErrorT.TYPE;
                }
                Type type8 = this.compose(type6, type7, bl, true);
                if (type8.isError()) {
                    return ErrorT.TYPE;
                }
                return type6 == type8 ? type2 : new PointerT(type2, type8);
            }
            case ARRAY: {
                return this.composeArrays(type2.toArray(), type3.toArray());
            }
            case FUNCTION: {
                return this.composeFunctions(type2.toFunction(), type3.toFunction(), bl);
            }
        }
        throw new AssertionError((Object)("Not a C type " + type2));
    }

    protected Type composeArrays(ArrayT arrayT, ArrayT arrayT2) {
        if (!this.hasSameQualifiers(arrayT.getType(), arrayT2.getType())) {
            return ErrorT.TYPE;
        }
        Type type2 = this.compose(arrayT.getType(), arrayT2.getType(), true);
        if (type2.isError()) {
            return ErrorT.TYPE;
        }
        if (arrayT.isVarLength()) {
            if (type2 == arrayT.getType()) {
                return arrayT;
            }
            return new ArrayT(arrayT, type2, arrayT.isVarLength(), arrayT.getLength());
        }
        if (arrayT2.isVarLength()) {
            if (type2 == arrayT2.getType()) {
                return arrayT2;
            }
            return new ArrayT(arrayT2, type2, arrayT2.isVarLength(), arrayT2.getLength());
        }
        if (arrayT.hasLength() && arrayT2.hasLength()) {
            if (arrayT.getLength() == arrayT2.getLength()) {
                if (type2 == arrayT.getType()) {
                    return arrayT;
                }
                return new ArrayT(arrayT, type2, arrayT.isVarLength(), arrayT.getLength());
            }
            return ErrorT.TYPE;
        }
        if (arrayT.hasLength()) {
            if (type2 == arrayT.getType()) {
                return arrayT;
            }
            return new ArrayT(arrayT, type2, arrayT.isVarLength(), arrayT.getLength());
        }
        if (arrayT2.hasLength()) {
            if (type2 == arrayT.getType()) {
                return arrayT2;
            }
            return new ArrayT(arrayT2, type2, arrayT2.isVarLength(), arrayT2.getLength());
        }
        return type2 == arrayT.getType() ? arrayT : new ArrayT(arrayT, type2, arrayT.isVarLength(), arrayT.getLength());
    }

    protected Type composeFunctions(FunctionT functionT, FunctionT functionT2, boolean bl) {
        if (null == functionT.getName() ? null != functionT2.getName() : !functionT.getName().equals(functionT2.getName())) {
            return ErrorT.TYPE;
        }
        boolean bl2 = false;
        if (!this.hasSameQualifiers(functionT.getResult(), functionT2.getResult())) {
            return ErrorT.TYPE;
        }
        Type type2 = this.compose(functionT.getResult(), functionT2.getResult(), true);
        if (type2.isError()) {
            return ErrorT.TYPE;
        }
        if (functionT.getResult() != type2) {
            bl2 = true;
        }
        if (functionT.hasAttribute(Constants.ATT_STYLE_OLD)) {
            if (functionT2.hasAttribute(Constants.ATT_STYLE_OLD)) {
                if (functionT.hasAttribute(Constants.ATT_DEFINED) || !functionT2.hasAttribute(Constants.ATT_DEFINED)) {
                    return bl2 ? new FunctionT(functionT, type2, functionT.getParameters(), functionT.isVarArgs()) : functionT;
                }
                return new FunctionT(functionT2, type2, functionT2.getParameters(), functionT2.isVarArgs());
            }
            if (functionT2.isVarArgs() && !functionT.hasAttribute(Constants.ATT_DEFINED)) {
                return ErrorT.TYPE;
            }
            return new FunctionT(functionT2, type2, functionT2.getParameters(), functionT2.isVarArgs());
        }
        if (functionT2.hasAttribute(Constants.ATT_STYLE_OLD)) {
            if (functionT.isVarArgs() && !functionT2.hasAttribute(Constants.ATT_DEFINED)) {
                return ErrorT.TYPE;
            }
            return bl2 ? new FunctionT(functionT, type2, functionT.getParameters(), functionT.isVarArgs()) : functionT;
        }
        if (functionT.getParameters().size() != functionT2.getParameters().size()) {
            return ErrorT.TYPE;
        }
        if (functionT.isVarArgs() != functionT2.isVarArgs()) {
            return ErrorT.TYPE;
        }
        int n = functionT.getParameters().size();
        ArrayList<Type> arrayList = bl2 ? new ArrayList<Type>(functionT.getParameters()) : null;
        for (int i = 0; i < n; ++i) {
            Type type3 = functionT.getParameters().get(i);
            Type type4 = functionT2.getParameters().get(i);
            if (bl && !this.hasSameQualifiers(type3, type4)) {
                return ErrorT.TYPE;
            }
            Type type5 = this.compose(type3, type4, true);
            if (type5.isError()) {
                return ErrorT.TYPE;
            }
            if (type3 == type5) continue;
            if (null == arrayList) {
                arrayList = new ArrayList<Type>(functionT.getParameters());
            }
            bl2 = true;
            arrayList.set(i, type5);
        }
        if (!bl2) {
            return functionT;
        }
        if (null == arrayList) {
            arrayList = new ArrayList<Type>(functionT.getParameters());
        }
        FunctionT functionT3 = new FunctionT(functionT, type2, arrayList, functionT.isVarArgs());
        return functionT3;
    }

    public boolean equal(Type type2, Type type3) {
        return this.hasSameQualifiers(type2, type3) && !this.compose(type2, type3, true).isError();
    }

    public Type typeCharacter(String string) {
        boolean bl = false;
        if (string.startsWith("L")) {
            string = string.substring(2, string.length() - 1);
            bl = true;
        } else {
            string = string.substring(1, string.length() - 1);
        }
        string = Utilities.unescape(string);
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = bl ? this.FACTOR_WIDE : this.FACTOR_CHAR;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            bigInteger = bigInteger.multiply(bigInteger2).add(BigInteger.valueOf(string.charAt(i)));
        }
        return bl ? WCHAR.annotate().constant(bigInteger) : NumberT.CHAR.annotate().constant(bigInteger);
    }

    public Type typeInteger(String string) {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = string.length(); n2 > 0; --n2) {
            n = string.charAt(n2 - 1);
            if (117 == n || 85 == n) {
                bl = true;
                continue;
            }
            if (108 != n && 76 != n) break;
            if (bl2) {
                bl2 = false;
                bl3 = true;
                continue;
            }
            bl2 = true;
        }
        string = string.substring(0, n2);
        n = 10;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n = 16;
            string = string.substring(2);
        } else if (string.startsWith("0")) {
            n = 8;
        }
        BigInteger bigInteger = new BigInteger(string, n);
        IntegerT integerT = null;
        if (bl) {
            if (bl3) {
                if (Limits.fitsUnsignedLongLong(bigInteger)) {
                    integerT = NumberT.U_LONG_LONG;
                }
            } else if (bl2) {
                if (Limits.fitsUnsignedLong(bigInteger)) {
                    integerT = NumberT.U_LONG;
                } else if (Limits.fitsUnsignedLongLong(bigInteger)) {
                    integerT = NumberT.U_LONG_LONG;
                }
            } else if (Limits.fitsUnsignedInt(bigInteger)) {
                integerT = NumberT.U_INT;
            } else if (Limits.fitsUnsignedLong(bigInteger)) {
                integerT = NumberT.U_LONG;
            } else if (Limits.fitsUnsignedLongLong(bigInteger)) {
                integerT = NumberT.U_LONG_LONG;
            }
            if (null == integerT) {
                integerT = NumberT.U_LONG_LONG;
            }
        } else if (10 == n) {
            if (bl3) {
                if (Limits.fitsLongLong(bigInteger)) {
                    integerT = NumberT.LONG_LONG;
                }
            } else if (bl2) {
                if (Limits.fitsLong(bigInteger)) {
                    integerT = NumberT.LONG;
                } else if (Limits.fitsLongLong(bigInteger)) {
                    integerT = NumberT.LONG_LONG;
                }
            } else if (Limits.fitsInt(bigInteger)) {
                integerT = NumberT.INT;
            } else if (Limits.fitsLong(bigInteger)) {
                integerT = NumberT.LONG;
            } else if (Limits.fitsLongLong(bigInteger)) {
                integerT = NumberT.LONG_LONG;
            }
            if (null == integerT) {
                integerT = NumberT.LONG_LONG;
            }
        } else {
            if (bl3) {
                if (Limits.fitsLongLong(bigInteger)) {
                    integerT = NumberT.LONG_LONG;
                } else if (Limits.fitsUnsignedLongLong(bigInteger)) {
                    integerT = NumberT.U_LONG_LONG;
                }
            } else if (bl2) {
                if (Limits.fitsLong(bigInteger)) {
                    integerT = NumberT.LONG;
                } else if (Limits.fitsUnsignedLong(bigInteger)) {
                    integerT = NumberT.U_LONG;
                } else if (Limits.fitsLongLong(bigInteger)) {
                    integerT = NumberT.LONG_LONG;
                } else if (Limits.fitsUnsignedLongLong(bigInteger)) {
                    integerT = NumberT.U_LONG_LONG;
                }
            } else if (Limits.fitsInt(bigInteger)) {
                integerT = NumberT.INT;
            } else if (Limits.fitsUnsignedInt(bigInteger)) {
                integerT = NumberT.U_INT;
            } else if (Limits.fitsLong(bigInteger)) {
                integerT = NumberT.LONG;
            } else if (Limits.fitsUnsignedLong(bigInteger)) {
                integerT = NumberT.U_LONG;
            } else if (Limits.fitsLongLong(bigInteger)) {
                integerT = NumberT.LONG_LONG;
            } else if (Limits.fitsUnsignedLongLong(bigInteger)) {
                integerT = NumberT.U_LONG_LONG;
            }
            if (null == integerT) {
                integerT = NumberT.U_LONG_LONG;
            }
        }
        return integerT.annotate().constant(bigInteger);
    }

    public Type typeFloat(String string) {
        FloatT floatT;
        char c = string.charAt(string.length() - 1);
        boolean bl = false;
        switch (c) {
            case 'F': 
            case 'f': {
                bl = true;
                floatT = NumberT.FLOAT;
                break;
            }
            case 'L': 
            case 'l': {
                bl = true;
                floatT = NumberT.LONG_DOUBLE;
                break;
            }
            case 'D': 
            case 'd': {
                bl = true;
            }
            default: {
                floatT = NumberT.DOUBLE;
            }
        }
        if (bl) {
            string = string.substring(0, string.length() - 1);
        }
        return floatT.annotate().constant(Double.valueOf(string));
    }

    static {
        IMPLICIT.addAttribute(Constants.ATT_IMPLICIT);
        IMPLICIT.seal();
        KIND_SIZEOF = IntegerT.fromRank(4, false);
        SIZEOF = new IntegerT(KIND_SIZEOF);
        SIZEOF.seal();
        KIND_PTR_DIFF = IntegerT.fromRank(3, true);
        PTR_DIFF = new IntegerT(KIND_PTR_DIFF);
        PTR_DIFF.seal();
        KIND_WCHAR = IntegerT.fromRank(3, true);
        WCHAR = new IntegerT(KIND_WCHAR);
        WCHAR.seal();
        PACKED = new Attribute("gcc", new Attribute("packed", null));
    }
}

