/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import xtc.tree.Annotation;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.VisitingException;
import xtc.tree.VisitorException;
import xtc.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Visitor {
    private static final int CACHE_SIZE = 300;
    private static final int CACHE_CAPACITY = 400;
    private static final float CACHE_LOAD = 0.75f;
    private static final LinkedHashMap<CacheKey, Method> cache = new LinkedHashMap<CacheKey, Method>(400, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry entry2) {
            return this.size() > 300;
        }
    };
    private static final CacheKey key = new CacheKey(null, null);
    private static final Object[] arguments = new Object[]{null};
    private static final Class[] types = new Class[]{null};

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public Object visit(Annotation annotation) {
        return this.dispatch(annotation.node);
    }

    public final Object dispatch(Node node) {
        if (null == node) {
            return null;
        }
        Visitor.key.visitor = this;
        Visitor.key.node = node.isGeneric() ? node.getName() : node.getClass();
        Method method = cache.get(key);
        if (null == method) {
            method = this.findMethod(node);
            cache.put(new CacheKey(this, Visitor.key.node), method);
        }
        Visitor.arguments[0] = node;
        try {
            return method.invoke((Object)this, arguments);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VisitorException("Unable to invoke " + method + " on " + arguments[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VisitorException("Internal error while visiting node " + node + " with visitor " + this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof VisitingException) {
                throw (VisitingException)throwable;
            }
            if (throwable instanceof VisitorException) {
                throw (VisitorException)throwable;
            }
            throw new VisitingException("Error visiting node " + node + " with " + "visitor " + this, throwable);
        }
        catch (NullPointerException nullPointerException) {
            throw new VisitorException("Internal error while visiting node " + node + " with visitor " + this);
        }
    }

    private Method findMethod(Node node) {
        Class<?> clazz = this.getClass();
        Method method = null;
        if (node.isGeneric()) {
            Visitor.types[0] = GNode.class;
            try {
                method = clazz.getMethod("visit" + node.getName(), types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("visit", types);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Visitor.types[0] = Node.class;
                    try {
                        method = clazz.getMethod("visit", types);
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {}
                }
            }
        } else {
            method = Visitor.findMethod(clazz, "visit", node.getClass());
        }
        if (null == method) {
            Visitor.types[0] = Node.class;
            try {
                method = clazz.getMethod("unableToVisit", types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)"Unable to find unableToVisit(Node)");
            }
        }
        method.setAccessible(true);
        return method;
    }

    private static Method findMethod(Class clazz, String string, Class clazz2) {
        Method method = null;
        do {
            Visitor.types[0] = clazz2;
            try {
                method = clazz.getMethod(string, types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class<?>[] classArray = clazz2.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    Visitor.types[0] = classArray[i];
                    try {
                        method = clazz.getMethod(string, types);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        continue;
                    }
                }
                clazz2 = clazz2.getSuperclass();
            }
        } while (null == method && Object.class != clazz2);
        return method;
    }

    public Object unableToVisit(Node node) {
        if (node.isGeneric()) {
            throw new VisitorException("No method to visit generic node " + node.getName() + " with visitor " + this);
        }
        throw new VisitorException("No method to visit node type " + node.getClass() + " with visitor " + this);
    }

    public void iterate(Pair<? extends Node> pair) {
        while (Pair.EMPTY != pair) {
            this.dispatch(pair.head());
            pair = pair.tail();
        }
    }

    public <T> Pair<T> map(Pair<? extends Node> pair) {
        Pair<Object> pair2;
        if (Pair.EMPTY == pair) {
            return Pair.empty();
        }
        Object object = this.dispatch(pair.head());
        Pair<Object> pair3 = pair2 = new Pair<Object>(object);
        while (Pair.EMPTY != pair.tail()) {
            pair = pair.tail();
            Object object2 = this.dispatch(pair.head());
            pair3.setTail(new Pair<Object>(object2));
            pair3 = pair3.tail();
        }
        return pair2;
    }

    public <T extends Node> Pair<T> mapInPlace(Pair<T> pair) {
        for (Pair<Node> pair2 = pair; Pair.EMPTY != pair2; pair2 = pair2.tail()) {
            Node node = (Node)this.dispatch((Node)pair2.head());
            pair2.setHead(node);
        }
        return pair;
    }

    static final class CacheKey {
        public Visitor visitor;
        public Object node;

        public CacheKey(Visitor visitor, Object object) {
            this.visitor = visitor;
            this.node = object;
        }

        public int hashCode() {
            return 37 * this.visitor.hashCode() + this.node.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (!this.visitor.equals(cacheKey.visitor)) {
                return false;
            }
            return this.node.equals(cacheKey.node);
        }
    }
}

