/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Token;
import xtc.tree.Visitor;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transducer
extends Visitor {
    protected final Printer printer;
    protected final Map<String, String> variables;
    protected int varcount;

    public Transducer(Printer printer) {
        this(printer, new HashMap<String, String>());
    }

    public Transducer(Printer printer, Map<String, String> map) {
        this.printer = printer;
        this.variables = map;
    }

    public boolean isPatternVariable(Node node) {
        return null == (node = node.strip()) ? false : node.isGeneric() && this.variables.containsKey(node.getName());
    }

    public GNode toPatternVariable(Node node) {
        if (null == (node = node.strip()) || !node.isGeneric() || !this.variables.containsKey(node.getName())) {
            throw new IllegalArgumentException("Not a pattern variable: " + node);
        }
        if (1 != node.size() || !Token.test(node.get(0))) {
            throw new IllegalArgumentException("Malformed pattern variable: " + node);
        }
        return (GNode)node;
    }

    public String getVariableName(Node node) {
        return Token.cast(this.toPatternVariable(node).get(0));
    }

    public String getVariableType(Node node) {
        return this.variables.get(this.toPatternVariable(node).getName());
    }

    public boolean isListType(String string) {
        return string.equals("List") || string.startsWith("List<");
    }

    public String toLiteral(Object object, String string) {
        if (null == object) {
            return "null";
        }
        if (Token.test(object)) {
            return '\"' + Utilities.escape(Token.cast(object), 8) + '\"';
        }
        if (object instanceof Node) {
            return null == string ? this.getVariableName((Node)object) : string;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "true" : "false";
        }
        if (object instanceof Double) {
            return (Double)object + "D";
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue() + "F";
        }
        if (object instanceof Long) {
            return (Long)object + "L";
        }
        if (object instanceof Integer) {
            return object.toString();
        }
        if (object instanceof Short) {
            return "Short.valueOf(" + (Short)object + ')';
        }
        if (object instanceof Byte) {
            return "Byte.valueOf(" + (Byte)object + ')';
        }
        if (object instanceof Character) {
            return "'" + ((Character)object).charValue() + "'";
        }
        throw new IllegalArgumentException("Unrecognized value: " + object);
    }

    public void process(String string, Node node) {
        if (null == string) {
            throw new NullPointerException("Null method name");
        }
        if (null == node) {
            throw new NullPointerException("Null node");
        }
        if (!GNode.test(node = node.strip())) {
            throw new IllegalArgumentException("Not an (annotated) generic node: " + node);
        }
        if (this.isPatternVariable(node)) {
            throw new IllegalArgumentException("Pattern variable: " + node);
        }
        this.varcount = 0;
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        new Visitor(){

            public void visit(GNode gNode) {
                block3: {
                    block1: {
                        int n;
                        String string;
                        block2: {
                            if (!Transducer.this.isPatternVariable(gNode)) break block1;
                            String string2 = Transducer.this.getVariableName(gNode);
                            string = Transducer.this.getVariableType(gNode);
                            n = arrayList.indexOf(string2);
                            if (-1 != n) break block2;
                            arrayList.add(string2);
                            arrayList2.add(string);
                            break block3;
                        }
                        if (((String)arrayList2.get(n)).equals(string)) break block3;
                        arrayList2.set(n, "Object");
                        break block3;
                    }
                    for (Object object : gNode) {
                        if (!(object instanceof Node)) continue;
                        this.dispatch((Node)object);
                    }
                }
            }
        }.dispatch(node);
        String string2 = Utilities.split(node.getName(), ' ');
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Create ").p(Utilities.toArticle(string2)).p(' ').p(string2).pln('.');
        this.printer.indent().pln(" *");
        for (String string3 : arrayList) {
            this.printer.indent().p(" * @param ").p(string3).p(" The ").p(string3).pln('.');
        }
        this.printer.indent().pln(" * @return The generic node.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public Node ").p(string).p('(');
        int n = this.printer.column();
        boolean bl = true;
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                this.printer.buffer();
            }
            this.printer.p((String)iterator2.next()).p(' ').p((String)iterator.next());
            if (iterator.hasNext()) {
                this.printer.p(", ");
            }
            if (bl) {
                bl = false;
                continue;
            }
            this.printer.fit(n);
        }
        this.printer.pln(") {").incr();
        String string4 = (String)this.dispatch(node);
        if (null == string4) {
            string4 = this.getVariableName(node);
        }
        this.printer.indent().p("return ").p(string4).pln(';');
        this.printer.decr().indent().pln('}');
    }

    public String visit(GNode gNode) {
        if (this.isPatternVariable(gNode)) {
            return null;
        }
        int n = gNode.size();
        ArrayList<String> arrayList = null;
        boolean bl = false;
        if (0 < n) {
            arrayList = new ArrayList<String>(n);
        }
        for (Object object : gNode) {
            if (object instanceof Node) {
                Node node = (Node)object;
                if (this.isPatternVariable(node)) {
                    arrayList.add(null);
                    if (!this.isListType(this.getVariableType(node))) continue;
                    bl = true;
                    continue;
                }
                arrayList.add((String)this.dispatch(node));
                continue;
            }
            arrayList.add(null);
        }
        String string = "v$" + ++this.varcount;
        this.printer.indent().p("Node ").p(string).p(" = GNode.create(\"").p(gNode.getName()).p("\"");
        if (0 == n) {
            this.printer.pln(", false);");
        } else if (bl) {
            Node node;
            Object object;
            int n2;
            this.printer.p(", ");
            int n3 = 0;
            boolean bl2 = false;
            for (n2 = 0; n2 < n; ++n2) {
                object = gNode.get(n2);
                if (object instanceof Node) {
                    node = (Node)object;
                    if (this.isPatternVariable(node) && this.isListType(this.getVariableType(node))) {
                        if (bl2) {
                            this.printer.p(" + ");
                        } else {
                            bl2 = true;
                        }
                        this.printer.p(this.getVariableName(node)).p(".size()");
                        continue;
                    }
                    ++n3;
                    continue;
                }
                ++n3;
            }
            if (0 < n3) {
                this.printer.p(" + ").p(n3);
            }
            this.printer.pln(").").indentMore();
            for (n2 = 0; n2 < n; ++n2) {
                object = gNode.get(n2);
                this.printer.buffer();
                if (object instanceof Node) {
                    node = (Node)object;
                    if (this.isPatternVariable(node) && this.isListType(this.getVariableType(node))) {
                        this.printer.p("addAll(");
                    } else {
                        this.printer.p("add(");
                    }
                } else {
                    this.printer.p("add(");
                }
                this.printer.p(this.toLiteral(object, (String)arrayList.get(n2))).p(')');
                if (n2 < n - 1) {
                    this.printer.p('.');
                } else {
                    this.printer.p(';');
                }
                this.printer.fitMore();
            }
            this.printer.pln();
        } else {
            this.printer.p(", ");
            if (8 < n) {
                this.printer.p(n).pln(").").indentMore();
            }
            for (int i = 0; i < n; ++i) {
                this.printer.buffer();
                if (8 < n) {
                    this.printer.p("add(");
                }
                this.printer.p(this.toLiteral(gNode.get(i), (String)arrayList.get(i)));
                if (8 < n) {
                    this.printer.p(')');
                }
                if (i < n - 1) {
                    if (8 < n) {
                        this.printer.p('.');
                    } else {
                        this.printer.p(", ");
                    }
                } else if (8 < n) {
                    this.printer.p(';');
                } else {
                    this.printer.p(");");
                }
                this.printer.fitMore();
            }
            this.printer.pln();
        }
        return string;
    }
}

