/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import xtc.tree.Annotation;
import xtc.tree.LineMarker;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Visitor;

public class Relocator
extends Visitor {
    protected String markedFile = null;
    protected int markedLine = -1;
    protected int baseLine = -1;

    protected void relocate(Node node) {
        if (null == this.markedFile || null == node.location) {
            return;
        }
        int n = node.location.line - this.baseLine - 1 + this.markedLine;
        if (n != node.location.line || !node.location.file.equals(this.markedFile)) {
            node.location = new Location(this.markedFile, n, node.location.column);
        }
    }

    public Node visit(Node node) {
        this.relocate(node);
        for (int i = 0; i < node.size(); ++i) {
            Object object = node.get(i);
            if (!(object instanceof Node)) continue;
            node.set(i, this.dispatch((Node)object));
        }
        return node;
    }

    public Annotation visit(Annotation annotation) {
        this.relocate(annotation);
        annotation.node = (Node)this.dispatch(annotation.node);
        return annotation;
    }

    public Node visit(LineMarker lineMarker) {
        if (null == lineMarker.location) {
            throw new IllegalArgumentException("Line marker without location");
        }
        this.markedFile = lineMarker.file;
        this.markedLine = lineMarker.line;
        this.baseLine = lineMarker.location.line;
        return (Node)this.dispatch(lineMarker.node);
    }
}

