/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import xtc.tree.Node;
import xtc.util.Pair;

public abstract class GNode
extends Node {
    public static final int MAX_FIXED = 8;
    final String name;

    GNode(String string) {
        this.name = string;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Object object = this.get(i);
            n = 37 * n + (null == object ? 0 : object.hashCode());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GNode)) {
            return false;
        }
        GNode gNode = (GNode)object;
        if (!this.name.equals(gNode.name)) {
            return false;
        }
        int n = this.size();
        if (gNode.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object2 = this.get(i);
            Object object3 = gNode.get(i);
            if (null != object2 ? object2.equals(object3) : null == object3) continue;
            return false;
        }
        return true;
    }

    public final boolean isGeneric() {
        return true;
    }

    public final boolean hasTraversal() {
        return true;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean hasName(String string) {
        return this.name.equals(string);
    }

    public static GNode create(String string) {
        return new Variable(string);
    }

    public static GNode create(String string, int n) {
        return new Variable(string, n);
    }

    public static GNode create(String string, boolean bl) {
        if (bl) {
            return new Variable(string);
        }
        return new Fixed0(string);
    }

    public static GNode create(String string, Object object) {
        return new Fixed1(string, object);
    }

    public static GNode create(String string, Object object, Object object2) {
        return new Fixed2(string, object, object2);
    }

    public static GNode create(String string, Object object, Object object2, Object object3) {
        return new Fixed3(string, object, object2, object3);
    }

    public static GNode create(String string, Object object, Object object2, Object object3, Object object4) {
        return new Fixed4(string, object, object2, object3, object4);
    }

    public static GNode create(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return new Fixed5(string, object, object2, object3, object4, object5);
    }

    public static GNode create(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new Fixed6(string, object, object2, object3, object4, object5, object6);
    }

    public static GNode create(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return new Fixed7(string, object, object2, object3, object4, object5, object6, object7);
    }

    public static GNode create(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return new Fixed8(string, object, object2, object3, object4, object5, object6, object7, object8);
    }

    public static GNode createFromPair(String string, Pair pair) {
        int n = pair.size();
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        switch (n) {
            case 8: {
                var3_3 = pair.head();
                pair = pair.tail();
            }
            case 7: {
                var4_4 = pair.head();
                pair = pair.tail();
            }
            case 6: {
                var5_5 = pair.head();
                pair = pair.tail();
            }
            case 5: {
                var6_6 = pair.head();
                pair = pair.tail();
            }
            case 4: {
                var7_7 = pair.head();
                pair = pair.tail();
            }
            case 3: {
                var8_8 = pair.head();
                pair = pair.tail();
            }
            case 2: {
                var9_9 = pair.head();
                pair = pair.tail();
            }
            case 1: {
                var10_10 = pair.head();
            }
            case 0: {
                break;
            }
            default: {
                Variable variable = new Variable(string, n);
                variable.addAll(pair);
                return variable;
            }
        }
        switch (n) {
            case 8: {
                return new Fixed8(string, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10);
            }
            case 7: {
                return new Fixed7(string, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10);
            }
            case 6: {
                return new Fixed6(string, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10);
            }
            case 5: {
                return new Fixed5(string, var6_6, var7_7, var8_8, var9_9, var10_10);
            }
            case 4: {
                return new Fixed4(string, var7_7, var8_8, var9_9, var10_10);
            }
            case 3: {
                return new Fixed3(string, var8_8, var9_9, var10_10);
            }
            case 2: {
                return new Fixed2(string, var9_9, var10_10);
            }
            case 1: {
                return new Fixed1(string, var10_10);
            }
            case 0: {
                return new Fixed0(string);
            }
        }
        throw new AssertionError((Object)"Internal error");
    }

    public static GNode createFromPair(String string, Object object, Pair pair) {
        int n = pair.size();
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        switch (n) {
            case 7: {
                var4_4 = pair.head();
                pair = pair.tail();
            }
            case 6: {
                var5_5 = pair.head();
                pair = pair.tail();
            }
            case 5: {
                var6_6 = pair.head();
                pair = pair.tail();
            }
            case 4: {
                var7_7 = pair.head();
                pair = pair.tail();
            }
            case 3: {
                var8_8 = pair.head();
                pair = pair.tail();
            }
            case 2: {
                var9_9 = pair.head();
                pair = pair.tail();
            }
            case 1: {
                var10_10 = pair.head();
                pair = pair.tail();
            }
            case 0: {
                break;
            }
            default: {
                Variable variable = new Variable(string, n + 1);
                variable.add(object);
                variable.addAll(pair);
                return variable;
            }
        }
        switch (n) {
            case 7: {
                return new Fixed8(string, object, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10);
            }
            case 6: {
                return new Fixed7(string, object, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10);
            }
            case 5: {
                return new Fixed6(string, object, var6_6, var7_7, var8_8, var9_9, var10_10);
            }
            case 4: {
                return new Fixed5(string, object, var7_7, var8_8, var9_9, var10_10);
            }
            case 3: {
                return new Fixed4(string, object, var8_8, var9_9, var10_10);
            }
            case 2: {
                return new Fixed3(string, object, var9_9, var10_10);
            }
            case 1: {
                return new Fixed2(string, object, var10_10);
            }
            case 0: {
                return new Fixed1(string, object);
            }
        }
        throw new AssertionError((Object)"Internal error");
    }

    public static GNode create(GNode gNode) {
        if (gNode instanceof Variable) {
            return new Variable((Variable)gNode);
        }
        switch (gNode.size()) {
            case 0: {
                return new Fixed0((Fixed0)gNode);
            }
            case 1: {
                return new Fixed1((Fixed1)gNode);
            }
            case 2: {
                return new Fixed2((Fixed2)gNode);
            }
            case 3: {
                return new Fixed3((Fixed3)gNode);
            }
            case 4: {
                return new Fixed4((Fixed4)gNode);
            }
            case 5: {
                return new Fixed5((Fixed5)gNode);
            }
            case 6: {
                return new Fixed6((Fixed6)gNode);
            }
            case 7: {
                return new Fixed7((Fixed7)gNode);
            }
            case 8: {
                return new Fixed8((Fixed8)gNode);
            }
        }
        throw new AssertionError((Object)"Internal error");
    }

    public static GNode ensureVariable(GNode gNode) {
        if (gNode instanceof Variable) {
            return gNode;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(gNode.size());
        gNode.addAllTo(arrayList);
        return new Variable(gNode.name, arrayList);
    }

    public static final boolean test(Object object) {
        return object instanceof Node && ((Node)object).strip().isGeneric();
    }

    public static final GNode cast(Object object) {
        Node node = (Node)object;
        return null == node ? null : (GNode)node.strip();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Variable
    extends GNode {
        private ArrayList<Object> children;

        Variable(String string) {
            super(string);
            this.children = new ArrayList();
        }

        Variable(String string, int n) {
            super(string);
            this.children = new ArrayList(n);
        }

        Variable(String string, ArrayList<Object> arrayList) {
            super(string);
            this.children = arrayList;
        }

        Variable(Variable variable) {
            super(variable.name);
            this.children = new ArrayList<Object>(variable.children);
        }

        @Override
        public boolean hasVariable() {
            return true;
        }

        @Override
        public Node add(Object object) {
            this.children.add(object);
            return this;
        }

        @Override
        public Node add(int n, Object object) {
            this.children.add(n, object);
            return this;
        }

        @Override
        public Node addAll(Pair<?> pair) {
            pair.addTo(this.children);
            return this;
        }

        @Override
        public Node addAll(int n, Pair<?> pair) {
            pair.addTo(this.children.subList(0, n));
            return this;
        }

        @Override
        public Node addAll(Collection<?> collection) {
            this.children.addAll(collection);
            return this;
        }

        @Override
        public Node addAll(int n, Collection<?> collection) {
            this.children.addAll(n, collection);
            return this;
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.addAll(this.children);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.children.iterator();
        }

        @Override
        public int size() {
            return this.children.size();
        }

        @Override
        public Object get(int n) {
            return this.children.get(n);
        }

        @Override
        public Object set(int n, Object object) {
            return this.children.set(n, object);
        }

        @Override
        public Object remove(int n) {
            return this.children.remove(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed8
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;
        Object c6;
        Object c7;
        Object c8;

        Fixed8(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
            super(string);
            this.c1 = object;
            this.c2 = object2;
            this.c3 = object3;
            this.c4 = object4;
            this.c5 = object5;
            this.c6 = object6;
            this.c7 = object7;
            this.c8 = object8;
        }

        Fixed8(Fixed8 fixed8) {
            this(fixed8.name, fixed8.c1, fixed8.c2, fixed8.c3, fixed8.c4, fixed8.c5, fixed8.c6, fixed8.c7, fixed8.c8);
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
                case 5: {
                    return this.c6;
                }
                case 6: {
                    return this.c7;
                }
                case 7: {
                    return this.c8;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 8");
        }

        @Override
        public Object set(int n, Object object) {
            switch (n) {
                case 0: {
                    Object object2 = this.c1;
                    this.c1 = object;
                    return object2;
                }
                case 1: {
                    Object object3 = this.c2;
                    this.c2 = object;
                    return object3;
                }
                case 2: {
                    Object object4 = this.c3;
                    this.c3 = object;
                    return object4;
                }
                case 3: {
                    Object object5 = this.c4;
                    this.c4 = object;
                    return object5;
                }
                case 4: {
                    Object object6 = this.c5;
                    this.c5 = object;
                    return object6;
                }
                case 5: {
                    Object object7 = this.c6;
                    this.c6 = object;
                    return object7;
                }
                case 6: {
                    Object object8 = this.c7;
                    this.c7 = object;
                    return object8;
                }
                case 7: {
                    Object object9 = this.c8;
                    this.c8 = object;
                    return object9;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 8");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
            collection.add(this.c2);
            collection.add(this.c3);
            collection.add(this.c4);
            collection.add(this.c5);
            collection.add(this.c6);
            collection.add(this.c7);
            collection.add(this.c8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed7
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;
        Object c6;
        Object c7;

        Fixed7(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
            super(string);
            this.c1 = object;
            this.c2 = object2;
            this.c3 = object3;
            this.c4 = object4;
            this.c5 = object5;
            this.c6 = object6;
            this.c7 = object7;
        }

        Fixed7(Fixed7 fixed7) {
            this(fixed7.name, fixed7.c1, fixed7.c2, fixed7.c3, fixed7.c4, fixed7.c5, fixed7.c6, fixed7.c7);
        }

        @Override
        public int size() {
            return 7;
        }

        @Override
        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
                case 5: {
                    return this.c6;
                }
                case 6: {
                    return this.c7;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 7");
        }

        @Override
        public Object set(int n, Object object) {
            switch (n) {
                case 0: {
                    Object object2 = this.c1;
                    this.c1 = object;
                    return object2;
                }
                case 1: {
                    Object object3 = this.c2;
                    this.c2 = object;
                    return object3;
                }
                case 2: {
                    Object object4 = this.c3;
                    this.c3 = object;
                    return object4;
                }
                case 3: {
                    Object object5 = this.c4;
                    this.c4 = object;
                    return object5;
                }
                case 4: {
                    Object object6 = this.c5;
                    this.c5 = object;
                    return object6;
                }
                case 5: {
                    Object object7 = this.c6;
                    this.c6 = object;
                    return object7;
                }
                case 6: {
                    Object object8 = this.c7;
                    this.c7 = object;
                    return object8;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 7");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
            collection.add(this.c2);
            collection.add(this.c3);
            collection.add(this.c4);
            collection.add(this.c5);
            collection.add(this.c6);
            collection.add(this.c7);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed6
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;
        Object c6;

        Fixed6(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
            super(string);
            this.c1 = object;
            this.c2 = object2;
            this.c3 = object3;
            this.c4 = object4;
            this.c5 = object5;
            this.c6 = object6;
        }

        Fixed6(Fixed6 fixed6) {
            this(fixed6.name, fixed6.c1, fixed6.c2, fixed6.c3, fixed6.c4, fixed6.c5, fixed6.c6);
        }

        @Override
        public int size() {
            return 6;
        }

        @Override
        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
                case 5: {
                    return this.c6;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 6");
        }

        @Override
        public Object set(int n, Object object) {
            switch (n) {
                case 0: {
                    Object object2 = this.c1;
                    this.c1 = object;
                    return object2;
                }
                case 1: {
                    Object object3 = this.c2;
                    this.c2 = object;
                    return object3;
                }
                case 2: {
                    Object object4 = this.c3;
                    this.c3 = object;
                    return object4;
                }
                case 3: {
                    Object object5 = this.c4;
                    this.c4 = object;
                    return object5;
                }
                case 4: {
                    Object object6 = this.c5;
                    this.c5 = object;
                    return object6;
                }
                case 5: {
                    Object object7 = this.c6;
                    this.c6 = object;
                    return object7;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 6");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
            collection.add(this.c2);
            collection.add(this.c3);
            collection.add(this.c4);
            collection.add(this.c5);
            collection.add(this.c6);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed5
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;
        Object c5;

        Fixed5(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
            super(string);
            this.c1 = object;
            this.c2 = object2;
            this.c3 = object3;
            this.c4 = object4;
            this.c5 = object5;
        }

        Fixed5(Fixed5 fixed5) {
            this(fixed5.name, fixed5.c1, fixed5.c2, fixed5.c3, fixed5.c4, fixed5.c5);
        }

        @Override
        public int size() {
            return 5;
        }

        @Override
        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
                case 4: {
                    return this.c5;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 5");
        }

        @Override
        public Object set(int n, Object object) {
            switch (n) {
                case 0: {
                    Object object2 = this.c1;
                    this.c1 = object;
                    return object2;
                }
                case 1: {
                    Object object3 = this.c2;
                    this.c2 = object;
                    return object3;
                }
                case 2: {
                    Object object4 = this.c3;
                    this.c3 = object;
                    return object4;
                }
                case 3: {
                    Object object5 = this.c4;
                    this.c4 = object;
                    return object5;
                }
                case 4: {
                    Object object6 = this.c5;
                    this.c5 = object;
                    return object6;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 5");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
            collection.add(this.c2);
            collection.add(this.c3);
            collection.add(this.c4);
            collection.add(this.c5);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed4
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;
        Object c4;

        Fixed4(String string, Object object, Object object2, Object object3, Object object4) {
            super(string);
            this.c1 = object;
            this.c2 = object2;
            this.c3 = object3;
            this.c4 = object4;
        }

        Fixed4(Fixed4 fixed4) {
            this(fixed4.name, fixed4.c1, fixed4.c2, fixed4.c3, fixed4.c4);
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
                case 3: {
                    return this.c4;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 4");
        }

        @Override
        public Object set(int n, Object object) {
            switch (n) {
                case 0: {
                    Object object2 = this.c1;
                    this.c1 = object;
                    return object2;
                }
                case 1: {
                    Object object3 = this.c2;
                    this.c2 = object;
                    return object3;
                }
                case 2: {
                    Object object4 = this.c3;
                    this.c3 = object;
                    return object4;
                }
                case 3: {
                    Object object5 = this.c4;
                    this.c4 = object;
                    return object5;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 4");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
            collection.add(this.c2);
            collection.add(this.c3);
            collection.add(this.c4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed3
    extends Fixed {
        Object c1;
        Object c2;
        Object c3;

        Fixed3(String string, Object object, Object object2, Object object3) {
            super(string);
            this.c1 = object;
            this.c2 = object2;
            this.c3 = object3;
        }

        Fixed3(Fixed3 fixed3) {
            this(fixed3.name, fixed3.c1, fixed3.c2, fixed3.c3);
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
                case 2: {
                    return this.c3;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 3");
        }

        @Override
        public Object set(int n, Object object) {
            switch (n) {
                case 0: {
                    Object object2 = this.c1;
                    this.c1 = object;
                    return object2;
                }
                case 1: {
                    Object object3 = this.c2;
                    this.c2 = object;
                    return object3;
                }
                case 2: {
                    Object object4 = this.c3;
                    this.c3 = object;
                    return object4;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 3");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
            collection.add(this.c2);
            collection.add(this.c3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed2
    extends Fixed {
        Object c1;
        Object c2;

        Fixed2(String string, Object object, Object object2) {
            super(string);
            this.c1 = object;
            this.c2 = object2;
        }

        Fixed2(Fixed2 fixed2) {
            this(fixed2.name, fixed2.c1, fixed2.c2);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.c1;
                }
                case 1: {
                    return this.c2;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 2");
        }

        @Override
        public Object set(int n, Object object) {
            switch (n) {
                case 0: {
                    Object object2 = this.c1;
                    this.c1 = object;
                    return object2;
                }
                case 1: {
                    Object object3 = this.c2;
                    this.c2 = object;
                    return object3;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 2");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
            collection.add(this.c2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed1
    extends Fixed {
        Object c1;

        Fixed1(String string, Object object) {
            super(string);
            this.c1 = object;
        }

        Fixed1(Fixed1 fixed1) {
            this(fixed1.name, fixed1.c1);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Object get(int n) {
            if (0 == n) {
                return this.c1;
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 1");
        }

        @Override
        public Object set(int n, Object object) {
            if (0 == n) {
                Object object2 = this.c1;
                this.c1 = object;
                return object2;
            }
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 1");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
            collection.add(this.c1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Fixed0
    extends Fixed {
        Fixed0(String string) {
            super(string);
        }

        Fixed0(Fixed0 fixed0) {
            super(fixed0.name);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 0");
        }

        @Override
        public Object set(int n, Object object) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: 0");
        }

        @Override
        public void addAllTo(Collection<Object> collection) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Fixed
    extends GNode {
        Fixed(String string) {
            super(string);
        }

        @Override
        public Node add(Object object) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node add(int n, Object object) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(Pair<?> pair) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(int n, Pair<?> pair) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(Collection<?> collection) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Node addAll(int n, Collection<?> collection) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }

        @Override
        public Object remove(int n) {
            throw new UnsupportedOperationException("Generic node with a fixed number of children");
        }
    }
}

