/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.List;
import xtc.tree.Annotation;
import xtc.tree.Node;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comment
extends Annotation {
    public Kind kind;
    public List<String> text;

    public Comment(Kind kind, List<String> list) {
        this(kind, list, null);
    }

    public Comment(Kind kind, List<String> list, Node node) {
        super(node);
        this.kind = kind;
        this.text = list;
    }

    public int hashCode() {
        return ((Object)this.text).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Comment)) {
            return false;
        }
        Comment comment = (Comment)object;
        if (this.kind != comment.kind) {
            return false;
        }
        if (!((Object)this.text).equals(comment.text)) {
            return false;
        }
        if (null == this.node) {
            return null == comment.node;
        }
        return this.node.equals(comment.node);
    }

    public static Comment documentation(String string) {
        int n;
        if (null == string) {
            return null;
        }
        if (4 > string.length()) {
            throw new IllegalArgumentException("Invalid documentation comment");
        }
        String[] stringArray = Utilities.COMMENT_NEWLINE.split(string = string.substring(3, string.length() - 2));
        if (0 < stringArray.length) {
            stringArray[0] = stringArray[0].trim();
            if (1 != stringArray.length) {
                stringArray[stringArray.length - 1] = stringArray[stringArray.length - 1].trim();
            }
        }
        int n2 = stringArray.length;
        int n3 = stringArray.length - 1;
        for (n = 0; n < stringArray.length; ++n) {
            if ("".equals(stringArray[n])) continue;
            n2 = n;
            break;
        }
        for (n = stringArray.length - 1; n >= 0; --n) {
            if ("".equals(stringArray[n])) continue;
            n3 = n;
            break;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n3 - n2 + 1);
        for (int i = n2; i <= n3; ++i) {
            arrayList.add(stringArray[i]);
        }
        return new Comment(Kind.DOCUMENTATION, arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        SINGLE_LINE,
        MULTIPLE_LINES,
        DOCUMENTATION;

    }
}

