/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.ErrorT;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.VariantT;
import xtc.type.Wildcard;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class VariantSorter
extends Visitor {
    private static final int DEBUG = 0;
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected final Typer gtyper;
    protected Map<Node, Node> malformed;
    protected boolean isPushMode;
    protected List<Production> productions;
    protected boolean hasChanged;
    protected List<Type> types;
    protected FullProduction production;
    protected boolean isGeneric;
    protected List<Element> elements;

    public VariantSorter(Runtime runtime, Analyzer analyzer, AST aST) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
        this.gtyper = new Typer();
        this.malformed = new IdentityHashMap<Node, Node>();
        this.productions = new ArrayList<Production>();
        this.types = new ArrayList<Type>();
        this.elements = new ArrayList<Element>();
    }

    protected Type merge(VariantT variantT, VariantT variantT2, Production production) {
        assert (variantT.isPolymorphic());
        if (this.ast.unify(variantT, variantT2, true).isError()) {
            this.runtime.error("production's alternatives have distinct variants", production);
            this.runtime.errConsole().loc(production).pln(": error: but include same generic node");
            this.runtime.errConsole().loc(production).p(": error: 1st type is '");
            this.ast.print(variantT, this.runtime.errConsole(), false, true, null);
            this.runtime.errConsole().pln("'");
            this.runtime.errConsole().loc(production).p(": error: 2nd type is '");
            this.ast.print(variantT2, this.runtime.errConsole(), false, true, null);
            this.runtime.errConsole().pln("'").flush();
            return ErrorT.TYPE;
        }
        VariantT variantT3 = variantT;
        if (variantT2.isPolymorphic()) {
            for (TupleT tupleT : variantT2.getTuples()) {
                this.ast.add(tupleT, variantT);
            }
        } else {
            this.ast.add(this.ast.toTuple(variantT2), variantT);
        }
        return variantT3;
    }

    protected void setType(Production production, Type type2) {
        production.type = type2.isError() ? type2 : (AST.isGenericNode(production.type) ? type2.annotate().attribute(Constants.ATT_GENERIC) : type2);
    }

    protected void pushPull(Module module) {
        boolean bl = true;
        do {
            this.isPushMode = true;
            this.hasChanged = bl;
            if (bl) {
                bl = false;
            }
            while (!this.productions.isEmpty()) {
                Iterator<Production> iterator = this.productions.remove(0);
                this.types.clear();
                this.types.add(((Production)((Object)iterator)).type.resolve());
                this.analyzer.process((Production)((Object)iterator));
            }
            if (!this.hasChanged) continue;
            for (Production production : module.productions) {
                Type type2;
                if (!AST.isDynamicNode(production.type) || !AST.isGenericNode(production.type)) continue;
                if (Analyzer.setsValue(production.choice, false) || (type2 = this.gtyper.type(production, false)).isError()) continue;
                this.setType(production, type2);
            }
            this.isPushMode = false;
            this.hasChanged = false;
            for (Production production : module.productions) {
                if (!AST.isDynamicNode(production.type)) continue;
                this.analyzer.process(production);
            }
        } while (!this.productions.isEmpty());
    }

    public void visit(Module module) {
        new Registrar().dispatch(module);
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.malformed.clear();
        this.productions.clear();
        this.elements.clear();
        if (!module.hasProperty("root")) {
            this.runtime.error("grammar without distinct root", module);
            return;
        }
        Iterator<Production> iterator = this.analyzer.lookup((NonTerminal)module.getProperty("root"));
        if (!AST.isNode(((Production)((Object)iterator)).type)) {
            this.runtime.error("grammar's root production does not return a node", (Node)((Object)iterator));
            return;
        }
        ((Production)((Object)iterator)).attributes.remove(Constants.ATT_VARIANT);
        this.setType((Production)((Object)iterator), this.ast.toVariant(((Production)((Object)iterator)).qName.name, false));
        this.productions.add((Production)((Object)iterator));
        for (Production production : module.productions) {
            if (!production.hasAttribute(Constants.ATT_VARIANT)) continue;
            this.setType(production, this.ast.toVariant(production.qName.name, false));
            this.productions.add(production);
        }
        this.pushPull(module);
        for (Production production : module.productions) {
            Type type2;
            if (!AST.isDynamicNode(production.type) || !AST.isGenericNode(production.type) || (type2 = this.gtyper.type(production, true)).isError()) continue;
            this.setType(production, type2);
            this.productions.add(production);
        }
        this.pushPull(module);
        for (Production production : module.productions) {
            if (!AST.isDynamicNode(production.type)) continue;
            this.analyzer.notWorkingOnAny();
            if (!this.analyzer.consumesInput(production.qName)) {
                production.type = AST.NULL_NODE;
                continue;
            }
            this.runtime.error("unable to determine static type", production);
        }
    }

    public void visit(FullProduction fullProduction) {
        this.production = fullProduction;
        this.isGeneric = AST.isGenericNode(fullProduction.type);
        if (this.isPushMode) {
            if (AST.isDynamicNode(fullProduction.type)) {
                this.hasChanged = true;
                this.setType(fullProduction, this.types.get(0));
            }
        } else {
            this.types.clear();
        }
        this.analyzer.workingOn(fullProduction.qName);
        if (this.isGeneric && DirectLeftRecurser.isTransformable(fullProduction)) {
            for (Sequence sequence : fullProduction.choice.alternatives) {
                Binding binding;
                if (DirectLeftRecurser.isRecursive(sequence, fullProduction) || null == (binding = this.analyzer.bind(sequence.elements))) continue;
                binding.name = "yyValue";
            }
        }
        this.dispatch(fullProduction.choice);
        if (!this.isPushMode) {
            Object object = Wildcard.TYPE;
            boolean bl = false;
            boolean bl2 = false;
            block6: for (Type type2 : this.types) {
                switch (type2.tag()) {
                    case ERROR: {
                        object = ErrorT.TYPE;
                        break block6;
                    }
                    case WILDCARD: {
                        bl = true;
                        if (!bl2) continue block6;
                        this.runtime.error("production requires polymorphic variant", fullProduction);
                        this.runtime.errConsole().loc(fullProduction).pln(": error: but has alternatives without static type").flush();
                        object = ErrorT.TYPE;
                        break block6;
                    }
                    case VARIANT: {
                        if (bl2) {
                            if (!((Type)(object = this.merge(((Type)object).toVariant(), type2.toVariant(), fullProduction))).isError()) continue block6;
                            break block6;
                        }
                        if (((Type)object).isWildcard()) {
                            object = type2;
                            break;
                        }
                        if (object.equals(type2)) continue block6;
                        if (this.isGeneric) {
                            this.runtime.error("variant '" + ((Type)object).toVariant().getName() + "' " + "overlaps with '" + type2.toVariant().getName() + "'", fullProduction);
                            object = ErrorT.TYPE;
                            break block6;
                        }
                        if (bl) {
                            this.runtime.error("production requires polymorphic variant", fullProduction);
                            this.runtime.errConsole().loc(fullProduction).pln(": error: but has alternatives without static type").flush();
                            object = ErrorT.TYPE;
                            break block6;
                        }
                        VariantT variantT = ((Type)object).toVariant();
                        object = this.merge(this.ast.toVariant(fullProduction.qName.name, true), variantT, fullProduction);
                        if (((Type)object).isError() || ((Type)(object = this.merge(((Type)object).toVariant(), type2.toVariant(), fullProduction))).isError()) break block6;
                        bl2 = true;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unrecognized type " + type2));
                    }
                }
            }
            if (!((Type)object).isWildcard()) {
                this.setType(fullProduction, (Type)object);
                Type type3 = ((Type)object).resolve();
                if (type3.isVariant() && !type3.toVariant().isPolymorphic()) {
                    this.productions.add(fullProduction);
                }
            }
        }
    }

    public void visit(OrderedChoice orderedChoice) {
        for (Sequence sequence : orderedChoice.alternatives) {
            this.dispatch(sequence);
        }
    }

    public void visit(Sequence sequence) {
        Element element;
        int n = this.elements.size();
        Object object = sequence.elements.iterator();
        while (object.hasNext()) {
            element = object.next();
            if (!object.hasNext() && element instanceof OrderedChoice) {
                this.dispatch(element);
                continue;
            }
            this.elements.add(element);
        }
        if (!sequence.hasTrailingChoice()) {
            if (this.isGeneric) {
                Node node;
                object = null;
                element = null;
                block5: for (Element element2 : this.elements) {
                    switch (element2.tag()) {
                        case BINDING: {
                            node = (Binding)element2;
                            if (!"yyValue".equals(node.name)) continue block5;
                            object = node.element;
                            break;
                        }
                        case NODE_MARKER: {
                            element = (NodeMarker)element2;
                        }
                    }
                }
                if (null != object) {
                    this.recurse((Element)object);
                } else if (this.isPushMode) {
                    Object object2 = this.production.qName.name;
                    if (null != element) {
                        object2 = Utilities.qualify(Utilities.getQualifier((String)object2), ((NodeMarker)element).name);
                    }
                    boolean bl = this.ast.hasTuple((String)object2);
                    node = this.ast.toTuple((String)object2);
                    List<VariantT> list = this.ast.toVariants((TupleT)node);
                    if (!bl || list.isEmpty()) {
                        this.ast.add((TupleT)node, this.types.get(0).toVariant());
                    } else if (!list.contains(this.types.get(0))) {
                        this.runtime.error("tuple '" + (String)object2 + "' should appear in variant '" + this.types.get(0).toVariant().getName() + "'", this.production);
                        this.runtime.errConsole().loc(this.production).p(": error: but already ").p("appears in variant '").p(list.get(0).getName()).pln("'").flush();
                        list.add(this.types.get(0).toVariant());
                    }
                }
            } else {
                object = this.analyzer.getValue(this.elements, true);
                if (null != object) {
                    this.recurse((Element)object);
                }
            }
        }
        if (0 == n) {
            this.elements.clear();
        } else {
            this.elements.subList(n, this.elements.size()).clear();
        }
    }

    protected void recurse(Element element) {
        Iterable<Object> iterable;
        element = Analyzer.strip(element);
        do {
            iterable = element;
            if (element instanceof Binding) {
                element = Analyzer.strip(((Binding)element).element);
            }
            if (!(element instanceof Option)) continue;
            element = Analyzer.strip(((Option)element).element);
        } while (iterable != element);
        iterable = this.types;
        FullProduction fullProduction = this.production;
        boolean bl = this.isGeneric;
        List<Element> list = this.elements;
        switch (element.tag()) {
            case NONTERMINAL: {
                FullProduction fullProduction2 = this.analyzer.lookup((NonTerminal)element);
                if (this.analyzer.isBeingWorkedOn(fullProduction2.qName)) {
                    if (!this.isPushMode) {
                        this.types.add(Wildcard.TYPE);
                    }
                    return;
                }
                if (fullProduction2.type.isError()) {
                    if (!this.isPushMode) {
                        this.types.add(ErrorT.TYPE);
                    }
                    return;
                }
                if (AST.isStaticNode(fullProduction2.type)) {
                    if (this.isPushMode && !this.types.get(0).equals(fullProduction2.type.resolve())) {
                        if (!this.malformed.containsKey(fullProduction2)) {
                            this.runtime.error("variant '" + this.types.get(0).toVariant().getName() + "' overlaps with '" + fullProduction2.type.resolve().toVariant().getName() + "'", fullProduction2);
                            this.malformed.put(fullProduction2, fullProduction2);
                        }
                        return;
                    }
                    if (!this.isPushMode) {
                        this.types.add(fullProduction2.type.resolve());
                    }
                    return;
                }
                assert (!AST.isVoid(fullProduction2.type));
                if (AST.isString(fullProduction2.type)) {
                    if (!this.malformed.containsKey(fullProduction2)) {
                        this.runtime.error("variant type for production with string value", fullProduction2);
                        this.malformed.put(fullProduction2, fullProduction2);
                    }
                    if (!this.isPushMode) {
                        this.types.add(ErrorT.TYPE);
                    }
                    return;
                }
                if (AST.isToken(fullProduction2.type)) {
                    if (!this.malformed.containsKey(fullProduction2)) {
                        this.runtime.error("variant type for production with token value", fullProduction2);
                        this.malformed.put(fullProduction2, fullProduction2);
                    }
                    if (!this.isPushMode) {
                        this.types.add(ErrorT.TYPE);
                    }
                    return;
                }
                if (!this.isPushMode) {
                    this.types = new ArrayList<Type>();
                }
                this.elements = new ArrayList<Element>();
                this.dispatch(fullProduction2);
                if (this.isPushMode || AST.isDynamicNode(fullProduction2.type)) break;
                iterable.add(fullProduction2.type.resolve());
                break;
            }
            case SEQUENCE: 
            case CHOICE: {
                this.isGeneric = false;
                this.elements = new ArrayList<Element>();
                this.dispatch(element);
                break;
            }
            case NULL: {
                if (!this.isPushMode) {
                    this.types.add(Wildcard.TYPE);
                }
                return;
            }
            default: {
                if (!this.malformed.containsKey(element)) {
                    this.runtime.error("variant type for invalid element", element);
                    this.malformed.put(element, element);
                }
                if (!this.isPushMode) {
                    this.types.add(ErrorT.TYPE);
                }
                return;
            }
        }
        this.types = iterable;
        this.production = fullProduction;
        this.isGeneric = bl;
        this.elements = list;
    }

    public class Typer
    extends Visitor {
        protected boolean create;
        protected FullProduction production;
        protected List<Element> elements = new ArrayList<Element>();
        protected Set<String> names = new HashSet<String>();
        protected Type type;

        public Type type(Production production, boolean bl) {
            assert (AST.isDynamicNode(production.type));
            assert (AST.isGenericNode(production.type));
            this.create = bl;
            return (Type)this.dispatch(production);
        }

        public Type visit(FullProduction fullProduction) {
            Object object;
            this.production = fullProduction;
            this.elements.clear();
            this.names.clear();
            this.dispatch(fullProduction.choice);
            if (this.names.isEmpty()) {
                return ErrorT.TYPE;
            }
            VariantT variantT = null;
            boolean bl = false;
            Object object2 = this.names.iterator();
            while (object2.hasNext()) {
                List<VariantT> list;
                object = object2.next();
                if (VariantSorter.this.ast.hasTuple((String)object) && 1 == (list = VariantSorter.this.ast.toVariants(VariantSorter.this.ast.toTuple((String)object))).size()) {
                    if (null == variantT) {
                        variantT = list.get(0);
                        bl = true;
                        continue;
                    }
                    if (variantT == list.get(0)) continue;
                }
                bl = false;
                break;
            }
            if (bl) {
                return variantT;
            }
            if (1 == this.names.size() && null != (object = VariantSorter.this.analyzer.lookup(new NonTerminal((String)(object2 = this.names.iterator().next())))) && AST.isGenericNode(((FullProduction)object).type) && AST.isStaticNode(((FullProduction)object).type)) {
                return ((FullProduction)object).type;
            }
            return this.create ? VariantSorter.this.ast.toVariant(fullProduction.qName.name, false) : ErrorT.TYPE;
        }

        public void visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                this.dispatch(sequence);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void visit(Sequence sequence) {
            Element element;
            int n = this.elements.size();
            Iterator<Element> iterator = sequence.elements.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (!iterator.hasNext() && element instanceof OrderedChoice) {
                    this.dispatch(element);
                    continue;
                }
                this.elements.add(element);
            }
            if (!sequence.hasTrailingChoice()) {
                boolean bl = false;
                element = null;
                block5: for (Element element2 : this.elements) {
                    switch (element2.tag()) {
                        case BINDING: {
                            Binding binding = (Binding)element2;
                            if (!"yyValue".equals(binding.name)) break;
                            bl = true;
                            break block5;
                        }
                        case NODE_MARKER: {
                            element = (NodeMarker)element2;
                        }
                    }
                }
                if (!bl) {
                    Object object = this.production.qName.name;
                    if (null != element) {
                        object = Utilities.qualify(Utilities.getQualifier((String)object), ((NodeMarker)element).name);
                    }
                    if (!this.names.contains(object)) {
                        this.names.add((String)object);
                    }
                }
            }
            if (0 == n) {
                this.elements.clear();
                return;
            }
            this.elements.subList(n, this.elements.size()).clear();
        }
    }

    public class Registrar
    extends Visitor {
        protected List<Element> elements = new ArrayList<Element>();

        public void visit(Module module) {
            VariantSorter.this.analyzer.register(this);
            VariantSorter.this.analyzer.init(module);
            this.elements.clear();
            for (Production production : module.productions) {
                if (!AST.isGenericNode(production.type)) continue;
                VariantSorter.this.analyzer.process(production);
            }
        }

        public void visit(FullProduction fullProduction) {
            this.dispatch(fullProduction.choice);
        }

        public void visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                this.dispatch(sequence);
            }
        }

        public void visit(Sequence sequence) {
            Object object;
            int n = this.elements.size();
            Object object2 = sequence.elements.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!object2.hasNext() && object instanceof OrderedChoice) {
                    this.dispatch((Node)object);
                    continue;
                }
                this.elements.add((Element)object);
            }
            if (!sequence.hasTrailingChoice()) {
                object2 = null;
                for (Element element : this.elements) {
                    if (!(element instanceof NodeMarker)) continue;
                    object2 = (NodeMarker)element;
                }
                object = VariantSorter.this.analyzer.current().qName.name;
                if (null != object2) {
                    object = Utilities.qualify(Utilities.getQualifier((String)object), ((NodeMarker)object2).name);
                }
                VariantSorter.this.ast.toTuple((String)object);
            }
            if (0 == n) {
                this.elements.clear();
            } else {
                this.elements.subList(n, this.elements.size()).clear();
            }
        }
    }
}

