/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.DeadProductionEliminator;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.Simplifier;
import xtc.parser.UnaryOperator;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class TreeExtractor
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected final boolean keepLexical;
    protected boolean isGeneric;
    protected boolean isList;
    protected boolean isTextOnly;
    protected boolean isToken;
    protected boolean setsValue;

    public TreeExtractor(Runtime runtime, Analyzer analyzer, AST aST, boolean bl) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
        this.keepLexical = bl;
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            this.analyzer.process(production);
        }
        new Simplifier(this.runtime, this.analyzer).dispatch(module);
        new DeadProductionEliminator(this.runtime, this.analyzer).dispatch(module);
        module.header = null;
        module.body = null;
        module.footer = null;
        module.attributes = null;
        for (Production production : module.productions) {
            production.attributes = null;
            production.type = null;
        }
    }

    public void visit(FullProduction fullProduction) {
        this.isGeneric = Generifier.isGeneric(fullProduction);
        this.isList = AST.isList(fullProduction.type);
        this.isTextOnly = fullProduction.getBooleanProperty("textOnly");
        this.isToken = fullProduction.getBooleanProperty("token");
        this.setsValue = false;
        if (this.isGeneric && DirectLeftRecurser.isTransformable(fullProduction)) {
            for (Sequence sequence : fullProduction.choice.alternatives) {
                Binding binding;
                if (DirectLeftRecurser.isRecursive(sequence, fullProduction) || null == (binding = this.analyzer.bind(sequence.elements))) continue;
                binding.name = "yyValue";
            }
        }
        if ((this.isTextOnly || this.isToken) && !this.keepLexical) {
            fullProduction.choice = new OrderedChoice(new Sequence());
            fullProduction.setProperty("redacted", Boolean.TRUE);
        } else {
            this.dispatch(fullProduction.choice);
        }
        String string = this.ast.extern(fullProduction.type);
        fullProduction.dType = this.isGeneric ? "define<Node>" : (this.isTextOnly ? "define<String>" : (this.isToken ? "define<Token>" : (this.isList ? "define<" + (String)string + '>' : (this.setsValue ? "define<" + (String)string + '>' : "expand<" + (String)string + '>'))));
    }

    public void visit(OrderedChoice orderedChoice) {
        for (Sequence sequence : orderedChoice.alternatives) {
            this.dispatch(sequence);
        }
    }

    public void visit(Sequence sequence) {
        sequence.name = null;
        for (int i = 0; i < sequence.size(); ++i) {
            Node node;
            Element element = sequence.get(i);
            if (sequence.size() - 1 == i && element instanceof OrderedChoice) {
                this.dispatch(element);
                continue;
            }
            if (element instanceof VoidedElement || element instanceof SemanticPredicate || element instanceof ValueElement) {
                sequence.elements.remove(i);
                --i;
                continue;
            }
            if (element instanceof Action) {
                node = (Action)element;
                if (node.setsValue()) {
                    this.setsValue = true;
                    node.code.clear();
                    node.indent.clear();
                    node.code.add("yyValue = ...");
                    node.indent.add(0);
                    continue;
                }
                sequence.elements.remove(i);
                --i;
                continue;
            }
            if (element instanceof Binding) {
                node = (Binding)element;
                if (!this.isGeneric || this.isGeneric && !"yyValue".equals(((Binding)node).name)) {
                    element = ((Binding)node).element;
                    sequence.elements.set(i, element);
                }
            } else if (!(this.isGeneric || this.isList || this.isTextOnly || this.isToken)) {
                sequence.elements.remove(i);
                --i;
                continue;
            }
            if (element instanceof NonTerminal) {
                node = this.analyzer.lookup((NonTerminal)element);
                if (AST.isVoid(((FullProduction)node).type)) {
                    sequence.elements.remove(i);
                    --i;
                    continue;
                }
            }
            this.dispatch(element);
        }
    }

    public void visit(CharCase charCase) {
        this.dispatch(charCase.element);
    }

    public void visit(CharSwitch charSwitch) {
        for (CharCase charCase : charSwitch.cases) {
            this.dispatch(charCase);
        }
        this.dispatch(charSwitch.base);
    }

    public void visit(UnaryOperator unaryOperator) {
        this.dispatch(unaryOperator.element);
        unaryOperator.element = Analyzer.strip(unaryOperator.element);
    }

    public void visit(Element element) {
    }
}

