/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Production;
import xtc.util.Runtime;

public class RootFinder
extends GrammarVisitor {
    protected Set<NonTerminal> topLevel = new HashSet<NonTerminal>();

    public RootFinder(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    public Object visit(Module module) {
        if (module.hasProperty("root")) {
            return null;
        }
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.topLevel.clear();
        for (Production node : module.productions) {
            if (!node.hasAttribute(Constants.ATT_PUBLIC)) continue;
            this.topLevel.add(node.qName);
        }
        if (1 == this.topLevel.size()) {
            module.setProperty("root", this.topLevel.toArray()[0]);
            return null;
        }
        for (NonTerminal nonTerminal : this.topLevel) {
            this.analyzer.unmarkAll();
            this.analyzer.mark(this.topLevel);
            this.analyzer.notWorkingOnAny();
            this.dispatch(nonTerminal);
            if (this.analyzer.hasMarked()) continue;
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Recognizing " + nonTerminal + " as real root]");
            }
            module.setProperty("root", nonTerminal);
            break;
        }
        return null;
    }

    public Element visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (!this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
            this.analyzer.workingOn(fullProduction.qName);
            this.analyzer.unmark(fullProduction.qName);
            this.dispatch(fullProduction);
        }
        return nonTerminal;
    }
}

