/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.SemanticPredicate;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.type.AST;
import xtc.util.Runtime;

public class ProductionVoider
extends GrammarVisitor {
    public ProductionVoider(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    public Object visit(Module module) {
        boolean bl;
        do {
            bl = false;
            Tester tester = new Tester(this.runtime, this.analyzer);
            tester.dispatch(module);
            Set<NonTerminal> set = tester.voidable();
            this.analyzer.register(this);
            this.analyzer.init(module);
            for (Production production : module.productions) {
                if (!set.contains(production.qName)) continue;
                if (this.runtime.test("optionVerbose")) {
                    System.err.println("[Voiding " + production.qName + "]");
                }
                this.analyzer.process(production);
                bl = true;
                production.type = AST.VOID;
                production.setProperty("voided", Boolean.TRUE);
            }
        } while (bl);
        return null;
    }

    public Element visit(VoidedElement voidedElement) {
        voidedElement.element = (Element)this.dispatch(voidedElement.element);
        return voidedElement.element;
    }

    public Element visit(Binding binding) {
        binding.element = (Element)this.dispatch(binding.element);
        if (Analyzer.isSynthetic(binding.name)) {
            return binding.element;
        }
        return binding;
    }

    public Element visit(ValueElement valueElement) {
        return NullValue.VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tester
    extends GrammarVisitor {
        protected boolean secondPhase;
        protected boolean voidable;

        public Tester(Runtime runtime, Analyzer analyzer) {
            super(runtime, analyzer);
        }

        public Set<NonTerminal> voidable() {
            return new HashSet<NonTerminal>(this.analyzer.marked());
        }

        @Override
        public Object visit(Module module) {
            this.analyzer.register(this);
            this.analyzer.init(module);
            this.secondPhase = false;
            for (Production production : module.productions) {
                if (production.hasAttribute(Constants.ATT_PUBLIC) || AST.isVoid(production.type)) continue;
                this.voidable = true;
                this.analyzer.process(production);
                if (!this.voidable) continue;
                this.analyzer.mark(production.qName);
            }
            this.secondPhase = true;
            for (Production production : module.productions) {
                this.analyzer.process(production);
            }
            return null;
        }

        @Override
        public Element visit(Binding binding) {
            if ("yyValue".equals(binding.name)) {
                this.voidable = false;
            }
            this.isBound = true;
            binding.element = (Element)this.dispatch(binding.element);
            return binding;
        }

        public Element visit(NonTerminal nonTerminal) {
            if (this.secondPhase && this.isBound) {
                FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
                if (this.analyzer.current() != fullProduction) {
                    this.analyzer.unmark(fullProduction.qName);
                }
            }
            this.isBound = false;
            return nonTerminal;
        }

        @Override
        public Element visit(SemanticPredicate semanticPredicate) {
            this.isBound = false;
            return semanticPredicate;
        }

        public Element visit(Action action) {
            this.isBound = false;
            this.voidable = !action.setsValue();
            return action;
        }

        @Override
        public Element visit(ParserAction parserAction) {
            this.isBound = false;
            this.voidable = false;
            return parserAction;
        }
    }
}

