/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleInstantiation;
import xtc.parser.ModuleList;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullLiteral;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.ProperListValue;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrinter
extends Visitor {
    protected Printer printer;
    protected final AST ast;
    protected final boolean verbose;
    protected boolean newline;
    protected boolean parenChoice;
    protected boolean parenSequence;
    protected boolean isTopLevel;

    protected PrettyPrinter(AST aST, boolean bl) {
        this.ast = aST;
        this.verbose = bl;
    }

    public PrettyPrinter(Printer printer, AST aST, boolean bl) {
        this.printer = printer;
        this.ast = aST;
        this.verbose = bl;
        printer.register(this);
    }

    protected int stringEscapes() {
        return 8;
    }

    protected int regexEscapes() {
        return 12;
    }

    protected boolean isPrefix(Element element) {
        switch (element.tag()) {
            case VOIDED: 
            case BINDING: 
            case PARSER_ACTION: 
            case FOLLOWED_BY: 
            case NOT_FOLLOWED_BY: 
            case SEMANTIC_PREDICATE: 
            case STRING_MATCH: {
                return true;
            }
        }
        return false;
    }

    public void flush() {
        this.printer.flush();
    }

    public void visit(Attribute attribute) {
        if ("visibility".equals(attribute.getName())) {
            this.printer.p((String)attribute.getValue());
        } else {
            this.printer.p(attribute.getName());
            Object object = attribute.getValue();
            if (null != object) {
                this.printer.p('(').p(object.toString()).p(')');
            }
        }
    }

    public void visit(Grammar grammar) {
        for (Module module : grammar.modules) {
            this.dispatch(module);
        }
    }

    protected void printDocumentation(Module module) {
        if (!this.verbose || null == module.documentation) {
            return;
        }
        Comment comment = module.documentation;
        int n = comment.text.size();
        if (0 != n) {
            if (1 == n) {
                this.printer.indent().p("/** ").p(comment.text.get(0)).pln(" */");
            } else {
                this.printer.indent().pln("/**");
                for (int i = 0; i < n; ++i) {
                    this.printer.indent().p(" * ").pln(comment.text.get(i));
                }
                this.printer.indent().pln(" */");
            }
        }
    }

    protected void printModule(Module module) {
        this.printer.indent().p("module ").p(module.name);
        if (null != module.parameters && 0 < module.parameters.size()) {
            this.printer.p(module.parameters);
        }
        if (this.verbose && (module.name.hasProperty("xtc.Constants.Original") || module.hasProperty("xtc.Constants.Arguments"))) {
            ModuleName moduleName = module.name.hasProperty("xtc.Constants.Original") ? (ModuleName)module.name.getProperty("xtc.Constants.Original") : module.name;
            ModuleList moduleList = (ModuleList)module.getProperty("xtc.Constants.Arguments");
            this.printer.p(" /* = ").p(moduleName);
            if (null == moduleList) {
                this.printer.p("()");
            } else {
                this.printer.p(moduleList);
            }
            this.printer.p(" */ ");
        }
        this.printer.pln(';');
    }

    protected void printActions(Module module) {
        if (null != module.header) {
            this.printer.pln().indent().p("header ").p(module.header);
            if (1 == module.header.code.size()) {
                this.printer.pln();
            }
        }
        if (null != module.body) {
            this.printer.pln().indent().p("body ").p(module.body);
            if (1 == module.body.code.size()) {
                this.printer.pln();
            }
        }
        if (null != module.footer) {
            this.printer.pln().indent().p("footer ").p(module.footer);
            if (1 == module.footer.code.size()) {
                this.printer.pln();
            }
        }
    }

    protected void printOption(Module module) {
        if (null != module.attributes && 0 < module.attributes.size()) {
            this.printer.pln().indent().p("option ");
            Iterator<Attribute> iterator = module.attributes.iterator();
            while (iterator.hasNext()) {
                this.printer.buffer().p(((Object)iterator.next()).toString());
                if (iterator.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p(';');
                }
                this.printer.fitMore();
            }
            this.printer.pln();
        }
    }

    public void visit(Module module) {
        this.printer.sep();
        this.printer.indent().p("// Generated by Rats!, version ").p("1.14.1").p(", ").p("(C) 2004-2008 Robert Grimm").pln('.');
        this.printer.sep();
        this.printer.pln();
        this.printDocumentation(module);
        this.printModule(module);
        if (null != module.dependencies && 0 < module.dependencies.size()) {
            this.printer.pln();
            for (ModuleDependency node : module.dependencies) {
                this.printer.p(node);
            }
        }
        this.printActions(module);
        this.printOption(module);
        this.printer.pln();
        for (Production production : module.productions) {
            this.printer.p(production);
        }
        this.printer.sep().pln();
    }

    protected void print(ModuleDependency moduleDependency, String string) {
        this.printer.indent().p(string).p(' ').p(moduleDependency.module);
        if (0 != moduleDependency.arguments.size()) {
            this.printer.p(moduleDependency.arguments);
        }
        if (null != moduleDependency.target) {
            this.printer.buffer().p(" as ").p(moduleDependency.target).fitMore();
        }
        this.printer.pln(';');
    }

    public void visit(ModuleImport moduleImport) {
        this.print(moduleImport, "import");
    }

    public void visit(ModuleInstantiation moduleInstantiation) {
        this.print(moduleInstantiation, "instantiate");
    }

    public void visit(ModuleModification moduleModification) {
        this.print(moduleModification, "modify");
    }

    public void visit(ModuleList moduleList) {
        this.printer.p('(');
        Iterator<ModuleName> iterator = moduleList.names.iterator();
        while (iterator.hasNext()) {
            this.printer.buffer().p(iterator.next());
            if (iterator.hasNext()) {
                this.printer.p(", ");
            }
            this.printer.fitMore();
        }
        this.printer.p(')');
    }

    public void visit(ModuleName moduleName) {
        this.printer.p(moduleName.name);
    }

    protected void enter(Production production) {
        if (this.verbose && production.hasProperty("duplicates")) {
            List<String> list = Properties.getDuplicates(production);
            this.printer.indent().pln("/*");
            this.printer.indent().p(" * The following production is the result of ").p("folding duplicates ");
            Iterator object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                this.printer.buffer();
                if (1 < list.size() && !object.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p(string);
                if (2 == list.size() && object.hasNext()) {
                    this.printer.p(' ');
                } else if (object.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit(" * ");
            }
            this.printer.pln();
            this.printer.indent().pln(" */");
        }
        this.printer.indent();
        if (null != production.attributes && 0 < production.attributes.size()) {
            for (Attribute attribute : production.attributes) {
                this.printer.p((Node)attribute).p(' ');
            }
        }
        if (null != production.type) {
            if (AST.isVoid(production.type)) {
                this.printer.p("void ");
            } else if (AST.isGenericNode(production.type)) {
                this.printer.p("generic ");
            } else {
                this.printer.p(this.ast.extern(production.type)).p(' ');
            }
        } else if (null != production.dType) {
            this.printer.p(production.dType).p(' ');
        }
        this.printer.p(production.name.name);
        this.parenChoice = false;
        this.parenSequence = false;
    }

    protected void exit(Production production) {
        this.printer.pln();
    }

    public void visit(AlternativeAddition alternativeAddition) {
        this.enter(alternativeAddition);
        this.printer.p(" += ");
        if (!alternativeAddition.isBefore) {
            this.printer.pln().indentMore().p(alternativeAddition.sequence).pln(" ...");
            this.printer.indentMore().p("/ ");
        }
        this.isTopLevel = true;
        this.printer.p(alternativeAddition.choice);
        if (alternativeAddition.isBefore) {
            this.printer.indentMore().p("/ ").p(alternativeAddition.sequence).pln(" ...");
        }
        this.printer.indentMore().pln(';');
        this.exit(alternativeAddition);
    }

    public void visit(AlternativeRemoval alternativeRemoval) {
        this.enter(alternativeRemoval);
        this.printer.pln(" -=").incr().indent();
        Iterator<SequenceName> iterator = alternativeRemoval.sequences.iterator();
        while (iterator.hasNext()) {
            this.printer.buffer().p(iterator.next());
            if (iterator.hasNext()) {
                this.printer.p(", ");
            }
            this.printer.fit();
        }
        this.printer.pln().indent().pln(';').decr();
        this.exit(alternativeRemoval);
    }

    public void visit(ProductionOverride productionOverride) {
        this.enter(productionOverride);
        this.printer.p(" := ");
        if (null == productionOverride.choice) {
            this.printer.pln("... ;");
        } else if (productionOverride.isComplete) {
            this.isTopLevel = true;
            this.printer.p(productionOverride.choice).indentMore().pln(';');
        } else {
            this.printer.pln().indentMore().pln("...").indentMore().p("/ ");
            this.isTopLevel = true;
            this.printer.p(productionOverride.choice).indentMore().pln(';');
        }
        this.exit(productionOverride);
    }

    public void visit(FullProduction fullProduction) {
        this.enter(fullProduction);
        this.printer.p(" = ");
        if (1 == fullProduction.choice.alternatives.size() && 0 == fullProduction.choice.alternatives.get(0).size()) {
            if (fullProduction.getBooleanProperty("redacted")) {
                this.printer.p("... ");
            } else if (this.verbose) {
                this.printer.p("/* Empty */ ");
            }
            this.printer.pln(';');
        } else {
            this.isTopLevel = true;
            this.printer.p(fullProduction.choice).indentMore().pln(';');
        }
        this.exit(fullProduction);
    }

    protected void print(List<Sequence> list, String string) {
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        if (bl) {
            this.printer.p("( ");
        }
        if (this.isTopLevel) {
            this.isTopLevel = false;
        } else if (this.verbose) {
            this.printer.p("/* ").p(string).p(" */ ");
        }
        this.printer.pln().incr();
        boolean bl3 = true;
        for (Sequence sequence : list) {
            if (bl3) {
                bl3 = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            this.printer.p(sequence);
            if (this.newline) continue;
            this.printer.pln();
        }
        this.printer.decr();
        if (bl) {
            this.printer.indent().p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
        this.newline = false;
    }

    public void visit(OrderedChoice orderedChoice) {
        this.print(orderedChoice.alternatives, "Choice");
    }

    public void visit(Repetition repetition) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer();
        if (this.isPrefix(repetition.element)) {
            this.printer.p('(');
        }
        this.printer.p(repetition.element);
        if (this.isPrefix(repetition.element)) {
            this.printer.p(')');
        }
        if (repetition.once) {
            this.printer.p('+');
        } else {
            this.printer.p('*');
        }
        this.printer.fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(Option option) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer();
        if (this.isPrefix(option.element)) {
            this.printer.p('(');
        }
        this.printer.p(option.element);
        if (this.isPrefix(option.element)) {
            this.printer.p(')');
        }
        this.printer.p('?').fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(SequenceName sequenceName) {
        this.printer.p('<').p(sequenceName.name).p('>');
    }

    public void visit(Sequence sequence) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        boolean bl3 = true;
        for (Element element : sequence.elements) {
            if (bl3) {
                bl3 = false;
                if (bl2) {
                    this.printer.p('(');
                }
                if (null != sequence.name) {
                    this.printer.p(sequence.name).p(' ');
                }
            } else {
                this.printer.p(' ');
            }
            this.printer.p(element);
        }
        if (bl2) {
            this.printer.p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(FollowedBy followedBy) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('&').p(followedBy.element).fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('!').p(notFollowedBy.element).fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        this.newline = false;
        this.parenChoice = true;
        this.parenSequence = true;
        this.printer.buffer().p('&').p(semanticPredicate.element).fit();
        this.parenChoice = bl;
        this.parenSequence = bl2;
    }

    public void visit(VoidedElement voidedElement) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("void:").p(voidedElement.element).fit();
    }

    public void visit(Binding binding) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p(binding.name).p(':').p(binding.element).fit();
    }

    public void visit(StringMatch stringMatch) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\"').escape(stringMatch.text, this.stringEscapes()).p("\":").p(stringMatch.element).fit();
    }

    public void visit(NonTerminal nonTerminal) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p(nonTerminal.name).fit();
    }

    public void visit(StringLiteral stringLiteral) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\"').escape(stringLiteral.text, this.stringEscapes()).p('\"').fit();
    }

    public void visit(AnyChar anyChar) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('_').fit();
    }

    public void visit(CharLiteral charLiteral) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('\'').escape(charLiteral.c, this.stringEscapes()).p('\'').fit();
    }

    public void visit(CharRange charRange) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        if (charRange.first == charRange.last) {
            this.printer.escape(charRange.first, this.regexEscapes());
        } else {
            this.printer.escape(charRange.first, this.regexEscapes()).p('-').escape(charRange.last, this.regexEscapes());
        }
    }

    public void visit(CharClass charClass) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer();
        if (charClass.exclusive) {
            if (this.verbose) {
                this.printer.p("/* Exclusive */ ");
            }
            this.printer.p('!');
        }
        this.printer.p('[');
        for (CharRange charRange : charClass.ranges) {
            this.printer.p(charRange);
        }
        this.printer.p(']');
        if (charClass.exclusive) {
            this.printer.p(" .");
        }
        this.printer.fit();
    }

    public void visit(CharCase charCase) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.p(charCase.klass).p(' ').p(charCase.element);
    }

    public void visit(CharSwitch charSwitch) {
        boolean bl = this.parenChoice;
        boolean bl2 = this.parenSequence;
        if (bl) {
            this.printer.p("( ");
        }
        if (this.verbose) {
            this.printer.pln("/* Switch */").incr();
        } else {
            this.printer.pln().incr();
        }
        boolean bl3 = true;
        boolean bl4 = false;
        CharClass charClass = null;
        for (CharCase charCase : charSwitch.cases) {
            if (null == charCase.element) {
                if (null == charClass) {
                    charClass = new CharClass(new ArrayList<CharRange>());
                }
                charClass.ranges.addAll(charCase.klass.ranges);
                continue;
            }
            if (bl3) {
                bl3 = false;
                this.printer.indent();
            } else {
                this.printer.indent().p("/ ");
            }
            this.parenChoice = true;
            this.parenSequence = false;
            this.newline = false;
            this.printer.p(charCase);
            if (!this.newline) {
                this.printer.pln();
            }
            bl4 = true;
        }
        if (null != charClass || null != charSwitch.base) {
            this.printer.indent();
            if (bl4) {
                this.printer.p("/ ");
            }
            if (null != charClass) {
                this.newline = false;
                this.printer.p('!').p(charClass).p(' ');
            }
            if (null != charSwitch.base) {
                this.parenChoice = true;
                this.parenSequence = false;
                this.newline = false;
                this.printer.p("_ ").p(charSwitch.base);
            }
            if (!this.newline) {
                this.printer.pln();
            }
        }
        this.printer.decr();
        if (bl) {
            this.printer.indent().p(')');
        }
        this.parenChoice = bl;
        this.parenSequence = bl2;
        this.newline = false;
    }

    protected void print(String string) {
        this.printer.p(string);
    }

    protected void print(Action action, boolean bl) {
        if (this.newline) {
            this.printer.indent();
        }
        if (action.code.isEmpty()) {
            this.newline = false;
        } else if (1 == action.code.size()) {
            this.newline = false;
            this.printer.buffer();
            if (bl) {
                this.printer.p('^');
            }
            this.printer.p("{ ");
            this.print(action.code.get(0));
            this.printer.p(" }").fit();
        } else {
            this.newline = true;
            if (bl) {
                this.printer.p('^');
            }
            int n = this.printer.level();
            this.printer.pln('{').incr();
            int n2 = 0;
            Iterator<String> iterator = action.code.iterator();
            Iterator<Integer> iterator2 = action.indent.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4 = iterator2.next();
                int n5 = n4 - n2;
                n2 = n4;
                if (0 < n5) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        this.printer.incr();
                    }
                } else {
                    for (n3 = 0; n3 > n5; --n3) {
                        this.printer.decr();
                    }
                }
                this.printer.indent();
                this.print(iterator.next());
                this.printer.pln();
            }
            this.printer.setLevel(n).indent().pln('}');
        }
    }

    public void visit(NodeMarker nodeMarker) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p('@').p(nodeMarker.name).fit();
    }

    public void visit(Action action) {
        this.print(action, false);
    }

    public void visit(ParserAction parserAction) {
        this.print((Action)parserAction.element, true);
    }

    public void visit(ParseTreeNode parseTreeNode) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("Formatting([");
        Iterator<Binding> iterator = parseTreeNode.predecessors.iterator();
        while (iterator.hasNext()) {
            this.printer.p(iterator.next().name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("], ");
        if (null == parseTreeNode.node) {
            this.printer.p("null");
        } else {
            this.printer.p(parseTreeNode.node.name);
        }
        this.printer.p(", [");
        iterator = parseTreeNode.successors.iterator();
        while (iterator.hasNext()) {
            this.printer.p(iterator.next().name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])").fit();
    }

    public void visit(NullLiteral nullLiteral) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("null").fit();
    }

    public void visit(NullValue nullValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = null; */").fit();
    }

    protected void format(boolean bl, String string) {
        if (this.newline) {
            this.printer.indent();
        }
        boolean bl2 = -1 != string.indexOf("*/");
        this.printer.buffer();
        if (bl2) {
            this.printer.p("//");
            this.newline = true;
        } else {
            this.printer.p("/*");
            this.newline = false;
        }
        this.printer.p(" value = ");
        if (bl) {
            this.printer.p("Token(");
        }
        this.printer.p('\"').escape(string, this.stringEscapes()).p('\"');
        if (bl) {
            this.printer.p(')');
        }
        this.printer.p(';');
        if (!bl2) {
            this.printer.p(" */");
        }
        this.printer.fit();
        if (bl2) {
            this.printer.pln();
        }
    }

    public void visit(StringValue stringValue) {
        if (null == stringValue.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = <text>; */").fit();
        } else {
            this.format(false, stringValue.text);
        }
    }

    public void visit(TokenValue tokenValue) {
        if (null == tokenValue.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = Token(<text>); */").fit();
        } else {
            this.format(true, tokenValue.text);
        }
    }

    public void visit(BindingValue bindingValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = ").p(bindingValue.binding.name).p("; */").fit();
    }

    public void visit(EmptyListValue emptyListValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = []; */").fit();
    }

    public void visit(ProperListValue properListValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = ");
        if (null == properListValue.tail) {
            this.printer.p('[');
            boolean bl = true;
            for (Binding binding : properListValue.elements) {
                if (bl) {
                    bl = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(binding.name);
            }
            this.printer.p(']');
        } else {
            for (Binding binding : properListValue.elements) {
                this.printer.p(binding.name).p(':');
            }
            this.printer.p(properListValue.tail.name);
        }
        this.printer.p("; */").fit();
    }

    public void visit(ActionBaseValue actionBaseValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action.run(").p(actionBaseValue.list.name).p(", ").p(actionBaseValue.seed.name).p("); */").fit();
    }

    public void visit(GenericNodeValue genericNodeValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = ");
        if (0 < genericNodeValue.formatting.size()) {
            this.printer.p("Formatting([], ");
        }
        this.printer.p("GNode(").p(Utilities.unqualify(genericNodeValue.name)).p(", [");
        Iterator iterator = genericNodeValue.children.iterator();
        while (iterator.hasNext()) {
            this.printer.p(((Binding)iterator.next()).name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])");
        if (0 < genericNodeValue.formatting.size()) {
            this.printer.p(", [");
            boolean bl = true;
            for (Binding binding : genericNodeValue.formatting) {
                if (bl) {
                    bl = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(binding.name);
            }
            this.printer.p("])");
        }
        this.printer.p("; */").fit();
    }

    public void visit(GenericActionValue genericActionValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action->");
        if (0 < genericActionValue.formatting.size()) {
            this.printer.p("Formatting([], ");
        }
        this.printer.p("GNode(").p(Utilities.unqualify(genericActionValue.name)).p(", [");
        Iterator iterator = genericActionValue.children.iterator();
        this.printer.p(genericActionValue.first);
        if (iterator.hasNext()) {
            this.printer.p(", ");
        }
        while (iterator.hasNext()) {
            this.printer.p(((Binding)iterator.next()).name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])");
        if (0 < genericActionValue.formatting.size()) {
            this.printer.p(", [");
            boolean bl = true;
            for (Binding binding : genericActionValue.formatting) {
                if (bl) {
                    bl = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(binding.name);
            }
            this.printer.p("])");
        }
        this.printer.p("; */").fit();
    }

    public void visit(GenericRecursionValue genericRecursionValue) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer().p("/* value = Action->");
        if (0 < genericRecursionValue.formatting.size()) {
            this.printer.p("Formatting([], ");
        }
        this.printer.p("GNode(").p(Utilities.unqualify(genericRecursionValue.name)).p(", [");
        Iterator iterator = genericRecursionValue.children.iterator();
        this.printer.p(genericRecursionValue.first);
        if (iterator.hasNext()) {
            this.printer.p(", ");
        }
        while (iterator.hasNext()) {
            this.printer.p(((Binding)iterator.next()).name);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p("])");
        if (0 < genericRecursionValue.formatting.size()) {
            this.printer.p(", [");
            boolean bl = true;
            for (Binding binding : genericRecursionValue.formatting) {
                if (bl) {
                    bl = false;
                } else {
                    this.printer.p(", ");
                }
                this.printer.p(binding.name);
            }
            this.printer.p("])");
        }
        this.printer.p(':').p(genericRecursionValue.list.name).p("; */").fit();
    }
}

