/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.io.Reader;
import xtc.parser.Column;
import xtc.parser.ParseError;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.util.Action;
import xtc.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParserBase {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final int FIRST_LINE = 1;
    public static final int FIRST_COLUMN = 1;
    public static final int INIT_SIZE = 4096;
    public static final int INCR_SIZE = 4096;
    protected Reader yyReader;
    protected int yyCount;
    protected boolean yyEOF;
    protected char[] yyData;
    protected Column[] yyColumns;

    public ParserBase(Reader reader, String string) {
        this(reader, string, 4095);
    }

    public ParserBase(Reader reader, String string, int n) {
        if (null == string) {
            throw new NullPointerException("Null file");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative size: " + n);
        }
        this.yyReader = reader;
        this.yyCount = 0;
        this.yyEOF = false;
        this.yyData = new char[n + 1];
        this.yyColumns = new Column[n + 1];
        Column column = this.newColumn();
        column.file = string;
        column.seenCR = false;
        column.line = 1;
        column.column = 1;
        this.yyColumns[0] = column;
    }

    public final void resetTo(int n) {
        int n2;
        if (0 > n) {
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        if (0 == n) {
            return;
        }
        if (n >= this.yyCount) {
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        Column column = this.column(n);
        Column column2 = this.newColumn();
        column2.file = column.file;
        column2.seenCR = column.seenCR;
        column2.line = column.line;
        column2.column = column.column;
        this.yyColumns[0] = column2;
        int n3 = this.yyCount - n;
        System.arraycopy(this.yyData, n, this.yyData, 0, n3);
        for (n2 = n3; n2 < this.yyCount; ++n2) {
            this.yyData[n2] = '\u0000';
        }
        for (n2 = 1; n2 < this.yyCount; ++n2) {
            this.yyColumns[n2] = null;
        }
        this.yyCount = n3;
    }

    private void growBy(int n) {
        char[] cArray = this.yyData;
        this.yyData = new char[cArray.length + n];
        System.arraycopy(cArray, 0, this.yyData, 0, cArray.length);
        Column[] columnArray = this.yyColumns;
        this.yyColumns = new Column[columnArray.length + n];
        System.arraycopy(columnArray, 0, this.yyColumns, 0, columnArray.length);
    }

    protected abstract Column newColumn();

    protected final Column column(int n) {
        Column column;
        if (this.yyColumns.length == n) {
            this.growBy(4096);
        }
        if (null != (column = this.yyColumns[n])) {
            return column;
        }
        Column column2 = null;
        for (int i = n; i >= 0 && null == (column2 = this.yyColumns[i]); --i) {
        }
        int n2 = column2.line;
        int n3 = column2.column;
        boolean bl = column2.seenCR;
        block6: for (int i = i; i < n; ++i) {
            switch (this.yyData[i]) {
                case '\t': {
                    n3 = (n3 >> 3) + 1 << 3;
                    bl = false;
                    continue block6;
                }
                case '\n': {
                    if (!bl) {
                        ++n2;
                        n3 = 1;
                    }
                    bl = false;
                    continue block6;
                }
                case '\r': {
                    ++n2;
                    n3 = 1;
                    bl = true;
                    continue block6;
                }
                default: {
                    ++n3;
                    bl = false;
                }
            }
        }
        column = this.newColumn();
        column.file = column2.file;
        column.seenCR = bl;
        column.line = n2;
        column.column = n3;
        this.yyColumns[n] = column;
        return column;
    }

    protected final int character(int n) throws IOException {
        int n2;
        if (this.yyEOF) {
            if (n < this.yyCount - 1) {
                return this.yyData[n];
            }
            if (n < this.yyCount) {
                return -1;
            }
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        if (n < this.yyCount) {
            return this.yyData[n];
        }
        if (n != this.yyCount) {
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        int n3 = this.yyReader.read();
        int n4 = n2 = -1 == n3 ? 1 : 4096;
        if (this.yyData.length <= this.yyCount) {
            this.growBy(n2);
        }
        if (-1 == n3) {
            this.yyEOF = true;
        } else {
            this.yyData[n] = (char)n3;
        }
        ++this.yyCount;
        return n3;
    }

    protected final String difference(int n, int n2) {
        return n == n2 ? "" : new String(this.yyData, n, n2 - n);
    }

    public final boolean isEOF(int n) {
        return this.yyEOF && n == this.yyCount - 1;
    }

    public final String lineAt(int n) throws IOException {
        if (0 > n) {
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        if (0 < n && 10 == this.character(n) && 13 == this.character(n - 1)) {
            --n;
        }
        int n2 = n;
        int n3 = n;
        int n4 = this.character(n3);
        while (-1 != n4 && 13 != n4 && 10 != n4) {
            n4 = this.character(++n3);
        }
        while (0 != n2 && 13 != (n4 = this.character(n2 - 1)) && 10 != n4) {
            --n2;
        }
        return this.difference(n2, n3);
    }

    public final Location location(int n) {
        Column column = this.column(n);
        return new Location(column.file, column.line, column.column);
    }

    protected final void setLocation(int n, String string, int n2, int n3) {
        if (null == string) {
            throw new NullPointerException("Null file");
        }
        if (0 > n2) {
            throw new IllegalArgumentException("Invalid line number: " + n2);
        }
        if (1 > n3) {
            throw new IllegalArgumentException("Invalid column number: " + n3);
        }
        if (n < 0 || this.yyCount <= n) {
            throw new IndexOutOfBoundsException("Parser index: " + n);
        }
        Column column = this.yyColumns[n];
        if (null != column) {
            if (string.equals(column.file) && n2 == column.line && n3 == column.column) {
                return;
            }
            if (0 != n) {
                throw new IllegalStateException("Location at index " + n + " is already committed");
            }
        }
        for (int i = n + 1; i < this.yyCount; ++i) {
            if (null == this.yyColumns[i]) continue;
            throw new IllegalStateException("Location at index " + n + " is already committed");
        }
        column = this.column(n);
        column.file = string;
        column.line = n2;
        column.column = n3;
    }

    public final void setLocation(Locatable locatable, int n) {
        if (null != locatable && !locatable.hasLocation()) {
            Column column = this.column(n);
            locatable.setLocation(new Location(column.file, column.line, column.column));
        }
    }

    protected final <T> T apply(Pair<Action<T>> pair, T t) {
        while (!pair.isEmpty()) {
            t = pair.head().run(t);
            pair = pair.tail();
        }
        return t;
    }

    protected final <T extends Locatable> T apply(Pair<Action<T>> pair, T object, int n) {
        if (!pair.isEmpty()) {
            Location location = this.location(n);
            do {
                object = (Locatable)pair.head().run(object);
                object.setLocation(location);
            } while (!(pair = pair.tail()).isEmpty());
        }
        return (T)object;
    }

    public final String format(ParseError parseError) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Column column = null;
        if (-1 != parseError.index) {
            column = this.column(parseError.index);
            stringBuilder.append(column.file);
            stringBuilder.append(':');
            stringBuilder.append(column.line);
            stringBuilder.append(':');
            stringBuilder.append(column.column);
            stringBuilder.append(": ");
        }
        stringBuilder.append("error: ");
        stringBuilder.append(parseError.msg);
        if (-1 != parseError.index) {
            int n;
            String string = this.lineAt(parseError.index);
            int n2 = string.length();
            stringBuilder.append(NEWLINE);
            for (n = 0; n < n2; ++n) {
                stringBuilder.append(string.charAt(n));
            }
            stringBuilder.append(NEWLINE);
            for (n = 1; n < column.column; ++n) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('^');
            stringBuilder.append(NEWLINE);
        }
        return stringBuilder.toString();
    }

    public final void signal(ParseError parseError) throws ParseException, IOException {
        throw new ParseException(this.format(parseError));
    }

    public final Object value(Result result2) throws ParseException, IOException {
        if (!result2.hasValue()) {
            this.signal(result2.parseError());
        }
        return result2.semanticValue();
    }

    protected final String peek(int n) {
        int n2;
        int n3 = n2 = this.yyEOF ? this.yyCount - 1 : this.yyCount;
        if (n >= n2) {
            return "";
        }
        n2 = Math.min(n + 20, n2);
        return new String(this.yyData, n, n2 - n);
    }

    protected static final <T> T cast(Object object) {
        return (T)object;
    }

    protected static final <T> Pair<T> cast(Pair<?> pair) {
        return pair;
    }
}

