/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericValue;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.TokenValue;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.Wildcard;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class MetaDataSetter
extends Visitor {
    public static final Pattern IMPORT = Pattern.compile("import\\s+(static\\s+)??(\\S+?)(\\.\\*)??;");
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean withLocation;
    protected boolean hasParseTree;
    protected boolean requiresLocatable;
    protected boolean requiresChar;
    protected boolean requiresIndex;
    protected boolean requiresResult;
    protected boolean requiresPredIndex;
    protected boolean requiresPredResult;
    protected boolean requiresPredMatch;
    protected boolean requiresBaseIndex;
    protected List<Boolean> repetitions;
    protected List<Type> boundRepetitions;
    protected List<Type> options;
    protected boolean createsNodeValue;
    protected boolean isTopLevel;
    protected boolean isRepeated;
    protected boolean isOptional;
    protected boolean isFirstElement;
    protected boolean isBound;
    protected boolean isPredicate;
    protected boolean isNotFollowedBy;
    protected boolean isLastInPredicate;
    protected int repetitionLevel;
    protected int optionLevel;

    public MetaDataSetter(Runtime runtime, Analyzer analyzer, AST aST) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
    }

    protected void importType(String string) {
        this.ast.importType(string, Utilities.getName(string));
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        String string = Utilities.getQualifier(module.getClassName());
        if (null != string) {
            this.ast.importModule(string + ".");
        }
        this.importType("java.io.Reader");
        if (module.hasAttribute("main")) {
            this.importType("java.io.BufferedReader");
            this.importType("java.io.BufferedWriter");
            this.importType("java.io.File");
            this.importType("java.io.FileReader");
            this.importType("java.io.OutputStreamWriter");
        }
        this.importType("java.io.IOException");
        if (module.hasAttribute(Constants.ATT_PROFILE)) {
            this.importType("java.util.HashMap");
        }
        if (module.hasAttribute("setOfString")) {
            this.importType("java.util.HashSet");
            this.importType("java.util.Set");
        }
        if (module.getBooleanProperty("recursive")) {
            this.importType("xtc.util.Action");
        }
        this.importType("xtc.util.Pair");
        if (module.hasAttribute(Constants.ATT_WITH_LOCATION)) {
            this.importType("xtc.tree.Locatable");
        }
        if (module.getBooleanProperty("generic") || module.hasAttribute("main")) {
            this.importType("xtc.tree.Node");
        }
        if (module.getBooleanProperty("generic")) {
            if (module.hasAttribute("factory")) {
                String string2 = (String)module.getAttributeValue("factory");
                if (Utilities.isQualified(string2)) {
                    this.importType(string2);
                }
            } else {
                this.importType("xtc.tree.GNode");
            }
        }
        if (module.hasAttribute(Constants.ATT_PARSE_TREE)) {
            this.importType("xtc.tree.Token");
            this.importType("xtc.tree.Formatting");
        }
        if (module.hasAttribute(Constants.ATT_VERBOSE) || module.hasAttribute("main") || module.hasAttribute(Constants.ATT_PROFILE) || module.hasAttribute(Constants.ATT_DUMP)) {
            this.importType("xtc.tree.Printer");
        }
        if (module.hasAttribute("printer")) {
            this.importType("xtc.tree.Visitor");
        }
        this.importType("xtc.parser.ParserBase");
        this.importType("xtc.parser.Column");
        this.importType("xtc.parser.Result");
        this.importType("xtc.parser.SemanticValue");
        this.importType("xtc.parser.ParseError");
        if (null != module.header) {
            for (String object : module.header.code) {
                Matcher matcher = IMPORT.matcher(object);
                if (!matcher.lookingAt()) continue;
                if (null == matcher.group(3)) {
                    String string2 = matcher.group(2);
                    try {
                        this.ast.importType(string2, Utilities.getName(string2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.runtime.error("inconsistent imports for '" + Utilities.getName(string2) + "'", module.header);
                    }
                    continue;
                }
                if (null == matcher.group(1)) {
                    this.ast.importModule(matcher.group(2) + ".");
                    continue;
                }
                this.ast.importModule(matcher.group(2) + "$");
            }
        }
        this.withLocation = module.hasAttribute(Constants.ATT_WITH_LOCATION);
        this.hasParseTree = module.hasAttribute(Constants.ATT_PARSE_TREE);
        this.requiresLocatable = false;
        for (Production production : module.productions) {
            this.analyzer.process(production);
        }
        if (this.requiresLocatable) {
            module.setProperty("locatable", Boolean.TRUE);
        }
    }

    public void visit(Production production) {
        Type type2;
        int n;
        MetaData metaData = (MetaData)production.getProperty("metaData");
        this.requiresChar = false;
        this.requiresIndex = false;
        this.requiresResult = false;
        this.requiresPredIndex = false;
        this.requiresPredResult = false;
        this.requiresPredMatch = false;
        this.requiresBaseIndex = false;
        this.repetitions = metaData.repetitions;
        this.boundRepetitions = metaData.boundRepetitions;
        this.options = metaData.options;
        this.createsNodeValue = false;
        this.isTopLevel = true;
        this.isRepeated = false;
        this.isOptional = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.isPredicate = false;
        this.isNotFollowedBy = false;
        this.isLastInPredicate = false;
        this.repetitionLevel = 0;
        this.optionLevel = 0;
        this.dispatch(production.choice);
        if (this.withLocation && this.createsNodeValue && Constants.FuzzyBoolean.MAYBE == this.ast.hasLocation(production.type)) {
            this.requiresLocatable = true;
        }
        metaData.requiresChar = this.requiresChar;
        metaData.requiresIndex = this.requiresIndex;
        metaData.requiresResult = this.requiresResult;
        metaData.requiresPredIndex = this.requiresPredIndex;
        metaData.requiresPredResult = this.requiresPredResult;
        metaData.requiresPredMatch = this.requiresPredMatch;
        metaData.requiresBaseIndex = this.requiresBaseIndex;
        int n2 = this.boundRepetitions.size();
        for (n = 0; n < n2; ++n) {
            type2 = this.boundRepetitions.get(n);
            if (null == type2) continue;
            this.boundRepetitions.set(n, AST.listOf(this.ast.concretize(type2, AST.ANY)));
        }
        n2 = this.options.size();
        for (n = 0; n < n2; ++n) {
            type2 = this.options.get(n);
            if (null == type2) continue;
            this.options.set(n, this.ast.concretize(type2, AST.ANY));
        }
    }

    public void visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        for (Sequence sequence : orderedChoice.alternatives) {
            if (bl) {
                this.isFirstElement = true;
            }
            this.dispatch(sequence);
        }
    }

    public void visit(Repetition repetition) {
        this.isTopLevel = false;
        boolean bl = this.isRepeated;
        this.isRepeated = true;
        boolean bl2 = this.isOptional;
        this.isOptional = false;
        this.isFirstElement = false;
        boolean bl3 = this.isBound;
        this.isBound = false;
        ++this.repetitionLevel;
        if (this.repetitions.size() < this.repetitionLevel) {
            this.repetitions.add(Boolean.FALSE);
            this.boundRepetitions.add(null);
        }
        if (repetition.once) {
            this.repetitions.set(this.repetitionLevel - 1, Boolean.TRUE);
        }
        if (bl3) {
            if (null == this.boundRepetitions.get(this.repetitionLevel - 1)) {
                this.boundRepetitions.set(this.repetitionLevel - 1, Wildcard.TYPE);
            }
            Binding binding = Analyzer.getBinding(((Sequence)repetition.element).elements);
            Type type2 = this.analyzer.type(binding.element);
            Type type3 = this.ast.unify(type2, this.boundRepetitions.get(this.repetitionLevel - 1), false);
            this.boundRepetitions.set(this.repetitionLevel - 1, type3);
        }
        this.dispatch(repetition.element);
        this.isRepeated = bl;
        this.isOptional = bl2;
        --this.repetitionLevel;
    }

    public void visit(Option option) {
        this.isTopLevel = false;
        boolean bl = this.isRepeated;
        this.isRepeated = false;
        boolean bl2 = this.isOptional;
        this.isOptional = false;
        this.isFirstElement = false;
        boolean bl3 = this.isBound;
        this.isBound = false;
        ++this.optionLevel;
        if (this.options.size() < this.optionLevel) {
            this.options.add(null);
        }
        if (bl3) {
            if (null == this.options.get(this.optionLevel - 1)) {
                this.options.set(this.optionLevel - 1, Wildcard.TYPE);
            }
            Binding binding = Analyzer.getBinding(((Sequence)option.element).elements);
            Type type2 = this.analyzer.type(binding.element);
            Type type3 = this.ast.unify(type2, this.options.get(this.optionLevel - 1), false);
            this.options.set(this.optionLevel - 1, type3);
        }
        this.dispatch(option.element);
        this.isRepeated = bl;
        this.isOptional = bl2;
        --this.optionLevel;
    }

    public void visit(Sequence sequence) {
        this.isTopLevel = false;
        boolean bl = this.isRepeated;
        this.isRepeated = false;
        boolean bl2 = this.isOptional;
        this.isOptional = false;
        this.isBound = false;
        int n = sequence.size();
        for (int i = 0; i < n; ++i) {
            this.isLastInPredicate = this.isPredicate && !bl && !bl2 && i == n - 1;
            this.dispatch(sequence.get(i));
        }
        this.isRepeated = bl;
        this.isOptional = bl2;
    }

    public void visit(FollowedBy followedBy) {
        this.isTopLevel = false;
        this.isBound = false;
        boolean bl = this.isFirstElement;
        this.isPredicate = true;
        this.isNotFollowedBy = false;
        this.dispatch(followedBy.element);
        this.isPredicate = false;
        this.isFirstElement = bl;
    }

    protected boolean isNotFollowedBy() {
        return this.isPredicate && this.isNotFollowedBy;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        this.isTopLevel = false;
        this.isBound = false;
        this.requiresPredMatch = true;
        boolean bl = this.isFirstElement;
        this.isPredicate = true;
        this.isNotFollowedBy = true;
        this.dispatch(notFollowedBy.element);
        this.isPredicate = false;
        this.isFirstElement = bl;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        this.isTopLevel = false;
        this.isBound = false;
        this.dispatch(semanticPredicate.element);
    }

    public void visit(VoidedElement voidedElement) {
        this.isTopLevel = false;
        this.isBound = false;
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        this.isTopLevel = false;
        this.isBound = true;
        this.dispatch(binding.element);
    }

    public void visit(StringMatch stringMatch) {
        this.isTopLevel = false;
        this.isBound = false;
        if (!(this.isNotFollowedBy() || this.runtime.test("optimizeErrors1") && this.isFirstElement)) {
            this.requiresBaseIndex = true;
        }
        this.isFirstElement = false;
        this.dispatch(stringMatch.element);
    }

    public void visit(NonTerminal nonTerminal) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        if (this.isPredicate) {
            this.requiresPredResult = true;
        } else {
            this.requiresResult = true;
        }
    }

    public void visit(AnyChar anyChar) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(StringLiteral stringLiteral) {
        this.isTopLevel = false;
        this.isBound = false;
        if (!(this.isNotFollowedBy() || this.runtime.test("optimizeErrors1") && this.isFirstElement)) {
            this.requiresBaseIndex = true;
        }
        this.isFirstElement = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate || 1 < stringLiteral.text.length()) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(CharCase charCase) {
        if (null != charCase.element) {
            this.dispatch(charCase.element);
        }
    }

    public void visit(CharSwitch charSwitch) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
        for (CharCase charCase : charSwitch.cases) {
            this.dispatch(charCase);
        }
        this.dispatch(charSwitch.base);
    }

    public void visit(Terminal terminal) {
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresChar = true;
        if (this.isPredicate) {
            if (!this.isLastInPredicate) {
                this.requiresPredIndex = true;
            }
        } else {
            this.requiresIndex = true;
        }
    }

    public void visit(Action action) {
        if (action.setsValue()) {
            this.createsNodeValue = true;
        }
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(ParserAction parserAction) {
        this.createsNodeValue = true;
        this.isTopLevel = false;
        this.isFirstElement = false;
        this.isBound = false;
        this.requiresBaseIndex = true;
    }

    protected boolean hasDirectLocation() {
        return this.withLocation && this.runtime.test("optimizeLocation") && AST.isNode(this.analyzer.current().type);
    }

    public void visit(TokenValue tokenValue) {
        if (!this.hasDirectLocation()) {
            this.createsNodeValue = true;
        }
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(ActionBaseValue actionBaseValue) {
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(GenericValue genericValue) {
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(GenericActionValue genericActionValue) {
        if (!this.hasDirectLocation()) {
            this.createsNodeValue = true;
        }
        this.isTopLevel = false;
        this.isBound = false;
    }

    public void visit(Element element) {
        this.isTopLevel = false;
        this.isBound = false;
    }
}

