/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Sequence;
import xtc.parser.ValueElement;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.Wildcard;
import xtc.util.Runtime;

public class ListMaker
extends Visitor {
    public static final String MARKER = "l";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected Type element;
    protected List<Element> elements;

    public ListMaker(Runtime runtime, Analyzer analyzer, AST aST) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
        this.elements = new ArrayList<Element>();
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.elements.clear();
        for (Production production : module.productions) {
            if (!AST.isList(production.type)) continue;
            this.element = this.runtime.test("optionVariant") && AST.isDynamicNode(AST.getArgument(production.type)) ? Wildcard.TYPE : null;
            this.analyzer.process(production);
            if (null == this.element || this.element.isError()) continue;
            production.type = AST.listOf(this.ast.concretize(this.element, AST.NULL_NODE));
        }
    }

    public void visit(FullProduction fullProduction) {
        this.dispatch(fullProduction.choice);
    }

    public void visit(OrderedChoice orderedChoice) {
        for (Sequence sequence : orderedChoice.alternatives) {
            this.dispatch(sequence);
        }
    }

    public void visit(Sequence sequence) {
        Element element;
        int n = this.elements.size();
        Object object = sequence.elements.iterator();
        while (object.hasNext()) {
            Element element2 = object.next();
            if (!object.hasNext() && element2 instanceof OrderedChoice) {
                this.dispatch(element2);
                continue;
            }
            this.elements.add(element2);
        }
        if (!sequence.hasTrailingChoice() && !Analyzer.setsValue(this.elements, false)) {
            Node node;
            object = new ArrayList();
            for (int i = 0; i < this.elements.size(); ++i) {
                element = this.elements.get(i);
                if (element instanceof Binding) {
                    object.add((Binding)element);
                    continue;
                }
                if (!this.analyzer.isBindable(element)) continue;
                node = new Binding(this.analyzer.variable(MARKER), element);
                this.elements.set(i, (Element)node);
                object.add(node);
            }
            if (null != this.element && !this.element.isError()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Type type2;
                    element = (Binding)iterator.next();
                    node = this.analyzer.type(((Binding)element).element);
                    if (AST.isList((Type)node)) {
                        node = AST.getArgument((Type)node);
                    }
                    if ((type2 = this.ast.unify(this.element, (Type)node, true)).isError()) {
                        this.runtime.error("unable to determine consistent list element type", sequence);
                        this.runtime.errConsole().loc(sequence).p(": error: 1st type is '");
                        this.ast.print(this.element, this.runtime.errConsole(), false, true, null);
                        this.runtime.errConsole().pln("'");
                        this.runtime.errConsole().loc(sequence).p(": error: 2nd type is '");
                        this.ast.print((Type)node, this.runtime.errConsole(), false, true, null);
                        this.runtime.errConsole().pln("'").flush();
                    }
                    this.element = type2;
                }
            }
            if (object.isEmpty()) {
                sequence.add(EmptyListValue.VALUE);
            } else if (1 == object.size() && AST.isList(this.analyzer.type(((Binding)object.get((int)0)).element))) {
                Binding binding = (Binding)object.get(0);
                if (Analyzer.isSynthetic(binding.name)) {
                    binding.name = "yyValue";
                } else {
                    sequence.add(new BindingValue(binding));
                }
            } else {
                Binding binding = (Binding)object.get(object.size() - 1);
                if (AST.isList(this.analyzer.type(binding.element))) {
                    object.remove(object.size() - 1);
                    sequence.add(new ProperListValue(this.analyzer.current().type, (List<Binding>)object, binding));
                } else {
                    sequence.add(new ProperListValue(this.analyzer.current().type, (List<Binding>)object, null));
                }
            }
        }
        int n2 = sequence.size();
        if (sequence.hasTrailingChoice() || 0 != n2 && sequence.get(n2 - 1) instanceof ValueElement) {
            --n2;
        }
        for (int i = 0; i < n2; ++i) {
            element = this.elements.get(n + i);
            if (sequence.get(i) == element) continue;
            sequence.elements.set(i, element);
        }
        if (0 == n) {
            this.elements.clear();
        } else {
            this.elements.subList(n, this.elements.size()).clear();
        }
    }
}

