/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.parser.ActionBaseValue;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.GenericValue;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.UnaryOperator;
import xtc.tree.Attribute;
import xtc.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalenceTester
extends Visitor {
    protected Map<String, String> nts = new HashMap<String, String>();
    protected Map<String, String> vars = new HashMap<String, String>();
    protected Element e2;

    public boolean areEquivalent(Production production, Production production2) {
        if (!Attribute.areEquivalent(production.attributes, production2.attributes)) {
            return false;
        }
        if (null == production.type ? !production.dType.equals(production2.dType) : !production.type.equals(production2.type)) {
            return false;
        }
        this.nts.put(production2.name.name, production.name.name);
        boolean bl = this.areEquivalent(production.choice, production2.choice);
        this.nts.remove(production2.name.name);
        return bl;
    }

    public boolean areEquivalent(Element element, Element element2) {
        if (null == element || null == element2) {
            return element == element2;
        }
        if (!element.getClass().equals(element2.getClass())) {
            return false;
        }
        this.e2 = element2;
        return (Boolean)this.dispatch(element);
    }

    protected boolean areEquivalent(List<Binding> list, List<Binding> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        Iterator<Binding> iterator = list.iterator();
        Iterator<Binding> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().name;
            String string2 = iterator2.next().name;
            if (string.equals(string2) || string.equals(this.vars.get(string2))) continue;
            return false;
        }
        return true;
    }

    protected boolean areEquivalent(GenericValue genericValue, GenericValue genericValue2) {
        if (!genericValue.name.equals(genericValue2.name) && !genericValue.name.equals(this.nts.get(genericValue2.name))) {
            return false;
        }
        return this.areEquivalent(genericValue.children, genericValue2.children);
    }

    public Boolean visit(OrderedChoice orderedChoice) {
        OrderedChoice orderedChoice2 = (OrderedChoice)this.e2;
        int n = orderedChoice.alternatives.size();
        if (n != orderedChoice2.alternatives.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areEquivalent(orderedChoice.alternatives.get(i), orderedChoice2.alternatives.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Repetition repetition) {
        Repetition repetition2 = (Repetition)this.e2;
        if (repetition.once != repetition2.once) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(repetition.element, repetition2.element);
    }

    public Boolean visit(Sequence sequence) {
        Sequence sequence2 = (Sequence)this.e2;
        int n = sequence.elements.size();
        if (n != sequence2.elements.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            if (this.areEquivalent(sequence.elements.get(i), sequence2.elements.get(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean visit(Binding binding) {
        Binding binding2 = (Binding)this.e2;
        if (binding.name.equals(binding2.name)) {
            return this.areEquivalent(binding.element, binding2.element);
        }
        String string = this.vars.get(binding2.name);
        if (null == string) {
            this.vars.put(binding2.name, binding.name);
            boolean bl = this.areEquivalent(binding.element, binding2.element);
            this.vars.remove(binding2.name);
            return bl;
        }
        if (!binding.name.equals(string)) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(binding.element, binding2.element);
    }

    public Boolean visit(StringMatch stringMatch) {
        StringMatch stringMatch2 = (StringMatch)this.e2;
        return stringMatch.text.equals(stringMatch2.text) && this.areEquivalent(stringMatch.element, stringMatch2.element);
    }

    public Boolean visit(NonTerminal nonTerminal) {
        NonTerminal nonTerminal2 = (NonTerminal)this.e2;
        return nonTerminal.equals(nonTerminal2) || nonTerminal.name.equals(this.nts.get(nonTerminal2.name));
    }

    public Boolean visit(CharSwitch charSwitch) {
        CharSwitch charSwitch2 = (CharSwitch)this.e2;
        int n = charSwitch.cases.size();
        if (n != charSwitch2.cases.size()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            CharCase charCase = charSwitch.cases.get(i);
            CharCase charCase2 = charSwitch2.cases.get(i);
            if (!this.areEquivalent(charCase.klass, charCase2.klass)) {
                return Boolean.FALSE;
            }
            if (this.areEquivalent(charCase.element, charCase2.element)) continue;
            return Boolean.FALSE;
        }
        if (null == charSwitch.base) {
            return null == charSwitch2.base;
        }
        if (null == charSwitch2.base) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(charSwitch.base, charSwitch2.base);
    }

    public Boolean visit(ParseTreeNode parseTreeNode) {
        ParseTreeNode parseTreeNode2 = (ParseTreeNode)this.e2;
        if (!this.areEquivalent(parseTreeNode.predecessors, parseTreeNode2.predecessors)) {
            return Boolean.FALSE;
        }
        if (null == parseTreeNode.node != (null == parseTreeNode2.node)) {
            return Boolean.FALSE;
        }
        if (null != parseTreeNode.node && !parseTreeNode.node.name.equals(parseTreeNode2.node.name) && !parseTreeNode.node.name.equals(this.vars.get(parseTreeNode2.node.name))) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(parseTreeNode.successors, parseTreeNode2.successors);
    }

    public Boolean visit(ProperListValue properListValue) {
        ProperListValue properListValue2 = (ProperListValue)this.e2;
        if (!properListValue.type.equals(properListValue2.type)) {
            return Boolean.FALSE;
        }
        if (!this.areEquivalent(properListValue.elements, properListValue2.elements)) {
            return Boolean.FALSE;
        }
        if (null == properListValue.tail != (null == properListValue2.tail)) {
            return Boolean.FALSE;
        }
        return null == properListValue.tail || properListValue.tail.name.equals(properListValue2.tail.name) || properListValue.tail.name.equals(this.vars.get(properListValue2.tail.name));
    }

    public Boolean visit(BindingValue bindingValue) {
        BindingValue bindingValue2 = (BindingValue)this.e2;
        return bindingValue.binding.name.equals(bindingValue2.binding.name) || bindingValue.binding.name.equals(this.vars.get(bindingValue2.binding.name));
    }

    public Boolean visit(ActionBaseValue actionBaseValue) {
        ActionBaseValue actionBaseValue2 = (ActionBaseValue)this.e2;
        return !(!actionBaseValue.list.name.equals(actionBaseValue2.list.name) && !actionBaseValue.list.name.equals(this.vars.get(actionBaseValue2.list.name)) || !actionBaseValue.seed.name.equals(actionBaseValue2.seed.name) && !actionBaseValue.seed.name.equals(this.vars.get(actionBaseValue2.seed.name)));
    }

    public Boolean visit(GenericNodeValue genericNodeValue) {
        GenericNodeValue genericNodeValue2 = (GenericNodeValue)this.e2;
        return this.areEquivalent(genericNodeValue, genericNodeValue2) && this.areEquivalent(genericNodeValue.formatting, genericNodeValue2.formatting);
    }

    public Boolean visit(GenericActionValue genericActionValue) {
        GenericActionValue genericActionValue2 = (GenericActionValue)this.e2;
        if (!this.areEquivalent(genericActionValue, genericActionValue2)) {
            return Boolean.FALSE;
        }
        if (!genericActionValue.first.equals(genericActionValue2.first) && !genericActionValue.first.equals(this.vars.get(genericActionValue2.first))) {
            return Boolean.FALSE;
        }
        return this.areEquivalent(genericActionValue.formatting, genericActionValue2.formatting);
    }

    public Boolean visit(GenericRecursionValue genericRecursionValue) {
        GenericRecursionValue genericRecursionValue2 = (GenericRecursionValue)this.e2;
        if (!this.areEquivalent(genericRecursionValue, genericRecursionValue2)) {
            return Boolean.FALSE;
        }
        if (!genericRecursionValue.first.equals(genericRecursionValue2.first) && !genericRecursionValue.first.equals(this.vars.get(genericRecursionValue2.first))) {
            return Boolean.FALSE;
        }
        if (!this.areEquivalent(genericRecursionValue.formatting, genericRecursionValue2.formatting)) {
            return Boolean.FALSE;
        }
        return genericRecursionValue.list.name.equals(genericRecursionValue2.list.name) || genericRecursionValue.list.name.equals(this.vars.get(genericRecursionValue2.list.name));
    }

    public Boolean visit(UnaryOperator unaryOperator) {
        UnaryOperator unaryOperator2 = (UnaryOperator)this.e2;
        return this.areEquivalent(unaryOperator.element, unaryOperator2.element);
    }

    public Boolean visit(Element element) {
        return element.equals(this.e2);
    }
}

