/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.Terminal;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;

public class CostEstimator
extends Visitor {
    protected final Analyzer analyzer;

    public CostEstimator(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            production.removeProperty("cost");
        }
        for (Production production : module.productions) {
            if (production.hasProperty("cost")) continue;
            this.analyzer.process(production);
        }
    }

    public Integer visit(Production production) {
        this.analyzer.workingOn(production.qName);
        Integer n = (Integer)this.dispatch(production.choice);
        this.analyzer.notWorkingOn(production.qName);
        production.setProperty("cost", n);
        return n;
    }

    public Integer visit(OrderedChoice orderedChoice) {
        int n = 0;
        for (Sequence sequence : orderedChoice.alternatives) {
            n = CostEstimator.add(n, (Integer)this.dispatch(sequence));
        }
        return n;
    }

    public Integer visit(Repetition repetition) {
        return Integer.MAX_VALUE;
    }

    public Integer visit(Option option) {
        return CostEstimator.add(1, (Integer)this.dispatch(option.element));
    }

    public Integer visit(Sequence sequence) {
        int n = 0;
        for (Element element : sequence.elements) {
            n = CostEstimator.add(n, (Integer)this.dispatch(element));
        }
        return n;
    }

    public Integer visit(Predicate predicate) {
        return CostEstimator.add(1, (Integer)this.dispatch(predicate.element));
    }

    public Integer visit(VoidedElement voidedElement) {
        return (Integer)this.dispatch(voidedElement.element);
    }

    public Integer visit(Binding binding) {
        return (Integer)this.dispatch(binding.element);
    }

    public Integer visit(StringMatch stringMatch) {
        return CostEstimator.add(1, (Integer)this.dispatch(stringMatch.element));
    }

    public Integer visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
            return Integer.MAX_VALUE;
        }
        return CostEstimator.add(1, fullProduction.hasProperty("cost") ? (Integer)fullProduction.getProperty("cost") : (Integer)this.dispatch(fullProduction));
    }

    public Integer visit(StringLiteral stringLiteral) {
        return stringLiteral.text.length();
    }

    public Integer visit(CharCase charCase) {
        if (null == charCase.element) {
            return 0;
        }
        return (Integer)this.dispatch(charCase.element);
    }

    public Integer visit(CharSwitch charSwitch) {
        int n = 0;
        for (CharCase charCase : charSwitch.cases) {
            n = Math.max(n, (Integer)this.dispatch(charCase) + 1);
        }
        if (null == charSwitch.base) {
            n = Math.max(n, (Integer)this.dispatch(charSwitch.base) + 1);
        }
        return n;
    }

    public Integer visit(Terminal terminal) {
        return 1;
    }

    public Integer visit(NodeMarker nodeMarker) {
        return 0;
    }

    public Integer visit(Action action) {
        return 1;
    }

    public Integer visit(ParserAction parserAction) {
        return Integer.MAX_VALUE;
    }

    public Integer visit(NullLiteral nullLiteral) {
        return 0;
    }

    public Integer visit(StringValue stringValue) {
        return null == stringValue.text ? 1 : 0;
    }

    public Integer visit(ProperListValue properListValue) {
        return properListValue.elements.size();
    }

    public Integer visit(ActionBaseValue actionBaseValue) {
        return Integer.MAX_VALUE;
    }

    public Integer visit(GenericNodeValue genericNodeValue) {
        return 2;
    }

    public Integer visit(GenericActionValue genericActionValue) {
        return 1;
    }

    public Integer visit(GenericRecursionValue genericRecursionValue) {
        return 2;
    }

    public Integer visit(ValueElement valueElement) {
        return 0;
    }

    protected static int add(int n, int n2) {
        if (Integer.MAX_VALUE == n || Integer.MAX_VALUE == n2) {
            return Integer.MAX_VALUE;
        }
        long l = n + n2;
        if (Integer.MAX_VALUE < l) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }
}

