/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleInstantiation;
import xtc.parser.ModuleList;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NotFollowedBy;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.ProperListValue;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Node;
import xtc.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Copier
extends Visitor {
    protected List<Binding> source = new ArrayList<Binding>();
    protected List<Binding> target = new ArrayList<Binding>();

    protected Binding match(Binding binding) {
        int n = this.source.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (binding != this.source.get(i)) continue;
            n2 = i;
            break;
        }
        if (-1 == n2) {
            throw new IllegalArgumentException("Copying element without binding for " + binding.name);
        }
        return this.target.get(n2);
    }

    protected void patch(List<Binding> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, this.match(list.get(i)));
        }
    }

    public <T extends Element> T copy(T t) {
        this.source.clear();
        this.target.clear();
        return (T)((Element)this.dispatch(t));
    }

    public Grammar visit(Grammar grammar) {
        Grammar grammar2 = new Grammar(new ArrayList<Module>(grammar.modules.size()));
        grammar2.setLocation(grammar);
        for (Module module : grammar.modules) {
            grammar2.modules.add((Module)this.dispatch(module));
        }
        return grammar2;
    }

    public Module visit(Module module) {
        Module module2 = new Module();
        module2.setLocation(module);
        module2.documentation = (Comment)this.dispatch(module.documentation);
        module2.name = module.name;
        module2.parameters = (ModuleList)this.dispatch(module.parameters);
        if (null != module.dependencies) {
            module2.dependencies = new ArrayList<ModuleDependency>(module.dependencies.size());
            for (ModuleDependency node : module.dependencies) {
                module2.dependencies.add((ModuleDependency)this.dispatch(node));
            }
        }
        module2.modification = module.modification;
        module2.header = (Action)this.dispatch(module.header);
        module2.body = (Action)this.dispatch(module.body);
        module2.footer = (Action)this.dispatch(module.footer);
        if (null != module.attributes) {
            module2.attributes = new ArrayList<Attribute>(module.attributes);
        }
        module2.productions = new ArrayList<Production>(module.productions.size());
        for (Production production : module.productions) {
            module2.productions.add((Production)this.dispatch(production));
        }
        return module2;
    }

    public Comment visit(Comment comment) {
        Node node = (Node)this.dispatch(comment.getNode());
        Comment comment2 = new Comment(comment.kind, new ArrayList<String>(comment.text), node);
        comment2.setLocation(comment);
        return comment2;
    }

    public ModuleImport visit(ModuleImport moduleImport) {
        ModuleImport moduleImport2 = new ModuleImport(moduleImport.module, (ModuleList)this.dispatch(moduleImport.arguments), moduleImport.target);
        moduleImport2.setLocation(moduleImport);
        return moduleImport2;
    }

    public ModuleInstantiation visit(ModuleInstantiation moduleInstantiation) {
        ModuleInstantiation moduleInstantiation2 = new ModuleInstantiation(moduleInstantiation.module, (ModuleList)this.dispatch(moduleInstantiation.arguments), moduleInstantiation.target);
        moduleInstantiation2.setLocation(moduleInstantiation);
        return moduleInstantiation2;
    }

    public ModuleModification visit(ModuleModification moduleModification) {
        ModuleModification moduleModification2 = new ModuleModification(moduleModification.module, (ModuleList)this.dispatch(moduleModification.arguments), moduleModification.target);
        moduleModification2.setLocation(moduleModification);
        return moduleModification2;
    }

    public ModuleList visit(ModuleList moduleList) {
        ModuleList moduleList2 = new ModuleList(new ArrayList<ModuleName>(moduleList.names));
        moduleList2.setLocation(moduleList);
        return moduleList2;
    }

    public FullProduction visit(FullProduction fullProduction) {
        FullProduction fullProduction2 = new FullProduction(null, fullProduction.type, fullProduction.name, fullProduction.qName, this.copy(fullProduction.choice));
        fullProduction2.setLocation(fullProduction);
        if (null != fullProduction.attributes) {
            fullProduction2.attributes = new ArrayList(fullProduction.attributes);
        }
        fullProduction2.dType = fullProduction.dType;
        return fullProduction2;
    }

    public AlternativeAddition visit(AlternativeAddition alternativeAddition) {
        AlternativeAddition alternativeAddition2 = new AlternativeAddition(alternativeAddition.dType, alternativeAddition.name, this.copy(alternativeAddition.choice), alternativeAddition.sequence, alternativeAddition.isBefore);
        alternativeAddition2.setLocation(alternativeAddition);
        alternativeAddition2.type = alternativeAddition.type;
        alternativeAddition2.qName = alternativeAddition.qName;
        return alternativeAddition2;
    }

    public AlternativeRemoval visit(AlternativeRemoval alternativeRemoval) {
        AlternativeRemoval alternativeRemoval2 = new AlternativeRemoval(alternativeRemoval.dType, alternativeRemoval.name, new ArrayList<SequenceName>(alternativeRemoval.sequences));
        alternativeRemoval2.setLocation(alternativeRemoval);
        alternativeRemoval2.type = alternativeRemoval.type;
        alternativeRemoval2.qName = alternativeRemoval.qName;
        return alternativeRemoval2;
    }

    public ProductionOverride visit(ProductionOverride productionOverride) {
        ProductionOverride productionOverride2 = new ProductionOverride(productionOverride.dType, productionOverride.name, this.copy(productionOverride.choice), productionOverride.isComplete);
        productionOverride2.setLocation(productionOverride);
        if (null != productionOverride.attributes) {
            productionOverride2.attributes = new ArrayList(productionOverride.attributes);
        }
        productionOverride2.type = productionOverride.type;
        productionOverride2.qName = productionOverride.qName;
        return productionOverride2;
    }

    public OrderedChoice visit(OrderedChoice orderedChoice) {
        int n = orderedChoice.alternatives.size();
        OrderedChoice orderedChoice2 = new OrderedChoice(new ArrayList<Sequence>(n));
        orderedChoice2.setLocation(orderedChoice);
        for (Sequence sequence : orderedChoice.alternatives) {
            orderedChoice2.alternatives.add((Sequence)this.dispatch(sequence));
        }
        return orderedChoice2;
    }

    public Repetition visit(Repetition repetition) {
        Repetition repetition2 = new Repetition(repetition.once, (Element)this.dispatch(repetition.element));
        repetition2.setLocation(repetition);
        return repetition2;
    }

    public Option visit(Option option) {
        Option option2 = new Option((Element)this.dispatch(option.element));
        option2.setLocation(option);
        return option2;
    }

    public Sequence visit(Sequence sequence) {
        int n = sequence.size();
        Sequence sequence2 = new Sequence(sequence.name, new ArrayList<Element>(n));
        sequence2.setLocation(sequence);
        for (int i = 0; i < n; ++i) {
            sequence2.add((Element)this.dispatch(sequence.get(i)));
        }
        return sequence2;
    }

    public FollowedBy visit(FollowedBy followedBy) {
        FollowedBy followedBy2 = new FollowedBy((Element)this.dispatch(followedBy.element));
        followedBy2.setLocation(followedBy);
        return followedBy2;
    }

    public NotFollowedBy visit(NotFollowedBy notFollowedBy) {
        NotFollowedBy notFollowedBy2 = new NotFollowedBy((Element)this.dispatch(notFollowedBy.element));
        notFollowedBy2.setLocation(notFollowedBy);
        return notFollowedBy2;
    }

    public SemanticPredicate visit(SemanticPredicate semanticPredicate) {
        SemanticPredicate semanticPredicate2 = new SemanticPredicate((Action)this.dispatch(semanticPredicate.element));
        semanticPredicate2.setLocation(semanticPredicate);
        return semanticPredicate2;
    }

    public VoidedElement visit(VoidedElement voidedElement) {
        VoidedElement voidedElement2 = new VoidedElement((Element)this.dispatch(voidedElement.element));
        voidedElement2.setLocation(voidedElement);
        return voidedElement2;
    }

    public Binding visit(Binding binding) {
        Binding binding2 = new Binding(binding.name, (Element)this.dispatch(binding.element));
        binding2.setLocation(binding);
        this.source.add(binding);
        this.target.add(binding2);
        return binding2;
    }

    public StringMatch visit(StringMatch stringMatch) {
        StringMatch stringMatch2 = new StringMatch(stringMatch.text, (Element)this.dispatch(stringMatch.element));
        stringMatch2.setLocation(stringMatch2);
        return stringMatch2;
    }

    public CharClass visit(CharClass charClass) {
        CharClass charClass2 = new CharClass(charClass.exclusive, new ArrayList<CharRange>(charClass.ranges.size()));
        charClass2.setLocation(charClass);
        charClass2.ranges.addAll(charClass.ranges);
        return charClass2;
    }

    public CharCase visit(CharCase charCase) {
        CharCase charCase2 = new CharCase((CharClass)this.dispatch(charCase.klass), (Element)this.dispatch(charCase.element));
        charCase2.setLocation(charCase);
        return charCase2;
    }

    public CharSwitch visit(CharSwitch charSwitch) {
        int n = charSwitch.cases.size();
        CharSwitch charSwitch2 = new CharSwitch(new ArrayList<CharCase>(n));
        charSwitch2.setLocation(charSwitch);
        for (CharCase charCase : charSwitch.cases) {
            charSwitch2.cases.add((CharCase)this.dispatch(charCase));
        }
        charSwitch2.base = (Element)this.dispatch(charSwitch.base);
        return charSwitch2;
    }

    public Action visit(Action action) {
        Action action2 = new Action(new ArrayList<String>(action.code), new ArrayList<Integer>(action.indent));
        action2.setLocation(action);
        return action2;
    }

    public ParserAction visit(ParserAction parserAction) {
        ParserAction parserAction2 = new ParserAction((Action)this.dispatch(parserAction.element));
        parserAction2.setLocation(parserAction);
        return parserAction2;
    }

    public ParseTreeNode visit(ParseTreeNode parseTreeNode) {
        ParseTreeNode parseTreeNode2 = new ParseTreeNode(new ArrayList<Binding>(parseTreeNode.predecessors), null, new ArrayList<Binding>(parseTreeNode.successors));
        parseTreeNode2.setLocation(parseTreeNode);
        this.patch(parseTreeNode2.predecessors);
        if (null != parseTreeNode.node) {
            parseTreeNode2.node = this.match(parseTreeNode.node);
        }
        this.patch(parseTreeNode2.successors);
        return parseTreeNode2;
    }

    public BindingValue visit(BindingValue bindingValue) {
        BindingValue bindingValue2 = new BindingValue(this.match(bindingValue.binding));
        bindingValue2.setLocation(bindingValue);
        return bindingValue2;
    }

    public ProperListValue visit(ProperListValue properListValue) {
        ProperListValue properListValue2 = new ProperListValue(properListValue.type, new ArrayList<Binding>(properListValue.elements), null);
        properListValue2.setLocation(properListValue);
        this.patch(properListValue2.elements);
        if (null != properListValue.tail) {
            properListValue2.tail = this.match(properListValue.tail);
        }
        return properListValue2;
    }

    public ActionBaseValue visit(ActionBaseValue actionBaseValue) {
        ActionBaseValue actionBaseValue2 = new ActionBaseValue(this.match(actionBaseValue.list), this.match(actionBaseValue.seed));
        actionBaseValue2.setLocation(actionBaseValue);
        return actionBaseValue2;
    }

    public GenericNodeValue visit(GenericNodeValue genericNodeValue) {
        GenericNodeValue genericNodeValue2 = new GenericNodeValue(genericNodeValue.name, new ArrayList<Binding>(genericNodeValue.children), new ArrayList<Binding>(genericNodeValue.formatting));
        genericNodeValue2.setLocation(genericNodeValue);
        this.patch(genericNodeValue2.children);
        this.patch(genericNodeValue2.formatting);
        return genericNodeValue2;
    }

    public GenericActionValue visit(GenericActionValue genericActionValue) {
        GenericActionValue genericActionValue2 = new GenericActionValue(genericActionValue.name, genericActionValue.first, new ArrayList<Binding>(genericActionValue.children), new ArrayList<Binding>(genericActionValue.formatting));
        genericActionValue2.setLocation(genericActionValue);
        this.patch(genericActionValue2.children);
        this.patch(genericActionValue2.formatting);
        return genericActionValue2;
    }

    public GenericRecursionValue visit(GenericRecursionValue genericRecursionValue) {
        GenericRecursionValue genericRecursionValue2 = new GenericRecursionValue(genericRecursionValue.name, genericRecursionValue.first, new ArrayList<Binding>(genericRecursionValue.children), new ArrayList<Binding>(genericRecursionValue.formatting), this.match(genericRecursionValue.list));
        genericRecursionValue2.setLocation(genericRecursionValue);
        this.patch(genericRecursionValue2.children);
        this.patch(genericRecursionValue2.formatting);
        return genericRecursionValue2;
    }

    public Element visit(Element element) {
        return element;
    }
}

