/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import xtc.parser.CharRange;
import xtc.parser.CharTerminal;
import xtc.parser.Element;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharClass
extends CharTerminal {
    public boolean exclusive;
    public List<CharRange> ranges;

    public CharClass(List<CharRange> list) {
        this(false, list);
    }

    public CharClass(boolean bl, List<CharRange> list) {
        this.exclusive = bl;
        this.ranges = list;
    }

    public CharClass(char c) {
        this.exclusive = false;
        this.ranges = new ArrayList<CharRange>(1);
        this.ranges.add(new CharRange(c));
    }

    public CharClass(String string) {
        this.exclusive = false;
        this.ranges = new ArrayList<CharRange>();
        Parser parser = new Parser(string);
        while (parser.hasNext()) {
            char c = parser.next();
            char c2 = parser.hasRange() ? parser.next() : c;
            this.ranges.add(new CharRange(c, c2));
        }
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.CHAR_CLASS;
    }

    public CharClass normalize() {
        Collections.sort(this.ranges);
        for (int i = 0; i < this.ranges.size() - 1; ++i) {
            CharRange charRange = this.ranges.get(i);
            CharRange charRange2 = this.ranges.get(i + 1);
            if (charRange.last >= charRange2.last) {
                this.ranges.remove(i + 1);
                --i;
                continue;
            }
            if (charRange.last < charRange2.first - '\u0001') continue;
            this.ranges.set(i, new CharRange(charRange.first, charRange2.last));
            this.ranges.remove(i + 1);
            --i;
        }
        return this;
    }

    public boolean overlaps(CharClass charClass) {
        if (this.exclusive) {
            throw new IllegalStateException("overlap test for exclusive character class " + this);
        }
        if (charClass.exclusive) {
            throw new IllegalStateException("overlap test for exclusive character class " + charClass);
        }
        for (CharRange charRange : charClass.ranges) {
            for (CharRange charRange2 : this.ranges) {
                if (!charRange.contains(charRange2.first) && !charRange.contains(charRange2.last) && !charRange2.contains(charRange.first) && !charRange2.contains(charRange.last)) continue;
                return true;
            }
        }
        return false;
    }

    public int count() {
        int n = 0;
        for (CharRange charRange : this.ranges) {
            n += charRange.count();
        }
        return n;
    }

    public int hashCode() {
        int n = 0;
        for (CharRange charRange : this.ranges) {
            n += charRange.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharClass)) {
            return false;
        }
        CharClass charClass = (CharClass)object;
        if (this.exclusive != charClass.exclusive) {
            return false;
        }
        if (this.ranges.size() != charClass.ranges.size()) {
            return false;
        }
        return this.ranges.containsAll(charClass.ranges);
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        if (this.exclusive) {
            appendable.append('!');
        }
        appendable.append('[');
        for (CharRange charRange : this.ranges) {
            if (charRange.first == charRange.last) {
                Utilities.escape(charRange.first, appendable, 12);
                continue;
            }
            Utilities.escape(charRange.first, appendable, 12);
            appendable.append('-');
            Utilities.escape(charRange.last, appendable, 12);
        }
        appendable.append(']');
        if (this.exclusive) {
            appendable.append(" _");
        }
    }

    public static class Parser {
        protected String s;
        protected int idx;

        public Parser(String string) {
            this.s = string;
            this.idx = 0;
        }

        public boolean hasNext() {
            return this.idx < this.s.length();
        }

        public boolean hasRange() {
            if (this.idx >= this.s.length()) {
                return false;
            }
            char c = this.s.charAt(this.idx);
            if ('-' == c) {
                ++this.idx;
                return true;
            }
            return false;
        }

        public char next() {
            char c = this.s.charAt(this.idx);
            ++this.idx;
            if ('\\' != c) {
                return c;
            }
            c = this.s.charAt(this.idx);
            ++this.idx;
            switch (c) {
                case 'b': {
                    return '\b';
                }
                case 't': {
                    return '\t';
                }
                case 'n': {
                    return '\n';
                }
                case 'f': {
                    return '\f';
                }
                case 'r': {
                    return '\r';
                }
                case '\"': {
                    return '\"';
                }
                case '\'': {
                    return '\'';
                }
                case '-': {
                    return '-';
                }
                case '[': {
                    return '[';
                }
                case '\\': {
                    return '\\';
                }
                case ']': {
                    return ']';
                }
                case 'u': {
                    int n;
                    this.idx += 4;
                    try {
                        n = Integer.parseInt(this.s.substring(this.idx - 4, this.idx), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Illegal Unicode escape ('\\u" + this.s.substring(this.idx - 4, this.idx) + "')");
                    }
                    return (char)n;
                }
            }
            throw new IllegalArgumentException("Illegal character escape ('\\" + c + "')");
        }
    }
}

