/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.overlog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.lang.overlog.MaterializationChecker;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.ArrayT;
import xtc.type.BooleanT;
import xtc.type.ErrorT;
import xtc.type.FloatT;
import xtc.type.FunctionT;
import xtc.type.IntegerT;
import xtc.type.InternalT;
import xtc.type.NullReference;
import xtc.type.NumberT;
import xtc.type.Parameter;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.type.Wildcard;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeAnalyzer
extends Visitor {
    private final Runtime runtime;
    private SymbolTable table;
    private static int tempNameCount = 0;
    private Map<Type, Type> updateMap;
    private Set<String> ruleIdentifiers;
    private int numNonMaterialized;
    private Set<String> materialized;

    public TypeAnalyzer(Runtime runtime) {
        this.runtime = runtime;
        this.updateMap = new HashMap<Type, Type>();
        this.ruleIdentifiers = new HashSet<String>();
    }

    public Node analyze(Node node) {
        this.materialized = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        new MaterializationChecker().analyze(node, hashSet, this.materialized);
        return this.analyze(node, new SymbolTable());
    }

    public Node analyze(Node node, SymbolTable symbolTable) {
        this.table = symbolTable;
        this.materialized = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        new MaterializationChecker().analyze(node, hashSet, this.materialized);
        this.dispatch(node);
        this.updateSymbolTable();
        return node;
    }

    private void makeSet(Type type2) {
        this.updateMap.put(type2, null);
    }

    private void union(Type type2, Type type3) {
        if (type2 == null || type3 == null) {
            return;
        }
        if (this.isBasicType(type2) && !this.isBasicType(type3)) {
            this.updateMap.put(type3, type2);
        } else if (!this.isBasicType(type2) && this.isBasicType(type3)) {
            this.updateMap.put(type2, type3);
        } else {
            Parameter parameter = new Parameter(this.newTempTypeName());
            this.updateMap.put(parameter, type2);
            this.updateMap.put(parameter, type3);
        }
    }

    private Type find(Type type2) {
        Type type3 = this.updateMap.get(type2);
        if (type3 == null) {
            return type2;
        }
        return this.find(type3);
    }

    private void updateSymbolTable() {
        this.updateScope(this.table.current());
        Iterator<String> iterator = this.table.current().nested();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.updateScope(this.table.current().getNested(string));
        }
    }

    private void updateScope(SymbolTable.Scope scope) {
        Iterator<String> iterator = scope.symbols();
        while (iterator.hasNext()) {
            Type type2;
            List<Type> list;
            ArrayList<Type> arrayList;
            String string = iterator.next();
            Type type3 = (Type)scope.lookup(string);
            Type type4 = this.find(type3);
            if (type4.isTuple()) {
                arrayList = new ArrayList<Type>();
                list = type3.toTuple().getTypes();
                for (Type type52 : list) {
                    type2 = this.find(type52);
                    if (type2.isParameter()) {
                        type2 = new InternalT("opaque");
                    }
                    arrayList.add(type2);
                }
                scope.define(string, new TupleT(type4.getName(), arrayList));
                continue;
            }
            if (type4.isFunction()) {
                Type type52;
                arrayList = new ArrayList();
                list = type4.toFunction().getParameters();
                for (Type type52 : list) {
                    type2 = this.find(type52);
                    if (type2.isParameter()) {
                        type2 = new InternalT("opaque");
                    }
                    arrayList.add(type2);
                }
                Object object = this.find(type4.toFunction().getResult());
                if (((Type)object).isParameter()) {
                    object = new InternalT("opaque");
                }
                type52 = new FunctionT((Type)object, arrayList, false);
                scope.define(string, type52);
                continue;
            }
            if (type4.isParameter()) {
                scope.define(string, new InternalT("opaque"));
                continue;
            }
            scope.define(string, type4);
        }
    }

    private boolean isBasicType(Type type2) {
        switch (type2.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case VOID: 
            case WILDCARD: {
                return true;
            }
            case INTERNAL: {
                return "location".equals(type2.toInternal().getName()) || "string constant".equals(type2.toInternal().getName());
            }
        }
        return false;
    }

    public boolean areSameBasicType(Type type2, Type type3) {
        if (Type.Tag.WILDCARD == type3.tag()) {
            return this.isBasicType(type2);
        }
        switch (type2.tag()) {
            case BOOLEAN: {
                return type3.isBoolean();
            }
            case INTEGER: {
                return type3.isInteger();
            }
            case FLOAT: {
                return type3.isFloat();
            }
            case VOID: {
                return type3.isVoid();
            }
            case WILDCARD: {
                return this.isBasicType(type3);
            }
            case INTERNAL: {
                if (!type3.isInternal()) {
                    return false;
                }
                if ("location".equals(type2.toInternal().getName()) && "location".equals(type3.toInternal().getName())) {
                    return true;
                }
                return "string constant".equals(type2.toInternal().getName()) && "string constant".equals(type3.toInternal().getName());
            }
        }
        return false;
    }

    private boolean isVariable(Type type2) {
        return type2.isParameter();
    }

    private String newTempTypeName() {
        String string = "tmp" + tempNameCount;
        ++tempNameCount;
        return string;
    }

    private boolean unify(Type type2, Type type3) {
        Type type4 = this.find(type2);
        Type type5 = this.find(type3);
        if (type4 == null || type5 == null) {
            return false;
        }
        if (type4.equals(type5)) {
            return true;
        }
        if (this.areSameBasicType(type4, type5)) {
            return true;
        }
        if (type4.isTuple() && type5.isTuple()) {
            if (type4.toTuple().getTypes().size() != type5.toTuple().getTypes().size()) {
                return false;
            }
            List<Type> list = type4.toTuple().getTypes();
            List<Type> list2 = type5.toTuple().getTypes();
            int n = 0;
            for (Type type6 : list) {
                Type type7;
                boolean bl = this.unify(type6, type7 = list2.get(n));
                if (!(bl || this.find(type6).isFloat() && this.find(type7).isInteger() || this.find(type6).isInteger() && this.find(type7).isFloat())) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (type4.isFunction() && type5.isFunction()) {
            if (((FunctionT)type4).getParameters().size() != ((FunctionT)type5).getParameters().size()) {
                return false;
            }
            List<Type> list = type4.toFunction().getParameters();
            List<Type> list3 = type5.toFunction().getParameters();
            int n = 0;
            for (Type type8 : list) {
                Type type9;
                boolean bl = this.unify(type8, type9 = list3.get(n));
                if (!(bl || this.find(type8).isFloat() && this.find(type9).isInteger() || this.find(type8).isInteger() && this.find(type9).isFloat())) {
                    return false;
                }
                ++n;
            }
            return this.unify(type4.toFunction().getResult(), type5.toFunction().getResult());
        }
        if (this.isVariable(type4) || this.isVariable(type5)) {
            this.union(type4, type5);
            return true;
        }
        return false;
    }

    public void visit(GNode gNode) {
        for (Object object : gNode) {
            if (object instanceof Node) {
                this.dispatch((Node)object);
                continue;
            }
            if (!Node.isList(object)) continue;
            this.iterate(Node.toList(object));
        }
    }

    public void visitRule(GNode gNode) {
        String string = "unknown";
        if ("RuleIdentifier".equals(gNode.getNode(0).getName())) {
            string = gNode.getNode(0).getString(0);
            if (this.ruleIdentifiers.contains(string)) {
                this.runtime.error("Rule " + string + " previously defined.", gNode);
                return;
            }
            this.ruleIdentifiers.add(string);
            this.table.enter(string);
        } else {
            this.table.enter(this.table.freshName());
        }
        this.dispatch(gNode.getNode(2));
        this.numNonMaterialized = 0;
        for (Node node : gNode.getList(3)) {
            this.dispatch(node);
        }
        if (this.numNonMaterialized > 1) {
            this.runtime.error("Rule " + string + " has " + this.numNonMaterialized + " non-materialized tuples", gNode);
        }
        this.numNonMaterialized = 0;
        this.table.exit();
        this.updateSymbolTable();
    }

    public Type visitTuple(GNode gNode) {
        Node node2;
        String string = gNode.getNode(0).getString(0);
        if (!this.materialized.contains(string)) {
            ++this.numNonMaterialized;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Node node2 : gNode.getList(1)) {
            Type type2 = (Type)this.dispatch(node2);
            arrayList.add(type2);
        }
        TupleT tupleT = new TupleT(string, arrayList);
        node2 = (Type)this.table.root().lookup(string);
        if (null == node2) {
            this.table.root().define(string, tupleT);
        } else {
            boolean bl = this.unify(tupleT, (Type)node2);
            if (!bl) {
                if (string.equals("periodic")) {
                    this.runtime.warning("periodic tuple previously defined with different type.", gNode);
                } else {
                    this.runtime.error("Tuple " + string + " previously defined " + "with different type", gNode);
                    return ErrorT.TYPE;
                }
            }
        }
        return tupleT;
    }

    public Type visitExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getNode(0));
        boolean bl = this.unify(type3, type2 = (Type)this.dispatch(gNode.getNode(2)));
        if (bl) {
            this.union(type3, type2);
            return this.find(type3);
        }
        if (this.find(type3).isFloat() && this.find(type2).isInteger() || this.find(type3).isInteger() && this.find(type2).isFloat()) {
            return NumberT.FLOAT;
        }
        this.runtime.error("Assignment Expression error. Cannot assign " + this.find(type2) + " to " + this.find(type3), gNode);
        return ErrorT.TYPE;
    }

    public Type visitLogicalOrExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getNode(0));
        boolean bl = this.unify(type3, type2 = (Type)this.dispatch(gNode.getNode(2)));
        if (bl) {
            return new BooleanT();
        }
        this.runtime.error("Cannot compare " + this.find(type3) + " and " + this.find(type2) + " in a logical or expression", gNode);
        return ErrorT.TYPE;
    }

    public Type visitLogicalAndExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getNode(0));
        boolean bl = this.unify(type3, type2 = (Type)this.dispatch(gNode.getNode(2)));
        if (bl) {
            return new BooleanT();
        }
        this.runtime.error("Cannot compare " + this.find(type3) + " and " + this.find(type2) + " in a logical and expression", gNode);
        return ErrorT.TYPE;
    }

    public Type visitEqualityExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getNode(0));
        boolean bl = this.unify(type3, type2 = (Type)this.dispatch(gNode.getNode(2)));
        if (bl) {
            return new BooleanT();
        }
        if (this.find(type3).isFloat() && this.find(type2).isInteger() || this.find(type3).isInteger() && this.find(type2).isFloat()) {
            return new BooleanT();
        }
        this.runtime.error("Cannot compare " + this.find(type3) + " and " + this.find(type2) + " in an equality expression", gNode);
        return ErrorT.TYPE;
    }

    public Type visitShiftExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        Type type3 = (Type)this.dispatch(gNode.getNode(2));
        if (type2.isInteger() && type3.isInteger()) {
            return NumberT.S_INT;
        }
        if (type2.isFloat() && type3.isInteger()) {
            return NumberT.FLOAT;
        }
        if (type2.isInteger() && type3.isFloat()) {
            return NumberT.FLOAT;
        }
        if (type2.isFloat() && type3.isFloat()) {
            return NumberT.FLOAT;
        }
        if (this.unify(type2, type3)) {
            return this.find(type2);
        }
        this.runtime.error("Cannot shift " + this.find(type2) + " and " + this.find(type3), gNode);
        return ErrorT.TYPE;
    }

    public Type visitAdditiveExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        Type type3 = (Type)this.dispatch(gNode.getNode(2));
        if (type2.isInteger() && type3.isInteger()) {
            return NumberT.S_INT;
        }
        if (type2.isFloat() && type3.isInteger()) {
            return NumberT.FLOAT;
        }
        if (type2.isInteger() && type3.isFloat()) {
            return NumberT.FLOAT;
        }
        if (type2.isFloat() && type3.isFloat()) {
            return NumberT.FLOAT;
        }
        if (this.unify(type2, type3)) {
            return this.find(type2);
        }
        this.runtime.error("Cannot add " + this.find(type2) + " and " + this.find(type3), gNode);
        return ErrorT.TYPE;
    }

    public Type visitMultiplicativeExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        Type type3 = (Type)this.dispatch(gNode.getNode(2));
        if (type2.isInteger() && type3.isInteger()) {
            return NumberT.S_INT;
        }
        if (type2.isFloat() && type3.isInteger()) {
            return NumberT.FLOAT;
        }
        if (type2.isInteger() && type3.isFloat()) {
            return NumberT.FLOAT;
        }
        if (type2.isFloat() && type3.isFloat()) {
            return NumberT.FLOAT;
        }
        if (this.unify(type2, type3)) {
            return this.find(type2);
        }
        this.runtime.error("Cannot multiply " + this.find(type2) + " and " + this.find(type3), gNode);
        return ErrorT.TYPE;
    }

    public Type visitLogicalNegationExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        return new BooleanT();
    }

    public Type visitInclusiveExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getNode(0));
        boolean bl = this.unify(type3, type2 = (Type)this.dispatch(gNode.getNode(2)));
        if (bl) {
            BooleanT booleanT = new BooleanT();
            this.makeSet(booleanT);
            return booleanT;
        }
        if (this.find(type3).isFloat() && this.find(type2).isInteger() || this.find(type3).isInteger() && this.find(type2).isFloat()) {
            BooleanT booleanT = new BooleanT();
            this.makeSet(booleanT);
            return booleanT;
        }
        this.runtime.error("Cannot compare " + this.find(type3) + " and " + this.find(type2) + " in an inclusion expression", gNode);
        return ErrorT.TYPE;
    }

    public Type visitRangeExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getNode(1));
        boolean bl = this.unify(type3, type2 = (Type)this.dispatch(gNode.getNode(2)));
        if (bl) {
            return this.find(type3);
        }
        if (this.find(type3).isFloat() && this.find(type2).isInteger() || this.find(type3).isInteger() && this.find(type2).isFloat()) {
            return NumberT.FLOAT;
        }
        this.runtime.error("Cannot compare " + this.find(type3) + " and " + this.find(type2) + " in a range expression", gNode);
        return ErrorT.TYPE;
    }

    public Type visitPostfixExpression(GNode gNode) {
        String string = gNode.getNode(0).getString(0);
        Parameter parameter = new Parameter(this.newTempTypeName());
        this.makeSet(parameter);
        ArrayList<Type> arrayList = this.visitArguments(gNode.getGeneric(1));
        FunctionT functionT = new FunctionT(parameter, arrayList, false);
        Type type2 = (Type)this.table.root().lookup(string);
        if (null == type2) {
            this.table.root().define(string, functionT);
        } else {
            boolean bl = this.unify(type2, functionT);
            if (!bl) {
                this.runtime.error("Function previously defined with a different type", gNode);
                return ErrorT.TYPE;
            }
        }
        return parameter;
    }

    public ArrayList<Type> visitArguments(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        if (gNode.size() != 0) {
            for (Node node : gNode.getList(0)) {
                Type type2 = (Type)this.dispatch(node);
                arrayList.add(type2);
            }
        }
        return arrayList;
    }

    public Type visitVectorExpression(GNode gNode) {
        Type type2;
        ArrayList arrayList = new ArrayList();
        Type type3 = (Type)this.dispatch((Node)arrayList.get(0));
        boolean bl = this.unify(type3, type2 = (Type)this.dispatch((Node)arrayList.get(1)));
        if (!bl) {
            this.runtime.error("Vector mal-typed", gNode);
            return ErrorT.TYPE;
        }
        return new ArrayT(type3, true);
    }

    public Type visitMatrixExpression(GNode gNode) {
        return new ArrayT((Type)NumberT.S_INT, true);
    }

    public Type visitMatrixEntry(GNode gNode) {
        return new ArrayT((Type)NumberT.S_INT, true);
    }

    public Type visitParenthesizedExpression(GNode gNode) {
        return (Type)this.dispatch(gNode.getNode(0));
    }

    public Type visitAggregate(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        return (Type)this.dispatch(gNode.getNode(1));
    }

    public Type visitMinAggregate(GNode gNode) {
        return (Type)this.dispatch(gNode.getNode(0));
    }

    public Type visitMaxAggregate(GNode gNode) {
        return (Type)this.dispatch(gNode.getNode(0));
    }

    public Type visitCountAggregate(GNode gNode) {
        IntegerT integerT = NumberT.S_INT;
        this.makeSet(integerT);
        return integerT;
    }

    public Type visitLocationSpecifier(GNode gNode) {
        InternalT internalT;
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        boolean bl = this.unify(type2, internalT = new InternalT("location"));
        if (!bl) {
            this.runtime.error("Location Specifier variable previously defined as a different type", gNode);
            return ErrorT.TYPE;
        }
        return internalT;
    }

    public Type visitAggregateIdentifier(GNode gNode) {
        String string = gNode.getString(0);
        Type type2 = (Type)this.table.current().lookup(string);
        if (type2 != null) {
            if ("aggregate".equals(type2.getName())) {
                return type2;
            }
            this.runtime.error("Aggregate Identifier previously defined as a different type", gNode);
            return ErrorT.TYPE;
        }
        type2 = new InternalT("aggregate");
        this.makeSet(type2);
        this.table.current().define(string, type2);
        return type2;
    }

    public Type visitVariableIdentifier(GNode gNode) {
        String string = gNode.getString(0);
        Type type2 = (Type)this.table.current().lookup(string);
        if (type2 != null) {
            return type2;
        }
        type2 = new Parameter(this.newTempTypeName());
        this.makeSet(type2);
        this.table.current().define(string, type2);
        return type2;
    }

    public Type visitUnnamedIdentifier(GNode gNode) {
        Wildcard wildcard = new Wildcard();
        this.makeSet(wildcard);
        return wildcard;
    }

    public Type visitFloatingPointConstant(GNode gNode) {
        FloatT floatT = NumberT.FLOAT;
        this.makeSet(floatT);
        return floatT;
    }

    public Type visitIntegerConstant(GNode gNode) {
        IntegerT integerT = NumberT.S_INT;
        this.makeSet(integerT);
        return integerT;
    }

    public Type visitStringConstant(GNode gNode) {
        InternalT internalT = new InternalT("string constant");
        this.makeSet(internalT);
        return internalT;
    }

    public Type visitBooleanConstant(GNode gNode) {
        BooleanT booleanT = new BooleanT();
        this.makeSet(booleanT);
        return booleanT;
    }

    public Type visitInfinityConstant(GNode gNode) {
        IntegerT integerT = NumberT.S_INT;
        this.makeSet(integerT);
        return integerT;
    }

    public Type visitTupleDeclaration(GNode gNode) {
        Node node2;
        String string = gNode.getNode(0).getString(0);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Node node2 : gNode.getList(1)) {
            Type type2 = (Type)this.dispatch(node2);
            arrayList.add(type2);
        }
        TupleT tupleT = new TupleT(string, arrayList);
        node2 = (Type)this.table.root().lookup(string);
        if (null == node2) {
            this.table.root().define(string, tupleT);
        } else {
            boolean bl = this.unify(tupleT, (Type)node2);
            if (!bl) {
                if (string.equals("periodic")) {
                    this.runtime.warning("periodic tuple previously defined with different type.", gNode);
                } else {
                    this.runtime.error("Tuple " + string + " previously defined " + "with different type", gNode);
                    return ErrorT.TYPE;
                }
            }
        }
        return tupleT;
    }

    public Type visitFunctionDeclaration(GNode gNode) {
        Node node2;
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        this.makeSet(type2);
        String string = gNode.getString(1);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        if (gNode.getList(2) != null) {
            for (Node node2 : gNode.getList(2)) {
                Type type3 = (Type)this.dispatch(node2);
                arrayList.add(type3);
            }
        }
        FunctionT functionT = new FunctionT(type2, arrayList, false);
        node2 = (Type)this.table.root().lookup(string);
        if (null == node2) {
            this.table.root().define(string, functionT);
        } else {
            boolean bl = this.unify((Type)node2, functionT);
            if (!bl) {
                this.runtime.error("Function previously defined with a different type", gNode);
                return ErrorT.TYPE;
            }
        }
        return type2;
    }

    public Type visitNullConstant(GNode gNode) {
        VoidT voidT = new VoidT();
        voidT.annotate().constant(NullReference.NULL);
        this.makeSet(voidT);
        return voidT;
    }

    public Type visitLocationConstant(GNode gNode) {
        InternalT internalT = new InternalT("location");
        this.makeSet(internalT);
        return internalT;
    }

    public Type visitLocationType(GNode gNode) {
        InternalT internalT = new InternalT("location");
        this.makeSet(internalT);
        return internalT;
    }

    public Type visitIntType(GNode gNode) {
        IntegerT integerT = NumberT.S_INT;
        this.makeSet(integerT);
        return integerT;
    }

    public Type visitFloatType(GNode gNode) {
        FloatT floatT = NumberT.FLOAT;
        this.makeSet(floatT);
        return floatT;
    }

    public Type visitStringType(GNode gNode) {
        InternalT internalT = new InternalT("string constant");
        this.makeSet(internalT);
        return internalT;
    }

    public Type visitBooleanType(GNode gNode) {
        BooleanT booleanT = new BooleanT();
        this.makeSet(booleanT);
        return booleanT;
    }

    public Type visitVoidType(GNode gNode) {
        VoidT voidT = new VoidT();
        this.makeSet(voidT);
        return voidT;
    }
}

