/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.overlog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.lang.overlog.MaterializationChecker;
import xtc.lang.overlog.Normalizer;
import xtc.lang.overlog.OverlogJavaFactory;
import xtc.lang.overlog.TypeAnalyzer;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
extends Visitor {
    private Node overlogAST;
    private final OverlogJavaFactory factory = new OverlogJavaFactory();
    private Set<String> materialized;
    private Set<String> tupleNames;
    private Node tableInitializerBody;
    private SymbolTable table;
    private SymbolTable mapping;
    private SymbolTable normalizedTypes;
    private final Runtime runtime;
    private static int keyTmp = 0;
    private Node currentTuple;
    private int currentTupleTermNum;
    private Map<String, GNode> forest;
    private Node currentBlock;
    private Node processTopLevel;
    private int watchNum;
    private int periodicNum;
    private Node classBody;
    private String thePackage;
    private String olgName;
    private int aggIndex;

    public Transformer(GNode gNode, SymbolTable symbolTable, Runtime runtime, String string, String string2) {
        this.runtime = runtime;
        this.overlogAST = gNode;
        this.table = symbolTable;
        this.thePackage = string;
        this.olgName = string2;
        this.tableInitializerBody = null;
        this.forest = new HashMap<String, GNode>();
        this.watchNum = 0;
        this.periodicNum = 0;
    }

    public void run() {
        this.table = new SymbolTable();
        this.overlogAST = new TypeAnalyzer(this.runtime).analyze(this.overlogAST, this.table);
        this.mapping = new SymbolTable();
        this.normalizedTypes = new SymbolTable();
        this.overlogAST = new Normalizer().analyze(this.overlogAST, this.mapping, this.table, this.normalizedTypes);
        this.materialized = new HashSet<String>();
        this.tupleNames = new HashSet<String>();
        new MaterializationChecker().analyze(this.overlogAST, this.tupleNames, this.materialized);
        this.makeTupleClasses();
        this.createExecutable();
        this.createInitializer();
        this.registerMarshallers();
        this.addExitSubstriber();
        this.dispatch(this.overlogAST);
    }

    public Map<String, GNode> getTransformedAST() {
        return this.forest;
    }

    public void visit(GNode gNode) {
        for (Object object : gNode) {
            if (object instanceof Node) {
                this.dispatch((Node)object);
                continue;
            }
            if (!Node.isList(object)) continue;
            this.iterate(Node.toList(object));
        }
    }

    public void visitClauses(GNode gNode) {
        for (Node node : gNode.getList(0)) {
            this.dispatch(node);
        }
    }

    public void visitGenericFact(GNode gNode) {
        Node node = gNode.getNode(0);
        Node node2 = this.factory.tableAddTuple(GNode.create("StringLiteral", "\"" + node.getNode(0).getString(0) + "\""), GNode.create("PrimaryIdentifier", "Tuple" + node.getNode(0).getString(0)));
        GNode gNode2 = GNode.create("Arguments");
        gNode2 = GNode.ensureVariable(gNode2);
        for (Node node3 : node.getList(1)) {
            gNode2.add(this.dispatch(node3));
        }
        node2.getNode(0).getNode(3).getNode(0).set(3, gNode2);
        this.tableInitializerBody.add(node2);
    }

    public void visitRule(GNode gNode) {
        String string = "unknown";
        if ("RuleIdentifier".equals(gNode.getNode(0).getName())) {
            string = gNode.getNode(0).getString(0);
            this.mapping.enter(string);
            this.table.enter(string);
            this.normalizedTypes.enter(string);
        }
        boolean bl = false;
        Object object = null;
        for (Object object2 : gNode.getList(3)) {
            if (!"Tuple".equals(((Node)object2).getName()) || this.materialized.contains(((Node)object2).getNode(0).getString(0))) continue;
            bl = true;
            object = object2;
        }
        if (bl) {
            this.createEventHandler(gNode, (Node)object, "");
        } else {
            int n = 0;
            for (Node node : gNode.getList(3)) {
                if (!"Tuple".equals(node.getName())) continue;
                this.createEventHandler(gNode, node, Integer.toString(n));
                ++n;
            }
        }
        this.mapping.exit();
        this.table.exit();
        this.normalizedTypes.exit();
    }

    public void visitTuple(GNode gNode) {
        String string = gNode.getNode(0).getString(0);
        if (this.materialized.contains(string)) {
            Node node = this.factory.joinLoop(gNode.getNode(0).getString(0), GNode.create("StringLiteral", "\"" + string + "\""));
            Node node2 = node.getNode(1);
            node2 = GNode.ensureVariable((GNode)node2);
            node.set(1, node2);
            this.currentBlock.add(node);
            this.currentBlock = node2;
        }
    }

    public void visitMaterialization(GNode gNode) {
        Node node4;
        Node node2 = this.factory.keys("keys" + keyTmp);
        this.tableInitializerBody.add(node2);
        Node node3 = node2.getNode(2).getNode(0).getNode(2).getNode(3);
        node3 = GNode.ensureVariable((GNode)node3);
        node2.getNode(2).getNode(0).getNode(2).set(3, node3);
        for (Node node4 : gNode.getNode(3).getList(0)) {
            node3.add(this.dispatch(node4));
        }
        GNode gNode2 = GNode.create("StringLiteral", "\"" + gNode.getNode(0).getString(0) + "\"");
        node4 = (Node)this.dispatch(gNode.getNode(1));
        Node node5 = (Node)this.dispatch(gNode.getNode(2));
        GNode gNode3 = GNode.create("PrimaryIdentifier", "keys" + keyTmp);
        this.tableInitializerBody.add(this.factory.tableInit(gNode2, node4, node5, gNode3));
        ++keyTmp;
    }

    public void visitTupleObservation(GNode gNode) {
        String string = gNode.getNode(0).getString(0);
        this.tableInitializerBody.add(this.factory.watchNew("watch" + this.watchNum));
        this.tableInitializerBody.add(this.factory.watchSub(GNode.create("StringLiteral", "\"" + string + "\""), GNode.create("PrimaryIdentifier", "watch" + this.watchNum)));
        ++this.watchNum;
    }

    public Node visitExpression(GNode gNode) {
        Type type2 = (Type)this.table.current().lookup(gNode.getNode(0).getString(0));
        GNode gNode2 = null;
        if (type2 != null) {
            if (type2.isInteger()) {
                gNode2 = GNode.create("PrimitiveType", "int");
            } else if (type2.isBoolean()) {
                gNode2 = GNode.create("PrimitiveType", "boolean");
            } else if (type2.isFloat()) {
                gNode2 = GNode.create("PrimitiveType", "float");
            } else if (type2.isInternal()) {
                if ("string constant".equals(type2.getName())) {
                    gNode2 = GNode.create("QualifiedIdentifier", "String");
                } else if ("location".equals(type2.getName())) {
                    gNode2 = GNode.create("QualifiedIdentifier", "NetAddr");
                }
            }
        }
        this.currentBlock.add(this.factory.varDecl(gNode2, gNode.getNode(0).getString(0)));
        return GNode.create("ExpressionStatement", GNode.create("Expression", this.dispatch(gNode.getNode(0)), "=", this.dispatch(gNode.getNode(2))));
    }

    public Node visitLogicalOrExpression(GNode gNode) {
        return GNode.create("LogicalOrExpression", this.dispatch(gNode.getNode(0)), gNode.getString(1), this.dispatch(gNode.getNode(2)));
    }

    public Node visitLogicalAndExpression(GNode gNode) {
        return GNode.create("LogicalAndExpression", this.dispatch(gNode.getNode(0)), gNode.getString(1), this.dispatch(gNode.getNode(2)));
    }

    public Node visitEqualityExpression(GNode gNode) {
        if ("==".equals(gNode.getString(1))) {
            return this.factory.equals((Node)this.dispatch(gNode.getNode(0)), (Node)this.dispatch(gNode.getNode(2)));
        }
        return this.factory.notEquals((Node)this.dispatch(gNode.getNode(0)), (Node)this.dispatch(gNode.getNode(2)));
    }

    public Node visitRelationalExpression(GNode gNode) {
        return GNode.create("RelationalExpression", this.dispatch(gNode.getNode(0)), gNode.getString(1), this.dispatch(gNode.getNode(2)));
    }

    public Node visitShiftExpression(GNode gNode) {
        return GNode.create("ShiftExpression", this.dispatch(gNode.getNode(0)), gNode.getString(1), this.dispatch(gNode.getNode(2)));
    }

    public Node visitAdditiveExpression(GNode gNode) {
        return GNode.create("AdditiveExpression", this.dispatch(gNode.getNode(0)), gNode.getString(1), this.dispatch(gNode.getNode(2)));
    }

    public Node visitMultiplicativeExpression(GNode gNode) {
        return GNode.create("MultiplicativeExpression", this.dispatch(gNode.getNode(0)), gNode.getString(1), this.dispatch(gNode.getNode(2)));
    }

    public Node visitLogicalNegationExpression(GNode gNode) {
        return GNode.create("LogicalNegationExpression", this.dispatch(gNode.getNode(0)));
    }

    public Node visitInclusiveExpression(GNode gNode) {
        return null;
    }

    public Node visitRangeExpression(GNode gNode) {
        return null;
    }

    public Node visitPostfixExpression(GNode gNode) {
        Object object;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (gNode.size() > 1 && ((Node)(object = gNode.getNode(1))).size() > 1) {
            for (Node node : ((Node)object).getList(0)) {
                arrayList.add((Node)this.dispatch(node));
            }
        }
        if (((String)(object = gNode.getNode(0).getString(0))).startsWith("f_")) {
            object = ((String)object).replace("f_", "");
        }
        return this.factory.functionCall((String)object, arrayList);
    }

    public Node visitPrimaryExpression(GNode gNode) {
        return (Node)this.dispatch(gNode.getNode(0));
    }

    public Node visitMinAggregate(GNode gNode) {
        Node node = (Node)this.dispatch(gNode.getNode(0));
        String string = node.getNode(1).getNode(0).getString(0);
        Node node2 = this.aggGetTermType(node);
        Node node3 = this.tupleAccess(node2, GNode.create("PrimaryIdentifier", node.getNode(1).getNode(0).getString(0)), GNode.create("IntegerLiteral", Integer.toString(this.aggIndex)));
        this.classBody.add(this.factory.aggMinFunction(string, GNode.create("PrimaryIdentifier", string), node2, node3));
        return (Node)this.dispatch(gNode.getNode(0));
    }

    public Node visitMaxAggregate(GNode gNode) {
        Node node = (Node)this.dispatch(gNode.getNode(0));
        String string = node.getNode(1).getNode(0).getString(0);
        Node node2 = this.aggGetTermType(node);
        Node node3 = this.tupleAccess(node2, GNode.create("PrimaryIdentifier", node.getNode(1).getNode(0).getString(0)), GNode.create("IntegerLiteral", Integer.toString(this.aggIndex)));
        this.classBody.add(this.factory.aggMaxFunction(string, GNode.create("PrimaryIdentifier", string), node2, node3));
        return (Node)this.dispatch(gNode.getNode(0));
    }

    public Node visitCountAggregate(GNode gNode) {
        return GNode.create("IntegerLiteral", "1");
    }

    private Node aggGetTermType(Node node) {
        GNode gNode = null;
        if (this.currentTuple != null) {
            Type type2 = (Type)this.table.root().lookup(this.currentTuple.getNode(0).getString(0));
            List<Type> list = ((TupleT)type2).getTypes();
            Type type3 = list.get(this.currentTupleTermNum);
            if (type3.isInteger()) {
                gNode = GNode.create("QualifiedIdentifier", "Integer");
            } else if (type3.isBoolean()) {
                gNode = GNode.create("QualifiedIdentifier", "Boolean");
            } else if (type3.isFloat()) {
                gNode = GNode.create("QualifiedIdentifier", "Float");
            } else if (type3.isInternal()) {
                if ("string constant".equals(type3.getName())) {
                    gNode = GNode.create("QualifiedIdentifier", "String");
                } else if ("location".equals(type3.getName())) {
                    gNode = GNode.create("QualifiedIdentifier", "NetAddr");
                }
            }
        }
        return gNode;
    }

    public Node visitAggregateIdentifier(GNode gNode) {
        return null;
    }

    public Node visitLocationSpecifier(GNode gNode) {
        return (Node)this.dispatch(gNode.getNode(0));
    }

    public Node visitVariableIdentifier(GNode gNode) {
        if (this.mapping.current().isDefined(gNode.getString(0))) {
            Node node = (Node)this.mapping.current().lookupLocally(gNode.getString(0));
            while (!"CastExpression".equals(node.getName()) && this.mapping.current().isDefined(node.getString(0)) && !node.getString(0).equals(gNode.getString(0))) {
                node = (Node)this.mapping.current().lookupLocally(node.getString(0));
            }
            if ("CastExpression".equals(node.getName())) {
                return node;
            }
        }
        return GNode.create("PrimaryIdentifier", gNode.getString(0));
    }

    public Node visitFloatingPointConstant(GNode gNode) {
        return GNode.create("FloatingPointLiteral", gNode.getString(0) + "f");
    }

    public Node visitIntegerConstant(GNode gNode) {
        return GNode.create("IntegerLiteral", gNode.getString(0));
    }

    public Node visitStringConstant(GNode gNode) {
        return GNode.create("StringLiteral", gNode.getString(0));
    }

    public Node visitBooleanConstant(GNode gNode) {
        return GNode.create("BooleanLiteral", gNode.getString(0));
    }

    public Node visitInfinityConstant(GNode gNode) {
        return GNode.create("IntegerLiteral", "Integer.MAX_VALUE");
    }

    public Node visitNullConstant(GNode gNode) {
        return GNode.create("NullLiteral");
    }

    public Node visitUnnamedIdentifier(GNode gNode) {
        if (this.currentTuple != null) {
            Type type2 = (Type)this.table.root().lookup(this.currentTuple.getNode(0).getString(0));
            List<Type> list = ((TupleT)type2).getTypes();
            Type type3 = list.get(this.currentTupleTermNum);
            if (type3.isInteger()) {
                return GNode.create("IntegerLiteral", "0");
            }
            if (type3.isBoolean()) {
                return GNode.create("BooleanLiteral", "true");
            }
            if (type3.isFloat()) {
                return GNode.create("FloatLiteral", "0.0f");
            }
            if (type3.isInternal()) {
                if ("string constant".equals(type3.getName())) {
                    return GNode.create("NullLiteral");
                }
                if ("location".equals(type3.getName())) {
                    return GNode.create("NullLiteral");
                }
            }
        }
        return GNode.create("NullLiteral");
    }

    public Node visitLocationConstant(GNode gNode) {
        return this.factory.netAddr(GNode.create("StringLiteral", "\"" + gNode.getString(0) + "\""), GNode.create("IntegerLiteral", gNode.getString(1)));
    }

    private Node makeSkeleton() {
        GNode gNode = GNode.create("CompilationUnit", 8);
        gNode.add(this.makePackage(this.thePackage));
        gNode.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "overlogRuntime", "*"), null));
        return gNode;
    }

    private void makeTupleClasses() {
        SymbolTable.Scope scope = this.table.root();
        Iterator<String> iterator = scope.symbols();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Type type2 = (Type)scope.lookup(string);
            if (!type2.isTuple()) continue;
            this.makeTupleClass(string, type2);
        }
    }

    private void makeTupleClass(String string, Type type2) {
        List<Type> list = type2.toTuple().getTypes();
        GNode gNode = GNode.cast(this.makeSkeleton());
        this.addImportsToTupleClass(gNode);
        Node node = this.factory.tupleClass("Tuple" + string, GNode.create("IntegerLiteral", Integer.toString(list.size())), GNode.create("StringLiteral", "\"" + string + "\""));
        gNode.add(node);
        this.forest.put("Tuple" + string, gNode);
        Node node2 = node.getNode(5).getNode(3);
        Node node3 = node2.getNode(3);
        node3 = GNode.ensureVariable((GNode)node3);
        node2.set(3, node3);
        Node node4 = node2.getNode(5);
        node4 = GNode.ensureVariable((GNode)node4);
        node2.set(5, node4);
        Node node5 = this.factory.tupleReadExternal();
        Node node6 = node5.getNode(7);
        node6 = GNode.ensureVariable((GNode)node6);
        node5.set(7, node6);
        Node node7 = this.factory.tupleWriteExternal();
        Node node8 = node7.getNode(7);
        node8 = GNode.ensureVariable((GNode)node8);
        node7.set(7, node8);
        Node node9 = this.factory.tupleToString();
        Node node10 = node9.getNode(7);
        node10 = GNode.ensureVariable((GNode)node10);
        node9.set(7, node10);
        Node node11 = node.getNode(5);
        node11 = GNode.ensureVariable((GNode)node11);
        node.set(5, node11);
        node11.add(node5);
        node11.add(node7);
        node11.add(node9);
        node10.add(this.factory.appendOpen());
        node6.add(this.factory.newID());
        node6.add(this.factory.readID());
        node8.add(this.factory.writeID());
        GNode gNode2 = GNode.create("Arguments");
        int n = 0;
        int n2 = list.size();
        for (Type type3 : list) {
            String string2 = new String("v" + n);
            if (type3.isInteger()) {
                this.addIntegerTerm(string2, n, n2, gNode2, node3, node4, node8, node6, node10);
            } else if (type3.isBoolean()) {
                this.addBooleanTerm(string2, n, n2, gNode2, node3, node4, node8, node6, node10);
            } else if (type3.isFloat()) {
                this.addFloatTerm(string2, n, n2, gNode2, node3, node4, node8, node6, node10);
            } else if (type3.isInternal()) {
                if ("string constant".equals(type3.getName())) {
                    this.addStringTerm(string2, n, n2, gNode2, node3, node4, node8, node6, node10);
                } else if ("location".equals(type3.getName())) {
                    this.addLocationTerm(string2, n, n2, gNode2, node3, node4, node8, node6, node10);
                }
            }
            ++n;
        }
        node6.add(GNode.create("ReturnStatement", GNode.create("NewClassExpression", null, null, GNode.create("QualifiedIdentifier", "Tuple" + string), gNode2, null)));
        node10.add(this.factory.appendClose());
        node10.add(this.factory.returnString());
    }

    private void addImportsToTupleClass(Node node) {
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "overlogRuntime", "Tuple"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "overlogRuntime", "Marshaller"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "overlogRuntime", "NetAddr"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "io", "IOException"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "io", "DataInputStream"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "io", "DataOutputStream"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "lang", "StringBuffer"), null));
    }

    private void addIntegerTerm(String string, int n, int n2, GNode gNode, Node node, Node node2, Node node3, Node node4, Node node5) {
        node.add(this.makeParameter(GNode.create("PrimitiveType", "int"), string));
        node2.add(this.factory.termAssignInteger(GNode.create("IntegerLiteral", Integer.toString(n)), GNode.create("PrimaryIdentifier", string)));
        node3.add(this.factory.writeInt(GNode.create("IntegerLiteral", Integer.toString(n))));
        node4.add(this.factory.readInt(string));
        gNode.add(GNode.create("PrimaryIdentifier", string));
        node5.add(this.factory.appendInt(GNode.create("IntegerLiteral", Integer.toString(n))));
        if (n <= n2 - 2) {
            node5.add(this.factory.appendComma());
        }
    }

    private void addBooleanTerm(String string, int n, int n2, GNode gNode, Node node, Node node2, Node node3, Node node4, Node node5) {
        node.add(this.makeParameter(GNode.create("PrimitiveType", "boolean"), string));
        node2.add(this.factory.termAssignBoolean(GNode.create("IntegerLiteral", Integer.toString(n)), GNode.create("PrimaryIdentifier", string)));
        node3.add(this.factory.writeBoolean(GNode.create("IntegerLiteral", Integer.toString(n))));
        node4.add(this.factory.readBoolean(string));
        gNode.add(GNode.create("PrimaryIdentifier", string));
        node5.add(this.factory.appendBoolean(GNode.create("IntegerLiteral", Integer.toString(n))));
        if (n <= n2 - 2) {
            node5.add(this.factory.appendComma());
        }
    }

    private void addLocationTerm(String string, int n, int n2, GNode gNode, Node node, Node node2, Node node3, Node node4, Node node5) {
        node.add(this.makeParameter(GNode.create("QualifiedIdentifier", "NetAddr"), string));
        node2.add(this.factory.termAssignAddress(GNode.create("IntegerLiteral", Integer.toString(n)), GNode.create("PrimaryIdentifier", string)));
        node3.add(this.factory.writeAddress(GNode.create("IntegerLiteral", Integer.toString(n))));
        node4.add(this.factory.netAddrNew(new String("addr" + n)));
        gNode.add(GNode.create("PrimaryIdentifier", "addr" + n));
        node4.add(this.factory.readAddress(GNode.create("PrimaryIdentifier", "addr" + n)));
        node5.add(this.factory.appendAddress(GNode.create("IntegerLiteral", Integer.toString(n))));
        if (n <= n2 - 2) {
            node5.add(this.factory.appendComma());
        }
    }

    private void addStringTerm(String string, int n, int n2, GNode gNode, Node node, Node node2, Node node3, Node node4, Node node5) {
        node.add(this.makeParameter(GNode.create("QualifiedIdentifier", "String"), string));
        node2.add(this.factory.termAssignString(GNode.create("IntegerLiteral", Integer.toString(n)), GNode.create("PrimaryIdentifier", string)));
        node3.add(this.factory.writeString(GNode.create("IntegerLiteral", Integer.toString(n))));
        node4.add(this.factory.readString(string));
        gNode.add(GNode.create("PrimaryIdentifier", string));
        node5.add(this.factory.appendString(GNode.create("IntegerLiteral", Integer.toString(n))));
        if (n <= n2 - 2) {
            node5.add(this.factory.appendComma());
        }
    }

    private void addFloatTerm(String string, int n, int n2, GNode gNode, Node node, Node node2, Node node3, Node node4, Node node5) {
        node.add(this.makeParameter(GNode.create("PrimitiveType", "float"), string));
        node2.add(this.factory.termAssignFloat(GNode.create("IntegerLiteral", Integer.toString(n)), GNode.create("PrimaryIdentifier", string)));
        node3.add(this.factory.writeFloat(GNode.create("IntegerLiteral", Integer.toString(n))));
        node4.add(this.factory.readFloat(string));
        gNode.add(GNode.create("PrimaryIdentifier", string));
        node5.add(this.factory.appendFloat(GNode.create("IntegerLiteral", Integer.toString(n))));
        if (n <= n2 - 2) {
            node5.add(this.factory.appendComma());
        }
    }

    private Node makeParameter(Node node, String string) {
        return GNode.create("FormalParameter", GNode.create("Modifiers"), GNode.create("Type", node, null), null, string, null);
    }

    private Node makePackage(String string) {
        String[] stringArray = string.split("\\.");
        GNode gNode = GNode.create("QualifiedIdentifier");
        for (String string2 : stringArray) {
            gNode.add(string2);
        }
        return GNode.create("PackageDeclaration", null, gNode);
    }

    private void createInitializer() {
        Node node = this.factory.tableInitializerClass(this.olgName);
        this.tableInitializerBody = node.getNode(5).getNode(4).getNode(7);
        this.tableInitializerBody = GNode.ensureVariable((GNode)this.tableInitializerBody);
        node.getNode(5).getNode(4).set(7, this.tableInitializerBody);
        GNode gNode = GNode.cast(this.makeSkeleton());
        this.forest.put(this.olgName, gNode);
        gNode.add(node);
    }

    private void registerMarshallers() {
        for (String string : this.tupleNames) {
            this.tableInitializerBody.add(this.factory.registerMarshaller(GNode.create("StringLiteral", "\"" + string + "\""), GNode.create("PrimaryIdentifier", "Tuple" + string)));
        }
    }

    private void addExitSubstriber() {
        this.tableInitializerBody.add(this.factory.exitNew("exit"));
        this.tableInitializerBody.add(this.factory.exitSub(GNode.create("StringLiteral", "\"exit\""), GNode.create("PrimaryIdentifier", "exit")));
    }

    private void createExecutable() {
        GNode gNode = GNode.cast(this.makeSkeleton());
        this.forest.put("RunOLG", gNode);
        gNode.add(this.factory.executableClass(GNode.create("PrimaryIdentifier", this.olgName)));
    }

    private Node tupleAccess(Node node, Node node2, Node node3) {
        GNode gNode = GNode.create("Type", node, null);
        GNode gNode2 = GNode.create("Arguments", node3);
        GNode gNode3 = GNode.create("CallExpression", node2, null, "getTerm", gNode2);
        GNode gNode4 = GNode.create("CastExpression", gNode, gNode3);
        return gNode4;
    }

    private Node createActionTuple(GNode gNode) {
        GNode gNode2 = GNode.create("QualifiedIdentifier", "Tuple" + gNode.getNode(2).getNode(0).getString(0));
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.currentTuple = gNode.getNode(2);
        this.currentTupleTermNum = 0;
        for (Node node : gNode.getNode(2).getList(1)) {
            if ("CountAggregate".equals(node.getName())) {
                arrayList.add((Node)this.dispatch(node));
            } else {
                Node node2 = (Node)this.dispatch(node);
                arrayList.add(node2);
            }
            ++this.currentTupleTermNum;
        }
        this.currentTuple = null;
        Object object = null;
        object = this.materialized.contains(gNode.getNode(2).getNode(0).getString(0)) ? (gNode.getString(1) == null ? this.factory.tableNew(gNode2, arrayList) : this.factory.tableDelete(gNode2, arrayList)) : this.factory.tupleNew(gNode2, arrayList);
        return object;
    }

    private Node createActionTupleForCount(GNode gNode) {
        GNode gNode2 = GNode.create("QualifiedIdentifier", "Tuple" + gNode.getNode(2).getNode(0).getString(0));
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.currentTuple = gNode.getNode(2);
        this.currentTupleTermNum = 0;
        for (Node node : gNode.getNode(2).getList(1)) {
            if ("CountAggregate".equals(node.getName())) {
                arrayList.add(this.factory.countCall());
            } else {
                Node node2 = (Node)this.dispatch(node);
                if ("CastExpression".equals(node2.getName())) {
                    arrayList.add(this.tupleAccess(node2.getNode(0), GNode.create("PrimaryIdentifier", "t"), node2.getNode(1).getNode(3).getNode(0)));
                } else {
                    arrayList.add(node2);
                }
            }
            ++this.currentTupleTermNum;
        }
        this.currentTuple = null;
        Object object = null;
        object = this.materialized.contains(gNode.getNode(2).getNode(0).getString(0)) ? (gNode.getString(1) == null ? this.factory.tableNew(gNode2, arrayList) : this.factory.tableDelete(gNode2, arrayList)) : this.factory.tupleNew(gNode2, arrayList);
        return object;
    }

    private void addImportsToEventHandler(Node node) {
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "overlogRuntime", "EventHandler"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "overlogRuntime", "EventQueue"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "util", "Map"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "util", "List"), null));
        node.add(GNode.create("ImportDeclaration", null, GNode.create("QualifiedIdentifier", "java", "util", "ArrayList"), null));
    }

    protected void createEventHandlerReWrite(GNode gNode, GNode gNode2) {
        Node node;
        Node node2 = node = this.createActionTuple(gNode);
        for (Node node3 : gNode.getList(3)) {
            if ("Tuple".equals(node3.getName()) || "Expression".equals(node3.getName())) continue;
            node2 = this.factory.conditional((Node)this.dispatch(node3), node2);
        }
        if (node2 == node) {
            node2 = GNode.create("Block");
        }
        for (Node node3 : gNode.getList(3)) {
            if ("Tuple".equals(node3.getName()) || !"Expression".equals(node3.getName())) continue;
            node2.add(this.dispatch(node3));
        }
    }

    private void createEventHandler(GNode gNode, Node node, String string) {
        Object object;
        Object object22;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.aggIndex = 0;
        int n = 0;
        for (Object object22 : gNode.getNode(2).getList(1)) {
            object = ((Node)object22).getName();
            if ("MinAggregate".equals(object)) {
                bl = true;
                this.aggIndex = n;
            } else if ("MaxAggregate".equals(object)) {
                bl2 = true;
                this.aggIndex = n;
            } else if ("CountAggregate".equals(object)) {
                bl3 = true;
                this.aggIndex = n;
            }
            ++n;
        }
        boolean bl4 = bl || bl2 || bl3;
        object22 = "EventHandler" + gNode.getNode(0).getString(0) + string;
        object = this.factory.eventHandlerClass((String)object22);
        this.classBody = ((Node)object).getNode(5);
        this.classBody = GNode.ensureVariable((GNode)this.classBody);
        ((Node)object).set(5, this.classBody);
        GNode gNode2 = GNode.cast(this.makeSkeleton());
        this.forest.put((String)object22, gNode2);
        this.addImportsToEventHandler(gNode2);
        gNode2.add(object);
        Node node2 = this.factory.eventHandlerProcess();
        node2 = GNode.ensureVariable((GNode)node2);
        this.classBody.add(node2);
        this.currentBlock = GNode.ensureVariable((GNode)node2.getNode(7));
        node2.set(7, this.currentBlock);
        this.processTopLevel = this.currentBlock;
        if (bl4) {
            this.currentBlock.add(this.factory.eventHandlerMatches());
        }
        this.currentBlock.add(this.factory.tupleAssign(node.getNode(0).getString(0)));
        String string2 = node.getNode(0).getString(0);
        if ("periodic".equals(string2)) {
            string2 = new String(string2 + this.periodicNum);
        }
        this.tableInitializerBody.add(this.factory.registerHandle(GNode.create("StringLiteral", "\"" + string2 + "\""), GNode.create("PrimaryIdentifier", object22)));
        for (Node node3 : gNode.getList(3)) {
            if (!"Tuple".equals(node3.getName())) continue;
            this.currentTuple = node3;
            if ("periodic".equals(node3.getNode(0).getString(0))) {
                this.createPeriodicTuple(node3);
                ++this.periodicNum;
            }
            if (node != node3) {
                this.dispatch(node3);
            }
            this.currentTuple = null;
        }
        for (Node node3 : gNode.getList(3)) {
            if ("Tuple".equals(node3.getName())) continue;
            if ("Expression".equals(node3.getName())) {
                this.currentBlock.add(this.dispatch(node3));
                continue;
            }
            GNode gNode3 = GNode.create("Block");
            this.currentBlock.add(GNode.create("ConditionalStatement", this.dispatch(node3), gNode3, null));
            this.currentBlock = gNode3;
        }
        Node node4 = this.createActionTuple(gNode);
        this.currentBlock.add(node4);
        if (bl || bl2) {
            this.currentBlock.add(this.factory.saveEvent());
            this.processTopLevel.add(this.factory.aggFunctionCall());
        } else if (bl3) {
            Node node3;
            node3 = this.createActionTupleForCount(gNode);
            this.currentBlock.add(this.factory.saveEvent());
            this.processTopLevel.add(node3);
            this.processTopLevel.add(this.factory.bufferEvent());
        } else {
            this.currentBlock.add(this.factory.bufferEvent());
        }
    }

    private void createPeriodicTuple(Node node) {
        String string = new String(node.getNode(0).getString(0) + this.periodicNum);
        Type type2 = (Type)this.table.root().lookup("periodic");
        this.makeTupleClass(string, type2);
        String string2 = ((Node)node.getList(1).get(1)).getString(0);
        String string3 = ((Node)node.getList(1).get(2)).getString(0);
        this.tableInitializerBody.add(this.factory.periodicNew("periodic" + this.periodicNum, GNode.create("StringLiteral", "Tupleperiodic" + this.periodicNum), GNode.create("IntegerLiteral", string2), GNode.create("IntegerLiteral", string3)));
        this.tableInitializerBody.add(this.factory.registerPeg(GNode.create("StringLiteral", "periodic" + this.periodicNum), GNode.create("IntegerLiteral", string2), GNode.create("IntegerLiteral", string3)));
    }
}

