/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.overlog;

import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;

public class OverlogPrinter
extends Visitor {
    protected final Printer printer;

    public OverlogPrinter(Printer printer) {
        this.printer = printer;
        printer.register(this);
    }

    public void visit(GNode gNode) {
        for (Object object : gNode) {
            if (object instanceof Node) {
                this.dispatch((Node)object);
                continue;
            }
            if (!Node.isList(object)) continue;
            this.iterate(Node.toList(object));
        }
    }

    public void visitRule(GNode gNode) {
        int n = 0;
        if (0 == gNode.getNode(0).getName().compareTo("RuleIdentifier")) {
            ++n;
            this.printer.p(gNode.getNode(0).getString(0) + " ");
        }
        if (gNode.getString(1) != null) {
            this.printer.p("delete ");
        }
        this.dispatch(gNode.getNode(++n));
        this.printer.p(" :- ");
        int n2 = gNode.getList(++n).size();
        for (Node node : gNode.getList(n)) {
            this.dispatch(node);
            if (--n2 <= 0) continue;
            this.printer.p(", ");
        }
        this.printer.pln(".");
    }

    public void visitMaterialization(GNode gNode) {
        int n = 0;
        this.printer.p("materialize(" + gNode.getNode(n).getString(0));
        ++n;
        while (n < 4) {
            this.printer.p(", ");
            this.dispatch(gNode.getNode(n));
            ++n;
        }
        this.printer.pln(").");
    }

    public void visitPrimaryKeys(GNode gNode) {
        this.printer.p("keys(");
        int n = gNode.getList(0).size();
        for (Node node : gNode.getList(0)) {
            this.dispatch(node);
            if (--n <= 0) continue;
            this.printer.p(", ");
        }
        this.printer.p(")");
    }

    public void visitTupleObservation(GNode gNode) {
        this.printer.pln("watch(" + gNode.getNode(0).getString(0) + ").");
    }

    public void visitFlowObservation(GNode gNode) {
        this.printer.pln("watchmod(" + gNode.getNode(0).getString(0) + ").");
    }

    public void visitExternalization(GNode gNode) {
        this.printer.pln("stage().");
    }

    public void visitGenericFact(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.pln(".");
    }

    public void visitExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" " + gNode.getString(1) + " ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitLogicalOrExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" || ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitLogicalAndExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" && ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitEqualityExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" " + gNode.getString(1) + " ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitRelationalExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" " + gNode.getString(1) + " ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitShiftExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" " + gNode.getString(1) + " ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitAdditiveExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" " + gNode.getString(1) + " ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitMultiplicativeExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" " + gNode.getString(1) + " ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitLogicalNegationExpression(GNode gNode) {
        this.printer.p("!");
        this.dispatch(gNode.getNode(0));
    }

    public void visitInclusiveExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p(" in ");
        this.dispatch(gNode.getNode(2));
    }

    public void visitRangeExpression(GNode gNode) {
        this.printer.p(gNode.getString(0) + " ");
        this.dispatch(gNode.getNode(1));
        this.printer.p(", ");
        this.dispatch(gNode.getNode(2));
        this.printer.p(" " + gNode.getString(3));
    }

    public void visitPostfixExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        if (gNode.size() > 0) {
            this.dispatch(gNode.getNode(1));
        }
    }

    public void visitArguments(GNode gNode) {
        this.printer.p("(");
        if (gNode.size() == 1) {
            int n = gNode.getList(0).size();
            for (Node node : gNode.getList(0)) {
                this.dispatch(node);
                if (--n <= 0) continue;
                this.printer.p(", ");
            }
        }
        this.printer.p(")");
    }

    public void visitVectorExpression(GNode gNode) {
        this.printer.p("[");
        this.printer.p("]");
    }

    public void visitMatrixExpression(GNode gNode) {
        this.printer.p("{");
        this.printer.p("}");
    }

    public void visitMatrixEntry(GNode gNode) {
        this.printer.p("{");
        this.printer.p("}");
    }

    public void visitParenthesizedExpression(GNode gNode) {
        this.printer.p("(");
        this.dispatch(gNode.getNode(0));
        this.printer.p(")");
    }

    public void visitTuple(GNode gNode) {
        this.printer.p(gNode.getNode(0).getString(0) + "(");
        int n = gNode.getList(1).size();
        for (Node node : gNode.getList(1)) {
            this.dispatch(node);
            if (--n <= 0) continue;
            this.printer.p(",");
        }
        this.printer.p(")");
    }

    public void visitAggregate(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        this.printer.p("<");
        if (gNode.get(1) instanceof String) {
            this.printer.p("*");
        } else {
            this.dispatch(gNode.getNode(1));
        }
        this.printer.p(">");
    }

    public void visitLocationIdentifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitFunctionIdentifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitAggregateIdentifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitVariableIdentifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitUnnamedIdentifier(GNode gNode) {
        this.printer.p("_");
    }

    public void visitFloatingPointConstant(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitIntegerConstant(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitStringConstant(GNode gNode) {
        this.printer.p("\"" + gNode.getString(0) + "\"");
    }

    public void visitBooleanConstant(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitInfinityConstant(GNode gNode) {
        this.printer.p("infinity");
    }

    public void visitNullConstant(GNode gNode) {
        this.printer.p("null");
    }

    public void visitLocationConstant(GNode gNode) {
        this.printer.p(gNode.getString(0) + ":" + gNode.getString(1));
    }
}

