/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.overlog;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import xtc.lang.JavaPrinter;
import xtc.lang.overlog.ConcurrencyAnalyzer;
import xtc.lang.overlog.OverlogPrinter;
import xtc.lang.overlog.Parser;
import xtc.lang.overlog.Transformer;
import xtc.lang.overlog.TypeAnalyzer;
import xtc.parser.ParseException;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.TypePrinter;
import xtc.util.SymbolTable;
import xtc.util.Tool;

public class Overlog
extends Tool {
    public String getName() {
        return "xtc Overlog Driver";
    }

    public String getCopy() {
        return "(C) 2004-2008 Robert Grimm and New York University";
    }

    public void init() {
        super.init();
        this.runtime.bool("optionTypeAnalyze", "optionTypeAnalyze", false, "Analyze the program's AST.").bool("optionConcurrency", "optionConcurrency", false, "Augment the program's AST with concurrency meta data.").word("o", "optionOutput", false, "Specify the base name of the generated java source code.").word("package", "package", false, "Specify the package of the generated code.").word("olgName", "olgName", false, "Specify the name of the main OLG class in the generated code.").bool("generateJava", "generateJava", false, "Output the result of the Overlog to Java source transformation.").bool("printAST", "printAST", false, "Print the program's AST in generic form.").bool("printSource", "printSource", false, "Print the program's AST in source form.").bool("printSymbolTable", "printSymbolTable", false, "Print the program's symbol table.");
    }

    public Node parse(Reader reader, File file) throws IOException, ParseException {
        Parser parser = new Parser(reader, file.toString(), (int)file.length());
        return (Node)parser.value(parser.pProgram(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Node node) {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3 = (String)this.runtime.getValue("optionOutput");
        if (null == string3) {
            string3 = "./generated/";
        }
        if (null == (string2 = (String)this.runtime.getValue("package"))) {
            string2 = "overlogRuntime";
        }
        if (null == (string = (String)this.runtime.getValue("olgName"))) {
            string = "TestOLG";
        }
        if (this.runtime.test("optionTypeAnalyze")) {
            object2 = new SymbolTable();
            node = new TypeAnalyzer(this.runtime).analyze(node, (SymbolTable)object2);
            if (this.runtime.test("printSymbolTable")) {
                object = this.runtime.console().visitor();
                new TypePrinter(this.runtime.console());
                try {
                    ((SymbolTable)object2).root().dump(this.runtime.console());
                }
                finally {
                    this.runtime.console().register((Visitor)object);
                }
                this.runtime.console().flush();
            }
        }
        if (this.runtime.test("generateJava")) {
            object2 = null;
            object = new SymbolTable();
            object2 = new Transformer((GNode)node, (SymbolTable)object, this.runtime, string2, string);
            ((Transformer)object2).run();
            Map<String, GNode> map = ((Transformer)object2).getTransformedAST();
            for (String string4 : map.keySet()) {
                GNode gNode = map.get(string4);
                File file = new File(string3);
                file.mkdirs();
                File file2 = new File(file, string4 + ".java");
                Printer printer = null;
                try {
                    printer = new Printer(new PrintWriter(new BufferedWriter(new FileWriter(file2))));
                }
                catch (IOException iOException) {
                    if (null == iOException.getMessage()) {
                        this.runtime.error(file2.toString() + ": I/O error");
                    } else {
                        this.runtime.error(file2.toString() + ": " + iOException.getMessage());
                    }
                    return;
                }
                new JavaPrinter(printer).dispatch(gNode);
                printer.flush();
                printer.close();
            }
        }
        if (this.runtime.test("optionConcurrency")) {
            node = new ConcurrencyAnalyzer(this.runtime).analyze(node);
        }
        if (this.runtime.test("printAST")) {
            this.runtime.console().format(node).pln().flush();
        }
        if (this.runtime.test("printSource")) {
            new OverlogPrinter(this.runtime.console()).dispatch(node);
            this.runtime.console().pln().flush();
        }
    }

    public static void main(String[] stringArray) {
        new Overlog().run(stringArray);
    }
}

