/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import xtc.lang.CAnalyzer;
import xtc.lang.JavaEntities;
import xtc.lang.JavaTypeConverter;
import xtc.lang.JavaUnitTests;
import xtc.lang.jeannie.Analyzer;
import xtc.lang.jeannie.AstSimplifier;
import xtc.lang.jeannie.CodeGenerator;
import xtc.lang.jeannie.JeannieParser;
import xtc.lang.jeannie.JeanniePrinter;
import xtc.parser.Result;
import xtc.parser.SemanticValue;
import xtc.tree.GNode;
import xtc.tree.LineMarker;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.C;
import xtc.type.ClassOrInterfaceT;
import xtc.type.ErrorT;
import xtc.type.Language;
import xtc.type.MethodT;
import xtc.type.NumberT;
import xtc.type.PointerT;
import xtc.type.SourcePrinter;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.type.WrappedT;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utilities {
    private static final String[] JAVA_BASE_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    public static final Set<String> EMPTY_SET = Collections.emptySet();
    private static final Set<String> STANDARD_JNI_TYPE_DEFS = new HashSet<String>();
    private static final Pattern AUTO_PATTERN = Pattern.compile("\\bauto\\b");
    private static C C = new Analyzer.JeannieCAnalyzer(null).c();

    public static C c() {
        return C;
    }

    public static String cAstToString(Node node) {
        return JavaUnitTests.cAstToString(node);
    }

    public static boolean containsCToJavaTransition(Node node) {
        MiniVisitor_containsCToJavaTransition miniVisitor_containsCToJavaTransition = new MiniVisitor_containsCToJavaTransition();
        Boolean bl = (Boolean)miniVisitor_containsCToJavaTransition.dispatch(node);
        return bl;
    }

    public static boolean containsJavaToCTransition(GNode gNode) {
        MiniVisitor_containsJavaToCTransition miniVisitor_containsJavaToCTransition = new MiniVisitor_containsJavaToCTransition();
        Boolean bl = (Boolean)miniVisitor_containsJavaToCTransition.dispatch(gNode);
        return bl;
    }

    public static String copyDropAuto(String string) {
        return AUTO_PATTERN.matcher(string).replaceAll("").trim();
    }

    public static Type cPtrToBaseType(Type type2) {
        return ((PointerT)C.pointerize(type2)).getType();
    }

    public static GNode cStringToAst(String string, String string2) {
        return Utilities.cStringToAst(string, string2, null);
    }

    public static GNode cStringToAst(String string, String string2, Set<String> set) {
        try {
            GNode gNode = JavaUnitTests.cStringToAst(string, string2, set);
            return JavaEntities.scrubLocations(gNode);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public static Type cStringToType(String string) {
        return Utilities.cStringToType(string, EMPTY_SET);
    }

    public static Type cStringToType(String string, Set<String> set) {
        Object object;
        GNode gNode = Utilities.cStringToAst("TypeName", string, set);
        CAnalyzer cAnalyzer = new CAnalyzer(Utilities.newRuntime());
        try {
            object = CAnalyzer.class.getDeclaredField("table");
            ((Field)object).setAccessible(true);
            ((Field)object).set(cAnalyzer, new SymbolTable());
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        object = cAnalyzer.visitTypeName(gNode);
        return object;
    }

    public static GNode cTypeToAst(Type type2, String string, String string2) {
        String string3;
        if (null == string) {
            assert ("TypeName".equals(string2));
            string3 = Utilities.cTypeToString(type2);
        } else {
            assert ("StructureDeclaration".equals(string2) || "Declaration".equals(string2));
            string3 = Utilities.cTypeToString(type2, string) + ";";
        }
        GNode gNode = Utilities.cStringToAst(string2, Utilities.copyDropAuto(string3), Utilities.typedefs(type2));
        return gNode;
    }

    /*
     * WARNING - void declaration
     */
    public static Type cTypeToJavaType(SymbolTable symbolTable, Runtime runtime, Node node, Type type2) {
        if (type2.isVoid()) {
            return JavaEntities.nameToBaseType("void");
        }
        Type object = Utilities.getJavaClassOrInterfaceT(type2);
        if (JavaEntities.isWrappedClassT(object) || JavaEntities.isWrappedInterfaceT(object)) {
            return object;
        }
        for (String string : JAVA_BASE_TYPES) {
            if (Utilities.hasTypedefName(type2, "j" + string)) {
                return JavaEntities.nameToBaseType(string);
            }
            if (!Utilities.hasTypedefName(type2, "j" + string + "Array")) continue;
            return JavaEntities.typeWithDimensions(JavaEntities.nameToBaseType(string), 1);
        }
        if (Utilities.hasTypedefName(type2, "jsize")) {
            return JavaEntities.nameToBaseType("int");
        }
        if (Utilities.hasTypedefName(type2, "jclass")) {
            return JavaEntities.tClass(symbolTable);
        }
        if (Utilities.hasTypedefName(type2, "jstring")) {
            return JavaEntities.tString(symbolTable);
        }
        if (Utilities.hasTypedefName(type2, "jthrowable")) {
            return JavaEntities.tThrowable(symbolTable);
        }
        if (Utilities.hasTypedefName(type2, "jobjectArray")) {
            return JavaEntities.typeWithDimensions(JavaEntities.tObject(symbolTable), 1);
        }
        if (Utilities.hasTypedefName(type2, "jobject")) {
            return JavaEntities.tObject(symbolTable);
        }
        if (C.isIntegral(type2)) {
            void var4_8;
            String string = "long";
            Type type3 = (Type)symbolTable.root().lookup("jint");
            if (null != type3 && type3.equals(C.convert(type3, type2))) {
                String string2 = "int";
            } else if (null != node) {
                runtime.warning("converting C type '" + type2 + "' to Java type '" + string + "'", node);
            }
            return JavaEntities.nameToBaseType((String)var4_8);
        }
        if (C.isArithmetic(type2) && !C.isIntegral(type2)) {
            void var4_11;
            String string = "double";
            Type type4 = (Type)symbolTable.root().lookup("jfloat");
            if (null != type4 && type4.equals(C.convert(type4, type2))) {
                String string3 = "float";
            }
            if (null != node) {
                runtime.warning("converting C type '" + type2 + "' to Java type '" + (String)var4_11 + "'", node);
            }
            return JavaEntities.nameToBaseType((String)var4_11);
        }
        runtime.error("illegal C type '" + type2 + "' in Java expression", node);
        return JavaEntities.nameToBaseType("int");
    }

    public static String cTypeToString(Type type2) {
        return Utilities.cTypeToString(type2, null);
    }

    public static String cTypeToString(Type type2, String string) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        Printer printer = new Printer(charArrayWriter);
        SourcePrinter sourcePrinter = new SourcePrinter(printer);
        if (null == string) {
            sourcePrinter.print(type2);
        } else {
            sourcePrinter.print(type2, string);
        }
        printer.flush();
        return charArrayWriter.toString();
    }

    public static Type currentFunctionOrMethod(SymbolTable symbolTable) {
        SymbolTable.Scope scope = symbolTable.current();
        while (!scope.isRoot()) {
            String string = scope.getName();
            if (SymbolTable.isInNameSpace(string, "method")) {
                return JavaEntities.currentMethod(symbolTable);
            }
            if (SymbolTable.isFunctionScopeName(string) || SymbolTable.isMacroScopeName(string)) {
                String string2 = SymbolTable.fromNameSpace(string);
                return (Type)scope.getParent().lookupLocally(string2);
            }
            scope = scope.getParent();
        }
        return null;
    }

    public static String currentFunctionOrMethodName(SymbolTable symbolTable) {
        SymbolTable.Scope scope = symbolTable.current();
        while (!scope.isRoot()) {
            String string = scope.getName();
            if (SymbolTable.isInNameSpace(string, "method")) {
                MethodT methodT = JavaEntities.currentMethod(symbolTable);
                return JavaEntities.typeToString(symbolTable, false, methodT) + JavaEntities.typeToDescriptor(symbolTable, methodT);
            }
            if (SymbolTable.isFunctionScopeName(string) || SymbolTable.isMacroScopeName(string)) {
                return SymbolTable.fromNameSpace(string);
            }
            scope = scope.getParent();
        }
        return null;
    }

    public static void dumpLineMarkers(Set<LineMarker> set, int n) {
        System.err.print("dumpLineNumbers(" + n + " / " + set.size() + ")");
        int n2 = -1 == n ? Integer.MAX_VALUE : n;
        for (LineMarker lineMarker : set) {
            Node node;
            if (0 > --n2) break;
            System.err.print(" " + lineMarker.line + ":");
            for (node = lineMarker; null != node && node instanceof LineMarker; node = node.getNode()) {
            }
            System.err.print(null == node ? "null" : node.getName());
        }
        System.err.println();
    }

    public static Type getJavaClassOrInterfaceT(Type type2) {
        Type type3 = type2;
        while (!JavaEntities.isWrappedClassT(type3) && !JavaEntities.isWrappedInterfaceT(type3)) {
            if (!(type3 instanceof WrappedT)) {
                return type2;
            }
            type3 = ((WrappedT)type3).getType();
        }
        return type3;
    }

    public static String getSimpleDeclarator(GNode gNode) {
        Set<String> set = Utilities.getSimpleDeclarators(gNode);
        if (set.size() != 1) {
            return null;
        }
        return set.iterator().next();
    }

    public static Set<String> getSimpleDeclarators(GNode gNode) {
        MiniVisitor_getSimpleDeclarators miniVisitor_getSimpleDeclarators = new MiniVisitor_getSimpleDeclarators();
        Set set = (Set)miniVisitor_getSimpleDeclarators.dispatch(gNode);
        return set;
    }

    public static boolean hasTypedefName(Type type2, String string) {
        Type type3 = type2;
        while (type3 instanceof WrappedT) {
            String string2;
            if (type3 instanceof AliasT && (string2 = type3.toAlias().getName()).equals(string)) {
                return true;
            }
            type3 = ((WrappedT)type3).getType();
        }
        return false;
    }

    public static boolean isJavaEntity(Type type2) {
        if (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2)) {
            return true;
        }
        if (type2.isMethod() || type2.isPackage()) {
            return true;
        }
        if (JavaEntities.isParameterT(type2) || JavaEntities.isFieldT(type2) || JavaEntities.isLocalT(type2)) {
            return Language.JAVA == type2.getLanguage();
        }
        return false;
    }

    public static boolean isPtrChar(Type type2) {
        Type type3 = Utilities.c().pointerize(type2);
        if (!type3.isPointer()) {
            return false;
        }
        Type type4 = type3.toPointer().getType().resolve();
        return type4.isNumber() && NumberT.Kind.CHAR == type4.toNumber().getKind();
    }

    public static boolean isPtrTypedef(Type type2, String string) {
        Type type3 = Utilities.c().pointerize(type2);
        return type3.isPointer() && Utilities.hasTypedefName(type3.toPointer().getType(), string);
    }

    public static String javaAstToString(Node node) {
        return JavaEntities.javaAstToString(node);
    }

    public static boolean javaIsStaticMethod(GNode gNode) {
        Type type2 = (Type)gNode.getProperty("xtc.Constants.Type");
        assert (type2.isMethod());
        return type2.hasAttribute(JavaEntities.nameToModifier("static"));
    }

    public static boolean javaIsVoidMethod(GNode gNode) {
        Type type2 = ((Type)gNode.getProperty("xtc.Constants.Type")).toMethod().getResult();
        return type2.isVoid();
    }

    public static String javaTypeToApiType(Type type2) {
        return Utilities.javaTypeToApiType(type2, false, true);
    }

    public static String javaTypeToApiType(Type type2, boolean bl, boolean bl2) {
        if (type2.isVoid()) {
            return "Void";
        }
        if (JavaEntities.isGeneralLValueT(type2)) {
            return Utilities.javaTypeToApiType(JavaEntities.dereference(type2), bl, bl2);
        }
        boolean bl3 = type2.isArray();
        Type type3 = bl3 ? JavaEntities.arrayElementType(type2.toArray()) : null;
        String string = "Object";
        for (String string2 : JAVA_BASE_TYPES) {
            Type type4 = JavaEntities.nameToBaseType(string2);
            if (bl2 && bl3) {
                if (!JavaTypeConverter.isIdentical(type3, type4)) continue;
                string = string2 + "Array";
                break;
            }
            if (!JavaTypeConverter.isIdentical(type2, type4)) continue;
            string = string2;
            break;
        }
        return bl ? Utilities.upcaseFirstLetter(string) : string;
    }

    public static Type javaTypeToCType(SymbolTable symbolTable, Runtime runtime, Node node, Type type2, boolean bl) {
        Type type3;
        if (type2.isError()) {
            return ErrorT.TYPE;
        }
        if (type2.isVoid()) {
            return VoidT.TYPE;
        }
        assert (JavaEntities.isGeneralRValueT(type2));
        if (JavaEntities.isNullT(type2)) {
            return C.typeInteger("0");
        }
        if (bl && (JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2))) {
            return type2;
        }
        String string = null;
        for (String string2 : JAVA_BASE_TYPES) {
            Type type4 = JavaEntities.nameToBaseType(string2);
            if (JavaTypeConverter.isIdentical(type2, type4)) {
                string = "j" + string2;
            } else if (JavaTypeConverter.isIdentical(type2, JavaEntities.typeWithDimensions(type4, 1))) {
                string = "j" + string2 + "Array";
            }
            if (null != string) break;
        }
        List<File> list = JavaEntities.classpath(runtime);
        if (null == string && JavaTypeConverter.isAssignable(symbolTable, list, JavaEntities.tClass(symbolTable), type2)) {
            string = "jclass";
        }
        if (null == string && JavaTypeConverter.isAssignable(symbolTable, list, JavaEntities.tString(symbolTable), type2)) {
            string = "jstring";
        }
        if (null == string && JavaTypeConverter.isAssignable(symbolTable, list, JavaEntities.tThrowable(symbolTable), type2)) {
            string = "jthrowable";
        }
        if (null == string && type2.isArray()) {
            assert (JavaEntities.isReferenceT(JavaEntities.arrayElementType(type2.toArray())));
            string = "jobjectArray";
        }
        if (null == string) {
            assert (JavaEntities.isReferenceT(type2));
            string = "jobject";
        }
        if (null != (type3 = (Type)symbolTable.root().lookup(string))) {
            return type3;
        }
        runtime.error("C typedef for '" + string + "' missing; did you forget to #include <jni.h>?", node);
        return ErrorT.TYPE;
    }

    public static String jeannieAstToString(GNode gNode, String string) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        JeanniePrinter jeanniePrinter = new JeanniePrinter(new Printer(charArrayWriter), string);
        jeanniePrinter.dispatch(gNode);
        return charArrayWriter.toString();
    }

    public static GNode jeannieStringToAst(String string, String string2, String string3) {
        try {
            return Utilities.jeannieStringToAst(string, string2, string3, true);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public static GNode jeannieStringToAst(String string, String string2, String string3, boolean bl) throws Exception {
        Class[] classArray = new Class[]{Integer.TYPE};
        Method method = JeannieParser.class.getDeclaredMethod("p" + string, classArray);
        method.setAccessible(true);
        String string4 = JavaEntities.unicodeUnescape(string3);
        JeannieParser jeannieParser = new JeannieParser(new StringReader(string4), "<input>", string4.length());
        Object[] objectArray = new Object[]{new Integer(0)};
        Result result2 = (Result)method.invoke((Object)jeannieParser, objectArray);
        if (result2.hasValue()) {
            SemanticValue semanticValue = (SemanticValue)result2;
            if (semanticValue.index != string4.length()) {
                jeannieParser.signal(result2.parseError());
            }
            GNode gNode = (GNode)semanticValue.value;
            if (bl) {
                return (GNode)new AstSimplifier(string2).dispatch(gNode);
            }
            return gNode;
        }
        jeannieParser.signal(result2.parseError());
        return null;
    }

    public static String jniMangledName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '.': {
                    stringBuffer.append('_');
                    continue block6;
                }
                case '_': {
                    stringBuffer.append("_1");
                    continue block6;
                }
                case ';': {
                    stringBuffer.append("_2");
                    continue block6;
                }
                case '[': {
                    stringBuffer.append("_3");
                    continue block6;
                }
                default: {
                    if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    String string2 = Integer.toHexString(c);
                    stringBuffer.append("_0");
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String jniMangledName(SymbolTable symbolTable, Type type2) {
        if (type2.isClass()) {
            return Utilities.jniMangledName(JavaEntities.qNameWithDollars(symbolTable, type2.toClass()));
        }
        if (type2.isInterface()) {
            return Utilities.jniMangledName(JavaEntities.qNameWithDollars(symbolTable, type2.toInterface()));
        }
        assert (type2.isMethod());
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.declaringType(symbolTable, type2);
        String string = Utilities.jniMangledName(symbolTable, classOrInterfaceT);
        String string2 = Utilities.jniMangledName(type2.toMethod().getName());
        String string3 = JavaEntities.typeToDescriptor(symbolTable, type2);
        String string4 = string3.substring(1 + string3.indexOf(40), string3.indexOf(41));
        if (0 == string4.length()) {
            return string + "_" + string2;
        }
        return string + "_" + string2 + "__" + Utilities.jniMangledName(string4);
    }

    public static Runtime newRuntime() {
        Runtime runtime = new Runtime();
        runtime.dir("in", "inputDirectory", true, "").setValue("inputDirectory", JavaEntities.TEMP_DIR);
        runtime.bool("markAST", "optionMarkAST", true, "Mark AST nodes with types.").setValue("optionMarkAST", true);
        runtime.bool("strict", "optionStrict", true, "Enforce strict C99 compliance.").setValue("optionStrict", true);
        runtime.bool("pedantic", "optionPedantic", false, "Enforce strict C99 compliance.").setValue("optionPedantic", true);
        runtime.word("jniCall", "jniCall", false, "Calling conventions qualifier to C JNI functions.").setValue("jniCall", "");
        runtime.initDefaultValues();
        return runtime;
    }

    static void printLocalVariableMap(PrintWriter printWriter, Node node, SymbolTable symbolTable, CodeGenerator.Substitutions substitutions, CodeGenerator.Substitutions substitutions2) {
        MiniVisitor_findScopeBoundaries miniVisitor_findScopeBoundaries = new MiniVisitor_findScopeBoundaries();
        miniVisitor_findScopeBoundaries.dispatch(node);
        printWriter.println("LocalVariableMap:");
        printWriter.println("# file startLine startCol endLine endCol lang srcId tgtId");
        Utilities.printLocalVariableMap_helper(printWriter, symbolTable, miniVisitor_findScopeBoundaries, "C", substitutions);
        Utilities.printLocalVariableMap_helper(printWriter, symbolTable, miniVisitor_findScopeBoundaries, "Java", substitutions2);
        printWriter.println();
    }

    static void printLocalVariableMap_helper(PrintWriter printWriter, SymbolTable symbolTable, MiniVisitor_findScopeBoundaries miniVisitor_findScopeBoundaries, String string, CodeGenerator.Substitutions substitutions) {
        for (CodeGenerator.StringString stringString : substitutions) {
            String string2 = stringString._s1;
            Location location = null;
            Object object = string2;
            while (0 < ((String)object).length() && null == (location = (Location)miniVisitor_findScopeBoundaries._starts.get(object))) {
                object = xtc.util.Utilities.getQualifier((String)object);
            }
            assert (null != location);
            object = (Location)miniVisitor_findScopeBoundaries._ends.get(string2);
            assert (null == object || ((Location)object).file.equals(location.file));
            String string3 = stringString._s2;
            String string4 = substitutions.get(symbolTable.getScope(string2), string3);
            printWriter.print("  " + location.file + " " + location.line + " " + location.column);
            if (null == object) {
                printWriter.print(" - -");
            } else {
                printWriter.print(" " + ((Location)object).line + " " + ((Location)object).column);
            }
            printWriter.println(" " + string + " " + string3 + " " + string4);
        }
    }

    public static void printMethodMap(PrintWriter printWriter, SymbolTable symbolTable, Map<String, String> map) {
        printWriter.println("MethodMap:");
        printWriter.println("# srcMethod tgtFunctionOrMethod:");
        for (String string : map.keySet()) {
            printWriter.println("  " + map.get(string) + " " + string);
        }
        printWriter.println();
    }

    public static void printTopLevelDeclarations(PrintWriter printWriter, Node node) {
        MiniVisitor_getTopLevelDeclarations miniVisitor_getTopLevelDeclarations = new MiniVisitor_getTopLevelDeclarations();
        printWriter.print("TopLevelClassesOrInterfaces:");
        for (String string : JavaEntities.stringSet(miniVisitor_getTopLevelDeclarations.dispatch(node))) {
            printWriter.print(" " + string);
        }
        printWriter.println();
        printWriter.println();
    }

    public static Type pureCType(SymbolTable symbolTable, Runtime runtime, Type type2) {
        if (Utilities.isJavaEntity(type2)) {
            return Utilities.javaTypeToCType(symbolTable, runtime, null, type2, false);
        }
        if (type2.isAnnotated()) {
            return Utilities.pureCType(symbolTable, runtime, type2.toAnnotated().getType());
        }
        if (type2.isVariable()) {
            return Utilities.pureCType(symbolTable, runtime, type2.toVariable().getType());
        }
        return type2;
    }

    public static String qualifiedIdentifierToString(GNode gNode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < gNode.size(); ++i) {
            if (0 < i) {
                stringBuilder.append('.');
            }
            stringBuilder.append(gNode.getString(i));
        }
        return stringBuilder.toString();
    }

    public static Type returnType(Type type2) {
        if (type2.isMethod()) {
            return type2.toMethod().getResult();
        }
        return type2.resolve().toFunction().getResult();
    }

    public static Set<String> standardJniTypeDefs() {
        if (STANDARD_JNI_TYPE_DEFS.isEmpty()) {
            String[] stringArray = JAVA_BASE_TYPES;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                STANDARD_JNI_TYPE_DEFS.add("j" + string);
                STANDARD_JNI_TYPE_DEFS.add("j" + string + "Array");
            }
            for (String string : stringArray = new String[]{"JNIEnv", "jclass", "jfieldID", "jmethodID", "jobject", "jstring"}) {
                STANDARD_JNI_TYPE_DEFS.add(string);
            }
        }
        return STANDARD_JNI_TYPE_DEFS;
    }

    public static Set<String> stringSet(Object object) {
        return (Set)object;
    }

    public static String stringSetToString(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : set) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static Set<String> typedefs(Type type2) {
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            if (type2.isAlias()) {
                hashSet.add(type2.toAlias().getName());
            }
            if (type2 instanceof WrappedT) {
                type2 = ((WrappedT)type2).getType();
                continue;
            }
            if (!(type2 instanceof PointerT)) break;
            type2 = ((PointerT)type2).getType();
        }
        return hashSet;
    }

    public static String upcaseFirstLetter(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    private Utilities() {
        assert (false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MiniVisitor_getTopLevelDeclarations
    extends Visitor {
        MiniVisitor_getTopLevelDeclarations() {
        }

        public final Set<String> visit(Node node) {
            Set<String> set = EMPTY_SET;
            for (Object object : node) {
                Set<String> set2;
                if (!(object instanceof Node) || (set2 = Utilities.stringSet(this.dispatch((Node)object))).isEmpty()) continue;
                if (set.isEmpty()) {
                    set = set2;
                    continue;
                }
                set.addAll(set2);
            }
            return set;
        }

        public final Set<String> visitClassDeclaration(GNode gNode) {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(gNode.getString(1));
            return hashSet;
        }

        public final Set<String> visitInterfaceDeclaration(GNode gNode) {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(gNode.getString(1));
            return hashSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MiniVisitor_getSimpleDeclarators
    extends Visitor {
        MiniVisitor_getSimpleDeclarators() {
        }

        public final Set<String> visit(Node node) {
            Set<String> set = EMPTY_SET;
            for (Object object : node) {
                Set<String> set2;
                if (!(object instanceof Node) || (set2 = Utilities.stringSet(this.dispatch((Node)object))).isEmpty()) continue;
                if (set.isEmpty()) {
                    set = set2;
                    continue;
                }
                set.addAll(set2);
            }
            return set;
        }

        public final Set<String> visitSimpleDeclarator(GNode gNode) {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(gNode.getString(0));
            return hashSet;
        }
    }

    static class MiniVisitor_findScopeBoundaries
    extends Visitor {
        private final Map<String, Location> _ends = new HashMap<String, Location>();
        private final Map<String, Location> _starts = new HashMap<String, Location>();
        private final List<String> _willEnd = new ArrayList<String>();

        MiniVisitor_findScopeBoundaries() {
        }

        public final void visit(Node node) {
            if (node.hasLocation()) {
                Location location = node.getLocation();
                for (String string : this._willEnd) {
                    this._ends.put(string, location);
                }
                this._willEnd.clear();
                if (node.hasProperty("xtc.Constants.Scope")) {
                    this._starts.put((String)node.getProperty("xtc.Constants.Scope"), location);
                }
            }
            for (Iterator<String> iterator : node) {
                if (!(iterator instanceof Node)) continue;
                this.dispatch((Node)((Object)iterator));
            }
            if (node.hasLocation() && node.hasProperty("xtc.Constants.Scope")) {
                this._willEnd.add((String)node.getProperty("xtc.Constants.Scope"));
            }
        }
    }

    static class MiniVisitor_containsJavaToCTransition
    extends Visitor {
        MiniVisitor_containsJavaToCTransition() {
        }

        public final Boolean visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                if (!(node.get(i) instanceof Node) || !((Boolean)this.dispatch(node.getNode(i))).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public final Boolean visitCDeclarations(GNode gNode) {
            return null != gNode;
        }

        public final Boolean visitCInJavaBlock(GNode gNode) {
            return null != gNode;
        }

        public final Boolean visitCInJavaExpression(GNode gNode) {
            return null != gNode;
        }
    }

    static class MiniVisitor_containsCToJavaTransition
    extends Visitor {
        MiniVisitor_containsCToJavaTransition() {
        }

        public final Boolean visit(LineMarker lineMarker) {
            Node node = lineMarker.getNode();
            return null == node ? Boolean.FALSE : (Boolean)this.dispatch(node);
        }

        public final Boolean visit(Node node) {
            for (int i = 0; i < node.size(); ++i) {
                if (!(node.get(i) instanceof Node) || !((Boolean)this.dispatch(node.getNode(i))).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public final Boolean visitJavaImports(GNode gNode) {
            return null != gNode;
        }

        public final Boolean visitJavaInCBlock(GNode gNode) {
            return null != gNode;
        }

        public final Boolean visitJavaInCExpression(GNode gNode) {
            return null != gNode;
        }

        public final Boolean visitJavaInCStatement(GNode gNode) {
            return null != gNode;
        }

        public final Boolean visitJavaThrows(GNode gNode) {
            return null != gNode && null != gNode.get(0);
        }

        public final Boolean visitJavaType(GNode gNode) {
            return null != gNode;
        }
    }
}

