/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import xtc.lang.JavaEntities;
import xtc.lang.JavaUnitTests;
import xtc.lang.jeannie.Analyzer;
import xtc.lang.jeannie.CodeGenerator;
import xtc.lang.jeannie.Utilities;
import xtc.tree.GNode;
import xtc.tree.Printer;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

public final class UnitTests
extends TestCase {
    static void assrtEquals(String string, String string2) {
        String string3;
        if (null == string) {
            return;
        }
        String string4 = JavaUnitTests.contractSpace(string);
        if (string4.equals(string3 = JavaUnitTests.contractSpace(string2))) {
            return;
        }
        UnitTests.assertEquals((String)string4, (String)string3);
    }

    static void jeannieAnalyzerTestError(String string, String string2, String string3, String string4, Analyzer analyzer) throws Exception {
        StringWriter stringWriter = new StringWriter();
        analyzer._runtime.setErrConsole(new Printer(stringWriter));
        GNode gNode = Utilities.jeannieStringToAst(string, string2, string3);
        analyzer.dispatch(gNode);
        String string5 = UnitTests.trimAnalyzerOutput(stringWriter.toString());
        UnitTests.assrtEquals(string4, string5);
    }

    static String trimAnalyzerOutput(String string) {
        int n = (string = JavaUnitTests.stripPrefix(string, "error:")).indexOf("warning:");
        if (-1 != n) {
            string = string.substring(n);
        }
        string = JavaUnitTests.stripSuffix(string, "\n");
        string = string.trim();
        return string;
    }

    static void jeannieParserTestRoundTrip(String string, String string2, String string3, String string4, boolean bl) throws Exception {
        String string5 = JavaEntities.unicodeUnescape(string3);
        GNode gNode = Utilities.jeannieStringToAst(string, string2, string5, bl);
        String string6 = Utilities.jeannieAstToString(gNode, string2);
        String string7 = JavaUnitTests.contractSpace(JavaEntities.unicodeUnescape(string4));
        UnitTests.assrtEquals(string7, string6);
    }

    private static TestSuite makeSuiteJeannieAnalyzerError() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{double y; }class A{int x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{enum e{a,b}y; }class A{int x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{enum e{a,b}y; }class A{long x=`y;}", "warning: converting C type 'annotated(enum e)' to Java type 'long'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{float y;}class A{double x=`y;}", "warning: converting C type 'annotated(float)' to Java type 'double'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{float y;}class A{float x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{float y;}class A{int x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{int i=0;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{int i=\"s\";}", "initializer for 'i' makes integer from pointer without a cast"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{int y;}class A{int x=`&y;}", "illegal C type 'annotated(pointer(int))' in Java expression"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{int y;}class A{int x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{int y;}class A{long x=`y;}", "warning: converting C type 'annotated(int)' to Java type 'long'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{int y[5];}class A{int x=`y;}", "illegal C type 'annotated(array(int, 5))' in Java expression"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{int* y;}class A{int x=`y;}", "illegal C type 'annotated(pointer(int))' in Java expression"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{long double y;}class A{int x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{long long y;}class A{int x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{struct s{}y;}class A{int x=`y;}", "illegal C type 'annotated(struct s)' in Java expression"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef float jfloat; float y; }class A{float x=`y;}", "warning: converting C type 'annotated(float)' to Java type 'float'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef float jfloat; jfloat y; }class A{float x=`y;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;typedef char jbyte;typedef int jint;extern int printf(__const char*__restrict __format,...);}class Main{public static void main(String[]args){String js=\"abc\";`{jbyte*bs;_with(bs=`js){printf(\"%*s\\n\",bs,`js.length());}}}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;typedef int jintArray;}class A{native int[]f()`{jintArray a;return a;}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;typedef void* jstring;}class A{native void f()`{jstring s=_newJavaString(123);}}", "expected pointer to char, `byte, or `char"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;typedef void* jstring;}class A{native void f()`{jstring s=_newJavaString(\"hi\");}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;void f(JNIEnv*env){`{{System.out.println();}}}}class A{}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;void f(JNIEnv*env){`{try{}catch(Error e){}}}}class A{}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;}class A{int f(){int i;return `i;}}", "cannot use Java entity 'i' in C context"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;}class A{int f(){return env;}}", "cannot use C entity 'env' in Java context"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;}class A{int f(int i){return `i;}}", "cannot use Java entity 'i' in C context"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;}class A{int i;int f(){return `i;}}", "cannot use Java entity 'i' in C context"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;}class A{native void f()`{JNIEnv* e=env;}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int JNIEnv;}class A{native void f(int env)`{}}", "formal parameter declaration of 'env' conflicts with implicit JNIEnv pointer"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int jint; int y; }class A{int x=`y;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int jint; jint i=0; typedef void* JNIEnv;} class A { int f(){return `i;} } ", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef int jint; long y; }class A{long x=`y;}", "warning: converting C type 'annotated(long)' to Java type 'long'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef long jint; long y; }class A{int x=`y;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef unsigned char jboolean;jboolean b;}class A{boolean x=`b;} ", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef unsigned char jboolean;}class A{boolean x=`((jboolean)(2<3));} ", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef unsigned char jboolean;}class A{boolean x=`(2<3);} ", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void(*FP)(int);void g(FP fp){}void h(int i){}void f(){g(h);}}class A{}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void* JNIEnv;typedef int jint;}class A{int f(){return `((jint)env);}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void* JNIEnv;}class A{native Exception f()`{return 123;}}", "return type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void* JNIEnv;}class A{native int f()`{return;}}", "'return' with no value, in method returning non-void"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void* JNIEnv;}class A{native void f()`{}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void* JNIEnv;}class A{void f(){if(true)`{int*p=0;}}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void* JNIEnv;}class A{void f(){if(true)`{int*p=3;}}}", "initializer for 'p' makes pointer from integer without a cast"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void*JNIEnv;typedef int jint;extern int printf(__const char* __restrict __format, ...);}class A{static native void f()`{jint a=0,b=0;b=`(1+`((jint)(a=1)));printf(\"%d,%d\\\\n\",a,b);}public static void main(String[]args){f();}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void*JNIEnv;typedef int jint;}class A{native int f()`{return (jint)1000;}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void*JNIEnv;typedef int jint;}class A{public static void main(String args[]){int a=0,b=0;b=`((jint)(1+`(a=1)));System.out.println(a+\",\"+b);}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void*JNIEnv;}class Main{native void f()`{int a[1]={3+5};}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{typedef void*JNIEnv;}class Main{native void f()`{int a[1]={3};}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{union u{}y;}class A{int x=`y;}", "illegal C type 'annotated(union u)' in Java expression"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{unsigned y;}class A{int x=`y;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{}class A extends B {}", "unknown class or interface B"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{}class A{native void f();}", "methods should be abstract iff they have no body"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{}class A{native void f()`{}}", "C typedef for 'JNIEnv' missing; did you forget to #include <jni.h>?"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{}class A{native void f(){}}", "methods should be native iff their body is in C"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{}class A{static{String b=\"x\";b=\"y\";}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.C{}class A{}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.Java{import java.util.*;}typedef int JNIEnv;typedef void* jobject;jobject f(JNIEnv*env){return `((Vector)null);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.Java{import java.util.Vector;}int i=`0;", "C typedef for 'jint' missing; did you forget to #include <jni.h>?"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.Java{import java.util.Vector;}typedef int JNIEnv;typedef int jint;int f(JNIEnv*env){return `0;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`.Java{import java.util.Vector;}typedef int JNIEnv;typedef void* jobject;jobject f(JNIEnv*env){return `((Vector)null);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "`Exception e;", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "int f(){return 123;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "int i;void f(){_cancel i;}", "no enclosing _with statement for 'i'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "int i;void f(){_commit i;}", "no enclosing _with statement for 'i'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "package p;`.C{typedef int JNIEnv;void printf(char*);void fflush(int);int stdout;void f(JNIEnv*env){printf(\"f 1\\n\");fflush(stdout);`p.Main.g();printf(\"f 2\\n\");fflush(stdout);}}public class Main{public static void g(){System.out.println(\"Main.g\");System.out.flush();}public static void main(String[]args){System.out.println(\"Main.main 1\");System.out.flush();`f(env);System.out.println(\"Main.main 2\");System.out.flush();}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef char jboolean;typedef int jintArray;void f(){jboolean* ca;_with(ca=`new int[5]){}}", "type 'jint*' expected"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef double jdouble;jdouble f(JNIEnv*env){return `1.5;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jboolean;typedef int jbooleanArray;void f(JNIEnv*env){jboolean* ca;_with(ca=`new boolean[5]){}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jboolean;typedef int jobjectArray;void f(JNIEnv*env){jboolean* ca;_with(ca=`new String[5]){}}", "type 'jobject*' expected"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jint;int f(JNIEnv*env)`{return 123;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jint;typedef void* jintArray;void f(JNIEnv*env){jint* ca;_copyFromJava(ca, 0, `new int[5], 0, 3);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jint;typedef void* jintArray;void f(JNIEnv*env){jint* ca;_copyFromJava(ca, 0, `new int[5], 3-1, 2);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jint;typedef void* jintArray;void f(JNIEnv*env){jint* ca;_copyFromJava(ca, 0, `new int[5], 3.1, 3);}", "invalid operand where integer required"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jint;typedef void* jintArray;void f(JNIEnv*env){jint* ca;_with(ca=`new int[5]){_cancel ca;}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef int jint;typedef void* jintArray;void f(JNIEnv*env){jint* ca;_with(ca=`new int[5]){_commit ca;}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jobject;int f(JNIEnv*env){return `null;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jobject;jobject f(JNIEnv*env){return `((Vector)null);}", "unknown class or interface Vector"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jobject;jobject f(JNIEnv*env){return `null;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jobject;typedef jobject jthrowable;jobject f(JNIEnv*env){return `new Exception();}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;jstring f(JNIEnv*env){return `\"hi\";}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;jstring f(JNIEnv*env){return `new String(1,2,3,4,5);}", "could not find constructor"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;typedef char jbyte;void f(JNIEnv*env){jbyte* ca;_with(ca=`\"abc\"){}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;typedef int jchar;typedef int jint;void f(JNIEnv*env){jchar* ca;_copyFromJava(ca, 0, `\"abc\", 0, 3);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;typedef int jchar;void f(JNIEnv*env){jchar* ca;_copyToJava(`\"abc\", 0, ca, 0, 3);}", "_copyToJava target must not be String"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;typedef int jchar;void f(JNIEnv*env){jchar* ca;_with(ca=`'a'){}}", "string or primitive array expected"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;typedef int jchar;void f(JNIEnv*env){jchar* ca;_with(ca=`(new Object().toString())){}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;typedef int jchar;void f(JNIEnv*env){jchar* ca;_with(ca=`\"abc\"){}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;void f(JNIEnv*env){int* ca;_with(ca=`\"abc\"){}}", "type 'jchar*' or 'jbyte*' expected"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jstring;void f(JNIEnv*env,jstring s)`{throw new Error(`s);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jthrowable;jthrowable f(JNIEnv*env){return `((Exception)null);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;typedef void* jthrowable;jthrowable f(JNIEnv*env){return `new Exception();}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`throws Exception{`throw new Exception();}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`throws Exception{}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`throws Exception{}void g(){f(0);}", "uncaught exception"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`throws Object{}", "throwable expected"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`throws RuntimeException{}void g(){f(0);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`throws java.io.FileNotFoundException, java.io.EOFException{}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`throws java.io.IOException{}void g(JNIEnv*env)`throws Exception{f(env);}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env)`{throw new Error();}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env){`Exception x,y;x=y;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env){`Object x;`Exception y;x=y;}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env){`Object x;`Exception y;y=x;}", "illegal C assignment to Java type 'java.lang.Exception'"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env){`throw new Exception();}", "uncaught exception"));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env){`try`{`throw new Exception();}catch(Exception e){}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env){`{String s=\"hi\";}}", ""));
        testSuite.addTest((Test)new JeannieAnalyzerTestError(false, "File", null, "typedef int JNIEnv;void f(JNIEnv*env){int* x;`Object y;`{y=x;}}", "cannot use C entity 'y' in Java context"));
        return testSuite;
    }

    private static TestSuite makeSuiteJeannieCodeGenerator() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef void* JNIEnv;extern int printf(__const char *__restrict __format,...);}class Main{static native void sayHi()`{printf(\"Hello world!\\n\");}public static void main(String[]args){sayHi();}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef void* JNIEnv;typedef int jint;typedef char jboolean;typedef void* jintArray;}class Main{static native int sum(int[] ja)`{int i,n;jint* ca,s;n=`ja.length;s=0;_with(ca=`ja){for(i=0;i<n;i++)s+=ca[i];_cancel ca;}return s;}public static void main(String[] args){int[] a ={3,1,4};System.out.println(\"expected 8,got \" + sum(a));}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef void* JNIEnv;struct L{struct L* x;};}class A{native void f()`{struct L* y=0;}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int JNIEnv;typedef char jbyte;typedef int jint;typedef void* jstring;typedef char jboolean;extern int printf(__const char*__restrict __format,...);}class Main{public static void main(String[]args){String js=\"abc\";`{jbyte*bs;_with(bs=`js){printf(\"%*s\\n\",bs,`js.length());}}}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int JNIEnv;typedef int jint;struct s{int i;}g;}class A{void f(){int j=`g.i;}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int JNIEnv;typedef int jlong;}class A{native int f()`{switch(0){case 0:``((jlong)1);}}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int JNIEnv;typedef int jstring;}class A{void f(){throw new Error(`_newJavaString(\"boo\"));}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int JNIEnv;typedef void* jstring;}class A{native void f()`{jstring s=_newJavaString(\"hi\");}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int JNIEnv;void f(JNIEnv*env){`{int i;i=1;}}}class A{}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int JNIEnv;void f(JNIEnv*env){`{int i;i=1;}}}class A{}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef int jint;jint i=42;typedef void* JNIEnv;}class A{void f(){int j=0;j=`i;}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef void* JNIEnv;}class A{void f(){}}", "typedef void* JNIEnv;", "class A{void f(){}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{}class A{}", "", "class A{}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "`.C{typedef void* JNIEnv;typedef int jint;extern int printf(__const char *__restrict __format,...);}class Main{native static void foo()`{int y;y=`Math.max(123,456);printf(\"return value: %d\\n\",y);}public static void main(String[]args){foo();}}"));
        testSuite.addTest((Test)new JeannieCodeGeneratorTest(false, "File", null, "package p;`.C{typedef int JNIEnv;void printf(char*);void fflush(int);int stdout;void f(JNIEnv*env){printf(\"f 1\\n\");fflush(stdout);`p.Main.g();printf(\"f 2\\n\");fflush(stdout);}}public class Main{public static void g(){System.out.println(\"Main.g\");System.out.flush();}public static void main(String[]args){System.out.println(\"Main.main 1\");System.out.flush();`f(env);System.out.println(\"Main.main 2\");System.out.flush();}}"));
        return testSuite;
    }

    private static TestSuite makeSuiteJeannieParser() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new JeannieParserTest(false, "Block", "Java", "`{int i = &a; someCFunction(i);}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "Block", "Java", "{int i = a >>> 3; someJavaMethod(i);}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "CompoundStatement", "C", "`{int i = a >>> 3; someJavaMethod(i);}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "CompoundStatement", "C", "{int i = &a; someCFunction(i);}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{extern int printf(__const char *__restrict __format, ...);}class Main{static native void sayHi() `{printf(\"Hello world!\\n\");}public static void main(String[]args){sayHi();}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{}class Main{public static void main(String[]args){System.out.println(\"Hello, world\");}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{extern int printf(__const char *__restrict __format, ...);}class Main{native static void foo() `{int y; y = `Math.max(123, 456); printf(\"return value: %d\\n\", y);}public static void main(String[] args){foo();}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, ""));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{extern int printf(__const char*__restrict __format,...);}class Main{static native void f(int[]ja)throws Exception`{int i;jint*ca;_with(ca=`ja){for(i=0;i<3;i++){if(ca[i]==4)`throw new Exception();printf(\"p0 (%d:%d)\\n\",i,ca[i]);}printf(\"p1\\n\");_commit ca;}printf(\"p2\\n\");}public static void main(String[]args){int[]a={3,1,4};try{f(a);System.out.println(\"p3\");}catch(Exception e){System.out.println(\"p4\");}}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{typedef int jint; jint i=0;}class A{int f(){return `&i;}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{typedef int jint; jint i=0;}class A{int f(){return `((jint)&i);}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{typedef int jint; jint i=0;}class A{int f(){return `(i+2);}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{typedef int jint;}class Main{static native int sum(int[] ja)`{jint *ca,s;int i,n;s=0;n=`ja.length;_with(ca=`ja){for(i=0;i<n;i++)s+=ca[i];_cancel ca;}return s;}public static void main(String[]args){int[] a={3,1,4};System.out.println(\"expected 8, got \"+sum(a));}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{} class A{int f(){return `(1+2);}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{} class A{void f(){int x=0;}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{} class A{} "));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.C{}class A{native void f()`{}}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.Java{import java.util.Vector;}int f(){}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.Java{}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.Java{}`java.lang.Integer i;"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.Java{}const `java.lang.Integer *i[10];"));
        testSuite.addTest((Test)new JeannieParserTest(false, "File", null, "`.Java{}int f()`throws E{}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$ConditionalExpression", "C", "1+2"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_cancel a;"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_commit a;"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_copyFromJava(ca, 0, `ja, 0, 2);"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_copyToJava(`ja, 0, ca, 0, `ja.length-1);"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_with(ca=`ja){}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_with(ca=`new int[123]){}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_with(ca=ja){ca[0]=3;}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "_with(ca=ja){}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "`synchronized(m){}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "`throw new E();"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$Statement", "C", "`try{}catch(E e){}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$UnaryExpression", "C", "`(x >>> 3)"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieC$UnaryExpression", "C", "`x"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieJava$Declaration", "Java", "A b(C d,E[]f){}"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieJava$Expression", "Java", "(a==++b.c(1)[d.e()][2].f&g)-h"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieJava$Expression", "Java", "`&x"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieJava$Expression", "Java", "`(1?2:3)"));
        testSuite.addTest((Test)new JeannieParserTest(false, "JeannieJava$Expression", "Java", "new A[][]{{b,c},{d,e}}"));
        return testSuite;
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTestSuite(UnitTests.class);
        testSuite.addTest((Test)UnitTests.makeSuiteJeannieCodeGenerator());
        testSuite.addTest((Test)UnitTests.makeSuiteJeannieAnalyzerError());
        testSuite.addTest((Test)UnitTests.makeSuiteJeannieParser());
        testSuite.addTest(JavaUnitTests.suite());
        return testSuite;
    }

    private void addJniTypedefs(Runtime runtime, SymbolTable symbolTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int jint;");
        stringBuffer.append("typedef long jlong;");
        stringBuffer.append("typedef void* jobject;");
        stringBuffer.append("typedef jobject jintArray;");
        stringBuffer.append("typedef jobject jobjectArray;");
        GNode gNode = Utilities.jeannieStringToAst("CompilationUnit", "Java", "`.C{" + stringBuffer + "}class A{}");
        new Analyzer(runtime, symbolTable, null).dispatch(gNode);
    }

    public final void testJeannieParser_pFile() throws Exception {
        GNode gNode = Utilities.jeannieStringToAst("File", null, "`.C{} class A { }", false);
        String string = Utilities.jeannieAstToString(gNode, null);
    }

    public final void testJeannieUtil_cAstToString() throws Exception {
        for (String string : new String[]{"{}", "{int*i,j=2+2,(*k)[5];}"}) {
            GNode gNode = Utilities.cStringToAst("CompoundStatement", string);
            UnitTests.assertEquals((String)string, (String)JavaUnitTests.contractSpace(Utilities.cAstToString(gNode)));
        }
    }

    public final void testJeannieUtil_containsCCode() throws Exception {
        UnitTests.assertFalse((boolean)Utilities.containsJavaToCTransition(Utilities.jeannieStringToAst("JavaInJavaBlock", "java", "{}")));
        UnitTests.assertTrue((boolean)Utilities.containsJavaToCTransition(Utilities.jeannieStringToAst("JavaInJavaBlock", "java", "{`{}}")));
        UnitTests.assertFalse((boolean)Utilities.containsJavaToCTransition(Utilities.jeannieStringToAst("JavaInJavaBlock", "java", "{int i = 2;}")));
        UnitTests.assertTrue((boolean)Utilities.containsJavaToCTransition(Utilities.jeannieStringToAst("JavaInJavaBlock", "java", "{int i = 3.5 * `(2 + 2);}")));
    }

    public final void testJeannieUtil_cTypeToJavaType() throws Exception {
        Runtime runtime = Utilities.newRuntime();
        SymbolTable symbolTable = new SymbolTable();
        this.addJniTypedefs(runtime, symbolTable);
        UnitTests.assertEquals((String)"int", (String)JavaEntities.javaTypeToString(symbolTable, Utilities.cTypeToJavaType(symbolTable, runtime, null, Utilities.cStringToType("char"))));
        UnitTests.assertEquals((String)"long", (String)JavaEntities.javaTypeToString(symbolTable, Utilities.cTypeToJavaType(symbolTable, runtime, null, Utilities.cStringToType("long"))));
    }

    public final void testJeannieUtil_cTypeToString() throws Exception {
        for (String string : new String[]{"int", "int*", "int[]", "int(*)[3]", "struct s***"}) {
            Type type2 = Utilities.cStringToType(string);
            UnitTests.assertEquals((String)string, (String)JavaUnitTests.contractSpace(Utilities.cTypeToString(type2)));
        }
        UnitTests.assertEquals((String)"struct t", (String)JavaUnitTests.contractSpace(Utilities.cTypeToString(Utilities.cStringToType("struct t{int i;}"))));
        UnitTests.assertEquals((String)"int(*p)[3]", (String)JavaUnitTests.contractSpace(Utilities.cTypeToString(Utilities.cStringToType("int(*)[3]"), "p")));
    }

    public final void testJeannieUtil_javaTypeToApiType() {
        UnitTests.assertEquals((String)"int", (String)Utilities.javaTypeToApiType(JavaEntities.javaStringToType("int")));
        UnitTests.assertEquals((String)"Object", (String)Utilities.javaTypeToApiType(JavaEntities.javaStringToType("int[][]")));
        UnitTests.assertEquals((String)"intArray", (String)Utilities.javaTypeToApiType(JavaEntities.javaStringToType("int[]")));
        UnitTests.assertEquals((String)"boolean", (String)Utilities.javaTypeToApiType(JavaEntities.javaStringToType("boolean")));
        UnitTests.assertEquals((String)"Object", (String)Utilities.javaTypeToApiType(JavaEntities.javaStringToType("String")));
    }

    public final void testJeannieUtil_javaTypeToCType() throws Exception {
        Runtime runtime = Utilities.newRuntime();
        SymbolTable symbolTable = new SymbolTable();
        this.addJniTypedefs(runtime, symbolTable);
        UnitTests.assertEquals((String)"jint", (String)Utilities.cTypeToString(Utilities.javaTypeToCType(symbolTable, runtime, null, JavaEntities.javaStringToType("int"), false)));
        UnitTests.assertEquals((String)"jintArray", (String)Utilities.cTypeToString(Utilities.javaTypeToCType(symbolTable, runtime, null, JavaEntities.javaStringToType("int[]"), false)));
        UnitTests.assertEquals((String)"jobjectArray", (String)Utilities.cTypeToString(Utilities.javaTypeToCType(symbolTable, runtime, null, JavaEntities.javaStringToType("int[][]"), false)));
        UnitTests.assertEquals((String)"jobject", (String)Utilities.cTypeToString(Utilities.javaTypeToCType(symbolTable, runtime, null, JavaEntities.javaStringToType("Object"), false)));
    }

    public final void testJeannieUtil_javaTypeToString() {
        for (String string : new String[]{"int", "int[][]", "java.lang.Object", "java.io.Writer[]"}) {
            Type type2 = JavaEntities.javaStringToType(string);
            UnitTests.assertEquals((String)string, (String)JavaEntities.javaTypeToString(null, type2));
        }
        UnitTests.assertEquals((String)"java.lang.Object", (String)JavaEntities.javaTypeToString(null, JavaEntities.javaStringToType("Object")));
    }

    public final void testJeannieUtil_jniMangledName() {
        UnitTests.assertEquals((String)"a_b_C", (String)Utilities.jniMangledName("a.b.C"));
        UnitTests.assertEquals((String)"C_1x", (String)Utilities.jniMangledName("C_x"));
        UnitTests.assertEquals((String)"java_lang_Object", (String)Utilities.jniMangledName("java.lang.Object"));
        UnitTests.assertEquals((String)"java_lang_String", (String)Utilities.jniMangledName(null, JavaEntities.javaStringToType("java.lang.String")));
    }

    static class JeannieParserTest
    extends JavaUnitTests.IgnorableTest {
        private final String _expected;
        private final String _input;
        private final String _language;
        private final String _production;

        JeannieParserTest(boolean bl, String string, String string2, String string3) {
            super(bl);
            this._expected = string3;
            this._input = string3;
            this._language = string2;
            this._production = string;
        }

        public void runTestIgnorable() throws Exception {
            UnitTests.jeannieParserTestRoundTrip(this._production, this._language, this._input, this._expected, false);
            UnitTests.jeannieParserTestRoundTrip(this._production, this._language, this._input, this._expected, true);
        }
    }

    static final class JeannieCodeGeneratorTest
    extends JavaUnitTests.IgnorableTest {
        private final String _cExpected;
        private final String _input;
        private final String _javaExpected;
        private final String _language;
        private final String _production;

        JeannieCodeGeneratorTest(boolean bl, String string, String string2, String string3) {
            super(bl);
            this._cExpected = null;
            this._input = string3;
            this._javaExpected = null;
            this._language = string2;
            this._production = string;
        }

        JeannieCodeGeneratorTest(boolean bl, String string, String string2, String string3, String string4, String string5) {
            super(bl);
            this._cExpected = string4;
            this._input = string3;
            this._javaExpected = string5;
            this._language = string2;
            this._production = string;
        }

        public void runTestIgnorable() throws Exception {
            GNode gNode = Utilities.jeannieStringToAst(this._production, this._language, this._input);
            Runtime runtime = Utilities.newRuntime();
            SymbolTable symbolTable = new SymbolTable();
            Analyzer analyzer = new Analyzer(runtime, symbolTable, this._language);
            analyzer.dispatch(gNode);
            CodeGenerator codeGenerator = new CodeGenerator(runtime, symbolTable);
            CodeGenerator.Out out = (CodeGenerator.Out)codeGenerator.dispatch(gNode);
            JeannieCodeGeneratorTest.assertTrue((null == out._cExternalDeclarations && null == out._cMembers && null == out._javaMembers ? 1 : 0) != 0);
            String string = Utilities.cAstToString(out._cNode);
            String string2 = Utilities.javaAstToString(out._javaNode);
            UnitTests.assrtEquals(this._cExpected, string);
            UnitTests.assrtEquals(this._javaExpected, string2);
        }
    }

    static final class JeannieAnalyzerTestError
    extends JavaUnitTests.IgnorableTest {
        private final String _expected;
        private final String _input;
        private final String _language;
        private final String _production;

        JeannieAnalyzerTestError(boolean bl, String string, String string2, String string3, String string4) {
            super(bl);
            this._expected = string4;
            this._input = string3;
            this._language = string2;
            this._production = string;
        }

        public void runTestIgnorable() throws Exception {
            Analyzer analyzer = new Analyzer(Utilities.newRuntime(), new SymbolTable(), this._language);
            if (!("File".equals(this._production) || "CompilationUnit".equals(this._production) || "TranslationUnit".equals(this._production))) {
                JavaUnitTests.enterPackageFile(analyzer._table, "", "<input>");
            }
            UnitTests.jeannieAnalyzerTestError(this._production, this._language, this._input, this._expected, analyzer);
        }
    }
}

