/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.util.Stack;
import xtc.lang.CPrinter;
import xtc.lang.JavaPrinter;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;

public class JeanniePrinter
extends Visitor {
    protected final Printer _printer;
    private final Stack<Context> _stack;
    private final JeannieCPrinter _cPrinter;
    private final JeannieJPrinter _jPrinter;

    public JeanniePrinter(Printer printer, String string) {
        this._printer = printer;
        this._cPrinter = new JeannieCPrinter(printer);
        this._jPrinter = new JeannieJPrinter(printer);
        printer.register(this);
        this._stack = new Stack();
        if ("C".equals(string)) {
            this.enterC(TransitionKind.SILENT);
        }
        if ("Java".equals(string)) {
            this.enterJava(TransitionKind.SILENT);
        }
    }

    private Visitor activePrinter() {
        return this._stack.isEmpty() ? null : this._stack.peek()._activePrinter;
    }

    protected final void enterC(TransitionKind transitionKind) {
        assert (this._cPrinter != this.activePrinter());
        this._stack.push(new Context(this._cPrinter, transitionKind));
        switch (transitionKind) {
            case SILENT: {
                break;
            }
            case SHORT: {
                this._printer.p('`');
                break;
            }
            case LONG: {
                this._printer.indent().p("`.C {");
            }
        }
    }

    protected final void enterJava(TransitionKind transitionKind) {
        assert (this._jPrinter != this.activePrinter());
        this._stack.push(new Context(this._jPrinter, transitionKind));
        switch (transitionKind) {
            case SILENT: {
                break;
            }
            case SHORT: {
                this._printer.p('`');
                break;
            }
            case LONG: {
                this._printer.indent().p("`.Java {");
            }
        }
    }

    protected final void exitC() {
        assert (this._cPrinter == this.activePrinter());
        Context context = this._stack.pop();
        if (TransitionKind.LONG == context._transitionKind) {
            this._printer.p("}");
        }
    }

    protected final void exitJava() {
        assert (this._jPrinter == this.activePrinter());
        Context context = this._stack.pop();
        if (TransitionKind.LONG == context._transitionKind) {
            this._printer.p("}");
        }
    }

    public final void visit(Node node) {
        this.activePrinter().dispatch(node);
    }

    public final void visitBlock(GNode gNode) {
        assert (this._jPrinter == this.activePrinter());
        assert (null == gNode);
    }

    public final void visitCancelStatement(GNode gNode) {
        assert (this._cPrinter == this.activePrinter());
        this._printer.p("_cancel ").p(gNode.getNode(0)).p(";");
    }

    public final void visitCDeclarations(GNode gNode) {
        this.enterC(TransitionKind.LONG);
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getNode(i));
        }
        this.exitC();
    }

    public final void visitCInCBlock(GNode gNode) {
        assert (this._cPrinter == this.activePrinter());
        this._cPrinter.visitCompoundStatement(gNode);
    }

    public final void visitCInJavaBlock(GNode gNode) {
        this.enterC(TransitionKind.SHORT);
        this.dispatch(gNode.getNode(0));
        this.exitC();
    }

    public final void visitCInJavaExpression(GNode gNode) {
        this.enterC(TransitionKind.SHORT);
        int n = this._cPrinter.startExpression(150);
        this.dispatch(gNode.getNode(0));
        this._cPrinter.endExpression(n);
        this.exitC();
    }

    public final void visitCommitStatement(GNode gNode) {
        assert (this._cPrinter == this.activePrinter());
        this._printer.p("_commit ").p(gNode.getNode(0)).p(";");
    }

    public final void visitCompilationUnit(GNode gNode) {
        assert (null == this.activePrinter());
        this.enterJava(TransitionKind.SILENT);
        this.activePrinter().dispatch(gNode);
        this.exitJava();
    }

    public final void visitCompoundStatement(GNode gNode) {
        assert (null == gNode);
    }

    public final void visitFile(GNode gNode) {
        assert (null == gNode);
    }

    public final void visitFunctionDeclarator(GNode gNode) {
        assert (this._cPrinter == this.activePrinter());
        this._cPrinter.dispatch(gNode);
        this.dispatch(gNode.getNode(2));
    }

    public final void visitJavaImports(GNode gNode) {
        boolean bl;
        boolean bl2 = bl = this._cPrinter == this.activePrinter();
        if (bl) {
            this.enterJava(TransitionKind.LONG);
        }
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getNode(i));
        }
        if (bl) {
            this.exitJava();
        }
    }

    public final void visitJavaInCBlock(GNode gNode) {
        this.enterJava(TransitionKind.SHORT);
        this.dispatch(gNode.getNode(0));
        this.exitJava();
    }

    public final void visitJavaInCExpression(GNode gNode) {
        this.enterJava(TransitionKind.SHORT);
        int n = this._jPrinter.startExpression(150);
        this.dispatch(gNode.getNode(0));
        this._jPrinter.endExpression(n);
        this.exitJava();
    }

    public final void visitJavaInCStatement(GNode gNode) {
        this.enterJava(TransitionKind.SHORT);
        this.dispatch(gNode.getNode(0));
        this.exitJava();
    }

    public final void visitJavaInJavaBlock(GNode gNode) {
        assert (this._jPrinter == this.activePrinter());
        this._jPrinter.visitBlock(gNode);
    }

    public final void visitJavaThrows(GNode gNode) {
        if (null == gNode.get(0)) {
            return;
        }
        this.enterJava(TransitionKind.SHORT);
        this.dispatch(gNode.getNode(0));
        this.exitJava();
    }

    public final void visitJavaType(GNode gNode) {
        this.enterJava(TransitionKind.SHORT);
        this.dispatch(gNode.getNode(0));
        this.exitJava();
    }

    public final void visitTranslationUnit(GNode gNode) {
        assert (null == this.activePrinter());
        this.enterC(TransitionKind.SILENT);
        this.activePrinter().dispatch(gNode);
        this.exitC();
    }

    public final void visitWithStatement(GNode gNode) {
        assert (this._cPrinter == this.activePrinter());
        this._printer.p("_with (");
        this.dispatch(gNode.getNode(0));
        this._printer.p(")");
        this.dispatch(gNode.getNode(1));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TransitionKind {
        SILENT,
        SHORT,
        LONG;

    }

    private static final class JeannieJPrinter
    extends JavaPrinter {
        JeannieJPrinter(Printer printer) {
            super(printer);
        }

        public void endExpression(int n) {
            super.endExpression(n);
        }

        public int startExpression(int n) {
            return super.startExpression(n);
        }
    }

    private static final class JeannieCPrinter
    extends CPrinter {
        JeannieCPrinter(Printer printer) {
            super(printer);
        }

        public void endExpression(int n) {
            super.endExpression(n);
        }

        public int startExpression(int n) {
            return super.startExpression(n);
        }
    }

    private static final class Context {
        final Visitor _activePrinter;
        final TransitionKind _transitionKind;

        Context(Visitor visitor, TransitionKind transitionKind) {
            this._activePrinter = visitor;
            this._transitionKind = transitionKind;
        }
    }
}

