/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.jeannie;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import xtc.lang.JavaAstSimplifier;
import xtc.tree.LineMarker;
import xtc.tree.Node;
import xtc.tree.Visitor;

public class AstSimplifier
extends Visitor {
    private static final Set<String> GOTO_C = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CDeclarations", "CInJavaBlock", "CInJavaExpression", "TranslationUnit")));
    private static final Set<String> GOTO_JAVA = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CompilationUnit", "JavaImports", "JavaInCBlock", "JavaInCExpression", "JavaInCStatement", "JavaThrows", "JavaType")));
    private boolean _inJava;
    private final JavaSimplifier _javaSimplifier;

    public AstSimplifier(String string) {
        this._inJava = "Java".equals(string);
        this._javaSimplifier = new JavaSimplifier(this);
    }

    private final Node genericDispatch(Node node) {
        for (int i = 0; i < node.size(); ++i) {
            Object object = node.get(i);
            if (!(object instanceof Node)) continue;
            node.set(i, this.dispatch((Node)object));
        }
        return node;
    }

    public final LineMarker visit(LineMarker lineMarker) {
        lineMarker.setNode((Node)this.dispatch(lineMarker.getNode()));
        return lineMarker;
    }

    public final Node visit(Node node) {
        Node node2;
        if (this._inJava) {
            node2 = (Node)this._javaSimplifier.dispatch(node);
        } else if (GOTO_JAVA.contains(node.getName())) {
            this._inJava = true;
            node2 = this.genericDispatch(node);
            this._inJava = false;
        } else {
            node2 = this.genericDispatch(node);
        }
        return node2;
    }

    private static final class JavaSimplifier
    extends JavaAstSimplifier {
        final AstSimplifier _jeannieSimplifier;

        JavaSimplifier(AstSimplifier astSimplifier) {
            this._jeannieSimplifier = astSimplifier;
        }

        public final Node visit(Node node) {
            if (GOTO_C.contains(node.getName())) {
                this._jeannieSimplifier._inJava = false;
                Node node2 = this._jeannieSimplifier.genericDispatch(node);
                this._jeannieSimplifier._inJava = true;
                return node2;
            }
            return super.visit(node);
        }
    }
}

