/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.c4;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import xtc.lang.CCounter;
import xtc.lang.c4.C4Parser;
import xtc.lang.c4.C4Printer;
import xtc.lang.c4.transformer.C4AspectTransformer;
import xtc.parser.ParseError;
import xtc.parser.SemanticValue;
import xtc.tree.GNode;
import xtc.tree.Printer;
import xtc.util.Statistics;

public final class C4Driver {
    private static final int WARM_UP_RUNS = 2;
    private static final int TOTAL_RUNS = 22;
    private static boolean error = false;
    private static boolean optionIncremental = true;
    private static boolean optionGC = false;
    private static boolean optionASTStats = false;
    private static boolean optionPrintAST = false;
    private static boolean optionPrint = false;
    private static boolean optionStats = false;
    private static boolean optionTable = false;
    private static boolean optionPrintTable = false;
    private static boolean optionAspectTransformer = false;
    private static boolean optionTransformerDebug = false;
    private static Statistics fileSizes = null;
    private static Statistics latencies = null;
    private static Statistics heapSizes = null;
    private static Method dump = null;

    private C4Driver() {
    }

    private static void error(ParseError parseError, C4Parser c4Parser) throws IOException {
        System.err.println();
        System.err.print(c4Parser.format(parseError));
        error = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void process(String var0) throws Exception {
        block40: {
            block39: {
                var1_1 = new File(var0).length();
                var3_2 = null;
                if (0x7FFFFFFFL < var1_1) {
                    throw new IllegalArgumentException("File too large");
                }
                var4_3 = null;
                var5_5 = null;
                var6_6 = 1;
                if (C4Driver.optionStats) {
                    var4_3 = new Statistics();
                    var5_5 = new Statistics();
                    var6_6 = 22;
                    C4Driver.fileSizes.add((double)var1_1 / 1024.0);
                }
                var7_7 = 0;
lbl15:
                // 2 sources

                while (true) {
                    if (var7_7 < var6_6) {
                        var3_2 = new BufferedReader(new FileReader(var0));
                        if (C4Driver.optionGC) {
                            System.gc();
                        }
                        var8_9 = 0L;
                        var10_10 = 0L;
                        if (C4Driver.optionStats) {
                            var10_10 = Runtime.getRuntime().freeMemory();
                            var8_9 = System.currentTimeMillis();
                        }
                        var12_11 = new C4Parser(var3_2, var0, (int)var1_1);
                        var13_12 = null;
                        if (C4Driver.optionIncremental) {
                            var13_12 = GNode.create("TranslationUnit");
                            var14_13 = true;
                            break block39;
                        }
                        var14_14 = var12_11.pTranslationUnit(0);
                        if (!var14_14.hasValue()) {
                            C4Driver.error((ParseError)var14_14, var12_11);
                            return;
                        }
                        var13_12 = (GNode)((SemanticValue)var14_14).value;
                        break block40;
                    }
                    if (C4Driver.optionStats == false) return;
                    var7_8 = var4_3.mean();
                    var9_23 = var5_5.mean();
                    C4Driver.latencies.add(var7_8);
                    C4Driver.heapSizes.add(var9_23 / 1024.0);
                    if (C4Driver.optionTable) {
                        System.out.println(var0 + " " + var1_1 + " " + Statistics.round(var7_8) + " " + var4_3.median() + " " + Statistics.round(var4_3.stdev()) + " " + Statistics.round(var9_23) + " " + var5_5.median() + " " + Statistics.round(var5_5.stdev()));
                        return;
                    }
                    System.out.println("  file size     : " + var1_1);
                    System.out.println("  time   mean   : " + Statistics.round(var7_8));
                    System.out.println("  time   median : " + var4_3.median());
                    System.out.println("  time   stdev  : " + Statistics.round(var4_3.stdev()));
                    System.out.println("  memory mean   : " + Statistics.round(var9_23));
                    System.out.println("  memory median : " + var5_5.median());
                    System.out.println("  memory stdev  : " + Statistics.round(var5_5.stdev()));
                    return;
                }
                finally {
                    if (null != var3_2) {
                        try {
                            var3_2.close();
                        }
                        catch (Exception var16_21) {}
                    }
                }
            }
            while (!var12_11.isEOF(0)) {
                var15_18 = null;
                var15_18 = var14_13 != false ? var12_11.pPrelude(0) : var12_11.pExternalDeclaration(0);
                if (!var15_18.hasValue()) {
                    C4Driver.error((ParseError)var15_18, var12_11);
                    return;
                }
                if (var14_13) {
                    var14_13 = false;
                } else {
                    var13_12.add(((SemanticValue)var15_18).value);
                }
                var12_11.resetTo(var15_18.index);
            }
            var15_18 = var12_11.pAnnotations(0);
            if (!var15_18.hasValue()) {
                C4Driver.error((ParseError)var15_18, var12_11);
                return;
            }
            var13_12.add(((SemanticValue)var15_18).value);
        }
        if (C4Driver.optionAspectTransformer) {
            System.err.println("Invoking C4AspectTransformer ...");
            new C4AspectTransformer(var13_12, C4Driver.optionTransformerDebug).transform();
        }
        if (C4Driver.optionASTStats) {
            var14_15 = new CCounter();
            var14_15.dispatch(var13_12);
            var15_18 = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
            var14_15.print((Printer)var15_18);
            var15_18.flush();
        }
        if (C4Driver.optionPrint || C4Driver.optionPrintAST || C4Driver.optionPrintTable) {
            var14_16 = new Printer(new BufferedWriter(new OutputStreamWriter(System.out)));
            if (C4Driver.optionPrintAST) {
                var14_16.format(var13_12).pln();
            }
            if (C4Driver.optionPrint) {
                new C4Printer(var14_16).dispatch(var13_12);
            }
            if (C4Driver.optionPrintTable) {
                C4Driver.dump.invoke((Object)var12_11, new Object[]{var14_16});
            }
            var14_16.flush();
        }
        if (C4Driver.optionStats) {
            var14_17 = System.currentTimeMillis();
            var16_20 = Runtime.getRuntime().freeMemory();
            if (var7_7 >= 2) {
                var4_3.add(var14_17 - var8_9);
                var5_5.add(var10_10 - var16_20);
            }
        }
        var3_2.close();
        ++var7_7;
        ** continue;
    }

    public static void main(String[] stringArray) {
        int n;
        System.err.print("C4 Parser Driver Version ");
        System.err.print("1.14.1");
        System.err.print("   ");
        System.err.println("(C) 2004-2008 Robert Grimm");
        if (null == stringArray || 0 == stringArray.length) {
            System.err.println();
            System.err.println("Usage: <option>* <file-name>+");
            System.err.println();
            System.err.println("Options are:");
            System.err.println("  -noincr    Do not parse incrementally.");
            System.err.println("  -gc        Perform GC before parsing a file.");
            System.err.println("  -aststats  Collect and print AST statistics.");
            System.err.println("  -ast       Print the AST in generic form.");
            System.err.println("  -source    Print the AST in C source form.");
            System.err.println("  -at        Transform Aspect to C.");
            System.err.println("  -tdebug    Turn on debugging for Aspect Transformer.");
            System.err.println("  -stats     Collect and print performance statistics.");
            System.err.println("  -table     Print performance statistics as a table.");
            System.err.println("  -memo      Print the memoization table.");
            System.err.println();
            System.exit(1);
        }
        int n2 = -1;
        error = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("-")) {
                if ("-noincr".equals(stringArray[n])) {
                    optionIncremental = false;
                    continue;
                }
                if ("-gc".equals(stringArray[n])) {
                    optionGC = true;
                    continue;
                }
                if ("-aststats".equals(stringArray[n])) {
                    optionASTStats = true;
                    continue;
                }
                if ("-ast".equals(stringArray[n])) {
                    optionPrintAST = true;
                    continue;
                }
                if ("-source".equals(stringArray[n])) {
                    optionPrint = true;
                    continue;
                }
                if ("-tdebug".equals(stringArray[n])) {
                    optionTransformerDebug = true;
                    continue;
                }
                if ("-at".equals(stringArray[n])) {
                    optionAspectTransformer = true;
                    continue;
                }
                if ("-stats".equals(stringArray[n])) {
                    optionStats = true;
                    continue;
                }
                if ("-table".equals(stringArray[n])) {
                    optionTable = true;
                    continue;
                }
                if ("-memo".equals(stringArray[n])) {
                    try {
                        dump = C4Parser.class.getMethod("dump", Printer.class);
                    }
                    catch (Exception exception) {
                        System.err.println("Parser cannot print memoization table. Rebuild with dumpTable option.");
                        error = true;
                    }
                    optionPrintTable = true;
                    continue;
                }
                System.err.println("Unrecognized option " + stringArray[n]);
                error = true;
                continue;
            }
            n2 = n;
            break;
        }
        if (-1 == n2) {
            System.err.println("No file names specified");
            error = true;
        }
        if (error) {
            System.exit(1);
        }
        if (optionStats) {
            fileSizes = new Statistics();
            latencies = new Statistics();
            heapSizes = new Statistics();
            if (optionTable) {
                System.out.println("Legend: File, size, time (ave, med, stdev), memory (ave, med, stdev)");
                System.out.println();
            }
        }
        error = false;
        for (n = n2; n < stringArray.length; ++n) {
            if (!optionStats || !optionTable) {
                System.err.println("Processing " + stringArray[n] + " ...");
            }
            try {
                C4Driver.process(stringArray[n]);
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                error = true;
                while (null != throwable2.getCause()) {
                    throwable2 = throwable2.getCause();
                }
                if (throwable2 instanceof FileNotFoundException) {
                    System.err.println(throwable2.getMessage());
                    continue;
                }
                throwable2.printStackTrace();
            }
        }
        if (optionStats) {
            double d = 1000.0 / Statistics.fitSlope(fileSizes, latencies);
            double d2 = Statistics.fitSlope(fileSizes, heapSizes);
            System.out.println();
            System.out.println("Overall performance      : " + Statistics.round(d) + " KB/s");
            System.out.println("Overall heap utilization : " + Statistics.round(d2) + ":1");
        }
        if (error) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }
}

