/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import xtc.lang.blink.Blink;
import xtc.lang.blink.Event;

abstract class StdIOProcess
implements Event.BlinkEventSource {
    private static final boolean needDOSEOLProcessing = System.getProperty("os.name").startsWith("Windows");
    protected final Blink dbg;
    private final String name;
    private String[] commandArray;
    private Process process;
    private BufferedWriter out;
    private final ThreadGroup tg;
    private final Thread stdOutReader;
    private final Thread stdErrReader;
    private final OutputLog logStdOut;
    private final OutputLog logStderr;

    private static int read(BufferedReader bufferedReader, char[] cArray) throws IOException {
        int n;
        int n2 = bufferedReader.read(cArray);
        if (n2 < 0) {
            return n2;
        }
        if (needDOSEOLProcessing) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (cArray[i] == '\r') continue;
                if (n == i) {
                    ++n;
                    continue;
                }
                assert (n <= i);
                cArray[n++] = cArray[i];
            }
        } else {
            n = n2;
        }
        return n;
    }

    StdIOProcess(Blink blink, String string) {
        this.dbg = blink;
        this.name = string;
        this.logStdOut = new OutputLog(blink.options.getLogSizeForMicroDebuggerOutput());
        this.logStderr = new OutputLog(blink.options.getLogSizeForMicroDebuggerOutput());
        this.tg = new ThreadGroup(this.getEventSourceName());
        this.stdOutReader = new Thread(this.tg, "stdout reader for " + this.getEventSourceName()){

            public void run() {
                StdIOProcess.this.monitorStdOut();
            }
        };
        this.stdErrReader = new Thread(this.tg, "stderr reader for " + this.getEventSourceName()){

            public void run() {
                StdIOProcess.this.monitorStdErr();
            }
        };
    }

    public String getEventSourceName() {
        return this.name;
    }

    protected void begin(String[] stringArray) {
        this.commandArray = stringArray;
        try {
            this.process = Runtime.getRuntime().exec(this.commandArray);
            OutputStream outputStream = this.process.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.out = new BufferedWriter(outputStreamWriter);
        }
        catch (IOException iOException) {
            this.dbg.err("could not correctly run " + this.commandArray + "\n");
            iOException.printStackTrace();
            return;
        }
        assert (this.process != null);
        this.stdOutReader.start();
        this.stdErrReader.start();
    }

    private void monitorStdOut() {
        block7: {
            InputStream inputStream = this.process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] cArray = new char[1024];
            try {
                int n = StdIOProcess.read(bufferedReader, cArray);
                while (n > 0) {
                    Object object;
                    if (this.dbg.options.getVerboseLevel() >= 1) {
                        object = new String(cArray, 0, n);
                        this.dbg.out((String)object);
                    }
                    this.logStdOut.put(cArray, 0, n);
                    object = new Event.RawTextMessageEvent(this, cArray, 0, n);
                    this.dbg.enqueEvent((Event)object);
                    this.processMessageEvent((Event.RawTextMessageEvent)object);
                    n = StdIOProcess.read(bufferedReader, cArray);
                }
                assert (n == -1);
            }
            catch (IOException iOException) {
                if (this.dbg.options.getVerboseLevel() < 1) break block7;
                this.dbg.err(this.name + ": " + " got an IO Exception in reading stderr, \n");
                this.dbg.err(this.name + ": " + " and finishing message reading thread\n");
            }
        }
        try {
            this.stdErrReader.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.dbg.enqueEvent(new Event.DeathEvent(this));
    }

    private void monitorStdErr() {
        block5: {
            InputStream inputStream = this.process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] cArray = new char[1024];
            try {
                int n = StdIOProcess.read(bufferedReader, cArray);
                while (n > 0) {
                    Object object;
                    if (this.dbg.options.getVerboseLevel() >= 1) {
                        object = new String(cArray, 0, n);
                        this.dbg.out((String)object);
                    }
                    this.logStderr.put(cArray, 0, n);
                    object = new Event.RawTextMessageEvent(this, cArray, 0, n);
                    this.processMessageEvent((Event.RawTextMessageEvent)object);
                    this.dbg.enqueEvent((Event)object);
                    n = StdIOProcess.read(bufferedReader, cArray);
                }
                assert (n == -1);
            }
            catch (IOException iOException) {
                if (this.dbg.options.getVerboseLevel() < 1) break block5;
                this.dbg.err(this.name + ": " + " got an IO Exception in reading stdout, ");
                this.dbg.err(this.name + ": " + " and finishing message reading thread\n");
            }
        }
    }

    abstract void processMessageEvent(Event.RawTextMessageEvent var1);

    public void sendMessage(String string) throws IOException {
        if (this.dbg.options.getVerboseLevel() >= 1) {
            this.dbg.out(this.name + ":send:" + string);
        }
        this.out.write(string);
        this.out.flush();
    }

    public String getLastOutputMessage() {
        return this.logStdOut.getLastTrace();
    }

    private static class OutputLog {
        private final char[] log;
        private int head = -1;
        private int tail = -1;

        OutputLog(int n) {
            assert (n > 0);
            this.log = new char[n];
        }

        private void put(char c) {
            if (this.length() == 0) {
                this.tail = 0;
                this.head = 0;
                this.log[0] = c;
            } else {
                this.head = (this.head + 1) % this.log.length;
                if (this.tail == this.head) {
                    this.tail = (this.tail + 1) % this.log.length;
                }
                this.log[this.head] = c;
            }
        }

        private int length() {
            if (this.head > this.tail) {
                return this.head - this.tail + 1;
            }
            if (this.head < this.tail) {
                return this.head + 1 + (this.log.length - this.tail);
            }
            if (this.head == -1 && this.tail == -1) {
                return 0;
            }
            assert (this.head == 0 && this.tail == 0);
            return 1;
        }

        public synchronized void put(char[] cArray, int n, int n2) {
            assert (n >= 0 && n2 >= 0);
            for (int i = 0; i < n2; ++i) {
                this.put(cArray[n + i]);
            }
        }

        public synchronized String getLastTrace() {
            int n = this.length();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.log[(this.tail + i) % this.log.length];
            }
            return new String(cArray);
        }
    }
}

