/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xtc.lang.blink.Blink;
import xtc.lang.blink.CallStack;
import xtc.lang.blink.Event;
import xtc.lang.blink.EventLoop;
import xtc.lang.blink.EventUtil;
import xtc.lang.blink.StdIOProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDebugger
extends StdIOProcess {
    private static final Pattern jdbListeningPattern = Pattern.compile("Listening at address: (\\S+)\\n");
    private static final Pattern jdbInitialedPattern = Pattern.compile("Initializing jdb ...\\n(.*\\n)*.+\\[1\\] ");
    private static final Pattern jdbBreakPointHitPattern = Pattern.compile("Breakpoint hit: \\\"thread=([^\"]+)\\\", ([^,]+), line=([0-9,]+) bci=([0-9]+)\\n((.*)\\n)?\\n.+\\[\\d+\\] ");
    private static final Pattern jdbStepCompletionPattern = Pattern.compile("Step completed: \\\"thread=(.+)\\\", (.+\\..+), line=([0-9,]+) bci=([0-9]+)\\n((?:.*\\n)+)(.+)\\[1\\] ");
    private static final Pattern j2cCompletionPattern = Pattern.compile(" xtc.lang.blink.Agent.j2c\\(\\) = <void value>\\n(?:.+)\\[1\\] ");
    private boolean j2c_pending = false;
    private final StringBuffer sbStdout = new StringBuffer();
    private boolean jdbListenAddressEventFired = false;
    private boolean jdbInitializedEventFired = false;

    public JavaDebugger(Blink blink, String string) {
        super(blink, string);
    }

    public void startListening(String string) throws IOException {
        String string2 = "jdb -listenany " + string;
        if (this.dbg.options.getVerboseLevel() >= 1) {
            this.dbg.out("executing: " + string2 + "\n");
        }
        this.begin(string2.split("\\s+"));
    }

    public boolean initAgent() throws IOException {
        Matcher matcher = this.raeJDB("eval java.lang.Class.forName(\"xtc.lang.blink.Agent\")\n", "java.lang.Class.forName.\"xtc.lang.blink.Agent\". = (\"class xtc.lang.blink.Agent\"|null)\\n(?:.*\\n)*\\S+\\[\\d+\\] ");
        if (matcher.group(1).equals("null")) {
            return false;
        }
        this.raeJDB("eval xtc.lang.blink.Agent.init()\n", "xtc.lang.blink.Agent.init\\(\\) = <void value>\\n(?:.*\\n)*\\S+\\[\\d+\\] ");
        this.raeJDB("stop in xtc.lang.blink.Agent.jbp\n");
        return true;
    }

    public int getJVMProcessID() throws IOException {
        Matcher matcher = this.raeJDB("print xtc.lang.blink.Agent.getProcessID()\n", "xtc.lang.blink.Agent.getProcessID\\(\\) = (\\d+)");
        int n = Integer.parseInt(matcher.group(1));
        return n;
    }

    public void j2c() throws IOException {
        this.sendMessage("eval xtc.lang.blink.Agent.j2c()\n");
        this.j2c_pending = true;
    }

    public void run() throws IOException {
        this.sendMessage("run\n");
    }

    public void cont() throws IOException {
        this.sendMessage("cont\n");
    }

    public void step() throws IOException {
        this.sendMessage("step\n");
    }

    public void stepi() throws IOException {
        this.raeJDB("stepi\n");
    }

    public void exit() throws IOException {
        this.sendMessage("exit\n");
    }

    public void setLoadLibraryEvent() throws IOException {
        this.raeJDB("stop in java.lang.System.loadLibrary\n");
    }

    public void resetLoadLibraryEvent() throws IOException {
        this.raeJDB("clear java.lang.System.loadLibrary\n");
    }

    public void prepareLoadLibrary() throws IOException {
        this.raeJDB("step up\n");
    }

    public void setBreakPoint(String string, int n) throws IOException {
        this.raeJDB("stop at " + string + ":" + n + "\n");
    }

    public void clearBreakPoint(String string, int n) throws IOException {
        this.raeJDB("clear " + string + ":" + n + "\n");
    }

    public void setBreakPoint(String string) throws IOException {
        this.raeJDB("stop in " + string + "\n");
    }

    public void clearBreakPoint(String string) throws IOException {
        this.raeJDB("clear " + string + "\n");
    }

    public List<CallStack.JavaCallFrame> getFrames() throws IOException {
        String string = this.raeJDB("where\n");
        LinkedList<CallStack.JavaCallFrame> linkedList = new LinkedList<CallStack.JavaCallFrame>();
        Pattern pattern2 = Pattern.compile("^\\s+\\[([0-9]+)\\]\\s+((\\S+)\\.([^\\.]+))\\s+(\\(([^:]+):([0-9]+)\\)|(\\(native method\\)))$");
        for (String string2 : string.split("\n")) {
            boolean bl;
            Matcher matcher = pattern2.matcher(string2);
            if (!matcher.find()) {
                this.dbg.err("could recognize jdb output: " + string2 + "\n");
                continue;
            }
            int n = Integer.valueOf(matcher.group(1));
            String string3 = matcher.group(3);
            String string4 = matcher.group(4);
            String string5 = matcher.group(6);
            int n2 = matcher.group(7) == null ? -1 : Integer.parseInt(matcher.group(7));
            boolean bl2 = bl = matcher.group(8) != null;
            if (string5 != null && string5.equals("Agent.java")) continue;
            CallStack.JavaCallFrame javaCallFrame = new CallStack.JavaCallFrame(n, string5, n2, bl, string3, string4);
            linkedList.addLast(javaCallFrame);
        }
        return linkedList;
    }

    private void selectFrame(CallStack.JavaCallFrame javaCallFrame) throws IOException {
        String string;
        int n;
        Blink.DebugerControlStatus debugerControlStatus = this.dbg.getDebugControlStatus();
        assert (debugerControlStatus == Blink.DebugerControlStatus.JDB || debugerControlStatus == Blink.DebugerControlStatus.JDB_IN_GDB);
        int n2 = javaCallFrame.getJdbIdentifier();
        int n3 = n2 - (n = Integer.parseInt(string = this.raeJDB("where\n", "  \\[(\\d+)\\] .+\\n(?:.*\\n)*\\S+\\[\\d+\\] ").group(1)));
        if (n3 > 0) {
            this.raeJDB("up " + n3 + "\n");
        } else if (n3 < 0) {
            int n4 = -n3;
            this.raeJDB("down " + n4 + "\n");
        }
        String string2 = this.raeJDB("where\n", "\\s \\[(\\d+)\\] .+\\n(?:.*\\n)*\\S+\\[\\d+\\] ").group(1);
        int n5 = Integer.parseInt(string2);
        assert (n5 == n2);
    }

    public List<CallStack.LocalVariable> getLocals(CallStack.JavaCallFrame javaCallFrame) throws IOException {
        LinkedList<CallStack.LocalVariable> linkedList = new LinkedList<CallStack.LocalVariable>();
        this.selectFrame(javaCallFrame);
        String string = this.raeJDB("locals\n");
        Pattern pattern2 = Pattern.compile("^(.+) = (.+)$");
        for (String string2 : string.split("\n")) {
            Matcher matcher = pattern2.matcher(string2);
            if (matcher.matches()) {
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                linkedList.add(new CallStack.LocalVariable(string3, string4));
                continue;
            }
            if (string2.equals("Method arguments:") || string2.equals("Local variables:") || string2.equals("")) continue;
            this.dbg.err("can not recognize this JDB output: " + string2 + "\n");
        }
        return linkedList;
    }

    public String eval(CallStack.JavaCallFrame javaCallFrame, String string) throws IOException {
        String string2 = this.raeJDB("eval " + string + "\n", ".+ = (.+)\\n(?:.*\\n)*\\S+\\[\\d+\\] ").group(1);
        return string2;
    }

    public String eval(String string) throws IOException {
        String string2 = this.raeJDB("eval " + string + "\n", ".+ = (.+)\\n(?:.*\\n)*\\S+\\[\\d+\\] ").group(1);
        return string2;
    }

    public String print(CallStack.JavaCallFrame javaCallFrame, String string) throws IOException {
        String string2 = this.raeJDB("print " + string + "\n", "\\S+ = (\\S+)\\n(?:.*\\n)*\\S+\\[\\d+\\] ").group(1);
        return string2;
    }

    public String list(CallStack.JavaCallFrame javaCallFrame) throws IOException {
        return this.raeJDB("list\n");
    }

    public String runCommand(String string) throws IOException {
        return this.raeJDB(string + "\n");
    }

    public void cleanConvenienceVariables() throws IOException {
        this.raeJDB("eval xtc.lang.blink.AgentVariable.cleanTempVars()\n");
    }

    public void dispatch(Event event) {
    }

    public Matcher raeJDB(final String string, String string2) throws IOException {
        return (Matcher)EventLoop.subLoop(this.dbg, new EventLoop.Action(){

            public void execute() throws IOException {
                JavaDebugger.this.sendMessage(string);
            }
        }, new EventUtil.RegExpReplyHandler(this, string2));
    }

    private String raeJDB(String string) throws IOException {
        return this.raeJDB(string, "((?:.+\\n)*)\\S+\\[\\d+\\] ").group(1);
    }

    @Override
    protected void processMessageEvent(Event.RawTextMessageEvent rawTextMessageEvent) {
        Matcher matcher;
        String string;
        Object object;
        Object object2;
        Object object3;
        Matcher matcher2;
        this.sbStdout.append(new String(rawTextMessageEvent.getMessage()));
        if (!this.jdbListenAddressEventFired) {
            matcher2 = jdbListeningPattern.matcher(this.sbStdout);
            if (matcher2.find()) {
                object3 = this.sbStdout.substring(matcher2.end());
                object2 = matcher2.group(1);
                this.sbStdout.setLength(0);
                this.sbStdout.append((String)object3);
                object = new ListenAddressEvent(this, (String)object2);
                this.dbg.enqueEvent((Event)object);
                this.jdbListenAddressEventFired = true;
            }
        } else if (!this.jdbInitializedEventFired && (matcher2 = jdbInitialedPattern.matcher(this.sbStdout)).find()) {
            object3 = this.sbStdout.substring(matcher2.end());
            this.sbStdout.setLength(0);
            this.sbStdout.append((String)object3);
            object2 = new InitializedEvent(this);
            this.dbg.enqueEvent((Event)object2);
            this.jdbInitializedEventFired = true;
        }
        matcher2 = jdbBreakPointHitPattern.matcher(this.sbStdout);
        if (matcher2.find()) {
            int n = matcher2.end();
            object2 = this.sbStdout.substring(n);
            object = matcher2.group(2);
            int n2 = Integer.valueOf(matcher2.group(3).replace(",", ""));
            String string2 = matcher2.group(6);
            if (string2 == null) {
                string2 = "";
            }
            this.sbStdout.setLength(0);
            this.sbStdout.append((String)object2);
            Event.SubDebuggerEvent subDebuggerEvent = ((String)object).startsWith("java.lang.System.loadLibrary") ? new Event.JavaLoadLibraryEvent(this) : new Event.JavaBreakPointHitEvent(this, (String)object, n2, string2);
            this.dbg.enqueEvent(subDebuggerEvent);
            return;
        }
        object3 = jdbStepCompletionPattern.matcher(this.sbStdout);
        if (((Matcher)object3).find()) {
            int n = ((Matcher)object3).end();
            object = this.sbStdout.substring(n);
            string = ((Matcher)object3).group(2);
            int n3 = Integer.valueOf(((Matcher)object3).group(3).replace(",", ""));
            int n4 = Integer.valueOf(((Matcher)object3).group(4));
            String string3 = ((Matcher)object3).group(5);
            Event.JavaStepCompletionEvent javaStepCompletionEvent = new Event.JavaStepCompletionEvent(this, n3, n4, string, string3);
            this.dbg.enqueEvent(javaStepCompletionEvent);
            this.sbStdout.setLength(0);
            this.sbStdout.append((String)object);
        }
        if (this.j2c_pending && (matcher = j2cCompletionPattern.matcher(this.sbStdout)).find()) {
            int n = matcher.end();
            string = this.sbStdout.substring(n);
            Event.J2CCompletionEvent j2CCompletionEvent = new Event.J2CCompletionEvent(this);
            this.dbg.enqueEvent(j2CCompletionEvent);
            this.sbStdout.setLength(0);
            this.sbStdout.append(string);
            this.j2c_pending = false;
        }
    }

    public static class InitializedEvent
    extends Event {
        InitializedEvent(JavaDebugger javaDebugger) {
            super(javaDebugger);
        }

        public String getName() {
            return "JDBInitialized:";
        }
    }

    public static class ListenAddressEvent
    extends Event {
        private final String address;

        ListenAddressEvent(JavaDebugger javaDebugger, String string) {
            super(javaDebugger);
            this.address = string;
        }

        public String getAddress() {
            return this.address;
        }

        public String getName() {
            return "JDBListen:" + this.address;
        }
    }
}

