/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.IOException;
import xtc.lang.blink.Blink;
import xtc.lang.blink.CommandInterpreter;
import xtc.lang.blink.Event;
import xtc.lang.blink.Utilities;
import xtc.tree.GNode;

public class EventLoop {
    private final Blink dbg;
    final CommandInterpreter interpreter;
    private boolean jvmFinished = false;
    private boolean jdbFinisned = false;
    private boolean gdbFinished = false;

    EventLoop(Blink blink) {
        this.dbg = blink;
        this.interpreter = new CommandInterpreter(blink, blink.breakpointManager);
    }

    void main() {
        boolean bl = false;
        while (!bl) {
            Event event = this.dbg.dequeEvent();
            if (this.dbg.options.getVerboseLevel() >= 2) {
                this.dbg.out("mainLoop dispatching: " + event + "\n");
            }
            switch (event.consumer) {
                case BlinkController: {
                    if (event instanceof Event.UserCommandEvent) {
                        this.dispatch((Event.UserCommandEvent)event);
                        break;
                    }
                    if (event instanceof Event.SubDebuggerEvent) {
                        this.dispatch((Event.SubDebuggerEvent)event);
                        break;
                    }
                    if (!(event instanceof Event.SessionFinishRequestEvent)) break;
                    bl = true;
                    break;
                }
                case JavaDebugger: {
                    this.dbg.jdb.dispatch(event);
                    break;
                }
                case NativerDebugger: {
                    this.dbg.gdb.dispatch(event);
                }
            }
        }
    }

    public static Object subLoop(Blink blink, Action action, ReplyHandler replyHandler) throws IOException {
        action.execute();
        boolean bl = false;
        while (!bl) {
            Event event = blink.dequeEvent();
            if (blink.options.getVerboseLevel() >= 2) {
                blink.out("subLoop dispatching: " + event + "\n");
            }
            switch (event.consumer) {
                case BlinkController: {
                    if (event instanceof Event.UserCommandEvent) {
                        blink.eventLoop.dispatch((Event.UserCommandEvent)event);
                        break;
                    }
                    bl = replyHandler.dispatch(event);
                    break;
                }
                case JavaDebugger: {
                    blink.jdb.dispatch(event);
                    break;
                }
                case NativerDebugger: {
                    blink.gdb.dispatch(event);
                }
            }
        }
        assert (bl);
        return replyHandler.getResult();
    }

    void dispatch(Event.UserCommandEvent userCommandEvent) {
        String string = userCommandEvent.getCommandLine();
        if (string.startsWith("bdb ")) {
            this.dbg.executeDebugCommand(string);
        } else {
            this.executeBlinkCommand(string);
        }
        this.dbg.showPrompt();
    }

    private void dispatch(Event.SubDebuggerEvent subDebuggerEvent) {
        if (subDebuggerEvent instanceof Event.DeathEvent) {
            this.dispatch((Event.DeathEvent)subDebuggerEvent);
        } else if (subDebuggerEvent instanceof Event.NativeBreakPointHitEvent) {
            this.dispatch((Event.NativeBreakPointHitEvent)subDebuggerEvent);
        } else if (subDebuggerEvent instanceof Event.JavaBreakPointHitEvent) {
            this.dispatch((Event.JavaBreakPointHitEvent)subDebuggerEvent);
        } else if (subDebuggerEvent instanceof Event.JavaLoadLibraryEvent) {
            this.dispatch((Event.JavaLoadLibraryEvent)subDebuggerEvent);
        }
    }

    private void dispatch(Event.DeathEvent deathEvent) {
        if (deathEvent.getSource() == this.dbg.jvm) {
            assert (!this.jvmFinished) : "no double death!";
            this.jvmFinished = true;
        } else if (deathEvent.getSource() == this.dbg.jdb) {
            assert (!this.jdbFinisned) : "no double death!";
            this.jdbFinisned = true;
        } else if (deathEvent.getSource() == this.dbg.gdb) {
            assert (!this.gdbFinished);
            this.gdbFinished = true;
        }
        if (this.jvmFinished && this.jdbFinisned && (!this.dbg.IsNativeDebuggerAttached() || this.gdbFinished)) {
            this.dbg.enqueEvent(new Event.SessionFinishRequestEvent("Application finished"));
        }
    }

    void executeBlinkCommand(String string) {
        String string2 = this.dbg.getCurrentLanguageContext();
        Object object = Utilities.debuggerParseAndAnalyze(string2, string);
        if (object instanceof GNode) {
            GNode gNode = (GNode)object;
            this.interpreter.dispatch(gNode);
        } else {
            this.dbg.err((String)object);
        }
    }

    private synchronized void dispatch(Event.JavaLoadLibraryEvent javaLoadLibraryEvent) {
        assert (this.dbg.getDebugControlStatus() == Blink.DebugerControlStatus.NONE);
        this.dbg.changeDebugControlStatus(Blink.DebugerControlStatus.JDB);
        try {
            this.dbg.jdb.prepareLoadLibrary();
            if (this.dbg.ensureDebugAgent() && this.dbg.breakpointManager.hasDeferredGDBBreakPoint()) {
                this.dbg.breakpointManager.HandleDeferredBreakPoint();
            }
            this.dbg.ensureJDBContext();
            this.dbg.jdb.cont();
            this.dbg.changeDebugControlStatus(Blink.DebugerControlStatus.NONE);
        }
        catch (IOException iOException) {
            this.dbg.err("could not correctly handle internal System.loadlibrary.\n");
        }
    }

    private void dispatch(Event.JavaBreakPointHitEvent javaBreakPointHitEvent) {
        assert (this.dbg.getDebugControlStatus() == Blink.DebugerControlStatus.NONE);
        this.dbg.changeDebugControlStatus(Blink.DebugerControlStatus.JDB);
        this.dbg.out("Java break point hit - " + javaBreakPointHitEvent.classAndmethod + ":" + javaBreakPointHitEvent.line + "\n");
        if (javaBreakPointHitEvent.sourceLine.length() > 0) {
            this.dbg.out(javaBreakPointHitEvent.sourceLine + "\n");
        }
        this.dbg.setBreakPointLocation(javaBreakPointHitEvent.classAndmethod, javaBreakPointHitEvent.line);
        this.dbg.changeDebugControlStatus(Blink.DebugerControlStatus.JDB);
        try {
            if (!this.dbg.ensureDebugAgent()) {
                return;
            }
            this.dbg.showPrompt();
        }
        catch (IOException iOException) {
            this.dbg.err("can not initialize the debugger helper.");
        }
    }

    private void dispatch(Event.NativeBreakPointHitEvent nativeBreakPointHitEvent) {
        assert (this.dbg.getDebugControlStatus() == Blink.DebugerControlStatus.NONE);
        if (nativeBreakPointHitEvent.sourceFile != null) {
            this.dbg.out("C break point hit - " + nativeBreakPointHitEvent.sourceFile + ":" + nativeBreakPointHitEvent.line + "\n");
            if (nativeBreakPointHitEvent.srcLine.length() > 0) {
                this.dbg.out(nativeBreakPointHitEvent.srcLine + "\n");
            }
            this.dbg.setBreakPointLocation(nativeBreakPointHitEvent.sourceFile, nativeBreakPointHitEvent.line);
        } else {
            this.dbg.out("C break point hit - " + nativeBreakPointHitEvent.symbol + ":" + nativeBreakPointHitEvent.addr + "\n");
            this.dbg.setBreakPointLocation(null);
        }
        this.dbg.changeDebugControlStatus(Blink.DebugerControlStatus.GDB);
        this.dbg.showPrompt();
    }

    static abstract class ReplyHandler {
        protected Object result;

        ReplyHandler() {
        }

        protected void setResult(Object object) {
            assert (this.result == null) : "the result is set only once";
            this.result = object;
        }

        public Object getResult() {
            return this.result;
        }

        abstract boolean dispatch(Event var1);
    }

    static interface Action {
        public void execute() throws IOException;
    }
}

