/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import xtc.lang.blink.CommandLineInterface;
import xtc.lang.blink.JavaDebugger;
import xtc.lang.blink.NativeDebugger;
import xtc.lang.blink.SymbolMapper;

public abstract class Event {
    public static final BlinkEventSource dummySource = new BlinkEventSource(){

        public String getEventSourceName() {
            return "dummy";
        }
    };
    final BlinkEventSource source;
    final EventConsumer consumer;

    Event(BlinkEventSource blinkEventSource) {
        this(blinkEventSource, EventConsumer.BlinkController);
    }

    Event(BlinkEventSource blinkEventSource, EventConsumer eventConsumer) {
        assert (blinkEventSource != null);
        this.source = blinkEventSource;
        this.consumer = eventConsumer;
    }

    public BlinkEventSource getSource() {
        return this.source;
    }

    public abstract String getName();

    public String toString() {
        return "Event[" + this.getName() + "," + this.getSource().getEventSourceName() + "," + (Object)((Object)this.consumer) + "]";
    }

    static class J2CCompletionEvent
    extends SubDebuggerEvent {
        public J2CCompletionEvent(JavaDebugger javaDebugger) {
            super(javaDebugger);
        }

        public String getName() {
            return "J2CCompletion";
        }
    }

    static class JavaLoadLibraryEvent
    extends SubDebuggerEvent {
        public JavaLoadLibraryEvent(JavaDebugger javaDebugger) {
            super(javaDebugger);
        }

        public String getName() {
            return "JavaLoadLibrary";
        }
    }

    static class JavaStepCompletionEvent
    extends JavaPauseEvent {
        final int bcIndex;

        public JavaStepCompletionEvent(JavaDebugger javaDebugger, int n, int n2, String string, String string2) {
            super(javaDebugger, string, n, string2);
            this.bcIndex = n2;
        }

        public String getName() {
            return "JavaStepCompleted";
        }
    }

    static class JavaBreakPointHitEvent
    extends JavaPauseEvent {
        public JavaBreakPointHitEvent(JavaDebugger javaDebugger, String string, int n, String string2) {
            super(javaDebugger, string, n, string2);
        }

        public String getName() {
            return "JavaBPHit";
        }
    }

    static abstract class JavaPauseEvent
    extends SubDebuggerEvent {
        final String classAndmethod;
        final int line;
        final String sourceLine;

        public JavaPauseEvent(JavaDebugger javaDebugger, String string, int n, String string2) {
            super(javaDebugger);
            this.classAndmethod = string;
            this.line = n;
            this.sourceLine = string2;
        }
    }

    static class J2CBreakPointHitEvent
    extends SubDebuggerEvent {
        public J2CBreakPointHitEvent(NativeDebugger nativeDebugger) {
            super(nativeDebugger);
        }

        public String getName() {
            return "J2CHit";
        }
    }

    static class NativeStepCompletionEvent
    extends SubDebuggerEvent {
        public NativeStepCompletionEvent(NativeDebugger nativeDebugger) {
            super(nativeDebugger);
        }

        public String getName() {
            return "NativeStepCompleted";
        }
    }

    static class NativeBreakPointHitEvent
    extends NativePauseEvent {
        final int bpid;

        public String getName() {
            return "NativeBPHit";
        }

        public NativeBreakPointHitEvent(NativeDebugger nativeDebugger, int n, String string, String string2) {
            this(nativeDebugger, n, string, string2, null, -1, null);
        }

        public NativeBreakPointHitEvent(NativeDebugger nativeDebugger, int n, String string, String string2, int n2, String string3) {
            this(nativeDebugger, n, string, null, string2, n2, string3);
        }

        private NativeBreakPointHitEvent(NativeDebugger nativeDebugger, int n, String string, String string2, String string3, int n2, String string4) {
            super(nativeDebugger, string, string2, string3, n2, string4);
            this.bpid = n;
        }
    }

    static abstract class NativePauseEvent
    extends SubDebuggerEvent {
        final String symbol;
        final String addr;
        final String sourceFile;
        final int line;
        final String srcLine;

        public NativePauseEvent(NativeDebugger nativeDebugger, String string, String string2, String string3, int n, String string4) {
            super(nativeDebugger);
            this.symbol = string;
            this.addr = string2;
            this.sourceFile = string3;
            this.line = n;
            this.srcLine = string4;
        }
    }

    static class LanguageTransitionEvent
    extends SubDebuggerEvent {
        final NativeDebugger.LanguageTransitionBreakPoint bptype;
        final String c2jtarget;
        final SymbolMapper.SourceFileAndLine fileAndLine;
        final String srcLine;

        public LanguageTransitionEvent(NativeDebugger nativeDebugger, NativeDebugger.LanguageTransitionBreakPoint languageTransitionBreakPoint, String string) {
            this(nativeDebugger, languageTransitionBreakPoint, string, null, null);
        }

        public LanguageTransitionEvent(NativeDebugger nativeDebugger, NativeDebugger.LanguageTransitionBreakPoint languageTransitionBreakPoint, SymbolMapper.SourceFileAndLine sourceFileAndLine, String string) {
            this(nativeDebugger, languageTransitionBreakPoint, null, sourceFileAndLine, string);
        }

        private LanguageTransitionEvent(NativeDebugger nativeDebugger, NativeDebugger.LanguageTransitionBreakPoint languageTransitionBreakPoint, String string, SymbolMapper.SourceFileAndLine sourceFileAndLine, String string2) {
            super(nativeDebugger);
            this.bptype = languageTransitionBreakPoint;
            this.c2jtarget = string;
            this.fileAndLine = sourceFileAndLine;
            this.srcLine = string2;
        }

        public String getName() {
            return "LanguageTransition";
        }
    }

    static class DeathEvent
    extends SubDebuggerEvent {
        DeathEvent(BlinkEventSource blinkEventSource) {
            super(blinkEventSource);
        }

        public String getName() {
            return "Death";
        }
    }

    static abstract class SubDebuggerEvent
    extends Event {
        SubDebuggerEvent(BlinkEventSource blinkEventSource) {
            super(blinkEventSource);
        }
    }

    public static class SessionFinishRequestEvent
    extends Event {
        private final String reason;

        SessionFinishRequestEvent(String string) {
            super(dummySource);
            this.reason = string;
        }

        public String getReason() {
            return this.reason;
        }

        public String getName() {
            return "BlinkSessionEnd";
        }

        public String toString() {
            return super.toString() + this.reason;
        }
    }

    static class RawTextMessageEvent
    extends Event {
        final char[] message;

        RawTextMessageEvent(BlinkEventSource blinkEventSource, char[] cArray) {
            this(blinkEventSource, cArray, 0, cArray.length);
        }

        RawTextMessageEvent(BlinkEventSource blinkEventSource, char[] cArray, int n, int n2) {
            super(blinkEventSource);
            assert (cArray != null && n >= 0 && n2 > 0 && cArray.length >= n + n2);
            this.message = new char[n2];
            System.arraycopy(cArray, n, this.message, 0, n2);
        }

        char[] getMessage() {
            return this.message;
        }

        public String getName() {
            return "RawMessage";
        }

        public String toString() {
            return super.toString() + new String(this.message);
        }
    }

    static class UserCommandEvent
    extends Event {
        private final String userCommand;

        UserCommandEvent(CommandLineInterface commandLineInterface, String string) {
            super(commandLineInterface);
            this.userCommand = string;
        }

        public String getCommandLine() {
            return this.userCommand;
        }

        public String getName() {
            return "UserCommand";
        }

        public String toString() {
            return super.toString() + this.userCommand;
        }
    }

    static interface BlinkEventSource {
        public String getEventSourceName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventConsumer {
        BlinkController,
        JavaDebugger,
        NativerDebugger;

    }
}

