/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import xtc.lang.blink.Blink;
import xtc.lang.blink.Event;

class CommandLineInterface
extends Thread
implements Event.BlinkEventSource {
    private final Blink dbg;
    private final BufferedReader userInput = new BufferedReader(new InputStreamReader(System.in));
    private final BufferedOutputStream userOutput = new BufferedOutputStream(System.out);
    private final BufferedOutputStream userError = new BufferedOutputStream(System.err);

    CommandLineInterface(Blink blink) {
        this.dbg = blink;
    }

    public String getEventSourceName() {
        return "DebuggerUser";
    }

    public void run() {
        if (this.dbg.options.getVerboseLevel() >= 1) {
            this.dbg.out("beginning user input line read thread.");
        }
        while (true) {
            String string;
            block6: {
                try {
                    string = this.userInput.readLine();
                    if (string == null) {
                        this.dbg.enqueEvent(new Event.UserCommandEvent(this, "exit"));
                    }
                    break block6;
                }
                catch (IOException iOException) {
                    this.dbg.err("I'm terminating this session since I failed in getting your command.");
                }
                break;
            }
            this.dbg.enqueEvent(new Event.UserCommandEvent(this, string));
        }
        if (this.dbg.options.getVerboseLevel() >= 1) {
            this.dbg.out("finishing user input line read thread.");
        }
    }

    void out(String string) {
        byte[] byArray = string.getBytes();
        CommandLineInterface.out(this.userOutput, byArray, 0, byArray.length);
    }

    void err(String string) {
        byte[] byArray = string.getBytes();
        CommandLineInterface.out(this.userError, byArray, 0, byArray.length);
    }

    private static synchronized void out(BufferedOutputStream bufferedOutputStream, byte[] byArray, int n, int n2) {
        try {
            bufferedOutputStream.write(byArray, n, n2);
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

