/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.IOException;
import xtc.lang.blink.Blink;
import xtc.lang.blink.BreakPointManager;
import xtc.lang.blink.CallStack;
import xtc.lang.blink.CommandAstAnalyzer;
import xtc.lang.blink.DebuggerContext;
import xtc.lang.blink.Event;
import xtc.lang.blink.SymbolMapper;
import xtc.lang.jeannie.Utilities;
import xtc.tree.GNode;
import xtc.tree.Visitor;

public final class CommandInterpreter
extends Visitor {
    private final Blink dbg;
    private final BreakPointManager breakpointManager;
    private final SymbolMapper jeannieSymbolRemapper;
    private DebuggerContext debuggerContext;
    private int nextVCIdentifier = 0;

    CommandInterpreter(Blink blink, BreakPointManager breakPointManager) {
        this.dbg = blink;
        this.breakpointManager = breakPointManager;
        this.jeannieSymbolRemapper = new SymbolMapper();
    }

    public String getEventSourceName() {
        return "CommandRunner";
    }

    public final void visitInitJCommand(GNode gNode) {
        this.dbg.initj();
        this.dbg.ensurePureContext();
    }

    public final void visitJ2cCommand(GNode gNode) {
        this.dbg.j2c();
    }

    public final void visitC2jCommand(GNode gNode) {
        this.dbg.c2j();
    }

    public final void visitJRetCommand(GNode gNode) {
        this.dbg.jret();
    }

    public final void visitJdbCommand(GNode gNode) {
        String string = gNode.getString(0);
        try {
            String string2 = this.dbg.jdb.runCommand(string);
            this.dbg.out(string2);
        }
        catch (IOException iOException) {
            this.dbg.err("can not successfully run the jdb command");
        }
    }

    public final void visitGdbCommand(GNode gNode) {
        if (!this.dbg.IsNativeDebuggerAttached()) {
            this.dbg.out("gdb is not activated yet.\n");
            return;
        }
        String string = gNode.getString(0);
        try {
            this.dbg.out(this.dbg.gdb.runCommand(string));
        }
        catch (IOException iOException) {
            this.dbg.err("can not successfully native debugger command");
        }
    }

    public final void visitHelpCommand(GNode gNode) {
        this.dbg.help();
        this.dbg.ensurePureContext();
    }

    public final void visitExitCommand(GNode gNode) {
        switch (this.dbg.getDebugControlStatus()) {
            case NONE: {
                this.dbg.out("can not process user exit command\n");
                break;
            }
            case JDB: 
            case GDB: {
                this.dbg.exit();
                this.dbg.enqueEvent(new Event.SessionFinishRequestEvent("user request"));
                break;
            }
            case JDB_IN_GDB: 
            case GDB_IN_JDB: {
                this.dbg.out("can not process use exit in the nested debug context!\n");
            }
        }
    }

    public final void visitBreakClassCommand(GNode gNode) {
        String string = gNode.getNode(0).getString(0);
        int n = Integer.parseInt(gNode.getString(1));
        this.breakpointManager.addUserJavaBreakPoint(string, n);
        this.dbg.ensurePureContext();
    }

    public final void visitBreakClassMethodCommand(GNode gNode) {
        String string = Utilities.qualifiedIdentifierToString(gNode.getGeneric(0));
        this.breakpointManager.addUserJavaBreakPoint(string);
        this.dbg.ensurePureContext();
    }

    public final void visitBreakFileCommand(GNode gNode) {
        String string = gNode.getString(0);
        int n = Integer.parseInt(gNode.getString(1));
        this.breakpointManager.addUserGDBBreakPoint(string, n);
        this.dbg.ensurePureContext();
    }

    public final void visitInfoBreakCommand(GNode gNode) {
        this.breakpointManager.showUserBreakPointList();
        this.dbg.ensurePureContext();
    }

    public final void visitInfoWatchCommand(GNode gNode) {
        assert (false) : "not yet implemented";
    }

    public final void visitDeleteCommand(GNode gNode) {
        int n = Integer.parseInt(gNode.getNode(0).getString(0));
        this.breakpointManager.deleteUserBreakPoint(n);
        this.dbg.ensurePureContext();
    }

    public final void visitRunCommand(GNode gNode) {
        this.dbg.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitStepCommand(GNode gNode) {
        try {
            this.clearDebuggerContext();
            switch (this.dbg.getDebugControlStatus()) {
                case NONE: {
                    this.dbg.err("can not perform step in this state\n");
                    break;
                }
                case JDB_IN_GDB: 
                case GDB_IN_JDB: {
                    this.dbg.jret();
                }
            }
            SymbolMapper.SourceFileAndLine sourceFileAndLine = this.dbg.getBreakPointLocation();
            assert (sourceFileAndLine != null);
            SymbolMapper.SourceFileAndLine sourceFileAndLine2 = null;
            block13: while (sourceFileAndLine2 == null || sourceFileAndLine.equals(sourceFileAndLine2)) {
                switch (this.dbg.getDebugControlStatus()) {
                    case JDB: {
                        this.dbg.stepj();
                        sourceFileAndLine2 = this.dbg.getBreakPointLocation();
                        continue block13;
                    }
                    case GDB: {
                        this.dbg.stepc();
                        sourceFileAndLine2 = this.dbg.getBreakPointLocation();
                        continue block13;
                    }
                }
                assert (false);
            }
        }
        catch (IOException iOException) {
            this.dbg.err("could not sucessfully perform stepping\n");
        }
        finally {
            this.dbg.ensurePureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitNextCommand(GNode gNode) {
        this.clearDebuggerContext();
        switch (this.dbg.getDebugControlStatus()) {
            case NONE: {
                this.dbg.err("can not perform step in this state\n");
                break;
            }
            case JDB_IN_GDB: 
            case GDB_IN_JDB: {
                this.dbg.jret();
            }
        }
        SymbolMapper.SourceFileAndLine sourceFileAndLine = this.dbg.getBreakPointLocation();
        assert (sourceFileAndLine != null);
        try {
            SymbolMapper.SourceFileAndLine sourceFileAndLine2 = null;
            block13: while (sourceFileAndLine2 == null || sourceFileAndLine.equals(sourceFileAndLine2)) {
                switch (this.dbg.getDebugControlStatus()) {
                    case JDB: {
                        this.dbg.nextj();
                        sourceFileAndLine2 = this.dbg.getBreakPointLocation();
                        continue block13;
                    }
                    case GDB: {
                        this.dbg.nextc();
                        sourceFileAndLine2 = this.dbg.getBreakPointLocation();
                        continue block13;
                    }
                }
                assert (false);
            }
        }
        catch (IOException iOException) {
            this.dbg.err("could not correctly perform the next command.\n");
        }
        finally {
            this.dbg.ensurePureContext();
        }
    }

    public final void visitContinueCommand(GNode gNode) {
        this.clearDebuggerContext();
        this.dbg.cont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitLocalsCommand(GNode gNode) {
        try {
            this.ensureDebuggerContext();
            this.debuggerContext.showLocals(this.dbg, this.jeannieSymbolRemapper);
        }
        catch (IOException iOException) {
            this.dbg.err("could not perform list command.\n");
        }
        finally {
            this.dbg.ensurePureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitListCommand(GNode gNode) {
        try {
            this.ensureDebuggerContext();
            this.debuggerContext.showSourceCode(this.dbg);
        }
        catch (IOException iOException) {
            this.dbg.err("could not perform the list command.\n");
        }
        finally {
            this.dbg.ensurePureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitWhereCommand(GNode gNode) {
        try {
            this.ensureDebuggerContext();
            this.debuggerContext.showWhere(this.dbg);
        }
        catch (IOException iOException) {
            this.dbg.err("could not perform where command.\n");
        }
        finally {
            this.dbg.ensurePureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitUpCommand(GNode gNode) {
        int n = Integer.parseInt(gNode.getNode(0).getString(0));
        try {
            this.ensureDebuggerContext();
            this.debuggerContext.unWindStack(this.dbg, n);
        }
        catch (IOException iOException) {
            this.dbg.err("could not perform up\n");
        }
        finally {
            this.dbg.ensurePureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitDownCommand(GNode gNode) {
        int n = Integer.parseInt(gNode.getNode(0).getString(0));
        try {
            this.ensureDebuggerContext();
            this.debuggerContext.windStack(this.dbg, n);
        }
        catch (IOException iOException) {
            this.dbg.err("could not perform up\n");
        }
        finally {
            this.dbg.ensurePureContext();
        }
    }

    public final void visitStatCommand(GNode gNode) {
        this.dbg.out("control: " + (Object)((Object)this.dbg.getDebugControlStatus()) + "\n");
    }

    public final void visitWatchCExpressionCommand(GNode gNode) {
        assert (false) : "not yet implemented";
    }

    public final void visitWatchJavaFieldCommand(GNode gNode) {
        assert (false) : "not yet implemented";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitPrintCExpressionCommand(GNode gNode) {
        try {
            this.breakpointManager.freezeActiveBreakPoints();
            Object object = this.dispatch(gNode.getNode(0));
            this.dbg.out("====> " + this.cprint((CExpr)object) + "\n");
        }
        catch (IOException iOException) {
            this.dbg.err("could not correctly print the final result\n");
        }
        finally {
            this.breakpointManager.unfreezeAllBreakpoints();
            this.cleanVJandVC();
            this.dbg.ensurePureContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitPrintJavaExpressionCommand(GNode gNode) {
        try {
            this.breakpointManager.freezeActiveBreakPoints();
            Object object = this.dispatch(gNode.getNode(0));
            if (object == null) {
                return;
            }
            this.dbg.out("=====> " + this.jprint((JExpr)object) + "\n");
        }
        catch (IOException iOException) {
            this.dbg.err("could not correctly print the final result\n");
        }
        finally {
            this.breakpointManager.unfreezeAllBreakpoints();
            this.cleanVJandVC();
            this.dbg.ensurePureContext();
        }
    }

    public final CExpr visitJavaInCExpression(GNode gNode) throws IOException {
        return this.CV_assign_JExpr((JExpr)this.dispatch(gNode.getNode(0)));
    }

    public final JExpr visitCInJavaExpression(GNode gNode) throws IOException {
        return this.JV_assign_CExpr((CExpr)this.dispatch(gNode.getNode(0)));
    }

    public final JExpr visitIntegerLiteral(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        return new JExpr(gNode.getString(0));
    }

    public final CExpr visitIntegerConstant(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.C);
        return new CExpr(CommandInterpreter.p(gNode.getString(0)));
    }

    public final JExpr visitStringConstant(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        return new JExpr(CommandInterpreter.q(gNode.getString(0)));
    }

    public final JExpr visitStringLiteral(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        return new JExpr(CommandInterpreter.q(gNode.getString(0)));
    }

    public final JExpr visitNullLiteral(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        return new JExpr(CommandInterpreter.p("null"));
    }

    public final BExpr visitMetaVariable(GNode gNode) throws IOException {
        assert (false) : "not implemented yet";
        return null;
    }

    public BExpr visitPrimaryIdentifier(GNode gNode) throws IOException {
        String string = (String)gNode.get(0);
        this.ensureDebuggerContext();
        SymbolMapper.SourceFileAndLine sourceFileAndLine = this.debuggerContext.getCurrentLocation();
        SymbolMapper.VariableRemapEntry variableRemapEntry = this.jeannieSymbolRemapper.lookUpVariableRemap(string, sourceFileAndLine.getSourceFile(), sourceFileAndLine.getSourceLine());
        String string2 = null;
        if (variableRemapEntry != null) {
            string2 = variableRemapEntry.targetLanguageExpression();
        }
        if (string2 == null) {
            string2 = string;
        }
        switch (CommandInterpreter.getLanguage(gNode)) {
            case C: {
                return this.eval(gNode, new CExpr(string2));
            }
            case JAVA: {
                return this.eval(gNode, new JExpr(string2));
            }
        }
        assert (false) : "not reachable";
        return null;
    }

    public final void visitThisExpression(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        assert (false) : "The Blink debugger does not supportqualified this in Java expression.";
    }

    public final BExpr visitAdditiveExpression(GNode gNode) throws IOException {
        switch (CommandInterpreter.getLanguage(gNode)) {
            case C: {
                return this.eval(gNode, CExpr.binop((CExpr)this.dispatch(gNode.getNode(0)), gNode.getString(1), (CExpr)this.dispatch(gNode.getNode(2))));
            }
            case JAVA: {
                return this.eval(gNode, JExpr.binop((JExpr)this.dispatch(gNode.getNode(0)), (String)gNode.get(1), (JExpr)this.dispatch(gNode.getNode(2))));
            }
        }
        assert (false) : "not reachable";
        return null;
    }

    public final BExpr visitEqualityExpression(GNode gNode) throws IOException {
        assert (!this.isLValue(gNode)) : "the binary operation never generages l-value.";
        switch (CommandInterpreter.getLanguage(gNode)) {
            case C: {
                return this.eval(gNode, CExpr.binop((CExpr)this.dispatch(gNode.getNode(0)), gNode.getString(1), (CExpr)this.dispatch(gNode.getNode(2))));
            }
            case JAVA: {
                return this.eval(gNode, JExpr.binop((JExpr)this.dispatch(gNode.getNode(0)), gNode.getString(1), (JExpr)this.dispatch(gNode.getNode(2))));
            }
        }
        assert (false) : "not reachable";
        return null;
    }

    public final CExpr visitFunctionCall(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.C);
        assert (!this.isLValue(gNode)) : "function call can never be l-value.";
        return this.eval(gNode, CExpr.funcCall((CExpr)this.dispatch(gNode.getNode(0)), (CExpr[])this.dispatch(gNode.getNode(1))));
    }

    public final CExpr[] visitExpressionList(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.C);
        assert (!this.isLValue(gNode)) : "function arguments can never be l-value.";
        CExpr[] cExprArray = new CExpr[gNode.size()];
        for (int i = 0; i < gNode.size(); ++i) {
            cExprArray[i] = (CExpr)this.dispatch(gNode.getNode(i));
        }
        return cExprArray;
    }

    public JExpr visitCallExpression(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        assert (!this.isLValue(gNode)) : "method call never gernates l-value.";
        return this.eval(gNode, JExpr.methodCall((JExpr)this.dispatch(gNode.getNode(0)), gNode.getString(2), (JExpr[])this.dispatch(gNode.getNode(3))));
    }

    public final JExpr[] visitArguments(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        JExpr[] jExprArray = new JExpr[gNode.size()];
        for (int i = 0; i < gNode.size(); ++i) {
            jExprArray[i] = (JExpr)this.dispatch(gNode.getNode(i));
        }
        return jExprArray;
    }

    public final CExpr visitAddressExpression(GNode gNode) {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.C);
        assert (!this.isLValue(gNode)) : "& never gernates l-value.";
        return CExpr.address((CExpr)this.dispatch(gNode.getNode(0)));
    }

    public final JExpr visitExpression(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        assert (!this.isLValue(gNode)) : "the assignment never gernates l-value.";
        CommandInterpreter.setLValue((GNode)gNode.getNode(0));
        return this.eval(gNode, JExpr.binop((JExpr)this.dispatch(gNode.getNode(0)), gNode.getString(1), (JExpr)this.dispatch(gNode.getNode(2))));
    }

    public final CExpr visitAssignmentExpression(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.C);
        assert (!this.isLValue(gNode)) : "the assignment never gernates l-value.";
        CommandInterpreter.setLValue((GNode)gNode.getNode(0));
        return this.eval(gNode, CExpr.binop((CExpr)this.dispatch(gNode.getNode(0)), gNode.getString(1), (CExpr)this.dispatch(gNode.getNode(2))));
    }

    public final CExpr visitIndirectionExpression(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.C);
        return this.eval(gNode, CExpr.indirect((CExpr)this.dispatch(gNode.getNode(0))));
    }

    public final JExpr visitQualifiedIdentifier(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        return this.eval(gNode, new JExpr(Utilities.qualifiedIdentifierToString(gNode)));
    }

    public final JExpr visitSelectionExpression(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.JAVA);
        return this.eval(gNode, JExpr.field((JExpr)this.dispatch(gNode.getNode(0)), gNode.getString(1)));
    }

    public final CExpr visitDirectComponentSelection(GNode gNode) throws IOException {
        assert (CommandInterpreter.getLanguage(gNode) == CommandAstAnalyzer.Language.C);
        return this.eval(gNode, CExpr.fieldDirect((CExpr)this.dispatch(gNode.getNode(0)), gNode.getString(1)));
    }

    public final BExpr visitSubscriptExpression(GNode gNode) throws IOException {
        switch (CommandInterpreter.getLanguage(gNode)) {
            case JAVA: {
                return this.eval(gNode, JExpr.arraySelect((JExpr)this.dispatch(gNode.getNode(0)), (JExpr)this.dispatch(gNode.getNode(1))));
            }
            case C: {
                return this.eval(gNode, CExpr.arraySelect((CExpr)this.dispatch(gNode.getNode(0)), (CExpr)this.dispatch(gNode.getNode(1))));
            }
        }
        assert (false) : "not reachable";
        return null;
    }

    private String jprint(JExpr jExpr) throws IOException {
        this.dbg.ensureJDBContext();
        String string = this.dbg.jdb.print(this.getCurrentJavaFrame(), jExpr.getValueExpr());
        if (this.dbg.options.getVerboseExprEvaluation() >= 1) {
            this.dbg.out("\tjprint " + jExpr.getValueExpr() + "\n");
        }
        return string;
    }

    private String cprint(CExpr cExpr) throws IOException {
        this.dbg.ensureGDBContext();
        String string = this.dbg.gdb.eval(this.getCurrentNativeFrame(), cExpr.getValueExpr());
        if (this.dbg.options.getVerboseExprEvaluation() >= 1) {
            this.dbg.out("\tcprint " + cExpr.getValueExpr() + "\n");
        }
        return string;
    }

    private JV JV_assign_JExpr(JExpr jExpr) throws IOException {
        String string;
        this.dbg.ensureJDBContext();
        CallStack.JavaCallFrame javaCallFrame = this.getCurrentJavaFrame();
        String string2 = this.dbg.jdb.eval(javaCallFrame, "xtc.lang.blink.AgentVariable.setVjFromJavaExpr(" + jExpr.getValueExpr() + ")");
        String string3 = this.dbg.jdb.eval(javaCallFrame, "xtc.lang.blink.AgentVariable.getVJExpr(" + string2 + ")");
        if (string3.matches("\".+\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if ((string = this.dbg.jdb.eval(javaCallFrame, "xtc.lang.blink.AgentVariable.get_java_type(" + string2 + ")")).matches("\".+\"")) {
            string = string.substring(1, string.length() - 1);
        }
        JV jV = new JV("vj" + string2, string, string3);
        if (this.dbg.options.getVerboseExprEvaluation() >= 1) {
            this.dbg.out("\t" + jV.getVjID() + "(" + jV.getType() + ") := " + jExpr.getValueExpr() + "\n");
        }
        return jV;
    }

    private JV JV_assign_CExpr(CExpr cExpr) throws IOException {
        String string;
        this.dbg.ensureGDBContext();
        String string2 = this.dbg.gdb.whatis(this.getCurrentNativeFrame(), cExpr.getValueExpr());
        String string3 = string2.equals("int") ? "bda_set_vj_from_cexpr_jint" : (string2.equals("long") ? "bda_set_vj_from_cexpr_jlong" : (string2.equals("float") ? "bda_set_vj_from_cexpr_jfloat" : (string2.equals("double") ? "bda_set_vj_from_cexpr_jdouble" : (string2.equals("jobject") ? "bda_set_vj_from_cexpr_jobject" : "bda_set_vj_from_cexpr_jobject"))));
        String string4 = this.dbg.ensureJNIENV();
        String string5 = this.dbg.gdb.eval(this.getCurrentNativeFrame(), string3 + "(" + string4 + "," + cExpr.getValueExpr() + ")");
        this.dbg.ensureJDBContext();
        CallStack.JavaCallFrame javaCallFrame = this.getCurrentJavaFrame();
        String string6 = this.dbg.jdb.eval(javaCallFrame, "xtc.lang.blink.AgentVariable.getVJExpr(" + string5 + ")" + "\n");
        if (string6.matches("\".+\"")) {
            string6 = string6.substring(1, string6.length() - 1);
        }
        if ((string = this.dbg.jdb.eval(javaCallFrame, "xtc.lang.blink.AgentVariable.get_java_type(" + string5 + ")" + "\n")).matches("\".+\"")) {
            string = string.substring(1, string.length() - 1);
        }
        JV jV = new JV("vj" + string5, string, string6);
        if (this.dbg.options.getVerboseExprEvaluation() >= 1) {
            this.dbg.out("\t" + jV.getVjID() + "(" + jV.getType() + ") := " + cExpr.getValueExpr() + "\n");
        }
        return jV;
    }

    private CV CV_assign_JExpr(JExpr jExpr) throws IOException {
        this.dbg.ensureJDBContext();
        CallStack.JavaCallFrame javaCallFrame = this.getCurrentJavaFrame();
        String string = this.dbg.jdb.eval(javaCallFrame, "xtc.lang.blink.AgentVariable.setVjFromJavaExpr(" + jExpr.getValueExpr() + ")\n");
        String string2 = this.dbg.jdb.eval(javaCallFrame, "xtc.lang.blink.AgentVariable.get_vj_jni_type(" + string + ")\n");
        if (string2.matches("\".+\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        this.dbg.ensureGDBContext();
        String string3 = this.dbg.ensureJNIENV();
        String string4 = this.getNewCTmpVarIdentifier();
        this.dbg.gdb.setVariable(this.getCurrentNativeFrame(), string4, "bda_get_cvalue_from_vj_" + string2 + "(" + string3 + "," + string + ")");
        CV cV = new CV(string4, string2);
        if (this.dbg.options.getVerboseExprEvaluation() >= 1) {
            this.dbg.out("\t" + cV.getVcId() + "(" + cV.getType() + ") := " + jExpr.getValueExpr() + "\n");
        }
        return cV;
    }

    private CallStack.JavaCallFrame getCurrentJavaFrame() throws IOException {
        DebuggerContext debuggerContext = this.ensureDebuggerContext();
        CallStack.ICallFrame iCallFrame = debuggerContext.getCurrentFrame();
        if (iCallFrame instanceof CallStack.JavaCallFrame) {
            return (CallStack.JavaCallFrame)iCallFrame;
        }
        if (iCallFrame instanceof CallStack.JeannieCallFrame) {
            CallStack.JeannieCallFrame jeannieCallFrame = (CallStack.JeannieCallFrame)iCallFrame;
            return jeannieCallFrame.getTopJavaFrame();
        }
        return null;
    }

    private CallStack.NativeCallFrame getCurrentNativeFrame() throws IOException {
        DebuggerContext debuggerContext = this.ensureDebuggerContext();
        CallStack.ICallFrame iCallFrame = debuggerContext.getCurrentFrame();
        if (iCallFrame instanceof CallStack.NativeCallFrame) {
            return (CallStack.NativeCallFrame)iCallFrame;
        }
        if (iCallFrame instanceof CallStack.JeannieCallFrame) {
            CallStack.JeannieCallFrame jeannieCallFrame = (CallStack.JeannieCallFrame)iCallFrame;
            return jeannieCallFrame.getTopNativeFrame();
        }
        return null;
    }

    private CV CV_assign_CExpr(CExpr cExpr) throws IOException {
        String string = this.getNewCTmpVarIdentifier();
        DebuggerContext debuggerContext = this.ensureDebuggerContext();
        this.dbg.ensureGDBContext();
        this.dbg.gdb.setVariable(this.getCurrentNativeFrame(), string, cExpr.getValueExpr());
        String string2 = this.dbg.gdb.whatis(this.getCurrentNativeFrame(), cExpr.getValueExpr());
        CV cV = new CV(string, string2);
        if (this.dbg.options.getVerboseExprEvaluation() >= 1) {
            this.dbg.out("\t" + cV.getVcId() + "(" + cV.getType() + ") := " + cExpr.getValueExpr() + "\n");
        }
        return cV;
    }

    private final void cleanVJandVC() {
        try {
            this.dbg.ensureJDBContext();
            this.dbg.jdb.cleanConvenienceVariables();
        }
        catch (IOException iOException) {
            this.dbg.err("could not successfully clean JDB temp varaibles.\n");
        }
        this.nextVCIdentifier = 0;
    }

    private final DebuggerContext ensureDebuggerContext() throws IOException {
        if (this.debuggerContext != null) {
            return this.debuggerContext;
        }
        this.dbg.ensurePureContext();
        CallStack callStack = CallStack.extractCallStack(this.dbg, this.jeannieSymbolRemapper);
        this.debuggerContext = new DebuggerContext(callStack);
        return this.debuggerContext;
    }

    private final void clearDebuggerContext() {
        this.debuggerContext = null;
    }

    private static CommandAstAnalyzer.Language getLanguage(GNode gNode) {
        return (CommandAstAnalyzer.Language)((Object)gNode.getProperty("language"));
    }

    private static void setLValue(GNode gNode) {
        gNode.setProperty("blink.lvalue", new Boolean("true"));
    }

    private boolean isLValue(GNode gNode) {
        Object object = gNode.getProperty("blink.lvalue");
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl;
        }
        return false;
    }

    private String getNewCTmpVarIdentifier() {
        return "$vc" + this.nextVCIdentifier++;
    }

    private CExpr eval(GNode gNode, CExpr cExpr) throws IOException {
        if (this.isLValue(gNode)) {
            return cExpr;
        }
        return this.CV_assign_CExpr(cExpr);
    }

    private JExpr eval(GNode gNode, JExpr jExpr) throws IOException {
        if (this.isLValue(gNode)) {
            return jExpr;
        }
        return this.JV_assign_JExpr(jExpr);
    }

    private static String q(String string) {
        return "\"" + string + "\"";
    }

    private static String p(String string) {
        return "(" + string + ")";
    }

    private static String join(String string, BExpr[] bExprArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bExprArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(bExprArray[i].getValueExpr());
                continue;
            }
            stringBuffer.append(string).append(bExprArray[i].getValueExpr());
        }
        return stringBuffer.toString();
    }

    private static class CV
    extends CExpr {
        private final String vcId;
        private final String type;

        CV(String string, String string2) {
            super("(" + string + ")");
            this.vcId = string;
            this.type = string2;
        }

        public String getType() {
            return this.type;
        }

        public String getVcId() {
            return this.vcId;
        }
    }

    private static class JV
    extends JExpr {
        private final String vjId;
        private final String type;

        JV(String string, String string2, String string3) {
            super(string3);
            this.type = string2;
            this.vjId = string;
        }

        public String getVjID() {
            return this.vjId;
        }

        public String getType() {
            return this.type;
        }
    }

    private static class CExpr
    extends BExpr {
        CExpr(String string) {
            super(string);
        }

        static CExpr address(CExpr cExpr) {
            return new CExpr("(&" + cExpr.getValueExpr() + ")");
        }

        static CExpr indirect(CExpr cExpr) {
            return new CExpr("(*" + cExpr.getValueExpr() + ")");
        }

        static CExpr binop(CExpr cExpr, String string, CExpr cExpr2) {
            return new CExpr("(" + cExpr.getValueExpr() + string + cExpr2.getValueExpr() + ")");
        }

        static CExpr fieldDirect(CExpr cExpr, String string) {
            return new CExpr("(" + cExpr.getValueExpr() + "." + string + ")");
        }

        static CExpr funcCall(CExpr cExpr, CExpr[] cExprArray) {
            return new CExpr(cExpr.getValueExpr() + "(" + CommandInterpreter.join(",", cExprArray) + ")");
        }

        static CExpr arraySelect(CExpr cExpr, CExpr cExpr2) {
            return new CExpr("(" + cExpr.getValueExpr() + "[" + cExpr2.getValueExpr() + "])");
        }
    }

    private static class JExpr
    extends BExpr {
        JExpr(String string) {
            super(string);
        }

        static JExpr field(JExpr jExpr, String string) {
            return new JExpr("(" + jExpr.getValueExpr() + "." + string + ")");
        }

        static JExpr binop(JExpr jExpr, String string, JExpr jExpr2) {
            return new JExpr("(" + jExpr.getValueExpr() + string + jExpr2.getValueExpr() + ")");
        }

        static JExpr methodCall(JExpr jExpr, String string, JExpr[] jExprArray) {
            return new JExpr("(" + jExpr.getValueExpr() + "." + string + "(" + CommandInterpreter.join(",", jExprArray) + "))");
        }

        static JExpr arraySelect(JExpr jExpr, JExpr jExpr2) {
            return new JExpr("(" + jExpr.getValueExpr() + "[" + jExpr2.getValueExpr() + "])");
        }
    }

    private static abstract class BExpr {
        final String val;

        BExpr(String string) {
            this.val = string;
        }

        String getValueExpr() {
            return this.val;
        }

        public String toString() {
            return this.getValueExpr();
        }
    }
}

