/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.util.Stack;
import xtc.lang.JavaEntities;
import xtc.lang.jeannie.Utilities;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.util.Runtime;

public final class CommandAstAnalyzer
extends Visitor {
    final Runtime _runtime;
    private final Stack<Language> _stack;

    public static void assertAllNodesHaveLanguage(Node node) {
        new MiniVisitor_allNodesHaveLanguage().dispatch(node);
    }

    public static Language getNodeLanguage(Node node) {
        return (Language)((Object)node.getProperty("language"));
    }

    public static Object getNodeVariableRemap(Node node) {
        return node.getProperty("variableRemap");
    }

    private static Language setNodeLanguage(Node node, Language language) {
        node.setProperty("language", (Object)language);
        return language;
    }

    public CommandAstAnalyzer(Runtime runtime) {
        assert (null != runtime);
        this._runtime = runtime;
        this._stack = new Stack();
        this._stack.push(Language.DEBUGGER);
    }

    private boolean assrt(Node node, boolean bl, String string, Object ... objectArray) {
        return JavaEntities.runtimeAssrt(this._runtime, node, bl, string, objectArray);
    }

    private final Language currentLanguage() {
        return this._stack.peek();
    }

    private final Object dispatchInLanguage(Node node, Language language) {
        this.enterLanguage(language);
        Object object = this.dispatch(node);
        this.exitLanguage(language);
        return object;
    }

    private final void enterLanguage(Language language) {
        this._stack.push(language);
    }

    private final void exitLanguage(Language language) {
        assert (this.currentLanguage() == language);
        this._stack.pop();
    }

    private boolean setAndAssrtLanguage(Node node, Language language) {
        CommandAstAnalyzer.setNodeLanguage(node, language);
        return this.assrt(node, language == this.currentLanguage(), "expected language %s, current %s", new Object[]{language, this.currentLanguage()});
    }

    public final void visit(GNode gNode) {
        this.assrt(gNode, false, "the Jeannie debugger does not support the %s feature", gNode.getName());
    }

    public final void visitAdditiveExpression(GNode gNode) {
        Language language = this.currentLanguage();
        if (this.assrt(gNode, language == Language.C || language == Language.JAVA, "expected language C or Java, current %s", new Object[]{language})) {
            CommandAstAnalyzer.setNodeLanguage(gNode, language);
            this.dispatch(gNode.getNode(0));
            this.dispatch(gNode.getNode(2));
        }
    }

    public final void visitAddressExpression(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.C)) {
            this.dispatch(gNode.getNode(0));
        }
    }

    public final void visitArguments(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.JAVA)) {
            for (int i = 0; i < gNode.size(); ++i) {
                this.dispatch(gNode.getNode(i));
            }
        }
    }

    public final void visitAssignmentExpression(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.C)) {
            this.dispatch(gNode.getNode(0));
            this.dispatch(gNode.getNode(2));
        }
    }

    public final void visitBreakClassCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            String string = (String)this.dispatchInLanguage(gNode.getNode(0), Language.JAVA);
        }
    }

    public final void visitBreakClassMethodCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            String string = (String)this.dispatchInLanguage(gNode.getNode(0), Language.JAVA);
        }
    }

    public final void visitBreakFileCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitC2jCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitCallExpression(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.JAVA)) {
            if (null != gNode.get(0)) {
                this.dispatch(gNode.getNode(0));
            }
            String string = gNode.getString(2);
            this.dispatch(gNode.getNode(3));
        }
    }

    public final void visitCInJavaExpression(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.JAVA)) {
            this.dispatchInLanguage(gNode.getNode(0), Language.C);
        }
    }

    public final void visitContinueCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitDeleteCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            this.dispatchInLanguage(gNode.getNode(0), Language.JAVA);
        }
    }

    public final void visitDirectComponentSelection(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.C)) {
            this.dispatch(gNode.getNode(0));
        }
    }

    public final void visitDownCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            this.dispatchInLanguage(gNode.getNode(0), Language.JAVA);
        }
    }

    public final void visitEqualityExpression(GNode gNode) {
        Language language = this.currentLanguage();
        if (this.assrt(gNode, language == Language.C || language == Language.JAVA, "expected language C or Java, current %s", new Object[]{language})) {
            CommandAstAnalyzer.setNodeLanguage(gNode, language);
            this.dispatch(gNode.getNode(0));
            this.dispatch(gNode.getNode(2));
        }
    }

    public final void visitExitCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitExpression(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.JAVA)) {
            this.dispatch(gNode.getNode(0));
            this.dispatch(gNode.getNode(2));
        }
    }

    public final void visitExpressionList(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.C)) {
            for (int i = 0; i < gNode.size(); ++i) {
                this.dispatch(gNode.getNode(i));
            }
        }
    }

    public final void visitFunctionCall(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.C)) {
            this.dispatch(gNode.getNode(0));
            if (null != gNode.get(1)) {
                this.dispatch(gNode.getNode(1));
            }
        }
    }

    public final void visitGdbCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitHelpCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitIndirectionExpression(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.C)) {
            this.dispatch(gNode.getNode(0));
        }
    }

    public final void visitInfoBreakCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitInfoWatchCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitInitJCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitIntegerConstant(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.C);
    }

    public final void visitIntegerLiteral(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.JAVA);
    }

    public final void visitJ2cCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitJavaInCExpression(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.C)) {
            this.dispatchInLanguage(gNode.getNode(0), Language.JAVA);
        }
    }

    public final void visitJdbCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitJRetCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitListCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitLocalsCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitMetaVariable(GNode gNode) {
        CommandAstAnalyzer.setNodeLanguage(gNode, Language.DEBUGGER);
        Language language = this.currentLanguage();
        this.assrt(gNode, language == Language.C || language == Language.JAVA, "expected language C or Java, current %s", new Object[]{language});
    }

    public final void visitNextCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitRunCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitNullLiteral(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.JAVA);
    }

    public void visitPrimaryIdentifier(GNode gNode) {
        Language language = this.currentLanguage();
        if (this.assrt(gNode, language == Language.C || language == Language.JAVA, "expected language C or Java, current %s", new Object[]{language})) {
            CommandAstAnalyzer.setNodeLanguage(gNode, language);
        }
    }

    public final void visitPrintCExpressionCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            this.dispatchInLanguage(gNode.getNode(0), Language.C);
        }
    }

    public final void visitPrintJavaExpressionCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            this.dispatchInLanguage(gNode.getNode(0), Language.JAVA);
        }
    }

    public final String visitQualifiedIdentifier(GNode gNode) {
        if (!this.setAndAssrtLanguage(gNode, Language.JAVA)) {
            return null;
        }
        return Utilities.qualifiedIdentifierToString(gNode);
    }

    public final void visitSelectionExpression(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.JAVA);
        this.dispatch(gNode.getNode(0));
    }

    public final void visitStatCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitStepCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    public final void visitStringConstant(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.JAVA);
    }

    public final void visitStringLiteral(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.JAVA);
    }

    public final void visitSubscriptExpression(GNode gNode) {
        Language language = this.currentLanguage();
        if (this.assrt(gNode, language == Language.C || language == Language.JAVA, "expected language C or Java, current %s", new Object[]{language})) {
            CommandAstAnalyzer.setNodeLanguage(gNode, language);
            this.dispatch(gNode.getNode(0));
            this.dispatch(gNode.getNode(1));
        }
    }

    public final void visitThisExpression(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.JAVA);
        this.assrt(gNode, null == gNode.get(0), "the Jeannie debugger does not support qualified this in Java expressions", new Object[0]);
    }

    public final void visitUpCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            this.dispatchInLanguage(gNode.getNode(0), Language.JAVA);
        }
    }

    public final void visitWatchCExpressionCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            this.dispatchInLanguage(gNode, Language.C);
        }
    }

    public final void visitWatchJavaFieldCommand(GNode gNode) {
        if (this.setAndAssrtLanguage(gNode, Language.DEBUGGER)) {
            String string = (String)this.dispatchInLanguage(gNode.getNode(1), Language.JAVA);
        }
    }

    public final void visitWhereCommand(GNode gNode) {
        this.setAndAssrtLanguage(gNode, Language.DEBUGGER);
    }

    private static class MiniVisitor_allNodesHaveLanguage
    extends Visitor {
        private MiniVisitor_allNodesHaveLanguage() {
        }

        public final void visit(Node node) {
            assert (null != CommandAstAnalyzer.getNodeLanguage(node)) : node.toString();
            for (int i = 0; i < node.size(); ++i) {
                if (!(node.get(i) instanceof Node)) continue;
                this.dispatch(node.getNode(i));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Language {
        C,
        JAVA,
        DEBUGGER;

    }
}

