/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import xtc.lang.blink.Blink;
import xtc.lang.blink.SymbolMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallStack {
    private final FrameLanguage topFrameLanguage;
    private final List<JavaCallFrame> javaFrames;
    private final List<NativeCallFrame> nativeFrames;
    private final List<ICallFrame> mixedFrames;

    public static CallStack extractCallStack(Blink blink, SymbolMapper symbolMapper) throws IOException {
        List<NativeCallFrame> list;
        List<JavaCallFrame> list2;
        FrameLanguage frameLanguage;
        switch (blink.getDebugControlStatus()) {
            case JDB: {
                frameLanguage = FrameLanguage.JAVA;
                list2 = blink.jdb.getFrames();
                blink.j2c();
                list = blink.gdb.getFrames();
                blink.jret();
                break;
            }
            case GDB: {
                frameLanguage = FrameLanguage.C;
                list = blink.gdb.getFrames();
                blink.c2j();
                list2 = blink.jdb.getFrames();
                blink.jret();
                break;
            }
            default: {
                assert (false) : "should not be reachable.";
                return null;
            }
        }
        CallStack callStack = new CallStack(frameLanguage, list2, list);
        callStack.buildMixedFrame(symbolMapper);
        return callStack;
    }

    public static JavaCallFrame getMostRecentJavaFrame(Blink blink) throws IOException {
        List<JavaCallFrame> list = blink.jdb.getFrames();
        JavaCallFrame javaCallFrame = null;
        ListIterator<JavaCallFrame> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JavaCallFrame javaCallFrame2 = listIterator.next();
            if (javaCallFrame2.isTransition()) continue;
            javaCallFrame = javaCallFrame2;
            break;
        }
        return javaCallFrame;
    }

    private CallStack(FrameLanguage frameLanguage, List<JavaCallFrame> list, List<NativeCallFrame> list2) {
        assert (!list.isEmpty() && !list2.isEmpty());
        this.javaFrames = list;
        this.nativeFrames = list2;
        this.topFrameLanguage = frameLanguage;
        this.mixedFrames = new LinkedList<ICallFrame>();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void buildMixedFrame(SymbolMapper symbolMapper) {
        assert (!this.javaFrames.isEmpty() && !this.nativeFrames.isEmpty());
        LinkedList<MicroCallFrame> linkedList = new LinkedList<MicroCallFrame>();
        FrameLanguage frameLanguage = this.topFrameLanguage;
        ListIterator<JavaCallFrame> listIterator = this.javaFrames.listIterator();
        ListIterator<NativeCallFrame> listIterator2 = this.nativeFrames.listIterator();
        JavaCallFrame javaCallFrame = listIterator.next();
        NativeCallFrame nativeCallFrame = listIterator2.next();
        block4: while (true) {
            switch (frameLanguage) {
                case C: {
                    if (nativeCallFrame.isTransition()) {
                        assert (javaCallFrame.isTransition());
                        javaCallFrame = listIterator.next();
                        frameLanguage = FrameLanguage.JAVA;
                        break;
                    }
                    assert (listIterator2.hasNext());
                    linkedList.addLast(nativeCallFrame);
                    nativeCallFrame = listIterator2.next();
                    break;
                }
                case JAVA: {
                    if (javaCallFrame.isTransition()) {
                        assert (nativeCallFrame.isTransition());
                        nativeCallFrame = listIterator2.next();
                        frameLanguage = FrameLanguage.C;
                        break;
                    }
                    linkedList.addLast(javaCallFrame);
                    if (!listIterator.hasNext()) break block4;
                    javaCallFrame = listIterator.next();
                }
            }
        }
        assert (!listIterator.hasNext());
        LinkedList<MicroCallFrame> linkedList2 = null;
        String string = null;
        for (MicroCallFrame microCallFrame : linkedList) {
            boolean bl;
            String string2;
            String string3 = microCallFrame.getSymbolName();
            SymbolMapper.MethodRemapEntry methodRemapEntry = symbolMapper.lookupMethodRemap(string3, string2 = microCallFrame.getSourceFile());
            boolean bl2 = bl = methodRemapEntry != null;
            if (bl) {
                if (linkedList2 == null) {
                    string = methodRemapEntry.getSourceLanguageName();
                    linkedList2 = new LinkedList<MicroCallFrame>();
                }
                linkedList2.add(microCallFrame);
                continue;
            }
            if (linkedList2 != null) {
                this.mixedFrames.add(new JeannieCallFrame(string, linkedList2));
                linkedList2 = null;
            }
            this.mixedFrames.add(microCallFrame);
        }
        if (linkedList2 != null) {
            this.mixedFrames.add(new JeannieCallFrame(string, linkedList2));
            return;
        }
    }

    public MicroCallFrame getMicroFrame(int n) {
        return this.getFrame(n).getTopMicroFrame();
    }

    public ICallFrame getFrame(int n) {
        assert (n < this.size());
        return this.mixedFrames.get(n);
    }

    public int size() {
        return this.mixedFrames.size();
    }

    public ICallFrame getMixedFrameAt(int n) {
        assert (n >= 0 && n < this.size());
        return this.mixedFrames.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Mixed frames\n");
        int n = 0;
        for (ICallFrame iCallFrame : this.mixedFrames) {
            stringBuffer.append("  [" + n++ + "]" + iCallFrame + "\n");
        }
        return stringBuffer.toString();
    }

    static class LocalVariable {
        private final String name;
        private final String value;

        public LocalVariable(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JeannieCallFrame
    implements ICallFrame {
        final String name;
        final MicroCallFrame[] frames;

        private JeannieCallFrame(String string, List<MicroCallFrame> list) {
            this.name = string;
            this.frames = list.toArray(new MicroCallFrame[0]);
            assert (this.frames != null && this.frames.length > 0);
        }

        @Override
        public int getLineNumber() {
            return this.frames[0].getLineNumber();
        }

        @Override
        public String getSourceFile() {
            return this.frames[0].getSourceFile();
        }

        @Override
        public boolean isTransition() {
            return false;
        }

        @Override
        public FrameLanguage getLanguage() {
            return FrameLanguage.JEANNIE;
        }

        @Override
        public MicroCallFrame getTopMicroFrame() {
            return this.frames[0];
        }

        public MicroCallFrame getMicroFrame(int n) {
            assert (n >= 0 && n < this.frames.length);
            return this.frames[n];
        }

        public int getNumberofMicroFrames() {
            return this.frames.length;
        }

        public JavaCallFrame getTopJavaFrame() {
            for (int i = 0; i < this.frames.length; ++i) {
                MicroCallFrame microCallFrame = this.frames[i];
                if (!(microCallFrame instanceof JavaCallFrame)) continue;
                return (JavaCallFrame)microCallFrame;
            }
            return null;
        }

        public NativeCallFrame getTopNativeFrame() {
            for (int i = 0; i < this.frames.length; ++i) {
                MicroCallFrame microCallFrame = this.frames[i];
                if (!(microCallFrame instanceof NativeCallFrame)) continue;
                return (NativeCallFrame)microCallFrame;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            String string = this.getSourceFile();
            int n = this.getLineNumber();
            if (string != null && n >= 1) {
                stringBuffer.append("  (" + string + ":" + n + ")");
            }
            stringBuffer.append(" Jeannie");
            return stringBuffer.toString();
        }
    }

    static class NativeCallFrame
    extends MicroCallFrame {
        private final int gdbIdentifier;
        private final String functionSymbol;
        private final String programCounter;

        protected NativeCallFrame(int n, String string, int n2, boolean bl, String string2, String string3) {
            super(string, n2, bl);
            this.gdbIdentifier = n;
            this.functionSymbol = string3;
            this.programCounter = string2;
        }

        public String getIdentifier() {
            return "g" + this.gdbIdentifier;
        }

        public int getGdbIdentifier() {
            return this.gdbIdentifier;
        }

        public final String getFunctionSymbol() {
            return this.functionSymbol;
        }

        public final String getProgramCounter() {
            return this.programCounter;
        }

        public FrameLanguage getLanguage() {
            return FrameLanguage.C;
        }

        public MicroCallFrame getTopMicroFrame() {
            return this;
        }

        public String getSymbolName() {
            return this.functionSymbol;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.functionSymbol);
            if (this.sourceFile != null && this.lineNumber >= 1) {
                stringBuffer.append("  (" + this.sourceFile + ":" + this.lineNumber + ")");
            }
            stringBuffer.append(" C");
            return stringBuffer.toString();
        }
    }

    static class JavaCallFrame
    extends MicroCallFrame {
        private final int jdbIdentifier;
        private final String className;
        private final String methodName;

        protected JavaCallFrame(int n, String string, int n2, boolean bl, String string2, String string3) {
            super(string, n2, bl);
            this.jdbIdentifier = n;
            this.className = string2;
            this.methodName = string3;
        }

        public String getIdentifier() {
            return "j" + this.jdbIdentifier;
        }

        public int getJdbIdentifier() {
            return this.jdbIdentifier;
        }

        public final String getClassName() {
            return this.className;
        }

        public final String getMethodName() {
            return this.methodName;
        }

        public FrameLanguage getLanguage() {
            return FrameLanguage.JAVA;
        }

        public String getSymbolName() {
            return this.className + "." + this.methodName;
        }

        public MicroCallFrame getTopMicroFrame() {
            return this;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.className);
            stringBuffer.append('.');
            stringBuffer.append(this.methodName);
            if (this.sourceFile != null && this.lineNumber >= 1) {
                stringBuffer.append("  (" + this.sourceFile + ":" + this.lineNumber + ")");
            } else {
                stringBuffer.append("  (native method)");
            }
            stringBuffer.append(" Java");
            return stringBuffer.toString();
        }
    }

    static abstract class MicroCallFrame
    implements ICallFrame {
        protected final String sourceFile;
        protected final int lineNumber;
        protected final boolean isTranstion;

        protected MicroCallFrame(String string, int n, boolean bl) {
            this.sourceFile = string;
            this.lineNumber = n;
            this.isTranstion = bl;
        }

        public abstract String getIdentifier();

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final String getSourceFile() {
            return this.sourceFile;
        }

        public final boolean isTransition() {
            return this.isTranstion;
        }

        public abstract String getSymbolName();
    }

    static interface ICallFrame {
        public int getLineNumber();

        public String getSourceFile();

        public boolean isTransition();

        public MicroCallFrame getTopMicroFrame();

        public FrameLanguage getLanguage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FrameLanguage {
        JAVA,
        C,
        JEANNIE;

    }
}

