/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang.blink;

public class AgentVariable {
    private int id;
    private Object value;
    private String expr;
    private String jniType;
    private String javaType;
    private static AgentVariable[] jvars;
    private static int nextVJIdentifier;
    private static final String JVARS_EXPRESSION = "xtc.lang.blink.AgentVariable.jvars";

    private AgentVariable(int id) {
        this.id = id;
    }

    public static void init() {
        jvars = new AgentVariable[100];
        nextVJIdentifier = 0;
    }

    private static AgentVariable createVariable() {
        if (nextVJIdentifier < jvars.length) {
            AgentVariable vj;
            AgentVariable.jvars[AgentVariable.nextVJIdentifier] = vj = new AgentVariable(nextVJIdentifier);
            ++nextVJIdentifier;
            return vj;
        }
        AgentVariable[] newJVars = new AgentVariable[jvars.length * 2];
        System.arraycopy(jvars, 0, newJVars, 0, nextVJIdentifier);
        jvars = newJVars;
        return AgentVariable.createVariable();
    }

    public static void cleanTempVars() {
        for (int i = 0; i < jvars.length; ++i) {
            if (jvars[i] == null) continue;
            AgentVariable.jvars[i] = null;
        }
        nextVJIdentifier = 0;
    }

    public static int setVjFromJavaExpr(boolean value2) {
        AgentVariable vj = AgentVariable.createVariable();
        vj.value = new Boolean(value2);
        vj.expr = "((Boolean)xtc.lang.blink.AgentVariable.jvars[" + vj.id + "].value)" + ".getBoolean()";
        vj.jniType = "jboolean";
        vj.javaType = "boolean";
        return vj.id;
    }

    public static int setVjFromJavaExpr(int value2) {
        AgentVariable vj = AgentVariable.createVariable();
        vj.value = new Integer(value2);
        vj.expr = "((Integer)xtc.lang.blink.AgentVariable.jvars[" + vj.id + "].value)" + ".intValue()";
        vj.jniType = "jint";
        vj.javaType = "int";
        return vj.id;
    }

    public static int setVjFromJavaExpr(double value2) {
        AgentVariable vj = AgentVariable.createVariable();
        vj.value = new Double(value2);
        vj.expr = "((Double)xtc.lang.blink.AgentVariable.jvars[" + vj.id + "].value)" + ".doubleValue()";
        vj.jniType = "jdouble";
        vj.javaType = "double";
        return vj.id;
    }

    public static int setVjFromJavaExpr(Object obj) {
        AgentVariable vj = AgentVariable.createVariable();
        if (obj != null) {
            vj.value = obj;
            String type2 = obj.getClass().getName();
            vj.expr = type2.equals("[D") ? "((double[])xtc.lang.blink.AgentVariable.jvars[" + vj.id + "].value)" : "((" + type2 + ")" + JVARS_EXPRESSION + "[" + vj.id + "].value)";
            vj.javaType = type2;
        } else {
            vj.value = null;
            vj.expr = "null";
            vj.javaType = "NULL";
        }
        vj.jniType = "jobject";
        return vj.id;
    }

    public static String getVJExpr(int vjid) {
        return AgentVariable.jvars[vjid].expr;
    }

    public static String get_java_type(int vjid) {
        return AgentVariable.jvars[vjid].javaType;
    }

    public static String get_vj_jni_type(int vjid) {
        return AgentVariable.jvars[vjid].jniType;
    }

    public static boolean get_vj_jboolean(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Boolean bobj = (Boolean)obj;
        return bobj;
    }

    public static byte get_vj_jbyte(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Byte bobj = (Byte)obj;
        return bobj;
    }

    public static char get_vj_jchar(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Character bobj = (Character)obj;
        return bobj.charValue();
    }

    public static short get_vj_jshort(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Short bobj = (Short)obj;
        return bobj;
    }

    public static int get_vj_jint(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Integer bobj = (Integer)obj;
        return bobj;
    }

    public static float get_vj_jlong(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Long bobj = (Long)obj;
        return bobj.longValue();
    }

    public static float get_vj_jfloat(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Float bobj = (Float)obj;
        return bobj.floatValue();
    }

    public static double get_vj_jdouble(int vjid) {
        Object obj = AgentVariable.jvars[vjid].value;
        Double bobj = (Double)obj;
        return bobj;
    }

    public static Object get_vj_jobject(int vjid) {
        Object obj;
        Object bobj = obj = AgentVariable.jvars[vjid].value;
        return bobj;
    }
}

